/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.buffer;

import java.nio.ByteBuffer;
import pro.gravit.repackage.io.netty.buffer.PoolArena;
import pro.gravit.repackage.io.netty.buffer.PoolChunk;
import pro.gravit.repackage.io.netty.buffer.PooledByteBuf;
import pro.gravit.repackage.io.netty.buffer.PooledByteBufAllocator;
import pro.gravit.repackage.io.netty.buffer.PooledDirectByteBuf;
import pro.gravit.repackage.io.netty.buffer.PooledUnsafeDirectByteBuf;
import pro.gravit.repackage.io.netty.util.internal.PlatformDependent;

final class PoolArena$DirectArena
extends PoolArena<ByteBuffer> {
    PoolArena$DirectArena(PooledByteBufAllocator pooledByteBufAllocator, int n, int n2, int n3, int n4) {
        super(pooledByteBufAllocator, n, n2, n3, n4);
    }

    @Override
    boolean isDirect() {
        return true;
    }

    @Override
    protected PoolChunk<ByteBuffer> newChunk(int n, int n2, int n3, int n4) {
        if (this.directMemoryCacheAlignment == 0) {
            ByteBuffer byteBuffer = PoolArena$DirectArena.allocateDirect(n4);
            return new PoolChunk<ByteBuffer>(this, byteBuffer, byteBuffer, n, n3, n4, n2);
        }
        ByteBuffer byteBuffer = PoolArena$DirectArena.allocateDirect(n4 + this.directMemoryCacheAlignment);
        ByteBuffer byteBuffer2 = PlatformDependent.alignDirectBuffer(byteBuffer, this.directMemoryCacheAlignment);
        return new PoolChunk<ByteBuffer>(this, byteBuffer, byteBuffer2, n, n3, n4, n2);
    }

    @Override
    protected PoolChunk<ByteBuffer> newUnpooledChunk(int n) {
        if (this.directMemoryCacheAlignment == 0) {
            ByteBuffer byteBuffer = PoolArena$DirectArena.allocateDirect(n);
            return new PoolChunk<ByteBuffer>(this, byteBuffer, byteBuffer, n);
        }
        ByteBuffer byteBuffer = PoolArena$DirectArena.allocateDirect(n + this.directMemoryCacheAlignment);
        ByteBuffer byteBuffer2 = PlatformDependent.alignDirectBuffer(byteBuffer, this.directMemoryCacheAlignment);
        return new PoolChunk<ByteBuffer>(this, byteBuffer, byteBuffer2, n);
    }

    private static ByteBuffer allocateDirect(int n) {
        return PlatformDependent.useDirectBufferNoCleaner() ? PlatformDependent.allocateDirectNoCleaner(n) : ByteBuffer.allocateDirect(n);
    }

    @Override
    protected void destroyChunk(PoolChunk<ByteBuffer> poolChunk) {
        if (PlatformDependent.useDirectBufferNoCleaner()) {
            PlatformDependent.freeDirectNoCleaner((ByteBuffer)poolChunk.base);
        } else {
            PlatformDependent.freeDirectBuffer((ByteBuffer)poolChunk.base);
        }
    }

    @Override
    protected PooledByteBuf<ByteBuffer> newByteBuf(int n) {
        if (HAS_UNSAFE) {
            return PooledUnsafeDirectByteBuf.newInstance(n);
        }
        return PooledDirectByteBuf.newInstance(n);
    }

    @Override
    protected void memoryCopy(ByteBuffer byteBuffer, int n, PooledByteBuf<ByteBuffer> pooledByteBuf, int n2) {
        if (n2 == 0) {
            return;
        }
        if (HAS_UNSAFE) {
            PlatformDependent.copyMemory(PlatformDependent.directBufferAddress(byteBuffer) + (long)n, PlatformDependent.directBufferAddress((ByteBuffer)pooledByteBuf.memory) + (long)pooledByteBuf.offset, n2);
        } else {
            byteBuffer = byteBuffer.duplicate();
            ByteBuffer byteBuffer2 = pooledByteBuf.internalNioBuffer();
            byteBuffer.position(n).limit(n + n2);
            byteBuffer2.position(pooledByteBuf.offset);
            byteBuffer2.put(byteBuffer);
        }
    }
}

