/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.buffer;

import java.nio.ByteBuffer;
import java.util.Queue;
import pro.gravit.repackage.io.netty.buffer.PoolArena$SizeClass;
import pro.gravit.repackage.io.netty.buffer.PoolChunk;
import pro.gravit.repackage.io.netty.buffer.PoolThreadCache;
import pro.gravit.repackage.io.netty.buffer.PoolThreadCache$MemoryRegionCache$1;
import pro.gravit.repackage.io.netty.buffer.PoolThreadCache$MemoryRegionCache$Entry;
import pro.gravit.repackage.io.netty.buffer.PooledByteBuf;
import pro.gravit.repackage.io.netty.util.internal.MathUtil;
import pro.gravit.repackage.io.netty.util.internal.ObjectPool;
import pro.gravit.repackage.io.netty.util.internal.PlatformDependent;

abstract class PoolThreadCache$MemoryRegionCache<T> {
    private final int size;
    private final Queue<PoolThreadCache$MemoryRegionCache$Entry<T>> queue;
    private final PoolArena$SizeClass sizeClass;
    private int allocations;
    private static final ObjectPool<PoolThreadCache$MemoryRegionCache$Entry> RECYCLER = ObjectPool.newPool(new PoolThreadCache$MemoryRegionCache$1());

    PoolThreadCache$MemoryRegionCache(int n, PoolArena$SizeClass poolArena$SizeClass) {
        this.size = MathUtil.safeFindNextPositivePowerOfTwo(n);
        this.queue = PlatformDependent.newFixedMpscQueue(this.size);
        this.sizeClass = poolArena$SizeClass;
    }

    protected abstract void initBuf(PoolChunk<T> var1, ByteBuffer var2, long var3, PooledByteBuf<T> var5, int var6, PoolThreadCache var7);

    public final boolean add(PoolChunk<T> poolChunk, ByteBuffer byteBuffer, long l, int n) {
        PoolThreadCache$MemoryRegionCache$Entry poolThreadCache$MemoryRegionCache$Entry = PoolThreadCache$MemoryRegionCache.newEntry(poolChunk, byteBuffer, l, n);
        boolean bl = this.queue.offer(poolThreadCache$MemoryRegionCache$Entry);
        if (!bl) {
            poolThreadCache$MemoryRegionCache$Entry.recycle();
        }
        return bl;
    }

    public final boolean allocate(PooledByteBuf<T> pooledByteBuf, int n, PoolThreadCache poolThreadCache) {
        PoolThreadCache$MemoryRegionCache$Entry<T> poolThreadCache$MemoryRegionCache$Entry = this.queue.poll();
        if (poolThreadCache$MemoryRegionCache$Entry == null) {
            return false;
        }
        this.initBuf(poolThreadCache$MemoryRegionCache$Entry.chunk, poolThreadCache$MemoryRegionCache$Entry.nioBuffer, poolThreadCache$MemoryRegionCache$Entry.handle, pooledByteBuf, n, poolThreadCache);
        poolThreadCache$MemoryRegionCache$Entry.recycle();
        ++this.allocations;
        return true;
    }

    public final int free(boolean bl) {
        return this.free(Integer.MAX_VALUE, bl);
    }

    private int free(int n, boolean bl) {
        int n2;
        for (n2 = 0; n2 < n; ++n2) {
            PoolThreadCache$MemoryRegionCache$Entry<T> poolThreadCache$MemoryRegionCache$Entry = this.queue.poll();
            if (poolThreadCache$MemoryRegionCache$Entry == null) {
                return n2;
            }
            this.freeEntry(poolThreadCache$MemoryRegionCache$Entry, bl);
        }
        return n2;
    }

    public final void trim() {
        int n = this.size - this.allocations;
        this.allocations = 0;
        if (n > 0) {
            this.free(n, false);
        }
    }

    private void freeEntry(PoolThreadCache$MemoryRegionCache$Entry poolThreadCache$MemoryRegionCache$Entry, boolean bl) {
        PoolChunk poolChunk = poolThreadCache$MemoryRegionCache$Entry.chunk;
        long l = poolThreadCache$MemoryRegionCache$Entry.handle;
        ByteBuffer byteBuffer = poolThreadCache$MemoryRegionCache$Entry.nioBuffer;
        int n = poolThreadCache$MemoryRegionCache$Entry.normCapacity;
        if (!bl) {
            poolThreadCache$MemoryRegionCache$Entry.recycle();
        }
        poolChunk.arena.freeChunk(poolChunk, l, n, this.sizeClass, byteBuffer, bl);
    }

    private static PoolThreadCache$MemoryRegionCache$Entry newEntry(PoolChunk<?> poolChunk, ByteBuffer byteBuffer, long l, int n) {
        PoolThreadCache$MemoryRegionCache$Entry poolThreadCache$MemoryRegionCache$Entry = RECYCLER.get();
        poolThreadCache$MemoryRegionCache$Entry.chunk = poolChunk;
        poolThreadCache$MemoryRegionCache$Entry.nioBuffer = byteBuffer;
        poolThreadCache$MemoryRegionCache$Entry.handle = l;
        poolThreadCache$MemoryRegionCache$Entry.normCapacity = n;
        return poolThreadCache$MemoryRegionCache$Entry;
    }

    static /* synthetic */ Queue access$000(PoolThreadCache$MemoryRegionCache poolThreadCache$MemoryRegionCache) {
        return poolThreadCache$MemoryRegionCache.queue;
    }
}

