/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.buffer.search;

import pro.gravit.repackage.io.netty.buffer.search.AbstractSearchProcessorFactory;
import pro.gravit.repackage.io.netty.buffer.search.KmpSearchProcessorFactory$Processor;

public class KmpSearchProcessorFactory
extends AbstractSearchProcessorFactory {
    private final int[] jumpTable;
    private final byte[] needle;

    KmpSearchProcessorFactory(byte[] byArray) {
        this.needle = (byte[])byArray.clone();
        this.jumpTable = new int[byArray.length + 1];
        int n = 0;
        for (int i = 1; i < byArray.length; ++i) {
            while (n > 0 && byArray[n] != byArray[i]) {
                n = this.jumpTable[n];
            }
            if (byArray[n] == byArray[i]) {
                // empty if block
            }
            this.jumpTable[i + 1] = ++n;
        }
    }

    @Override
    public KmpSearchProcessorFactory$Processor newSearchProcessor() {
        return new KmpSearchProcessorFactory$Processor(this.needle, this.jumpTable);
    }
}

