/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.channel.embedded;

import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayDeque;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import pro.gravit.repackage.io.netty.channel.AbstractChannel;
import pro.gravit.repackage.io.netty.channel.AbstractChannel$AbstractUnsafe;
import pro.gravit.repackage.io.netty.channel.Channel;
import pro.gravit.repackage.io.netty.channel.Channel$Unsafe;
import pro.gravit.repackage.io.netty.channel.ChannelConfig;
import pro.gravit.repackage.io.netty.channel.ChannelFuture;
import pro.gravit.repackage.io.netty.channel.ChannelFutureListener;
import pro.gravit.repackage.io.netty.channel.ChannelHandler;
import pro.gravit.repackage.io.netty.channel.ChannelId;
import pro.gravit.repackage.io.netty.channel.ChannelMetadata;
import pro.gravit.repackage.io.netty.channel.ChannelOutboundBuffer;
import pro.gravit.repackage.io.netty.channel.ChannelPipeline;
import pro.gravit.repackage.io.netty.channel.ChannelPromise;
import pro.gravit.repackage.io.netty.channel.DefaultChannelConfig;
import pro.gravit.repackage.io.netty.channel.DefaultChannelPipeline;
import pro.gravit.repackage.io.netty.channel.EventLoop;
import pro.gravit.repackage.io.netty.channel.embedded.EmbeddedChannel$1;
import pro.gravit.repackage.io.netty.channel.embedded.EmbeddedChannel$2;
import pro.gravit.repackage.io.netty.channel.embedded.EmbeddedChannel$EmbeddedChannelPipeline;
import pro.gravit.repackage.io.netty.channel.embedded.EmbeddedChannel$EmbeddedUnsafe;
import pro.gravit.repackage.io.netty.channel.embedded.EmbeddedChannel$State;
import pro.gravit.repackage.io.netty.channel.embedded.EmbeddedChannelId;
import pro.gravit.repackage.io.netty.channel.embedded.EmbeddedEventLoop;
import pro.gravit.repackage.io.netty.channel.embedded.EmbeddedSocketAddress;
import pro.gravit.repackage.io.netty.util.ReferenceCountUtil;
import pro.gravit.repackage.io.netty.util.internal.ObjectUtil;
import pro.gravit.repackage.io.netty.util.internal.PlatformDependent;
import pro.gravit.repackage.io.netty.util.internal.RecyclableArrayList;
import pro.gravit.repackage.io.netty.util.internal.logging.InternalLogger;
import pro.gravit.repackage.io.netty.util.internal.logging.InternalLoggerFactory;

public class EmbeddedChannel
extends AbstractChannel {
    private static final SocketAddress LOCAL_ADDRESS = new EmbeddedSocketAddress();
    private static final SocketAddress REMOTE_ADDRESS = new EmbeddedSocketAddress();
    private static final ChannelHandler[] EMPTY_HANDLERS = new ChannelHandler[0];
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(EmbeddedChannel.class);
    private static final ChannelMetadata METADATA_NO_DISCONNECT = new ChannelMetadata(false);
    private static final ChannelMetadata METADATA_DISCONNECT = new ChannelMetadata(true);
    private final EmbeddedEventLoop loop = new EmbeddedEventLoop();
    private final ChannelFutureListener recordExceptionListener = new EmbeddedChannel$1(this);
    private final ChannelMetadata metadata;
    private final ChannelConfig config;
    private Queue<Object> inboundMessages;
    private Queue<Object> outboundMessages;
    private Throwable lastException;
    private EmbeddedChannel$State state;

    public EmbeddedChannel() {
        this(EMPTY_HANDLERS);
    }

    public EmbeddedChannel(ChannelId channelId) {
        this(channelId, EMPTY_HANDLERS);
    }

    public EmbeddedChannel(ChannelHandler ... channelHandlerArray) {
        this(EmbeddedChannelId.INSTANCE, channelHandlerArray);
    }

    public EmbeddedChannel(boolean bl, ChannelHandler ... channelHandlerArray) {
        this(EmbeddedChannelId.INSTANCE, bl, channelHandlerArray);
    }

    public EmbeddedChannel(boolean bl, boolean bl2, ChannelHandler ... channelHandlerArray) {
        this(EmbeddedChannelId.INSTANCE, bl, bl2, channelHandlerArray);
    }

    public EmbeddedChannel(ChannelId channelId, ChannelHandler ... channelHandlerArray) {
        this(channelId, false, channelHandlerArray);
    }

    public EmbeddedChannel(ChannelId channelId, boolean bl, ChannelHandler ... channelHandlerArray) {
        this(channelId, true, bl, channelHandlerArray);
    }

    public EmbeddedChannel(ChannelId channelId, boolean bl, boolean bl2, ChannelHandler ... channelHandlerArray) {
        this(null, channelId, bl, bl2, channelHandlerArray);
    }

    public EmbeddedChannel(Channel channel, ChannelId channelId, boolean bl, boolean bl2, ChannelHandler ... channelHandlerArray) {
        super(channel, channelId);
        this.metadata = EmbeddedChannel.metadata(bl2);
        this.config = new DefaultChannelConfig(this);
        this.setup(bl, channelHandlerArray);
    }

    public EmbeddedChannel(ChannelId channelId, boolean bl, ChannelConfig channelConfig, ChannelHandler ... channelHandlerArray) {
        super(null, channelId);
        this.metadata = EmbeddedChannel.metadata(bl);
        this.config = ObjectUtil.checkNotNull(channelConfig, "config");
        this.setup(true, channelHandlerArray);
    }

    private static ChannelMetadata metadata(boolean bl) {
        return bl ? METADATA_DISCONNECT : METADATA_NO_DISCONNECT;
    }

    private void setup(boolean bl, ChannelHandler ... channelHandlerArray) {
        ObjectUtil.checkNotNull(channelHandlerArray, "handlers");
        ChannelPipeline channelPipeline = this.pipeline();
        channelPipeline.addLast(new EmbeddedChannel$2(this, channelHandlerArray));
        if (bl) {
            ChannelFuture channelFuture = this.loop.register(this);
            assert (channelFuture.isDone());
        }
    }

    public void register() {
        ChannelFuture channelFuture = this.loop.register(this);
        assert (channelFuture.isDone());
        Throwable throwable = channelFuture.cause();
        if (throwable != null) {
            PlatformDependent.throwException(throwable);
        }
    }

    @Override
    protected final DefaultChannelPipeline newChannelPipeline() {
        return new EmbeddedChannel$EmbeddedChannelPipeline(this, this);
    }

    @Override
    public ChannelMetadata metadata() {
        return this.metadata;
    }

    @Override
    public ChannelConfig config() {
        return this.config;
    }

    @Override
    public boolean isOpen() {
        return this.state != EmbeddedChannel$State.CLOSED;
    }

    @Override
    public boolean isActive() {
        return this.state == EmbeddedChannel$State.ACTIVE;
    }

    public Queue<Object> inboundMessages() {
        if (this.inboundMessages == null) {
            this.inboundMessages = new ArrayDeque<Object>();
        }
        return this.inboundMessages;
    }

    @Deprecated
    public Queue<Object> lastInboundBuffer() {
        return this.inboundMessages();
    }

    public Queue<Object> outboundMessages() {
        if (this.outboundMessages == null) {
            this.outboundMessages = new ArrayDeque<Object>();
        }
        return this.outboundMessages;
    }

    @Deprecated
    public Queue<Object> lastOutboundBuffer() {
        return this.outboundMessages();
    }

    public <T> T readInbound() {
        Object object = EmbeddedChannel.poll(this.inboundMessages);
        if (object != null) {
            ReferenceCountUtil.touch(object, "Caller of readInbound() will handle the message from this point");
        }
        return (T)object;
    }

    public <T> T readOutbound() {
        Object object = EmbeddedChannel.poll(this.outboundMessages);
        if (object != null) {
            ReferenceCountUtil.touch(object, "Caller of readOutbound() will handle the message from this point.");
        }
        return (T)object;
    }

    public boolean writeInbound(Object ... objectArray) {
        this.ensureOpen();
        if (objectArray.length == 0) {
            return EmbeddedChannel.isNotEmpty(this.inboundMessages);
        }
        ChannelPipeline channelPipeline = this.pipeline();
        for (Object object : objectArray) {
            channelPipeline.fireChannelRead(object);
        }
        this.flushInbound(false, this.voidPromise());
        return EmbeddedChannel.isNotEmpty(this.inboundMessages);
    }

    public ChannelFuture writeOneInbound(Object object) {
        return this.writeOneInbound(object, this.newPromise());
    }

    public ChannelFuture writeOneInbound(Object object, ChannelPromise channelPromise) {
        if (this.checkOpen(true)) {
            this.pipeline().fireChannelRead(object);
        }
        return this.checkException(channelPromise);
    }

    public EmbeddedChannel flushInbound() {
        this.flushInbound(true, this.voidPromise());
        return this;
    }

    private ChannelFuture flushInbound(boolean bl, ChannelPromise channelPromise) {
        if (this.checkOpen(bl)) {
            this.pipeline().fireChannelReadComplete();
            this.runPendingTasks();
        }
        return this.checkException(channelPromise);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeOutbound(Object ... objectArray) {
        this.ensureOpen();
        if (objectArray.length == 0) {
            return EmbeddedChannel.isNotEmpty(this.outboundMessages);
        }
        RecyclableArrayList recyclableArrayList = RecyclableArrayList.newInstance(objectArray.length);
        try {
            Object object;
            Object[] objectArray2 = objectArray;
            int n = objectArray2.length;
            for (int i = 0; i < n && (object = objectArray2[i]) != null; ++i) {
                recyclableArrayList.add(this.write(object));
            }
            this.flushOutbound0();
            int n2 = recyclableArrayList.size();
            for (n = 0; n < n2; ++n) {
                ChannelFuture channelFuture = (ChannelFuture)recyclableArrayList.get(n);
                if (channelFuture.isDone()) {
                    this.recordException(channelFuture);
                    continue;
                }
                channelFuture.addListener(this.recordExceptionListener);
            }
            this.checkException();
            n = EmbeddedChannel.isNotEmpty(this.outboundMessages) ? 1 : 0;
            return n != 0;
        }
        finally {
            recyclableArrayList.recycle();
        }
    }

    public ChannelFuture writeOneOutbound(Object object) {
        return this.writeOneOutbound(object, this.newPromise());
    }

    public ChannelFuture writeOneOutbound(Object object, ChannelPromise channelPromise) {
        if (this.checkOpen(true)) {
            return this.write(object, channelPromise);
        }
        return this.checkException(channelPromise);
    }

    public EmbeddedChannel flushOutbound() {
        if (this.checkOpen(true)) {
            this.flushOutbound0();
        }
        this.checkException(this.voidPromise());
        return this;
    }

    private void flushOutbound0() {
        this.runPendingTasks();
        this.flush();
    }

    public boolean finish() {
        return this.finish(false);
    }

    public boolean finishAndReleaseAll() {
        return this.finish(true);
    }

    private boolean finish(boolean bl) {
        this.close();
        try {
            this.checkException();
            boolean bl2 = EmbeddedChannel.isNotEmpty(this.inboundMessages) || EmbeddedChannel.isNotEmpty(this.outboundMessages);
            return bl2;
        }
        finally {
            if (bl) {
                EmbeddedChannel.releaseAll(this.inboundMessages);
                EmbeddedChannel.releaseAll(this.outboundMessages);
            }
        }
    }

    public boolean releaseInbound() {
        return EmbeddedChannel.releaseAll(this.inboundMessages);
    }

    public boolean releaseOutbound() {
        return EmbeddedChannel.releaseAll(this.outboundMessages);
    }

    private static boolean releaseAll(Queue<Object> queue) {
        if (EmbeddedChannel.isNotEmpty(queue)) {
            Object object;
            while ((object = queue.poll()) != null) {
                ReferenceCountUtil.release(object);
            }
            return true;
        }
        return false;
    }

    private void finishPendingTasks(boolean bl) {
        this.runPendingTasks();
        if (bl) {
            this.embeddedEventLoop().cancelScheduledTasks();
        }
    }

    @Override
    public final ChannelFuture close() {
        return this.close(this.newPromise());
    }

    @Override
    public final ChannelFuture disconnect() {
        return this.disconnect(this.newPromise());
    }

    @Override
    public final ChannelFuture close(ChannelPromise channelPromise) {
        this.runPendingTasks();
        ChannelFuture channelFuture = super.close(channelPromise);
        this.finishPendingTasks(true);
        return channelFuture;
    }

    @Override
    public final ChannelFuture disconnect(ChannelPromise channelPromise) {
        ChannelFuture channelFuture = super.disconnect(channelPromise);
        this.finishPendingTasks(!this.metadata.hasDisconnect());
        return channelFuture;
    }

    private static boolean isNotEmpty(Queue<Object> queue) {
        return queue != null && !queue.isEmpty();
    }

    private static Object poll(Queue<Object> queue) {
        return queue != null ? queue.poll() : null;
    }

    public void runPendingTasks() {
        try {
            this.embeddedEventLoop().runTasks();
        }
        catch (Exception exception) {
            this.recordException(exception);
        }
        try {
            this.embeddedEventLoop().runScheduledTasks();
        }
        catch (Exception exception) {
            this.recordException(exception);
        }
    }

    public boolean hasPendingTasks() {
        return this.embeddedEventLoop().hasPendingNormalTasks() || this.embeddedEventLoop().nextScheduledTask() == 0L;
    }

    public long runScheduledPendingTasks() {
        try {
            return this.embeddedEventLoop().runScheduledTasks();
        }
        catch (Exception exception) {
            this.recordException(exception);
            return this.embeddedEventLoop().nextScheduledTask();
        }
    }

    private void recordException(ChannelFuture channelFuture) {
        if (!channelFuture.isSuccess()) {
            this.recordException(channelFuture.cause());
        }
    }

    private void recordException(Throwable throwable) {
        if (this.lastException == null) {
            this.lastException = throwable;
        } else {
            logger.warn("More than one exception was raised. Will report only the first one and log others.", throwable);
        }
    }

    public void advanceTimeBy(long l, TimeUnit timeUnit) {
        this.embeddedEventLoop().advanceTimeBy(timeUnit.toNanos(l));
    }

    public void freezeTime() {
        this.embeddedEventLoop().freezeTime();
    }

    public void unfreezeTime() {
        this.embeddedEventLoop().unfreezeTime();
    }

    private ChannelFuture checkException(ChannelPromise channelPromise) {
        Throwable throwable = this.lastException;
        if (throwable != null) {
            this.lastException = null;
            if (channelPromise.isVoid()) {
                PlatformDependent.throwException(throwable);
            }
            return channelPromise.setFailure(throwable);
        }
        return channelPromise.setSuccess();
    }

    public void checkException() {
        this.checkException(this.voidPromise());
    }

    private boolean checkOpen(boolean bl) {
        if (!this.isOpen()) {
            if (bl) {
                this.recordException(new ClosedChannelException());
            }
            return false;
        }
        return true;
    }

    private EmbeddedEventLoop embeddedEventLoop() {
        if (this.isRegistered()) {
            return (EmbeddedEventLoop)super.eventLoop();
        }
        return this.loop;
    }

    protected final void ensureOpen() {
        if (!this.checkOpen(true)) {
            this.checkException();
        }
    }

    @Override
    protected boolean isCompatible(EventLoop eventLoop) {
        return eventLoop instanceof EmbeddedEventLoop;
    }

    @Override
    protected SocketAddress localAddress0() {
        return this.isActive() ? LOCAL_ADDRESS : null;
    }

    @Override
    protected SocketAddress remoteAddress0() {
        return this.isActive() ? REMOTE_ADDRESS : null;
    }

    @Override
    protected void doRegister() {
        this.state = EmbeddedChannel$State.ACTIVE;
    }

    @Override
    protected void doBind(SocketAddress socketAddress) {
    }

    @Override
    protected void doDisconnect() {
        if (!this.metadata.hasDisconnect()) {
            this.doClose();
        }
    }

    @Override
    protected void doClose() {
        this.state = EmbeddedChannel$State.CLOSED;
    }

    @Override
    protected void doBeginRead() {
    }

    @Override
    protected AbstractChannel$AbstractUnsafe newUnsafe() {
        return new EmbeddedChannel$EmbeddedUnsafe(this, null);
    }

    @Override
    public Channel$Unsafe unsafe() {
        return ((EmbeddedChannel$EmbeddedUnsafe)super.unsafe()).wrapped;
    }

    @Override
    protected void doWrite(ChannelOutboundBuffer channelOutboundBuffer) {
        Object object;
        while ((object = channelOutboundBuffer.current()) != null) {
            ReferenceCountUtil.retain(object);
            this.handleOutboundMessage(object);
            channelOutboundBuffer.remove();
        }
    }

    protected void handleOutboundMessage(Object object) {
        this.outboundMessages().add(object);
    }

    protected void handleInboundMessage(Object object) {
        this.inboundMessages().add(object);
    }

    static /* synthetic */ void access$000(EmbeddedChannel embeddedChannel, ChannelFuture channelFuture) {
        embeddedChannel.recordException(channelFuture);
    }

    static /* synthetic */ void access$200(EmbeddedChannel embeddedChannel, Throwable throwable) {
        embeddedChannel.recordException(throwable);
    }
}

