/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.channel.group;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import pro.gravit.repackage.io.netty.channel.Channel;
import pro.gravit.repackage.io.netty.channel.ChannelFuture;
import pro.gravit.repackage.io.netty.channel.ChannelFutureListener;
import pro.gravit.repackage.io.netty.channel.group.ChannelGroup;
import pro.gravit.repackage.io.netty.channel.group.ChannelGroupException;
import pro.gravit.repackage.io.netty.channel.group.ChannelGroupFuture;
import pro.gravit.repackage.io.netty.channel.group.DefaultChannelGroupFuture$1;
import pro.gravit.repackage.io.netty.util.concurrent.BlockingOperationException;
import pro.gravit.repackage.io.netty.util.concurrent.DefaultPromise;
import pro.gravit.repackage.io.netty.util.concurrent.EventExecutor;
import pro.gravit.repackage.io.netty.util.concurrent.Future;
import pro.gravit.repackage.io.netty.util.concurrent.GenericFutureListener;
import pro.gravit.repackage.io.netty.util.concurrent.ImmediateEventExecutor;
import pro.gravit.repackage.io.netty.util.internal.ObjectUtil;

final class DefaultChannelGroupFuture
extends DefaultPromise<Void>
implements ChannelGroupFuture {
    private final ChannelGroup group;
    private final Map<Channel, ChannelFuture> futures;
    private int successCount;
    private int failureCount;
    private final ChannelFutureListener childListener = new DefaultChannelGroupFuture$1(this);

    DefaultChannelGroupFuture(ChannelGroup channelGroup, Collection<ChannelFuture> collection, EventExecutor eventExecutor) {
        super(eventExecutor);
        this.group = ObjectUtil.checkNotNull(channelGroup, "group");
        ObjectUtil.checkNotNull(collection, "futures");
        LinkedHashMap<Channel, ChannelFuture> linkedHashMap = new LinkedHashMap<Channel, ChannelFuture>();
        for (ChannelFuture channelFuture : collection) {
            linkedHashMap.put(channelFuture.channel(), channelFuture);
        }
        this.futures = Collections.unmodifiableMap(linkedHashMap);
        for (ChannelFuture channelFuture : this.futures.values()) {
            channelFuture.addListener(this.childListener);
        }
        if (this.futures.isEmpty()) {
            this.setSuccess0();
        }
    }

    DefaultChannelGroupFuture(ChannelGroup channelGroup, Map<Channel, ChannelFuture> map, EventExecutor eventExecutor) {
        super(eventExecutor);
        this.group = channelGroup;
        this.futures = Collections.unmodifiableMap(map);
        for (ChannelFuture channelFuture : this.futures.values()) {
            channelFuture.addListener(this.childListener);
        }
        if (this.futures.isEmpty()) {
            this.setSuccess0();
        }
    }

    @Override
    public ChannelGroup group() {
        return this.group;
    }

    @Override
    public ChannelFuture find(Channel channel) {
        return this.futures.get(channel);
    }

    @Override
    public Iterator<ChannelFuture> iterator() {
        return this.futures.values().iterator();
    }

    @Override
    public synchronized boolean isPartialSuccess() {
        return this.successCount != 0 && this.successCount != this.futures.size();
    }

    @Override
    public synchronized boolean isPartialFailure() {
        return this.failureCount != 0 && this.failureCount != this.futures.size();
    }

    @Override
    public DefaultChannelGroupFuture addListener(GenericFutureListener<? extends Future<? super Void>> genericFutureListener) {
        super.addListener(genericFutureListener);
        return this;
    }

    @Override
    public DefaultChannelGroupFuture addListeners(GenericFutureListener<? extends Future<? super Void>> ... genericFutureListenerArray) {
        super.addListeners(genericFutureListenerArray);
        return this;
    }

    @Override
    public DefaultChannelGroupFuture removeListener(GenericFutureListener<? extends Future<? super Void>> genericFutureListener) {
        super.removeListener(genericFutureListener);
        return this;
    }

    @Override
    public DefaultChannelGroupFuture removeListeners(GenericFutureListener<? extends Future<? super Void>> ... genericFutureListenerArray) {
        super.removeListeners(genericFutureListenerArray);
        return this;
    }

    @Override
    public DefaultChannelGroupFuture await() {
        super.await();
        return this;
    }

    @Override
    public DefaultChannelGroupFuture awaitUninterruptibly() {
        super.awaitUninterruptibly();
        return this;
    }

    @Override
    public DefaultChannelGroupFuture syncUninterruptibly() {
        super.syncUninterruptibly();
        return this;
    }

    @Override
    public DefaultChannelGroupFuture sync() {
        super.sync();
        return this;
    }

    @Override
    public ChannelGroupException cause() {
        return (ChannelGroupException)super.cause();
    }

    private void setSuccess0() {
        super.setSuccess(null);
    }

    private void setFailure0(ChannelGroupException channelGroupException) {
        super.setFailure(channelGroupException);
    }

    public DefaultChannelGroupFuture setSuccess(Void void_) {
        throw new IllegalStateException();
    }

    @Override
    public boolean trySuccess(Void void_) {
        throw new IllegalStateException();
    }

    public DefaultChannelGroupFuture setFailure(Throwable throwable) {
        throw new IllegalStateException();
    }

    @Override
    public boolean tryFailure(Throwable throwable) {
        throw new IllegalStateException();
    }

    @Override
    protected void checkDeadLock() {
        EventExecutor eventExecutor = this.executor();
        if (eventExecutor != null && eventExecutor != ImmediateEventExecutor.INSTANCE && eventExecutor.inEventLoop()) {
            throw new BlockingOperationException();
        }
    }

    static /* synthetic */ int access$008(DefaultChannelGroupFuture defaultChannelGroupFuture) {
        return defaultChannelGroupFuture.successCount++;
    }

    static /* synthetic */ int access$108(DefaultChannelGroupFuture defaultChannelGroupFuture) {
        return defaultChannelGroupFuture.failureCount++;
    }

    static /* synthetic */ int access$000(DefaultChannelGroupFuture defaultChannelGroupFuture) {
        return defaultChannelGroupFuture.successCount;
    }

    static /* synthetic */ int access$100(DefaultChannelGroupFuture defaultChannelGroupFuture) {
        return defaultChannelGroupFuture.failureCount;
    }

    static /* synthetic */ Map access$200(DefaultChannelGroupFuture defaultChannelGroupFuture) {
        return defaultChannelGroupFuture.futures;
    }

    static /* synthetic */ void access$300(DefaultChannelGroupFuture defaultChannelGroupFuture, ChannelGroupException channelGroupException) {
        defaultChannelGroupFuture.setFailure0(channelGroupException);
    }

    static /* synthetic */ void access$400(DefaultChannelGroupFuture defaultChannelGroupFuture) {
        defaultChannelGroupFuture.setSuccess0();
    }
}

