/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.channel.unix;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import java.nio.channels.AlreadyConnectedException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ConnectionPendingException;
import java.nio.channels.NotYetConnectedException;
import pro.gravit.repackage.io.netty.channel.unix.Errors$NativeIoException;
import pro.gravit.repackage.io.netty.channel.unix.ErrorsStaticallyReferencedJniMethods;
import pro.gravit.repackage.io.netty.util.internal.EmptyArrays;

public final class Errors {
    public static final int ERRNO_ENOENT_NEGATIVE = -ErrorsStaticallyReferencedJniMethods.errnoENOENT();
    public static final int ERRNO_ENOTCONN_NEGATIVE = -ErrorsStaticallyReferencedJniMethods.errnoENOTCONN();
    public static final int ERRNO_EBADF_NEGATIVE = -ErrorsStaticallyReferencedJniMethods.errnoEBADF();
    public static final int ERRNO_EPIPE_NEGATIVE = -ErrorsStaticallyReferencedJniMethods.errnoEPIPE();
    public static final int ERRNO_ECONNRESET_NEGATIVE = -ErrorsStaticallyReferencedJniMethods.errnoECONNRESET();
    public static final int ERRNO_EAGAIN_NEGATIVE = -ErrorsStaticallyReferencedJniMethods.errnoEAGAIN();
    public static final int ERRNO_EWOULDBLOCK_NEGATIVE = -ErrorsStaticallyReferencedJniMethods.errnoEWOULDBLOCK();
    public static final int ERRNO_EINPROGRESS_NEGATIVE = -ErrorsStaticallyReferencedJniMethods.errnoEINPROGRESS();
    public static final int ERROR_ECONNREFUSED_NEGATIVE = -ErrorsStaticallyReferencedJniMethods.errorECONNREFUSED();
    public static final int ERROR_EISCONN_NEGATIVE = -ErrorsStaticallyReferencedJniMethods.errorEISCONN();
    public static final int ERROR_EALREADY_NEGATIVE = -ErrorsStaticallyReferencedJniMethods.errorEALREADY();
    public static final int ERROR_ENETUNREACH_NEGATIVE = -ErrorsStaticallyReferencedJniMethods.errorENETUNREACH();
    private static final String[] ERRORS = new String[512];

    static boolean handleConnectErrno(String string, int n) {
        if (n == ERRNO_EINPROGRESS_NEGATIVE || n == ERROR_EALREADY_NEGATIVE) {
            return false;
        }
        throw Errors.newConnectException0(string, n);
    }

    @Deprecated
    public static void throwConnectException(String string, int n) {
        if (n == ERROR_EALREADY_NEGATIVE) {
            throw new ConnectionPendingException();
        }
        throw Errors.newConnectException0(string, n);
    }

    private static IOException newConnectException0(String string, int n) {
        if (n == ERROR_ENETUNREACH_NEGATIVE) {
            return new NoRouteToHostException();
        }
        if (n == ERROR_EISCONN_NEGATIVE) {
            throw new AlreadyConnectedException();
        }
        if (n == ERRNO_ENOENT_NEGATIVE) {
            return new FileNotFoundException();
        }
        return new ConnectException(string + "(..) failed: " + ERRORS[-n]);
    }

    public static Errors$NativeIoException newConnectionResetException(String string, int n) {
        Errors$NativeIoException errors$NativeIoException = new Errors$NativeIoException(string, n, false);
        errors$NativeIoException.setStackTrace(EmptyArrays.EMPTY_STACK_TRACE);
        return errors$NativeIoException;
    }

    public static Errors$NativeIoException newIOException(String string, int n) {
        return new Errors$NativeIoException(string, n);
    }

    @Deprecated
    public static int ioResult(String string, int n, Errors$NativeIoException errors$NativeIoException, ClosedChannelException closedChannelException) {
        if (n == ERRNO_EAGAIN_NEGATIVE || n == ERRNO_EWOULDBLOCK_NEGATIVE) {
            return 0;
        }
        if (n == errors$NativeIoException.expectedErr()) {
            throw errors$NativeIoException;
        }
        if (n == ERRNO_EBADF_NEGATIVE) {
            throw closedChannelException;
        }
        if (n == ERRNO_ENOTCONN_NEGATIVE) {
            throw new NotYetConnectedException();
        }
        if (n == ERRNO_ENOENT_NEGATIVE) {
            throw new FileNotFoundException();
        }
        throw Errors.newIOException(string, n);
    }

    public static int ioResult(String string, int n) {
        if (n == ERRNO_EAGAIN_NEGATIVE || n == ERRNO_EWOULDBLOCK_NEGATIVE) {
            return 0;
        }
        if (n == ERRNO_EBADF_NEGATIVE) {
            throw new ClosedChannelException();
        }
        if (n == ERRNO_ENOTCONN_NEGATIVE) {
            throw new NotYetConnectedException();
        }
        if (n == ERRNO_ENOENT_NEGATIVE) {
            throw new FileNotFoundException();
        }
        throw new Errors$NativeIoException(string, n, false);
    }

    private Errors() {
    }

    static /* synthetic */ String[] access$000() {
        return ERRORS;
    }

    static {
        for (int i = 0; i < ERRORS.length; ++i) {
            Errors.ERRORS[i] = ErrorsStaticallyReferencedJniMethods.strError(i);
        }
    }
}

