/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.codec;

import java.util.List;
import pro.gravit.repackage.io.netty.buffer.ByteBuf;
import pro.gravit.repackage.io.netty.channel.ChannelHandlerContext;
import pro.gravit.repackage.io.netty.handler.codec.ByteToMessageDecoder;
import pro.gravit.repackage.io.netty.handler.codec.LineBasedFrameDecoder;
import pro.gravit.repackage.io.netty.handler.codec.TooLongFrameException;
import pro.gravit.repackage.io.netty.util.internal.ObjectUtil;

public class DelimiterBasedFrameDecoder
extends ByteToMessageDecoder {
    private final ByteBuf[] delimiters;
    private final int maxFrameLength;
    private final boolean stripDelimiter;
    private final boolean failFast;
    private boolean discardingTooLongFrame;
    private int tooLongFrameLength;
    private final LineBasedFrameDecoder lineBasedDecoder;

    public DelimiterBasedFrameDecoder(int n, ByteBuf byteBuf) {
        this(n, true, byteBuf);
    }

    public DelimiterBasedFrameDecoder(int n, boolean bl, ByteBuf byteBuf) {
        this(n, bl, true, byteBuf);
    }

    public DelimiterBasedFrameDecoder(int n, boolean bl, boolean bl2, ByteBuf byteBuf) {
        this(n, bl, bl2, new ByteBuf[]{byteBuf.slice(byteBuf.readerIndex(), byteBuf.readableBytes())});
    }

    public DelimiterBasedFrameDecoder(int n, ByteBuf ... byteBufArray) {
        this(n, true, byteBufArray);
    }

    public DelimiterBasedFrameDecoder(int n, boolean bl, ByteBuf ... byteBufArray) {
        this(n, bl, true, byteBufArray);
    }

    public DelimiterBasedFrameDecoder(int n, boolean bl, boolean bl2, ByteBuf ... byteBufArray) {
        DelimiterBasedFrameDecoder.validateMaxFrameLength(n);
        ObjectUtil.checkNonEmpty(byteBufArray, "delimiters");
        if (DelimiterBasedFrameDecoder.isLineBased(byteBufArray) && !this.isSubclass()) {
            this.lineBasedDecoder = new LineBasedFrameDecoder(n, bl, bl2);
            this.delimiters = null;
        } else {
            this.delimiters = new ByteBuf[byteBufArray.length];
            for (int i = 0; i < byteBufArray.length; ++i) {
                ByteBuf byteBuf = byteBufArray[i];
                DelimiterBasedFrameDecoder.validateDelimiter(byteBuf);
                this.delimiters[i] = byteBuf.slice(byteBuf.readerIndex(), byteBuf.readableBytes());
            }
            this.lineBasedDecoder = null;
        }
        this.maxFrameLength = n;
        this.stripDelimiter = bl;
        this.failFast = bl2;
    }

    private static boolean isLineBased(ByteBuf[] byteBufArray) {
        if (byteBufArray.length != 2) {
            return false;
        }
        ByteBuf byteBuf = byteBufArray[0];
        ByteBuf byteBuf2 = byteBufArray[1];
        if (byteBuf.capacity() < byteBuf2.capacity()) {
            byteBuf = byteBufArray[1];
            byteBuf2 = byteBufArray[0];
        }
        return byteBuf.capacity() == 2 && byteBuf2.capacity() == 1 && byteBuf.getByte(0) == 13 && byteBuf.getByte(1) == 10 && byteBuf2.getByte(0) == 10;
    }

    private boolean isSubclass() {
        return this.getClass() != DelimiterBasedFrameDecoder.class;
    }

    @Override
    protected final void decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, List<Object> list) {
        Object object = this.decode(channelHandlerContext, byteBuf);
        if (object != null) {
            list.add(object);
        }
    }

    protected Object decode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf) {
        if (this.lineBasedDecoder != null) {
            return this.lineBasedDecoder.decode(channelHandlerContext, byteBuf);
        }
        int n = Integer.MAX_VALUE;
        ByteBuf byteBuf2 = null;
        for (ByteBuf byteBuf3 : this.delimiters) {
            int n2 = DelimiterBasedFrameDecoder.indexOf(byteBuf, byteBuf3);
            if (n2 < 0 || n2 >= n) continue;
            n = n2;
            byteBuf2 = byteBuf3;
        }
        if (byteBuf2 != null) {
            ByteBuf byteBuf4;
            int n3 = byteBuf2.capacity();
            if (this.discardingTooLongFrame) {
                this.discardingTooLongFrame = false;
                byteBuf.skipBytes(n + n3);
                int n4 = this.tooLongFrameLength;
                this.tooLongFrameLength = 0;
                if (!this.failFast) {
                    this.fail(n4);
                }
                return null;
            }
            if (n > this.maxFrameLength) {
                byteBuf.skipBytes(n + n3);
                this.fail(n);
                return null;
            }
            if (this.stripDelimiter) {
                byteBuf4 = byteBuf.readRetainedSlice(n);
                byteBuf.skipBytes(n3);
            } else {
                byteBuf4 = byteBuf.readRetainedSlice(n + n3);
            }
            return byteBuf4;
        }
        if (!this.discardingTooLongFrame) {
            if (byteBuf.readableBytes() > this.maxFrameLength) {
                this.tooLongFrameLength = byteBuf.readableBytes();
                byteBuf.skipBytes(byteBuf.readableBytes());
                this.discardingTooLongFrame = true;
                if (this.failFast) {
                    this.fail(this.tooLongFrameLength);
                }
            }
        } else {
            this.tooLongFrameLength += byteBuf.readableBytes();
            byteBuf.skipBytes(byteBuf.readableBytes());
        }
        return null;
    }

    private void fail(long l) {
        if (l > 0L) {
            throw new TooLongFrameException("frame length exceeds " + this.maxFrameLength + ": " + l + " - discarded");
        }
        throw new TooLongFrameException("frame length exceeds " + this.maxFrameLength + " - discarding");
    }

    private static int indexOf(ByteBuf byteBuf, ByteBuf byteBuf2) {
        for (int i = byteBuf.readerIndex(); i < byteBuf.writerIndex(); ++i) {
            int n;
            int n2 = i;
            for (n = 0; n < byteBuf2.capacity() && byteBuf.getByte(n2) == byteBuf2.getByte(n); ++n) {
                if (++n2 != byteBuf.writerIndex() || n == byteBuf2.capacity() - 1) continue;
                return -1;
            }
            if (n != byteBuf2.capacity()) continue;
            return i - byteBuf.readerIndex();
        }
        return -1;
    }

    private static void validateDelimiter(ByteBuf byteBuf) {
        ObjectUtil.checkNotNull(byteBuf, "delimiter");
        if (!byteBuf.isReadable()) {
            throw new IllegalArgumentException("empty delimiter");
        }
    }

    private static void validateMaxFrameLength(int n) {
        ObjectUtil.checkPositive(n, "maxFrameLength");
    }
}

