/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.codec.compression;

import com.aayushatharva.brotli4j.encoder.BrotliEncoderChannel;
import com.aayushatharva.brotli4j.encoder.Encoder;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.WritableByteChannel;
import pro.gravit.repackage.io.netty.buffer.ByteBuf;
import pro.gravit.repackage.io.netty.channel.ChannelHandlerContext;
import pro.gravit.repackage.io.netty.channel.ChannelPromise;
import pro.gravit.repackage.io.netty.handler.codec.compression.BrotliEncoder;
import pro.gravit.repackage.io.netty.handler.codec.compression.BrotliEncoder$1;
import pro.gravit.repackage.io.netty.handler.codec.compression.BrotliEncoder$Writer$1;
import pro.gravit.repackage.io.netty.util.ReferenceCountUtil;

final class BrotliEncoder$Writer
implements WritableByteChannel {
    private ByteBuf writableBuffer;
    private final BrotliEncoderChannel brotliEncoderChannel;
    private final ChannelHandlerContext ctx;
    private boolean isClosed;

    private BrotliEncoder$Writer(Encoder.Parameters parameters, ChannelHandlerContext channelHandlerContext) {
        this.brotliEncoderChannel = new BrotliEncoderChannel((WritableByteChannel)this, parameters);
        this.ctx = channelHandlerContext;
    }

    private void encode(ByteBuf byteBuf, boolean bl) {
        try {
            this.allocate(bl);
            this.brotliEncoderChannel.write(byteBuf.nioBuffer());
            BrotliEncoder.access$300().invoke((Object)this.brotliEncoderChannel, new Object[0]);
        }
        catch (Exception exception) {
            ReferenceCountUtil.release(byteBuf);
            throw exception;
        }
    }

    private void allocate(boolean bl) {
        this.writableBuffer = bl ? this.ctx.alloc().ioBuffer() : this.ctx.alloc().buffer();
    }

    @Override
    public int write(ByteBuffer byteBuffer) {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        return this.writableBuffer.writeBytes(byteBuffer).readableBytes();
    }

    @Override
    public boolean isOpen() {
        return !this.isClosed;
    }

    @Override
    public void close() {
        ChannelPromise channelPromise = this.ctx.newPromise();
        this.ctx.executor().execute(new BrotliEncoder$Writer$1(this, channelPromise));
    }

    public void finish(ChannelPromise channelPromise) {
        if (!this.isClosed) {
            this.allocate(true);
            try {
                this.brotliEncoderChannel.close();
                this.isClosed = true;
            }
            catch (Exception exception) {
                channelPromise.setFailure(exception);
                ReferenceCountUtil.release(this.writableBuffer);
                return;
            }
            this.ctx.writeAndFlush(this.writableBuffer, channelPromise);
        }
    }

    /* synthetic */ BrotliEncoder$Writer(Encoder.Parameters parameters, ChannelHandlerContext channelHandlerContext, BrotliEncoder$1 brotliEncoder$1) {
        this(parameters, channelHandlerContext);
    }

    static /* synthetic */ void access$100(BrotliEncoder$Writer brotliEncoder$Writer, ByteBuf byteBuf, boolean bl) {
        brotliEncoder$Writer.encode(byteBuf, bl);
    }

    static /* synthetic */ ByteBuf access$200(BrotliEncoder$Writer brotliEncoder$Writer) {
        return brotliEncoder$Writer.writableBuffer;
    }
}

