/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.codec.compression;

import com.aayushatharva.brotli4j.encoder.Encoder;
import java.lang.reflect.Method;
import pro.gravit.repackage.io.netty.buffer.ByteBuf;
import pro.gravit.repackage.io.netty.buffer.Unpooled;
import pro.gravit.repackage.io.netty.channel.ChannelHandler;
import pro.gravit.repackage.io.netty.channel.ChannelHandlerContext;
import pro.gravit.repackage.io.netty.handler.codec.MessageToByteEncoder;
import pro.gravit.repackage.io.netty.handler.codec.compression.BrotliEncoder$Writer;
import pro.gravit.repackage.io.netty.handler.codec.compression.BrotliOptions;
import pro.gravit.repackage.io.netty.util.AttributeKey;
import pro.gravit.repackage.io.netty.util.internal.ObjectUtil;

@ChannelHandler.Sharable
public final class BrotliEncoder
extends MessageToByteEncoder<ByteBuf> {
    private static final AttributeKey<BrotliEncoder$Writer> ATTR;
    private static final Method FLUSH_METHOD;
    private final Encoder.Parameters parameters;
    private final boolean isSharable;
    private BrotliEncoder$Writer writer;

    public BrotliEncoder() {
        this(BrotliOptions.DEFAULT);
    }

    public BrotliEncoder(BrotliOptions brotliOptions) {
        this(brotliOptions.parameters());
    }

    public BrotliEncoder(Encoder.Parameters parameters) {
        this(parameters, true);
    }

    public BrotliEncoder(Encoder.Parameters parameters, boolean bl) {
        this.parameters = ObjectUtil.checkNotNull(parameters, "Parameters");
        this.isSharable = bl;
    }

    @Override
    public void handlerAdded(ChannelHandlerContext channelHandlerContext) {
        BrotliEncoder$Writer brotliEncoder$Writer = new BrotliEncoder$Writer(this.parameters, channelHandlerContext, null);
        if (this.isSharable) {
            channelHandlerContext.channel().attr(ATTR).set(brotliEncoder$Writer);
        } else {
            this.writer = brotliEncoder$Writer;
        }
        super.handlerAdded(channelHandlerContext);
    }

    @Override
    public void handlerRemoved(ChannelHandlerContext channelHandlerContext) {
        this.finish(channelHandlerContext);
        super.handlerRemoved(channelHandlerContext);
    }

    @Override
    protected void encode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, ByteBuf byteBuf2) {
    }

    @Override
    protected ByteBuf allocateBuffer(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, boolean bl) {
        if (!byteBuf.isReadable()) {
            return Unpooled.EMPTY_BUFFER;
        }
        BrotliEncoder$Writer brotliEncoder$Writer = this.isSharable ? channelHandlerContext.channel().attr(ATTR).get() : this.writer;
        if (brotliEncoder$Writer == null) {
            return Unpooled.EMPTY_BUFFER;
        }
        BrotliEncoder$Writer.access$100(brotliEncoder$Writer, byteBuf, bl);
        return BrotliEncoder$Writer.access$200(brotliEncoder$Writer);
    }

    @Override
    public boolean isSharable() {
        return this.isSharable;
    }

    public void finish(ChannelHandlerContext channelHandlerContext) {
        BrotliEncoder$Writer brotliEncoder$Writer = this.isSharable ? (BrotliEncoder$Writer)channelHandlerContext.channel().attr(ATTR).getAndSet(null) : this.writer;
        if (brotliEncoder$Writer != null) {
            brotliEncoder$Writer.close();
            this.writer = null;
        }
    }

    static /* synthetic */ Method access$300() {
        return FLUSH_METHOD;
    }

    static {
        Method method;
        ATTR = AttributeKey.valueOf("BrotliEncoderWriter");
        try {
            method = Encoder.class.getDeclaredMethod("flush", new Class[0]);
            method.setAccessible(true);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new IllegalStateException(noSuchMethodException);
        }
        FLUSH_METHOD = method;
    }
}

