/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.codec.compression;

import java.util.concurrent.TimeUnit;
import pro.gravit.repackage.io.netty.buffer.ByteBuf;
import pro.gravit.repackage.io.netty.channel.ChannelFuture;
import pro.gravit.repackage.io.netty.channel.ChannelHandlerContext;
import pro.gravit.repackage.io.netty.channel.ChannelPromise;
import pro.gravit.repackage.io.netty.handler.codec.MessageToByteEncoder;
import pro.gravit.repackage.io.netty.handler.codec.compression.Bzip2BitWriter;
import pro.gravit.repackage.io.netty.handler.codec.compression.Bzip2BlockCompressor;
import pro.gravit.repackage.io.netty.handler.codec.compression.Bzip2Encoder$1;
import pro.gravit.repackage.io.netty.handler.codec.compression.Bzip2Encoder$2;
import pro.gravit.repackage.io.netty.handler.codec.compression.Bzip2Encoder$3;
import pro.gravit.repackage.io.netty.handler.codec.compression.Bzip2Encoder$State;
import pro.gravit.repackage.io.netty.util.concurrent.EventExecutor;

public class Bzip2Encoder
extends MessageToByteEncoder<ByteBuf> {
    private Bzip2Encoder$State currentState = Bzip2Encoder$State.INIT;
    private final Bzip2BitWriter writer = new Bzip2BitWriter();
    private final int streamBlockSize;
    private int streamCRC;
    private Bzip2BlockCompressor blockCompressor;
    private volatile boolean finished;
    private volatile ChannelHandlerContext ctx;

    public Bzip2Encoder() {
        this(9);
    }

    public Bzip2Encoder(int n) {
        if (n < 1 || n > 9) {
            throw new IllegalArgumentException("blockSizeMultiplier: " + n + " (expected: 1-9)");
        }
        this.streamBlockSize = n * 100000;
    }

    @Override
    protected void encode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, ByteBuf byteBuf2) {
        if (this.finished) {
            byteBuf2.writeBytes(byteBuf);
            return;
        }
        block6: while (true) {
            switch (this.currentState) {
                case INIT: {
                    byteBuf2.ensureWritable(4);
                    byteBuf2.writeMedium(4348520);
                    byteBuf2.writeByte(48 + this.streamBlockSize / 100000);
                    this.currentState = Bzip2Encoder$State.INIT_BLOCK;
                }
                case INIT_BLOCK: {
                    this.blockCompressor = new Bzip2BlockCompressor(this.writer, this.streamBlockSize);
                    this.currentState = Bzip2Encoder$State.WRITE_DATA;
                }
                case WRITE_DATA: {
                    if (!byteBuf.isReadable()) {
                        return;
                    }
                    Bzip2BlockCompressor bzip2BlockCompressor = this.blockCompressor;
                    int n = Math.min(byteBuf.readableBytes(), bzip2BlockCompressor.availableSize());
                    int n2 = bzip2BlockCompressor.write(byteBuf, byteBuf.readerIndex(), n);
                    byteBuf.skipBytes(n2);
                    if (!bzip2BlockCompressor.isFull()) {
                        if (byteBuf.isReadable()) continue block6;
                        return;
                    }
                    this.currentState = Bzip2Encoder$State.CLOSE_BLOCK;
                }
                case CLOSE_BLOCK: {
                    this.closeBlock(byteBuf2);
                    this.currentState = Bzip2Encoder$State.INIT_BLOCK;
                    continue block6;
                }
            }
            break;
        }
        throw new IllegalStateException();
    }

    private void closeBlock(ByteBuf byteBuf) {
        Bzip2BlockCompressor bzip2BlockCompressor = this.blockCompressor;
        if (!bzip2BlockCompressor.isEmpty()) {
            bzip2BlockCompressor.close(byteBuf);
            int n = bzip2BlockCompressor.crc();
            this.streamCRC = (this.streamCRC << 1 | this.streamCRC >>> 31) ^ n;
        }
    }

    public boolean isClosed() {
        return this.finished;
    }

    public ChannelFuture close() {
        return this.close(this.ctx().newPromise());
    }

    public ChannelFuture close(ChannelPromise channelPromise) {
        ChannelHandlerContext channelHandlerContext = this.ctx();
        EventExecutor eventExecutor = channelHandlerContext.executor();
        if (eventExecutor.inEventLoop()) {
            return this.finishEncode(channelHandlerContext, channelPromise);
        }
        eventExecutor.execute(new Bzip2Encoder$1(this, channelPromise));
        return channelPromise;
    }

    @Override
    public void close(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
        ChannelFuture channelFuture = this.finishEncode(channelHandlerContext, channelHandlerContext.newPromise());
        channelFuture.addListener(new Bzip2Encoder$2(this, channelHandlerContext, channelPromise));
        if (!channelFuture.isDone()) {
            channelHandlerContext.executor().schedule(new Bzip2Encoder$3(this, channelHandlerContext, channelPromise), 10L, TimeUnit.SECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ChannelFuture finishEncode(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
        if (this.finished) {
            channelPromise.setSuccess();
            return channelPromise;
        }
        this.finished = true;
        ByteBuf byteBuf = channelHandlerContext.alloc().buffer();
        this.closeBlock(byteBuf);
        int n = this.streamCRC;
        Bzip2BitWriter bzip2BitWriter = this.writer;
        try {
            bzip2BitWriter.writeBits(byteBuf, 24, 1536581L);
            bzip2BitWriter.writeBits(byteBuf, 24, 3690640L);
            bzip2BitWriter.writeInt(byteBuf, n);
            bzip2BitWriter.flush(byteBuf);
        }
        finally {
            this.blockCompressor = null;
        }
        return channelHandlerContext.writeAndFlush(byteBuf, channelPromise);
    }

    private ChannelHandlerContext ctx() {
        ChannelHandlerContext channelHandlerContext = this.ctx;
        if (channelHandlerContext == null) {
            throw new IllegalStateException("not added to a pipeline");
        }
        return channelHandlerContext;
    }

    @Override
    public void handlerAdded(ChannelHandlerContext channelHandlerContext) {
        this.ctx = channelHandlerContext;
    }

    static /* synthetic */ ChannelHandlerContext access$000(Bzip2Encoder bzip2Encoder) {
        return bzip2Encoder.ctx();
    }

    static /* synthetic */ ChannelFuture access$100(Bzip2Encoder bzip2Encoder, ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
        return bzip2Encoder.finishEncode(channelHandlerContext, channelPromise);
    }
}

