/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.codec.compression;

import java.util.concurrent.TimeUnit;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import pro.gravit.repackage.io.netty.buffer.ByteBuf;
import pro.gravit.repackage.io.netty.channel.ChannelFuture;
import pro.gravit.repackage.io.netty.channel.ChannelHandlerContext;
import pro.gravit.repackage.io.netty.channel.ChannelPromise;
import pro.gravit.repackage.io.netty.handler.codec.compression.JdkZlibEncoder$1;
import pro.gravit.repackage.io.netty.handler.codec.compression.JdkZlibEncoder$2;
import pro.gravit.repackage.io.netty.handler.codec.compression.JdkZlibEncoder$3;
import pro.gravit.repackage.io.netty.handler.codec.compression.ZlibEncoder;
import pro.gravit.repackage.io.netty.handler.codec.compression.ZlibWrapper;
import pro.gravit.repackage.io.netty.util.concurrent.EventExecutor;
import pro.gravit.repackage.io.netty.util.internal.EmptyArrays;
import pro.gravit.repackage.io.netty.util.internal.ObjectUtil;
import pro.gravit.repackage.io.netty.util.internal.PlatformDependent;
import pro.gravit.repackage.io.netty.util.internal.SuppressJava6Requirement;
import pro.gravit.repackage.io.netty.util.internal.SystemPropertyUtil;
import pro.gravit.repackage.io.netty.util.internal.logging.InternalLogger;
import pro.gravit.repackage.io.netty.util.internal.logging.InternalLoggerFactory;

public class JdkZlibEncoder
extends ZlibEncoder {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(JdkZlibEncoder.class);
    private static final int MAX_INITIAL_OUTPUT_BUFFER_SIZE;
    private static final int MAX_INPUT_BUFFER_SIZE;
    private final ZlibWrapper wrapper;
    private final Deflater deflater;
    private volatile boolean finished;
    private volatile ChannelHandlerContext ctx;
    private final CRC32 crc = new CRC32();
    private static final byte[] gzipHeader;
    private boolean writeHeader = true;
    private static final int THREAD_POOL_DELAY_SECONDS = 10;

    public JdkZlibEncoder() {
        this(6);
    }

    public JdkZlibEncoder(int n) {
        this(ZlibWrapper.ZLIB, n);
    }

    public JdkZlibEncoder(ZlibWrapper zlibWrapper) {
        this(zlibWrapper, 6);
    }

    public JdkZlibEncoder(ZlibWrapper zlibWrapper, int n) {
        ObjectUtil.checkInRange(n, 0, 9, "compressionLevel");
        ObjectUtil.checkNotNull(zlibWrapper, "wrapper");
        if (zlibWrapper == ZlibWrapper.ZLIB_OR_NONE) {
            throw new IllegalArgumentException("wrapper '" + (Object)((Object)ZlibWrapper.ZLIB_OR_NONE) + "' is not allowed for compression.");
        }
        this.wrapper = zlibWrapper;
        this.deflater = new Deflater(n, zlibWrapper != ZlibWrapper.ZLIB);
    }

    public JdkZlibEncoder(byte[] byArray) {
        this(6, byArray);
    }

    public JdkZlibEncoder(int n, byte[] byArray) {
        ObjectUtil.checkInRange(n, 0, 9, "compressionLevel");
        ObjectUtil.checkNotNull(byArray, "dictionary");
        this.wrapper = ZlibWrapper.ZLIB;
        this.deflater = new Deflater(n);
        this.deflater.setDictionary(byArray);
    }

    @Override
    public ChannelFuture close() {
        return this.close(this.ctx().newPromise());
    }

    @Override
    public ChannelFuture close(ChannelPromise channelPromise) {
        ChannelHandlerContext channelHandlerContext = this.ctx();
        EventExecutor eventExecutor = channelHandlerContext.executor();
        if (eventExecutor.inEventLoop()) {
            return this.finishEncode(channelHandlerContext, channelPromise);
        }
        ChannelPromise channelPromise2 = channelHandlerContext.newPromise();
        eventExecutor.execute(new JdkZlibEncoder$1(this, channelPromise2, channelPromise));
        return channelPromise2;
    }

    private ChannelHandlerContext ctx() {
        ChannelHandlerContext channelHandlerContext = this.ctx;
        if (channelHandlerContext == null) {
            throw new IllegalStateException("not added to a pipeline");
        }
        return channelHandlerContext;
    }

    @Override
    public boolean isClosed() {
        return this.finished;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void encode(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, ByteBuf byteBuf2) {
        if (this.finished) {
            byteBuf2.writeBytes(byteBuf);
            return;
        }
        int n = byteBuf.readableBytes();
        if (n == 0) {
            return;
        }
        if (byteBuf.hasArray()) {
            this.encodeSome(byteBuf, byteBuf2);
        } else {
            int n2 = Math.min(n, MAX_INPUT_BUFFER_SIZE);
            ByteBuf byteBuf3 = channelHandlerContext.alloc().heapBuffer(n2, n2);
            try {
                while (byteBuf.isReadable()) {
                    byteBuf.readBytes(byteBuf3, Math.min(byteBuf3.writableBytes(), byteBuf.readableBytes()));
                    this.encodeSome(byteBuf3, byteBuf2);
                    byteBuf3.clear();
                }
            }
            finally {
                byteBuf3.release();
            }
        }
        this.deflater.setInput(EmptyArrays.EMPTY_BYTES);
    }

    private void encodeSome(ByteBuf byteBuf, ByteBuf byteBuf2) {
        byte[] byArray = byteBuf.array();
        int n = byteBuf.arrayOffset() + byteBuf.readerIndex();
        if (this.writeHeader) {
            this.writeHeader = false;
            if (this.wrapper == ZlibWrapper.GZIP) {
                byteBuf2.writeBytes(gzipHeader);
            }
        }
        int n2 = byteBuf.readableBytes();
        if (this.wrapper == ZlibWrapper.GZIP) {
            this.crc.update(byArray, n, n2);
        }
        this.deflater.setInput(byArray, n, n2);
        while (true) {
            this.deflate(byteBuf2);
            if (!byteBuf2.isWritable()) {
                byteBuf2.ensureWritable(byteBuf2.writerIndex());
                continue;
            }
            if (this.deflater.needsInput()) break;
        }
        byteBuf.skipBytes(n2);
    }

    @Override
    protected final ByteBuf allocateBuffer(ChannelHandlerContext channelHandlerContext, ByteBuf byteBuf, boolean bl) {
        int n = (int)Math.ceil((double)byteBuf.readableBytes() * 1.001) + 12;
        if (this.writeHeader) {
            switch (this.wrapper) {
                case GZIP: {
                    n += gzipHeader.length;
                    break;
                }
                case ZLIB: {
                    n += 2;
                    break;
                }
            }
        }
        if (n < 0 || n > MAX_INITIAL_OUTPUT_BUFFER_SIZE) {
            return channelHandlerContext.alloc().heapBuffer(MAX_INITIAL_OUTPUT_BUFFER_SIZE);
        }
        return channelHandlerContext.alloc().heapBuffer(n);
    }

    @Override
    public void close(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
        ChannelFuture channelFuture = this.finishEncode(channelHandlerContext, channelHandlerContext.newPromise());
        channelFuture.addListener(new JdkZlibEncoder$2(this, channelHandlerContext, channelPromise));
        if (!channelFuture.isDone()) {
            channelHandlerContext.executor().schedule(new JdkZlibEncoder$3(this, channelHandlerContext, channelPromise), 10L, TimeUnit.SECONDS);
        }
    }

    private ChannelFuture finishEncode(ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
        if (this.finished) {
            channelPromise.setSuccess();
            return channelPromise;
        }
        this.finished = true;
        ByteBuf byteBuf = channelHandlerContext.alloc().heapBuffer();
        if (this.writeHeader && this.wrapper == ZlibWrapper.GZIP) {
            this.writeHeader = false;
            byteBuf.writeBytes(gzipHeader);
        }
        this.deflater.finish();
        while (!this.deflater.finished()) {
            this.deflate(byteBuf);
            if (byteBuf.isWritable()) continue;
            channelHandlerContext.write(byteBuf);
            byteBuf = channelHandlerContext.alloc().heapBuffer();
        }
        if (this.wrapper == ZlibWrapper.GZIP) {
            int n = (int)this.crc.getValue();
            int n2 = this.deflater.getTotalIn();
            byteBuf.writeByte(n);
            byteBuf.writeByte(n >>> 8);
            byteBuf.writeByte(n >>> 16);
            byteBuf.writeByte(n >>> 24);
            byteBuf.writeByte(n2);
            byteBuf.writeByte(n2 >>> 8);
            byteBuf.writeByte(n2 >>> 16);
            byteBuf.writeByte(n2 >>> 24);
        }
        this.deflater.end();
        return channelHandlerContext.writeAndFlush(byteBuf, channelPromise);
    }

    @SuppressJava6Requirement(reason="Usage guarded by java version check")
    private void deflate(ByteBuf byteBuf) {
        int n;
        if (PlatformDependent.javaVersion() < 7) {
            this.deflateJdk6(byteBuf);
        }
        do {
            int n2 = byteBuf.writerIndex();
            n = this.deflater.deflate(byteBuf.array(), byteBuf.arrayOffset() + n2, byteBuf.writableBytes(), 2);
            byteBuf.writerIndex(n2 + n);
        } while (n > 0);
    }

    private void deflateJdk6(ByteBuf byteBuf) {
        int n;
        do {
            int n2 = byteBuf.writerIndex();
            n = this.deflater.deflate(byteBuf.array(), byteBuf.arrayOffset() + n2, byteBuf.writableBytes());
            byteBuf.writerIndex(n2 + n);
        } while (n > 0);
    }

    @Override
    public void handlerAdded(ChannelHandlerContext channelHandlerContext) {
        this.ctx = channelHandlerContext;
    }

    static /* synthetic */ ChannelHandlerContext access$000(JdkZlibEncoder jdkZlibEncoder) {
        return jdkZlibEncoder.ctx();
    }

    static /* synthetic */ ChannelFuture access$100(JdkZlibEncoder jdkZlibEncoder, ChannelHandlerContext channelHandlerContext, ChannelPromise channelPromise) {
        return jdkZlibEncoder.finishEncode(channelHandlerContext, channelPromise);
    }

    static {
        gzipHeader = new byte[]{31, -117, 8, 0, 0, 0, 0, 0, 0, 0};
        MAX_INITIAL_OUTPUT_BUFFER_SIZE = SystemPropertyUtil.getInt("pro.gravit.repackage.io.netty.jdkzlib.encoder.maxInitialOutputBufferSize", 65536);
        MAX_INPUT_BUFFER_SIZE = SystemPropertyUtil.getInt("pro.gravit.repackage.io.netty.jdkzlib.encoder.maxInputBufferSize", 65536);
        if (logger.isDebugEnabled()) {
            logger.debug("-Dio.netty.jdkzlib.encoder.maxInitialOutputBufferSize={}", (Object)MAX_INITIAL_OUTPUT_BUFFER_SIZE);
            logger.debug("-Dio.netty.jdkzlib.encoder.maxInputBufferSize={}", (Object)MAX_INPUT_BUFFER_SIZE);
        }
    }
}

