/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.codec.http.cookie;

import java.util.Date;
import pro.gravit.repackage.io.netty.handler.codec.DateFormatter;
import pro.gravit.repackage.io.netty.handler.codec.http.cookie.Cookie;
import pro.gravit.repackage.io.netty.handler.codec.http.cookie.CookieHeaderNames$SameSite;
import pro.gravit.repackage.io.netty.handler.codec.http.cookie.DefaultCookie;

class ClientCookieDecoder$CookieBuilder {
    private final String header;
    private final DefaultCookie cookie;
    private String domain;
    private String path;
    private long maxAge = Long.MIN_VALUE;
    private int expiresStart;
    private int expiresEnd;
    private boolean secure;
    private boolean httpOnly;
    private CookieHeaderNames$SameSite sameSite;

    ClientCookieDecoder$CookieBuilder(DefaultCookie defaultCookie, String string) {
        this.cookie = defaultCookie;
        this.header = string;
    }

    private long mergeMaxAgeAndExpires() {
        Date date;
        if (this.maxAge != Long.MIN_VALUE) {
            return this.maxAge;
        }
        if (ClientCookieDecoder$CookieBuilder.isValueDefined(this.expiresStart, this.expiresEnd) && (date = DateFormatter.parseHttpDate(this.header, this.expiresStart, this.expiresEnd)) != null) {
            long l = date.getTime() - System.currentTimeMillis();
            return l / 1000L + (long)(l % 1000L != 0L ? 1 : 0);
        }
        return Long.MIN_VALUE;
    }

    Cookie cookie() {
        this.cookie.setDomain(this.domain);
        this.cookie.setPath(this.path);
        this.cookie.setMaxAge(this.mergeMaxAgeAndExpires());
        this.cookie.setSecure(this.secure);
        this.cookie.setHttpOnly(this.httpOnly);
        this.cookie.setSameSite(this.sameSite);
        return this.cookie;
    }

    void appendAttribute(int n, int n2, int n3, int n4) {
        int n5 = n2 - n;
        if (n5 == 4) {
            this.parse4(n, n3, n4);
        } else if (n5 == 6) {
            this.parse6(n, n3, n4);
        } else if (n5 == 7) {
            this.parse7(n, n3, n4);
        } else if (n5 == 8) {
            this.parse8(n, n3, n4);
        }
    }

    private void parse4(int n, int n2, int n3) {
        if (this.header.regionMatches(true, n, "Path", 0, 4)) {
            this.path = this.computeValue(n2, n3);
        }
    }

    private void parse6(int n, int n2, int n3) {
        if (this.header.regionMatches(true, n, "Domain", 0, 5)) {
            this.domain = this.computeValue(n2, n3);
        } else if (this.header.regionMatches(true, n, "Secure", 0, 5)) {
            this.secure = true;
        }
    }

    private void setMaxAge(String string) {
        try {
            this.maxAge = Math.max(Long.parseLong(string), 0L);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void parse7(int n, int n2, int n3) {
        if (this.header.regionMatches(true, n, "Expires", 0, 7)) {
            this.expiresStart = n2;
            this.expiresEnd = n3;
        } else if (this.header.regionMatches(true, n, "Max-Age", 0, 7)) {
            this.setMaxAge(this.computeValue(n2, n3));
        }
    }

    private void parse8(int n, int n2, int n3) {
        if (this.header.regionMatches(true, n, "HTTPOnly", 0, 8)) {
            this.httpOnly = true;
        } else if (this.header.regionMatches(true, n, "SameSite", 0, 8)) {
            this.sameSite = CookieHeaderNames$SameSite.of(this.computeValue(n2, n3));
        }
    }

    private static boolean isValueDefined(int n, int n2) {
        return n != -1 && n != n2;
    }

    private String computeValue(int n, int n2) {
        return ClientCookieDecoder$CookieBuilder.isValueDefined(n, n2) ? this.header.substring(n, n2) : null;
    }
}

