/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.codec.http.multipart;

import java.nio.charset.Charset;
import java.util.List;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpConstants;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpContent;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpHeaderNames;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpHeaderValues;
import pro.gravit.repackage.io.netty.handler.codec.http.HttpRequest;
import pro.gravit.repackage.io.netty.handler.codec.http.multipart.DefaultHttpDataFactory;
import pro.gravit.repackage.io.netty.handler.codec.http.multipart.HttpDataFactory;
import pro.gravit.repackage.io.netty.handler.codec.http.multipart.HttpPostBodyUtil;
import pro.gravit.repackage.io.netty.handler.codec.http.multipart.HttpPostMultipartRequestDecoder;
import pro.gravit.repackage.io.netty.handler.codec.http.multipart.HttpPostRequestDecoder$ErrorDataDecoderException;
import pro.gravit.repackage.io.netty.handler.codec.http.multipart.HttpPostStandardRequestDecoder;
import pro.gravit.repackage.io.netty.handler.codec.http.multipart.InterfaceHttpData;
import pro.gravit.repackage.io.netty.handler.codec.http.multipart.InterfaceHttpPostRequestDecoder;
import pro.gravit.repackage.io.netty.util.internal.ObjectUtil;
import pro.gravit.repackage.io.netty.util.internal.StringUtil;

public class HttpPostRequestDecoder
implements InterfaceHttpPostRequestDecoder {
    static final int DEFAULT_DISCARD_THRESHOLD = 0xA00000;
    private final InterfaceHttpPostRequestDecoder decoder;

    public HttpPostRequestDecoder(HttpRequest httpRequest) {
        this(new DefaultHttpDataFactory(16384L), httpRequest, HttpConstants.DEFAULT_CHARSET);
    }

    public HttpPostRequestDecoder(HttpDataFactory httpDataFactory, HttpRequest httpRequest) {
        this(httpDataFactory, httpRequest, HttpConstants.DEFAULT_CHARSET);
    }

    public HttpPostRequestDecoder(HttpDataFactory httpDataFactory, HttpRequest httpRequest, Charset charset) {
        ObjectUtil.checkNotNull(httpDataFactory, "factory");
        ObjectUtil.checkNotNull(httpRequest, "request");
        ObjectUtil.checkNotNull(charset, "charset");
        this.decoder = HttpPostRequestDecoder.isMultipart(httpRequest) ? new HttpPostMultipartRequestDecoder(httpDataFactory, httpRequest, charset) : new HttpPostStandardRequestDecoder(httpDataFactory, httpRequest, charset);
    }

    public static boolean isMultipart(HttpRequest httpRequest) {
        String string = httpRequest.headers().get(HttpHeaderNames.CONTENT_TYPE);
        if (string != null && string.startsWith(HttpHeaderValues.MULTIPART_FORM_DATA.toString())) {
            return HttpPostRequestDecoder.getMultipartDataBoundary(string) != null;
        }
        return false;
    }

    protected static String[] getMultipartDataBoundary(String string) {
        String string2;
        String[] stringArray = HttpPostRequestDecoder.splitHeaderContentType(string);
        if (stringArray[0].regionMatches(true, 0, string2 = HttpHeaderValues.MULTIPART_FORM_DATA.toString(), 0, string2.length())) {
            String string3;
            int n;
            String string4;
            int n2;
            int n3;
            String string5 = HttpHeaderValues.BOUNDARY.toString();
            if (stringArray[1].regionMatches(true, 0, string5, 0, string5.length())) {
                n3 = 1;
                n2 = 2;
            } else if (stringArray[2].regionMatches(true, 0, string5, 0, string5.length())) {
                n3 = 2;
                n2 = 1;
            } else {
                return null;
            }
            String string6 = StringUtil.substringAfter(stringArray[n3], '=');
            if (string6 == null) {
                throw new HttpPostRequestDecoder$ErrorDataDecoderException("Needs a boundary value");
            }
            if (string6.charAt(0) == '\"' && (string4 = string6.trim()).charAt(n = string4.length() - 1) == '\"') {
                string6 = string4.substring(1, n);
            }
            if (stringArray[n2].regionMatches(true, 0, string4 = HttpHeaderValues.CHARSET.toString(), 0, string4.length()) && (string3 = StringUtil.substringAfter(stringArray[n2], '=')) != null) {
                return new String[]{"--" + string6, string3};
            }
            return new String[]{"--" + string6};
        }
        return null;
    }

    @Override
    public boolean isMultipart() {
        return this.decoder.isMultipart();
    }

    @Override
    public void setDiscardThreshold(int n) {
        this.decoder.setDiscardThreshold(n);
    }

    @Override
    public int getDiscardThreshold() {
        return this.decoder.getDiscardThreshold();
    }

    @Override
    public List<InterfaceHttpData> getBodyHttpDatas() {
        return this.decoder.getBodyHttpDatas();
    }

    @Override
    public List<InterfaceHttpData> getBodyHttpDatas(String string) {
        return this.decoder.getBodyHttpDatas(string);
    }

    @Override
    public InterfaceHttpData getBodyHttpData(String string) {
        return this.decoder.getBodyHttpData(string);
    }

    @Override
    public InterfaceHttpPostRequestDecoder offer(HttpContent httpContent) {
        return this.decoder.offer(httpContent);
    }

    @Override
    public boolean hasNext() {
        return this.decoder.hasNext();
    }

    @Override
    public InterfaceHttpData next() {
        return this.decoder.next();
    }

    @Override
    public InterfaceHttpData currentPartialHttpData() {
        return this.decoder.currentPartialHttpData();
    }

    @Override
    public void destroy() {
        this.decoder.destroy();
    }

    @Override
    public void cleanFiles() {
        this.decoder.cleanFiles();
    }

    @Override
    public void removeHttpDataFromClean(InterfaceHttpData interfaceHttpData) {
        this.decoder.removeHttpDataFromClean(interfaceHttpData);
    }

    private static String[] splitHeaderContentType(String string) {
        int n;
        int n2 = HttpPostBodyUtil.findNonWhitespace(string, 0);
        int n3 = string.indexOf(59);
        if (n3 == -1) {
            return new String[]{string, "", ""};
        }
        int n4 = HttpPostBodyUtil.findNonWhitespace(string, n3 + 1);
        if (string.charAt(n3 - 1) == ' ') {
            --n3;
        }
        if ((n = string.indexOf(59, n4)) == -1) {
            n = HttpPostBodyUtil.findEndOfString(string);
            return new String[]{string.substring(n2, n3), string.substring(n4, n), ""};
        }
        int n5 = HttpPostBodyUtil.findNonWhitespace(string, n + 1);
        if (string.charAt(n - 1) == ' ') {
            --n;
        }
        int n6 = HttpPostBodyUtil.findEndOfString(string);
        return new String[]{string.substring(n2, n3), string.substring(n4, n), string.substring(n5, n6)};
    }
}

