/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.codec.http.websocketx.extensions.compression;

import java.util.Iterator;
import java.util.Map;
import pro.gravit.repackage.io.netty.handler.codec.compression.ZlibCodecFactory;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionData;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.extensions.WebSocketExtensionFilterProvider;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.extensions.WebSocketServerExtension;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.extensions.WebSocketServerExtensionHandshaker;
import pro.gravit.repackage.io.netty.handler.codec.http.websocketx.extensions.compression.PerMessageDeflateServerExtensionHandshaker$PermessageDeflateExtension;
import pro.gravit.repackage.io.netty.util.internal.ObjectUtil;

public final class PerMessageDeflateServerExtensionHandshaker
implements WebSocketServerExtensionHandshaker {
    public static final int MIN_WINDOW_SIZE = 8;
    public static final int MAX_WINDOW_SIZE = 15;
    static final String PERMESSAGE_DEFLATE_EXTENSION = "permessage-deflate";
    static final String CLIENT_MAX_WINDOW = "client_max_window_bits";
    static final String SERVER_MAX_WINDOW = "server_max_window_bits";
    static final String CLIENT_NO_CONTEXT = "client_no_context_takeover";
    static final String SERVER_NO_CONTEXT = "server_no_context_takeover";
    private final int compressionLevel;
    private final boolean allowServerWindowSize;
    private final int preferredClientWindowSize;
    private final boolean allowServerNoContext;
    private final boolean preferredClientNoContext;
    private final WebSocketExtensionFilterProvider extensionFilterProvider;

    public PerMessageDeflateServerExtensionHandshaker() {
        this(6, ZlibCodecFactory.isSupportingWindowSizeAndMemLevel(), 15, false, false);
    }

    public PerMessageDeflateServerExtensionHandshaker(int n, boolean bl, int n2, boolean bl2, boolean bl3) {
        this(n, bl, n2, bl2, bl3, WebSocketExtensionFilterProvider.DEFAULT);
    }

    public PerMessageDeflateServerExtensionHandshaker(int n, boolean bl, int n2, boolean bl2, boolean bl3, WebSocketExtensionFilterProvider webSocketExtensionFilterProvider) {
        if (n2 > 15 || n2 < 8) {
            throw new IllegalArgumentException("preferredServerWindowSize: " + n2 + " (expected: 8-15)");
        }
        if (n < 0 || n > 9) {
            throw new IllegalArgumentException("compressionLevel: " + n + " (expected: 0-9)");
        }
        this.compressionLevel = n;
        this.allowServerWindowSize = bl;
        this.preferredClientWindowSize = n2;
        this.allowServerNoContext = bl2;
        this.preferredClientNoContext = bl3;
        this.extensionFilterProvider = ObjectUtil.checkNotNull(webSocketExtensionFilterProvider, "extensionFilterProvider");
    }

    @Override
    public WebSocketServerExtension handshakeExtension(WebSocketExtensionData webSocketExtensionData) {
        if (!PERMESSAGE_DEFLATE_EXTENSION.equals(webSocketExtensionData.name())) {
            return null;
        }
        boolean bl = true;
        int n = 15;
        int n2 = 15;
        boolean bl2 = false;
        boolean bl3 = false;
        Iterator<Map.Entry<String, String>> iterator = webSocketExtensionData.parameters().entrySet().iterator();
        while (bl && iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            if (CLIENT_MAX_WINDOW.equalsIgnoreCase(entry.getKey())) {
                n = this.preferredClientWindowSize;
                continue;
            }
            if (SERVER_MAX_WINDOW.equalsIgnoreCase(entry.getKey())) {
                if (this.allowServerWindowSize) {
                    n2 = Integer.parseInt(entry.getValue());
                    if (n2 <= 15 && n2 >= 8) continue;
                    bl = false;
                    continue;
                }
                bl = false;
                continue;
            }
            if (CLIENT_NO_CONTEXT.equalsIgnoreCase(entry.getKey())) {
                bl3 = this.preferredClientNoContext;
                continue;
            }
            if (SERVER_NO_CONTEXT.equalsIgnoreCase(entry.getKey())) {
                if (this.allowServerNoContext) {
                    bl2 = true;
                    continue;
                }
                bl = false;
                continue;
            }
            bl = false;
        }
        if (bl) {
            return new PerMessageDeflateServerExtensionHandshaker$PermessageDeflateExtension(this.compressionLevel, bl2, n2, bl3, n, this.extensionFilterProvider);
        }
        return null;
    }
}

