/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.ipfilter;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import pro.gravit.repackage.io.netty.handler.ipfilter.IpFilterRule;
import pro.gravit.repackage.io.netty.handler.ipfilter.IpFilterRuleType;
import pro.gravit.repackage.io.netty.handler.ipfilter.IpSubnetFilterRule$1;
import pro.gravit.repackage.io.netty.util.NetUtil;

final class IpSubnetFilterRule$Ip4SubnetFilterRule
implements IpFilterRule {
    private final int networkAddress;
    private final int subnetMask;
    private final IpFilterRuleType ruleType;

    private IpSubnetFilterRule$Ip4SubnetFilterRule(Inet4Address inet4Address, int n, IpFilterRuleType ipFilterRuleType) {
        if (n < 0 || n > 32) {
            throw new IllegalArgumentException(String.format("IPv4 requires the subnet prefix to be in range of [0,32]. The prefix was: %d", n));
        }
        this.subnetMask = IpSubnetFilterRule$Ip4SubnetFilterRule.prefixToSubnetMask(n);
        this.networkAddress = NetUtil.ipv4AddressToInt(inet4Address) & this.subnetMask;
        this.ruleType = ipFilterRuleType;
    }

    @Override
    public boolean matches(InetSocketAddress inetSocketAddress) {
        InetAddress inetAddress = inetSocketAddress.getAddress();
        if (inetAddress instanceof Inet4Address) {
            int n = NetUtil.ipv4AddressToInt((Inet4Address)inetAddress);
            return (n & this.subnetMask) == this.networkAddress;
        }
        return false;
    }

    @Override
    public IpFilterRuleType ruleType() {
        return this.ruleType;
    }

    private static int prefixToSubnetMask(int n) {
        return (int)(-1L << 32 - n);
    }

    /* synthetic */ IpSubnetFilterRule$Ip4SubnetFilterRule(Inet4Address inet4Address, int n, IpFilterRuleType ipFilterRuleType, IpSubnetFilterRule$1 ipSubnetFilterRule$1) {
        this(inet4Address, n, ipFilterRuleType);
    }

    static /* synthetic */ int access$200(IpSubnetFilterRule$Ip4SubnetFilterRule ipSubnetFilterRule$Ip4SubnetFilterRule) {
        return ipSubnetFilterRule$Ip4SubnetFilterRule.networkAddress;
    }

    static /* synthetic */ int access$400(IpSubnetFilterRule$Ip4SubnetFilterRule ipSubnetFilterRule$Ip4SubnetFilterRule) {
        return ipSubnetFilterRule$Ip4SubnetFilterRule.subnetMask;
    }
}

