/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.pcap;

import java.io.Closeable;
import java.io.OutputStream;
import pro.gravit.repackage.io.netty.buffer.ByteBuf;
import pro.gravit.repackage.io.netty.handler.pcap.PcapHeaders;
import pro.gravit.repackage.io.netty.util.internal.logging.InternalLogger;
import pro.gravit.repackage.io.netty.util.internal.logging.InternalLoggerFactory;

final class PcapWriter
implements Closeable {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(PcapWriter.class);
    private final OutputStream outputStream;
    private boolean isClosed;

    PcapWriter(OutputStream outputStream) {
        this.outputStream = outputStream;
    }

    PcapWriter(OutputStream outputStream, ByteBuf byteBuf) {
        this.outputStream = outputStream;
        PcapHeaders.writeGlobalHeader(byteBuf);
        byteBuf.readBytes(outputStream, byteBuf.readableBytes());
    }

    void writePacket(ByteBuf byteBuf, ByteBuf byteBuf2) {
        if (this.isClosed) {
            logger.debug("Pcap Write attempted on closed PcapWriter");
        }
        long l = System.currentTimeMillis();
        PcapHeaders.writePacketHeader(byteBuf, (int)(l / 1000L), (int)(l % 1000L * 1000L), byteBuf2.readableBytes(), byteBuf2.readableBytes());
        byteBuf.readBytes(this.outputStream, byteBuf.readableBytes());
        byteBuf2.readBytes(this.outputStream, byteBuf2.readableBytes());
    }

    @Override
    public void close() {
        if (this.isClosed) {
            logger.debug("PcapWriter is already closed");
        } else {
            this.isClosed = true;
            this.outputStream.flush();
            this.outputStream.close();
            logger.debug("PcapWriter is now closed");
        }
    }
}

