/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.ssl;

import java.nio.ByteBuffer;
import java.util.List;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import org.conscrypt.BufferAllocator;
import org.conscrypt.Conscrypt;
import pro.gravit.repackage.io.netty.buffer.ByteBufAllocator;
import pro.gravit.repackage.io.netty.handler.ssl.ConscryptAlpnSslEngine$BufferAllocatorAdapter;
import pro.gravit.repackage.io.netty.handler.ssl.ConscryptAlpnSslEngine$ClientEngine;
import pro.gravit.repackage.io.netty.handler.ssl.ConscryptAlpnSslEngine$ServerEngine;
import pro.gravit.repackage.io.netty.handler.ssl.JdkApplicationProtocolNegotiator;
import pro.gravit.repackage.io.netty.handler.ssl.JdkSslEngine;
import pro.gravit.repackage.io.netty.util.internal.SystemPropertyUtil;

abstract class ConscryptAlpnSslEngine
extends JdkSslEngine {
    private static final boolean USE_BUFFER_ALLOCATOR = SystemPropertyUtil.getBoolean("pro.gravit.repackage.io.netty.handler.ssl.conscrypt.useBufferAllocator", true);

    static ConscryptAlpnSslEngine newClientEngine(SSLEngine sSLEngine, ByteBufAllocator byteBufAllocator, JdkApplicationProtocolNegotiator jdkApplicationProtocolNegotiator) {
        return new ConscryptAlpnSslEngine$ClientEngine(sSLEngine, byteBufAllocator, jdkApplicationProtocolNegotiator);
    }

    static ConscryptAlpnSslEngine newServerEngine(SSLEngine sSLEngine, ByteBufAllocator byteBufAllocator, JdkApplicationProtocolNegotiator jdkApplicationProtocolNegotiator) {
        return new ConscryptAlpnSslEngine$ServerEngine(sSLEngine, byteBufAllocator, jdkApplicationProtocolNegotiator);
    }

    private ConscryptAlpnSslEngine(SSLEngine sSLEngine, ByteBufAllocator byteBufAllocator, List<String> list) {
        super(sSLEngine);
        if (USE_BUFFER_ALLOCATOR) {
            Conscrypt.setBufferAllocator((SSLEngine)sSLEngine, (BufferAllocator)new ConscryptAlpnSslEngine$BufferAllocatorAdapter(byteBufAllocator));
        }
        Conscrypt.setApplicationProtocols((SSLEngine)sSLEngine, (String[])list.toArray(new String[0]));
    }

    final int calculateOutNetBufSize(int n, int n2) {
        long l = (long)Conscrypt.maxSealOverhead((SSLEngine)this.getWrappedEngine()) * (long)n2;
        return (int)Math.min(Integer.MAX_VALUE, (long)n + l);
    }

    final SSLEngineResult unwrap(ByteBuffer[] byteBufferArray, ByteBuffer[] byteBufferArray2) {
        return Conscrypt.unwrap((SSLEngine)this.getWrappedEngine(), (ByteBuffer[])byteBufferArray, (ByteBuffer[])byteBufferArray2);
    }
}

