/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.ssl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import pro.gravit.repackage.io.netty.handler.ssl.OpenSslEngineMap;
import pro.gravit.repackage.io.netty.handler.ssl.OpenSslSession;
import pro.gravit.repackage.io.netty.handler.ssl.OpenSslSessionCache$1;
import pro.gravit.repackage.io.netty.handler.ssl.OpenSslSessionCache$NativeSslSession;
import pro.gravit.repackage.io.netty.handler.ssl.OpenSslSessionId;
import pro.gravit.repackage.io.netty.handler.ssl.ReferenceCountedOpenSslEngine;
import pro.gravit.repackage.io.netty.internal.tcnative.SSLSessionCache;
import pro.gravit.repackage.io.netty.util.internal.SystemPropertyUtil;

class OpenSslSessionCache
implements SSLSessionCache {
    private static final OpenSslSession[] EMPTY_SESSIONS = new OpenSslSession[0];
    private static final int DEFAULT_CACHE_SIZE;
    private final OpenSslEngineMap engineMap;
    private final Map<OpenSslSessionId, OpenSslSessionCache$NativeSslSession> sessions = new OpenSslSessionCache$1(this);
    private final AtomicInteger maximumCacheSize = new AtomicInteger(DEFAULT_CACHE_SIZE);
    private final AtomicInteger sessionTimeout = new AtomicInteger(300);
    private int sessionCounter;

    OpenSslSessionCache(OpenSslEngineMap openSslEngineMap) {
        this.engineMap = openSslEngineMap;
    }

    final void setSessionTimeout(int n) {
        int n2 = this.sessionTimeout.getAndSet(n);
        if (n2 > n) {
            this.clear();
        }
    }

    final int getSessionTimeout() {
        return this.sessionTimeout.get();
    }

    protected boolean sessionCreated(OpenSslSessionCache$NativeSslSession nativeSslSession) {
        return true;
    }

    protected void sessionRemoved(OpenSslSessionCache$NativeSslSession nativeSslSession) {
    }

    final void setSessionCacheSize(int n) {
        long l = this.maximumCacheSize.getAndSet(n);
        if (l > (long)n || n == 0) {
            this.clear();
        }
    }

    final int getSessionCacheSize() {
        return this.maximumCacheSize.get();
    }

    private void expungeInvalidSessions() {
        OpenSslSessionCache$NativeSslSession openSslSessionCache$NativeSslSession;
        if (this.sessions.isEmpty()) {
            return;
        }
        long l = System.currentTimeMillis();
        Iterator<Map.Entry<OpenSslSessionId, OpenSslSessionCache$NativeSslSession>> iterator = this.sessions.entrySet().iterator();
        while (iterator.hasNext() && !(openSslSessionCache$NativeSslSession = iterator.next().getValue()).isValid(l)) {
            iterator.remove();
            this.notifyRemovalAndFree(openSslSessionCache$NativeSslSession);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean sessionCreated(long l, long l2) {
        ReferenceCountedOpenSslEngine referenceCountedOpenSslEngine = this.engineMap.get(l);
        if (referenceCountedOpenSslEngine == null) {
            return false;
        }
        OpenSslSessionCache$NativeSslSession openSslSessionCache$NativeSslSession = new OpenSslSessionCache$NativeSslSession(l2, referenceCountedOpenSslEngine.getPeerHost(), referenceCountedOpenSslEngine.getPeerPort(), (long)this.getSessionTimeout() * 1000L);
        referenceCountedOpenSslEngine.setSessionId(openSslSessionCache$NativeSslSession.sessionId());
        OpenSslSessionCache openSslSessionCache = this;
        synchronized (openSslSessionCache) {
            if (++this.sessionCounter == 255) {
                this.sessionCounter = 0;
                this.expungeInvalidSessions();
            }
            if (!this.sessionCreated(openSslSessionCache$NativeSslSession)) {
                openSslSessionCache$NativeSslSession.close();
                return false;
            }
            OpenSslSessionCache$NativeSslSession openSslSessionCache$NativeSslSession2 = this.sessions.put(openSslSessionCache$NativeSslSession.sessionId(), openSslSessionCache$NativeSslSession);
            if (openSslSessionCache$NativeSslSession2 != null) {
                this.notifyRemovalAndFree(openSslSessionCache$NativeSslSession2);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final long getSession(long l, byte[] byArray) {
        OpenSslSessionCache$NativeSslSession openSslSessionCache$NativeSslSession;
        OpenSslSessionId openSslSessionId = new OpenSslSessionId(byArray);
        OpenSslSessionCache openSslSessionCache = this;
        synchronized (openSslSessionCache) {
            openSslSessionCache$NativeSslSession = this.sessions.get(openSslSessionId);
            if (openSslSessionCache$NativeSslSession == null) {
                return -1L;
            }
            if (!openSslSessionCache$NativeSslSession.isValid() || !openSslSessionCache$NativeSslSession.upRef()) {
                this.removeSessionWithId(openSslSessionCache$NativeSslSession.sessionId());
                return -1L;
            }
            if (openSslSessionCache$NativeSslSession.shouldBeSingleUse()) {
                this.removeSessionWithId(openSslSessionCache$NativeSslSession.sessionId());
            }
        }
        openSslSessionCache$NativeSslSession.updateLastAccessedTime();
        return openSslSessionCache$NativeSslSession.session();
    }

    void setSession(long l, String string, int n) {
    }

    final synchronized void removeSessionWithId(OpenSslSessionId openSslSessionId) {
        OpenSslSessionCache$NativeSslSession openSslSessionCache$NativeSslSession = this.sessions.remove(openSslSessionId);
        if (openSslSessionCache$NativeSslSession != null) {
            this.notifyRemovalAndFree(openSslSessionCache$NativeSslSession);
        }
    }

    final synchronized boolean containsSessionWithId(OpenSslSessionId openSslSessionId) {
        return this.sessions.containsKey(openSslSessionId);
    }

    private void notifyRemovalAndFree(OpenSslSessionCache$NativeSslSession openSslSessionCache$NativeSslSession) {
        this.sessionRemoved(openSslSessionCache$NativeSslSession);
        openSslSessionCache$NativeSslSession.free();
    }

    final synchronized OpenSslSession getSession(OpenSslSessionId openSslSessionId) {
        OpenSslSessionCache$NativeSslSession openSslSessionCache$NativeSslSession = this.sessions.get(openSslSessionId);
        if (openSslSessionCache$NativeSslSession != null && !openSslSessionCache$NativeSslSession.isValid()) {
            this.removeSessionWithId(openSslSessionCache$NativeSslSession.sessionId());
            return null;
        }
        return openSslSessionCache$NativeSslSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final List<OpenSslSessionId> getIds() {
        OpenSslSession[] openSslSessionArray;
        Object object = this;
        synchronized (object) {
            openSslSessionArray = this.sessions.values().toArray(EMPTY_SESSIONS);
        }
        object = new ArrayList(openSslSessionArray.length);
        for (OpenSslSession openSslSession : openSslSessionArray) {
            if (!openSslSession.isValid()) continue;
            object.add(openSslSession.sessionId());
        }
        return object;
    }

    synchronized void clear() {
        Iterator<Map.Entry<OpenSslSessionId, OpenSslSessionCache$NativeSslSession>> iterator = this.sessions.entrySet().iterator();
        while (iterator.hasNext()) {
            OpenSslSessionCache$NativeSslSession openSslSessionCache$NativeSslSession = iterator.next().getValue();
            iterator.remove();
            this.notifyRemovalAndFree(openSslSessionCache$NativeSslSession);
        }
    }

    static /* synthetic */ AtomicInteger access$000(OpenSslSessionCache openSslSessionCache) {
        return openSslSessionCache.maximumCacheSize;
    }

    static {
        int n = SystemPropertyUtil.getInt("javax.net.ssl.sessionCacheSize", 20480);
        DEFAULT_CACHE_SIZE = n >= 0 ? n : 20480;
    }
}

