/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.handler.stream;

import java.io.File;
import java.io.RandomAccessFile;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import pro.gravit.repackage.io.netty.buffer.ByteBuf;
import pro.gravit.repackage.io.netty.buffer.ByteBufAllocator;
import pro.gravit.repackage.io.netty.channel.ChannelHandlerContext;
import pro.gravit.repackage.io.netty.handler.stream.ChunkedInput;
import pro.gravit.repackage.io.netty.util.internal.ObjectUtil;

public class ChunkedNioFile
implements ChunkedInput<ByteBuf> {
    private final FileChannel in;
    private final long startOffset;
    private final long endOffset;
    private final int chunkSize;
    private long offset;

    public ChunkedNioFile(File file) {
        this(new RandomAccessFile(file, "r").getChannel());
    }

    public ChunkedNioFile(File file, int n) {
        this(new RandomAccessFile(file, "r").getChannel(), n);
    }

    public ChunkedNioFile(FileChannel fileChannel) {
        this(fileChannel, 8192);
    }

    public ChunkedNioFile(FileChannel fileChannel, int n) {
        this(fileChannel, 0L, fileChannel.size(), n);
    }

    public ChunkedNioFile(FileChannel fileChannel, long l, long l2, int n) {
        ObjectUtil.checkNotNull(fileChannel, "in");
        ObjectUtil.checkPositiveOrZero(l, "offset");
        ObjectUtil.checkPositiveOrZero(l2, "length");
        ObjectUtil.checkPositive(n, "chunkSize");
        if (!fileChannel.isOpen()) {
            throw new ClosedChannelException();
        }
        this.in = fileChannel;
        this.chunkSize = n;
        this.offset = this.startOffset = l;
        this.endOffset = l + l2;
    }

    public long startOffset() {
        return this.startOffset;
    }

    public long endOffset() {
        return this.endOffset;
    }

    public long currentOffset() {
        return this.offset;
    }

    @Override
    public boolean isEndOfInput() {
        return this.offset >= this.endOffset || !this.in.isOpen();
    }

    @Override
    public void close() {
        this.in.close();
    }

    @Override
    @Deprecated
    public ByteBuf readChunk(ChannelHandlerContext channelHandlerContext) {
        return this.readChunk(channelHandlerContext.alloc());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ByteBuf readChunk(ByteBufAllocator byteBufAllocator) {
        long l = this.offset;
        if (l >= this.endOffset) {
            return null;
        }
        int n = (int)Math.min((long)this.chunkSize, this.endOffset - l);
        ByteBuf byteBuf = byteBufAllocator.buffer(n);
        boolean bl = true;
        try {
            int n2;
            int n3 = 0;
            while ((n2 = byteBuf.writeBytes(this.in, l + (long)n3, n - n3)) >= 0 && (n3 += n2) != n) {
            }
            this.offset += (long)n3;
            bl = false;
            ByteBuf byteBuf2 = byteBuf;
            return byteBuf2;
        }
        finally {
            if (bl) {
                byteBuf.release();
            }
        }
    }

    @Override
    public long length() {
        return this.endOffset - this.startOffset;
    }

    @Override
    public long progress() {
        return this.offset - this.startOffset;
    }
}

