/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.util;

import pro.gravit.repackage.io.netty.util.Recycler$1;
import pro.gravit.repackage.io.netty.util.Recycler$2;
import pro.gravit.repackage.io.netty.util.Recycler$DefaultHandle;
import pro.gravit.repackage.io.netty.util.Recycler$Handle;
import pro.gravit.repackage.io.netty.util.Recycler$LocalPool;
import pro.gravit.repackage.io.netty.util.concurrent.FastThreadLocal;
import pro.gravit.repackage.io.netty.util.internal.SystemPropertyUtil;
import pro.gravit.repackage.io.netty.util.internal.logging.InternalLogger;
import pro.gravit.repackage.io.netty.util.internal.logging.InternalLoggerFactory;

public abstract class Recycler<T> {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(Recycler.class);
    private static final Recycler$Handle<?> NOOP_HANDLE = new Recycler$1();
    private static final int DEFAULT_INITIAL_MAX_CAPACITY_PER_THREAD = 4096;
    private static final int DEFAULT_MAX_CAPACITY_PER_THREAD;
    private static final int RATIO;
    private static final int DEFAULT_QUEUE_CHUNK_SIZE_PER_THREAD;
    private static final boolean BLOCKING_POOL;
    private final int maxCapacityPerThread;
    private final int interval;
    private final int chunkSize;
    private final FastThreadLocal<Recycler$LocalPool<T>> threadLocal = new Recycler$2(this);

    protected Recycler() {
        this(DEFAULT_MAX_CAPACITY_PER_THREAD);
    }

    protected Recycler(int n) {
        this(n, RATIO, DEFAULT_QUEUE_CHUNK_SIZE_PER_THREAD);
    }

    @Deprecated
    protected Recycler(int n, int n2) {
        this(n, RATIO, DEFAULT_QUEUE_CHUNK_SIZE_PER_THREAD);
    }

    @Deprecated
    protected Recycler(int n, int n2, int n3, int n4) {
        this(n, n3, DEFAULT_QUEUE_CHUNK_SIZE_PER_THREAD);
    }

    @Deprecated
    protected Recycler(int n, int n2, int n3, int n4, int n5) {
        this(n, n3, DEFAULT_QUEUE_CHUNK_SIZE_PER_THREAD);
    }

    protected Recycler(int n, int n2, int n3) {
        this.interval = Math.max(0, n2);
        if (n <= 0) {
            this.maxCapacityPerThread = 0;
            this.chunkSize = 0;
        } else {
            this.maxCapacityPerThread = Math.max(4, n);
            this.chunkSize = Math.max(2, Math.min(n3, this.maxCapacityPerThread >> 1));
        }
    }

    public final T get() {
        Object object;
        if (this.maxCapacityPerThread == 0) {
            return (T)this.newObject(NOOP_HANDLE);
        }
        Recycler$LocalPool<T> recycler$LocalPool = this.threadLocal.get();
        Recycler$DefaultHandle<T> recycler$DefaultHandle = recycler$LocalPool.claim();
        if (recycler$DefaultHandle == null) {
            recycler$DefaultHandle = recycler$LocalPool.newHandle();
            if (recycler$DefaultHandle != null) {
                object = this.newObject(recycler$DefaultHandle);
                recycler$DefaultHandle.set(object);
            } else {
                object = this.newObject(NOOP_HANDLE);
            }
        } else {
            object = recycler$DefaultHandle.get();
        }
        return object;
    }

    @Deprecated
    public final boolean recycle(T t, Recycler$Handle<T> recycler$Handle) {
        if (recycler$Handle == NOOP_HANDLE) {
            return false;
        }
        recycler$Handle.recycle(t);
        return true;
    }

    final int threadLocalSize() {
        Recycler$LocalPool<T> recycler$LocalPool = this.threadLocal.getIfExists();
        return recycler$LocalPool == null ? 0 : Recycler$LocalPool.access$300(recycler$LocalPool).size();
    }

    protected abstract T newObject(Recycler$Handle<T> var1);

    static /* synthetic */ int access$000(Recycler recycler) {
        return recycler.maxCapacityPerThread;
    }

    static /* synthetic */ int access$100(Recycler recycler) {
        return recycler.interval;
    }

    static /* synthetic */ int access$200(Recycler recycler) {
        return recycler.chunkSize;
    }

    static /* synthetic */ boolean access$400() {
        return BLOCKING_POOL;
    }

    static {
        int n = SystemPropertyUtil.getInt("pro.gravit.repackage.io.netty.recycler.maxCapacityPerThread", SystemPropertyUtil.getInt("pro.gravit.repackage.io.netty.recycler.maxCapacity", 4096));
        if (n < 0) {
            n = 4096;
        }
        DEFAULT_MAX_CAPACITY_PER_THREAD = n;
        DEFAULT_QUEUE_CHUNK_SIZE_PER_THREAD = SystemPropertyUtil.getInt("pro.gravit.repackage.io.netty.recycler.chunkSize", 32);
        RATIO = Math.max(0, SystemPropertyUtil.getInt("pro.gravit.repackage.io.netty.recycler.ratio", 8));
        BLOCKING_POOL = SystemPropertyUtil.getBoolean("pro.gravit.repackage.io.netty.recycler.blocking", false);
        if (logger.isDebugEnabled()) {
            if (DEFAULT_MAX_CAPACITY_PER_THREAD == 0) {
                logger.debug("-Dio.netty.recycler.maxCapacityPerThread: disabled");
                logger.debug("-Dio.netty.recycler.ratio: disabled");
                logger.debug("-Dio.netty.recycler.chunkSize: disabled");
                logger.debug("-Dio.netty.recycler.blocking: disabled");
            } else {
                logger.debug("-Dio.netty.recycler.maxCapacityPerThread: {}", (Object)DEFAULT_MAX_CAPACITY_PER_THREAD);
                logger.debug("-Dio.netty.recycler.ratio: {}", (Object)RATIO);
                logger.debug("-Dio.netty.recycler.chunkSize: {}", (Object)DEFAULT_QUEUE_CHUNK_SIZE_PER_THREAD);
                logger.debug("-Dio.netty.recycler.blocking: {}", (Object)BLOCKING_POOL);
            }
        }
    }
}

