/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.util.collection;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import pro.gravit.repackage.io.netty.util.collection.LongObjectHashMap$1;
import pro.gravit.repackage.io.netty.util.collection.LongObjectHashMap$2;
import pro.gravit.repackage.io.netty.util.collection.LongObjectHashMap$EntrySet;
import pro.gravit.repackage.io.netty.util.collection.LongObjectHashMap$KeySet;
import pro.gravit.repackage.io.netty.util.collection.LongObjectMap;
import pro.gravit.repackage.io.netty.util.collection.LongObjectMap$PrimitiveEntry;
import pro.gravit.repackage.io.netty.util.internal.MathUtil;

public class LongObjectHashMap<V>
implements LongObjectMap<V> {
    public static final int DEFAULT_CAPACITY = 8;
    public static final float DEFAULT_LOAD_FACTOR = 0.5f;
    private static final Object NULL_VALUE = new Object();
    private int maxSize;
    private final float loadFactor;
    private long[] keys;
    private V[] values;
    private int size;
    private int mask;
    private final Set<Long> keySet = new LongObjectHashMap$KeySet(this, null);
    private final Set<Map.Entry<Long, V>> entrySet = new LongObjectHashMap$EntrySet(this, null);
    private final Iterable<LongObjectMap$PrimitiveEntry<V>> entries = new LongObjectHashMap$1(this);

    public LongObjectHashMap() {
        this(8, 0.5f);
    }

    public LongObjectHashMap(int n) {
        this(n, 0.5f);
    }

    public LongObjectHashMap(int n, float f) {
        if (f <= 0.0f || f > 1.0f) {
            throw new IllegalArgumentException("loadFactor must be > 0 and <= 1");
        }
        this.loadFactor = f;
        int n2 = MathUtil.safeFindNextPositivePowerOfTwo(n);
        this.mask = n2 - 1;
        this.keys = new long[n2];
        Object[] objectArray = new Object[n2];
        this.values = objectArray;
        this.maxSize = this.calcMaxSize(n2);
    }

    private static <T> T toExternal(T t) {
        assert (t != null) : "null is not a legitimate internal value. Concurrent Modification?";
        return t == NULL_VALUE ? null : (T)t;
    }

    private static <T> T toInternal(T t) {
        return (T)(t == null ? NULL_VALUE : t);
    }

    @Override
    public V get(long l) {
        int n = this.indexOf(l);
        return n == -1 ? null : (V)LongObjectHashMap.toExternal(this.values[n]);
    }

    @Override
    public V put(long l, V v) {
        int n;
        int n2 = n = this.hashIndex(l);
        do {
            if (this.values[n2] == null) {
                this.keys[n2] = l;
                this.values[n2] = LongObjectHashMap.toInternal(v);
                this.growSize();
                return null;
            }
            if (this.keys[n2] != l) continue;
            V v2 = this.values[n2];
            this.values[n2] = LongObjectHashMap.toInternal(v);
            return LongObjectHashMap.toExternal(v2);
        } while ((n2 = this.probeNext(n2)) != n);
        throw new IllegalStateException("Unable to insert");
    }

    @Override
    public void putAll(Map<? extends Long, ? extends V> map) {
        if (map instanceof LongObjectHashMap) {
            LongObjectHashMap longObjectHashMap = (LongObjectHashMap)map;
            for (int i = 0; i < longObjectHashMap.values.length; ++i) {
                V v = longObjectHashMap.values[i];
                if (v == null) continue;
                this.put(longObjectHashMap.keys[i], v);
            }
            return;
        }
        for (Map.Entry<Long, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(long l) {
        int n = this.indexOf(l);
        if (n == -1) {
            return null;
        }
        V v = this.values[n];
        this.removeAt(n);
        return LongObjectHashMap.toExternal(v);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public void clear() {
        Arrays.fill(this.keys, 0L);
        Arrays.fill(this.values, null);
        this.size = 0;
    }

    @Override
    public boolean containsKey(long l) {
        return this.indexOf(l) >= 0;
    }

    @Override
    public boolean containsValue(Object object) {
        Object object2 = LongObjectHashMap.toInternal(object);
        for (V v : this.values) {
            if (v == null || !v.equals(object2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterable<LongObjectMap$PrimitiveEntry<V>> entries() {
        return this.entries;
    }

    @Override
    public Collection<V> values() {
        return new LongObjectHashMap$2(this);
    }

    @Override
    public int hashCode() {
        int n = this.size;
        for (long l : this.keys) {
            n ^= LongObjectHashMap.hashCode(l);
        }
        return n;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof LongObjectMap)) {
            return false;
        }
        LongObjectMap longObjectMap = (LongObjectMap)object;
        if (this.size != longObjectMap.size()) {
            return false;
        }
        for (int i = 0; i < this.values.length; ++i) {
            V v = this.values[i];
            if (v == null) continue;
            long l = this.keys[i];
            Object v2 = longObjectMap.get(l);
            if (!(v == NULL_VALUE ? v2 != null : !v.equals(v2))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsKey(Object object) {
        return this.containsKey(this.objectToKey(object));
    }

    @Override
    public V get(Object object) {
        return this.get(this.objectToKey(object));
    }

    @Override
    public V put(Long l, V v) {
        return this.put(this.objectToKey(l), v);
    }

    @Override
    public V remove(Object object) {
        return this.remove(this.objectToKey(object));
    }

    @Override
    public Set<Long> keySet() {
        return this.keySet;
    }

    @Override
    public Set<Map.Entry<Long, V>> entrySet() {
        return this.entrySet;
    }

    private long objectToKey(Object object) {
        return (Long)object;
    }

    private int indexOf(long l) {
        int n;
        int n2 = n = this.hashIndex(l);
        do {
            if (this.values[n2] == null) {
                return -1;
            }
            if (l != this.keys[n2]) continue;
            return n2;
        } while ((n2 = this.probeNext(n2)) != n);
        return -1;
    }

    private int hashIndex(long l) {
        return LongObjectHashMap.hashCode(l) & this.mask;
    }

    private static int hashCode(long l) {
        return (int)(l ^ l >>> 32);
    }

    private int probeNext(int n) {
        return n + 1 & this.mask;
    }

    private void growSize() {
        ++this.size;
        if (this.size > this.maxSize) {
            if (this.keys.length == Integer.MAX_VALUE) {
                throw new IllegalStateException("Max capacity reached at size=" + this.size);
            }
            this.rehash(this.keys.length << 1);
        }
    }

    private boolean removeAt(int n) {
        --this.size;
        this.keys[n] = 0L;
        this.values[n] = null;
        int n2 = n;
        int n3 = this.probeNext(n);
        V v = this.values[n3];
        while (v != null) {
            long l = this.keys[n3];
            int n4 = this.hashIndex(l);
            if (n3 < n4 && (n4 <= n2 || n2 <= n3) || n4 <= n2 && n2 <= n3) {
                this.keys[n2] = l;
                this.values[n2] = v;
                this.keys[n3] = 0L;
                this.values[n3] = null;
                n2 = n3;
            }
            n3 = this.probeNext(n3);
            v = this.values[n3];
        }
        return n2 != n;
    }

    private int calcMaxSize(int n) {
        int n2 = n - 1;
        return Math.min(n2, (int)((float)n * this.loadFactor));
    }

    private void rehash(int n) {
        long[] lArray = this.keys;
        V[] VArray = this.values;
        this.keys = new long[n];
        Object[] objectArray = new Object[n];
        this.values = objectArray;
        this.maxSize = this.calcMaxSize(n);
        this.mask = n - 1;
        block0: for (int i = 0; i < VArray.length; ++i) {
            V v = VArray[i];
            if (v == null) continue;
            long l = lArray[i];
            int n2 = this.hashIndex(l);
            while (true) {
                if (this.values[n2] == null) {
                    this.keys[n2] = l;
                    this.values[n2] = v;
                    continue block0;
                }
                n2 = this.probeNext(n2);
            }
        }
    }

    public String toString() {
        if (this.isEmpty()) {
            return "{}";
        }
        StringBuilder stringBuilder = new StringBuilder(4 * this.size);
        stringBuilder.append('{');
        boolean bl = true;
        for (int i = 0; i < this.values.length; ++i) {
            V v = this.values[i];
            if (v == null) continue;
            if (!bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(this.keyToString(this.keys[i])).append('=').append((Object)(v == this ? "(this Map)" : LongObjectHashMap.toExternal(v)));
            bl = false;
        }
        return stringBuilder.append('}').toString();
    }

    protected String keyToString(long l) {
        return Long.toString(l);
    }

    static /* synthetic */ int access$300(LongObjectHashMap longObjectHashMap) {
        return longObjectHashMap.size;
    }

    static /* synthetic */ Set access$500(LongObjectHashMap longObjectHashMap) {
        return longObjectHashMap.entrySet;
    }

    static /* synthetic */ Object[] access$600(LongObjectHashMap longObjectHashMap) {
        return longObjectHashMap.values;
    }

    static /* synthetic */ boolean access$700(LongObjectHashMap longObjectHashMap, int n) {
        return longObjectHashMap.removeAt(n);
    }

    static /* synthetic */ long[] access$800(LongObjectHashMap longObjectHashMap) {
        return longObjectHashMap.keys;
    }

    static /* synthetic */ Object access$900(Object object) {
        return LongObjectHashMap.toExternal(object);
    }

    static /* synthetic */ Object access$1000(Object object) {
        return LongObjectHashMap.toInternal(object);
    }
}

