/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.util.concurrent;

import java.util.Queue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import pro.gravit.repackage.io.netty.util.concurrent.AbstractEventExecutor;
import pro.gravit.repackage.io.netty.util.concurrent.EventExecutor;
import pro.gravit.repackage.io.netty.util.concurrent.Future;
import pro.gravit.repackage.io.netty.util.concurrent.OrderedEventExecutor;
import pro.gravit.repackage.io.netty.util.internal.PlatformDependent;

final class NonStickyEventExecutorGroup$NonStickyOrderedEventExecutor
extends AbstractEventExecutor
implements Runnable,
OrderedEventExecutor {
    private final EventExecutor executor;
    private final Queue<Runnable> tasks = PlatformDependent.newMpscQueue();
    private static final int NONE = 0;
    private static final int SUBMITTED = 1;
    private static final int RUNNING = 2;
    private final AtomicInteger state = new AtomicInteger();
    private final int maxTaskExecutePerRun;

    NonStickyEventExecutorGroup$NonStickyOrderedEventExecutor(EventExecutor eventExecutor, int n) {
        super(eventExecutor);
        this.executor = eventExecutor;
        this.maxTaskExecutePerRun = n;
    }

    @Override
    public void run() {
        if (!this.state.compareAndSet(1, 2)) {
            return;
        }
        block7: while (true) {
            int n = 0;
            try {
                while (true) {
                    Runnable runnable;
                    if (n >= this.maxTaskExecutePerRun || (runnable = this.tasks.poll()) == null) continue block7;
                    NonStickyEventExecutorGroup$NonStickyOrderedEventExecutor.safeExecute(runnable);
                    ++n;
                }
            }
            finally {
                if (n == this.maxTaskExecutePerRun) {
                    try {
                        this.state.set(1);
                        this.executor.execute(this);
                        return;
                    }
                    catch (Throwable throwable) {
                        this.state.set(2);
                    }
                } else {
                    this.state.set(0);
                    if (!this.tasks.isEmpty() && this.state.compareAndSet(0, 2)) continue;
                    return;
                }
                continue;
            }
            break;
        }
    }

    @Override
    public boolean inEventLoop(Thread thread) {
        return false;
    }

    @Override
    public boolean inEventLoop() {
        return false;
    }

    @Override
    public boolean isShuttingDown() {
        return this.executor.isShutdown();
    }

    @Override
    public Future<?> shutdownGracefully(long l, long l2, TimeUnit timeUnit) {
        return this.executor.shutdownGracefully(l, l2, timeUnit);
    }

    @Override
    public Future<?> terminationFuture() {
        return this.executor.terminationFuture();
    }

    @Override
    public void shutdown() {
        this.executor.shutdown();
    }

    @Override
    public boolean isShutdown() {
        return this.executor.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.executor.isTerminated();
    }

    @Override
    public boolean awaitTermination(long l, TimeUnit timeUnit) {
        return this.executor.awaitTermination(l, timeUnit);
    }

    @Override
    public void execute(Runnable runnable) {
        if (!this.tasks.offer(runnable)) {
            throw new RejectedExecutionException();
        }
        if (this.state.compareAndSet(0, 1)) {
            this.executor.execute(this);
        }
    }
}

