/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.util.concurrent;

import pro.gravit.repackage.io.netty.util.concurrent.Future;
import pro.gravit.repackage.io.netty.util.concurrent.GenericFutureListener;
import pro.gravit.repackage.io.netty.util.concurrent.Promise;
import pro.gravit.repackage.io.netty.util.concurrent.PromiseNotifier$1;
import pro.gravit.repackage.io.netty.util.concurrent.PromiseNotifier$2;
import pro.gravit.repackage.io.netty.util.internal.ObjectUtil;
import pro.gravit.repackage.io.netty.util.internal.PromiseNotificationUtil;
import pro.gravit.repackage.io.netty.util.internal.logging.InternalLogger;
import pro.gravit.repackage.io.netty.util.internal.logging.InternalLoggerFactory;

public class PromiseNotifier<V, F extends Future<V>>
implements GenericFutureListener<F> {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(PromiseNotifier.class);
    private final Promise<? super V>[] promises;
    private final boolean logNotifyFailure;

    @SafeVarargs
    public PromiseNotifier(Promise<? super V> ... promiseArray) {
        this(true, promiseArray);
    }

    @SafeVarargs
    public PromiseNotifier(boolean bl, Promise<? super V> ... promiseArray) {
        ObjectUtil.checkNotNull(promiseArray, "promises");
        for (Promise<? super V> promise : promiseArray) {
            ObjectUtil.checkNotNullWithIAE(promise, "promise");
        }
        this.promises = (Promise[])promiseArray.clone();
        this.logNotifyFailure = bl;
    }

    public static <V, F extends Future<V>> F cascade(F f, Promise<? super V> promise) {
        return PromiseNotifier.cascade(true, f, promise);
    }

    public static <V, F extends Future<V>> F cascade(boolean bl, F f, Promise<? super V> promise) {
        promise.addListener(new PromiseNotifier$1(f));
        f.addListener(new PromiseNotifier$2(bl, new Promise[]{promise}, promise, f));
        return f;
    }

    @Override
    public void operationComplete(F f) {
        InternalLogger internalLogger;
        InternalLogger internalLogger2 = internalLogger = this.logNotifyFailure ? logger : null;
        if (f.isSuccess()) {
            Object v = f.get();
            for (Promise<? super V> promise : this.promises) {
                PromiseNotificationUtil.trySuccess(promise, v, internalLogger);
            }
        } else if (f.isCancelled()) {
            for (Promise<? super V> promise : this.promises) {
                PromiseNotificationUtil.tryCancel(promise, internalLogger);
            }
        } else {
            Throwable throwable = f.cause();
            for (Promise<? super V> promise : this.promises) {
                PromiseNotificationUtil.tryFailure(promise, throwable, internalLogger);
            }
        }
    }
}

