/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.repackage.io.netty.util.concurrent;

import java.util.concurrent.Callable;
import java.util.concurrent.RunnableFuture;
import pro.gravit.repackage.io.netty.util.concurrent.DefaultPromise;
import pro.gravit.repackage.io.netty.util.concurrent.EventExecutor;
import pro.gravit.repackage.io.netty.util.concurrent.Promise;
import pro.gravit.repackage.io.netty.util.concurrent.PromiseTask$RunnableAdapter;
import pro.gravit.repackage.io.netty.util.concurrent.PromiseTask$SentinelRunnable;

class PromiseTask<V>
extends DefaultPromise<V>
implements RunnableFuture<V> {
    private static final Runnable COMPLETED = new PromiseTask$SentinelRunnable("COMPLETED");
    private static final Runnable CANCELLED = new PromiseTask$SentinelRunnable("CANCELLED");
    private static final Runnable FAILED = new PromiseTask$SentinelRunnable("FAILED");
    private Object task;

    PromiseTask(EventExecutor eventExecutor, Runnable runnable, V v) {
        super(eventExecutor);
        this.task = v == null ? runnable : new PromiseTask$RunnableAdapter<V>(runnable, v);
    }

    PromiseTask(EventExecutor eventExecutor, Runnable runnable) {
        super(eventExecutor);
        this.task = runnable;
    }

    PromiseTask(EventExecutor eventExecutor, Callable<V> callable) {
        super(eventExecutor);
        this.task = callable;
    }

    public final int hashCode() {
        return System.identityHashCode(this);
    }

    public final boolean equals(Object object) {
        return this == object;
    }

    V runTask() {
        Object object = this.task;
        if (object instanceof Callable) {
            return ((Callable)object).call();
        }
        ((Runnable)object).run();
        return null;
    }

    @Override
    public void run() {
        try {
            if (this.setUncancellableInternal()) {
                V v = this.runTask();
                this.setSuccessInternal(v);
            }
        }
        catch (Throwable throwable) {
            this.setFailureInternal(throwable);
        }
    }

    private boolean clearTaskAfterCompletion(boolean bl, Runnable runnable) {
        if (bl) {
            this.task = runnable;
        }
        return bl;
    }

    @Override
    public final Promise<V> setFailure(Throwable throwable) {
        throw new IllegalStateException();
    }

    protected final Promise<V> setFailureInternal(Throwable throwable) {
        super.setFailure(throwable);
        this.clearTaskAfterCompletion(true, FAILED);
        return this;
    }

    @Override
    public final boolean tryFailure(Throwable throwable) {
        return false;
    }

    protected final boolean tryFailureInternal(Throwable throwable) {
        return this.clearTaskAfterCompletion(super.tryFailure(throwable), FAILED);
    }

    @Override
    public final Promise<V> setSuccess(V v) {
        throw new IllegalStateException();
    }

    protected final Promise<V> setSuccessInternal(V v) {
        super.setSuccess(v);
        this.clearTaskAfterCompletion(true, COMPLETED);
        return this;
    }

    @Override
    public final boolean trySuccess(V v) {
        return false;
    }

    protected final boolean trySuccessInternal(V v) {
        return this.clearTaskAfterCompletion(super.trySuccess(v), COMPLETED);
    }

    @Override
    public final boolean setUncancellable() {
        throw new IllegalStateException();
    }

    protected final boolean setUncancellableInternal() {
        return super.setUncancellable();
    }

    @Override
    public boolean cancel(boolean bl) {
        return this.clearTaskAfterCompletion(super.cancel(bl), CANCELLED);
    }

    @Override
    protected StringBuilder toStringBuilder() {
        StringBuilder stringBuilder = super.toStringBuilder();
        stringBuilder.setCharAt(stringBuilder.length() - 1, ',');
        return stringBuilder.append(" task: ").append(this.task).append(')');
    }
}

