/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.utils.helper;

import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Properties;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.JVMHelper;
import pro.gravit.utils.helper.JVMHelper$ARCH;
import pro.gravit.utils.helper.JavaHelper;
import pro.gravit.utils.helper.JavaHelper$JavaVersionAndBuild;

public class JavaHelper$JavaVersion {
    public final Path jvmDir;
    public final int version;
    public final int build;
    public final JVMHelper$ARCH arch;
    public boolean enabledJavaFX;

    public JavaHelper$JavaVersion(Path path, int n) {
        this.jvmDir = path;
        this.version = n;
        this.build = 0;
        this.arch = JVMHelper.ARCH_TYPE;
        this.enabledJavaFX = true;
    }

    public JavaHelper$JavaVersion(Path path, int n, int n2, boolean bl) {
        this.jvmDir = path;
        this.version = n;
        this.build = n2;
        this.arch = JVMHelper.ARCH_TYPE;
        this.enabledJavaFX = bl;
    }

    public JavaHelper$JavaVersion(Path path, int n, int n2, JVMHelper$ARCH jVMHelper$ARCH, boolean bl) {
        this.jvmDir = path;
        this.version = n;
        this.build = n2;
        this.arch = jVMHelper$ARCH;
        this.enabledJavaFX = bl;
    }

    public static JavaHelper$JavaVersion getCurrentJavaVersion() {
        return new JavaHelper$JavaVersion(Paths.get(System.getProperty("java.home"), new String[0]), JVMHelper.getVersion(), JVMHelper.JVM_BUILD, JVMHelper.ARCH_TYPE, JavaHelper$JavaVersion.isCurrentJavaSupportJavaFX());
    }

    private static boolean isCurrentJavaSupportJavaFX() {
        try {
            Class.forName("javafx.application.Application");
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            if (JVMHelper.getVersion() > 8) {
                Path path = Paths.get(System.getProperty("java.home"), new String[0]);
                return JavaHelper.tryFindModule(path, "javafx.base") != null;
            }
            return false;
        }
    }

    public static JavaHelper$JavaVersion getByPath(Path path) {
        Object object;
        Object object2 = JavaHelper.access$000(path);
        if (object2 != null) {
            return object2;
        }
        object2 = path.resolve("release");
        JavaHelper$JavaVersionAndBuild javaHelper$JavaVersionAndBuild = null;
        JVMHelper$ARCH jVMHelper$ARCH = JVMHelper.ARCH_TYPE;
        if (IOHelper.isFile((Path)object2)) {
            try {
                object = new Properties();
                ((Properties)object).load(IOHelper.newReader((Path)object2));
                javaHelper$JavaVersionAndBuild = JavaHelper.getJavaVersion(((Properties)object).getProperty("JAVA_VERSION").replaceAll("\"", ""));
                try {
                    jVMHelper$ARCH = JVMHelper.getArch(((Properties)object).getProperty("OS_ARCH").replaceAll("\"", ""));
                }
                catch (Throwable throwable) {
                    jVMHelper$ARCH = null;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (javaHelper$JavaVersionAndBuild == null) {
            javaHelper$JavaVersionAndBuild = new JavaHelper$JavaVersionAndBuild(JavaHelper$JavaVersion.isExistExtJavaLibrary(path, "rt") ? 8 : 9, 0);
        }
        object = new JavaHelper$JavaVersion(path, javaHelper$JavaVersionAndBuild.version, javaHelper$JavaVersionAndBuild.build, jVMHelper$ARCH, false);
        if (javaHelper$JavaVersionAndBuild.version <= 8) {
            ((JavaHelper$JavaVersion)object).enabledJavaFX = JavaHelper$JavaVersion.isExistExtJavaLibrary(path, "jfxrt");
        } else {
            boolean bl = ((JavaHelper$JavaVersion)object).enabledJavaFX = JavaHelper.tryFindModule(path, "javafx.base") != null;
            if (!((JavaHelper$JavaVersion)object).enabledJavaFX) {
                ((JavaHelper$JavaVersion)object).enabledJavaFX = JavaHelper.tryFindModule(path.resolve("jre"), "javafx.base") != null;
            }
        }
        return object;
    }

    public static boolean isExistExtJavaLibrary(Path path, String string) {
        Path path2 = path.resolve("lib").resolve("ext").resolve(string.concat(".jar"));
        Path path3 = path.resolve("lib").resolve(string.concat(".jar"));
        Path path4 = path.resolve("jre").resolve("lib").resolve("ext").resolve(string.concat(".jar"));
        Path path5 = path.resolve("jre").resolve("lib").resolve(string.concat(".jar"));
        return IOHelper.isFile(path2) || IOHelper.isFile(path4) || IOHelper.isFile(path5) || IOHelper.isFile(path3);
    }
}

