/*
 * Decompiled with CFR 0.152.
 */
package pro.gravit.utils.helper;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import pro.gravit.utils.helper.IOHelper;
import pro.gravit.utils.helper.JVMHelper;
import pro.gravit.utils.helper.JVMHelper$OS;
import pro.gravit.utils.helper.JavaHelper$JavaVersion;
import pro.gravit.utils.helper.JavaHelper$JavaVersionAndBuild;
import pro.gravit.utils.helper.LogHelper;

public class JavaHelper {
    private static List<JavaHelper$JavaVersion> javaVersionsCache;

    public static Path tryGetOpenJFXPath(Path path) {
        Path path2;
        String string = path.getFileName().toString();
        Path path3 = path.getParent();
        if (path3 == null) {
            return null;
        }
        Path path4 = path3.resolve(string.replace("openjdk", "openjfx"));
        if (Files.isDirectory(path4, new LinkOption[0])) {
            return path4;
        }
        Path path5 = path3.resolve(string.replace("jdk", "openjfx"));
        if (Files.isDirectory(path5, new LinkOption[0])) {
            return path5;
        }
        if (JVMHelper.OS_TYPE == JVMHelper$OS.LINUX && Files.isDirectory(path2 = Paths.get("/usr/share/openjfx", new String[0]), new LinkOption[0])) {
            return path2;
        }
        return null;
    }

    public static Path tryFindModule(Path path, String string) {
        Path path2 = path.resolve(string.concat(".jar"));
        if (IOHelper.isFile(path2)) {
            return path2;
        }
        path2 = path.resolve("lib").resolve(string.concat(".jar"));
        if (!IOHelper.isFile(path2)) {
            return null;
        }
        return path2;
    }

    public static boolean tryAddModule(List<Path> list, String string, StringBuilder stringBuilder) {
        for (Path path : list) {
            Path path2;
            if (path == null || (path2 = JavaHelper.tryFindModule(path, string)) == null) continue;
            if (stringBuilder.length() != 0) {
                stringBuilder.append(File.pathSeparatorChar);
            }
            stringBuilder.append(path2.toAbsolutePath());
            return true;
        }
        return false;
    }

    public static synchronized List<JavaHelper$JavaVersion> findJava() {
        if (javaVersionsCache != null) {
            return javaVersionsCache;
        }
        ArrayList<String> arrayList = new ArrayList<String>(4);
        ArrayList<JavaHelper$JavaVersion> arrayList2 = new ArrayList<JavaHelper$JavaVersion>(4);
        JavaHelper.tryAddJava(arrayList, arrayList2, JavaHelper$JavaVersion.getCurrentJavaVersion());
        String[] stringArray = System.getenv("PATH").split(JVMHelper.OS_TYPE == JVMHelper$OS.MUSTDIE ? ";" : ":");
        for (String string : stringArray) {
            try {
                Path path;
                Path path2 = Paths.get(string, new String[0]);
                Path path3 = path = JVMHelper.OS_TYPE == JVMHelper$OS.MUSTDIE ? path2.resolve("java.exe") : path2.resolve("java");
                if (!Files.exists(path, new LinkOption[0]) || (path2 = (path = path.toRealPath(new LinkOption[0])).getParent().getParent()) == null) continue;
                JavaHelper.tryAddJava(arrayList, arrayList2, JavaHelper$JavaVersion.getByPath(path2));
                JavaHelper.trySearchJava(arrayList, arrayList2, path2.getParent());
            }
            catch (NullPointerException | InvalidPathException runtimeException) {
            }
            catch (IOException iOException) {
                LogHelper.error(iOException);
            }
        }
        if (JVMHelper.OS_TYPE == JVMHelper$OS.MUSTDIE) {
            Path path = IOHelper.getRoot();
            try {
                JavaHelper.trySearchJava(arrayList, arrayList2, path.resolve("Program Files").resolve("Java"));
                JavaHelper.trySearchJava(arrayList, arrayList2, path.resolve("Program Files").resolve("AdoptOpenJDK"));
                JavaHelper.trySearchJava(arrayList, arrayList2, path.resolve("Program Files").resolve("Eclipse Foundation"));
                JavaHelper.trySearchJava(arrayList, arrayList2, path.resolve("Program Files").resolve("BellSoft"));
            }
            catch (IOException iOException) {
                LogHelper.error(iOException);
            }
        } else if (JVMHelper.OS_TYPE == JVMHelper$OS.LINUX) {
            try {
                JavaHelper.trySearchJava(arrayList, arrayList2, Paths.get("/usr/lib/jvm", new String[0]));
            }
            catch (IOException iOException) {
                LogHelper.error(iOException);
            }
        }
        javaVersionsCache = arrayList2;
        return arrayList2;
    }

    private static JavaHelper$JavaVersion tryFindJavaByPath(Path path) {
        if (javaVersionsCache == null) {
            return null;
        }
        for (JavaHelper$JavaVersion javaHelper$JavaVersion : javaVersionsCache) {
            if (!javaHelper$JavaVersion.jvmDir.equals(path)) continue;
            return javaHelper$JavaVersion;
        }
        return null;
    }

    public static void tryAddJava(List<String> list, List<JavaHelper$JavaVersion> list2, JavaHelper$JavaVersion javaHelper$JavaVersion) {
        if (javaHelper$JavaVersion == null) {
            return;
        }
        Path path = javaHelper$JavaVersion.jvmDir.toAbsolutePath();
        try {
            path = path.toRealPath(new LinkOption[0]);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String string = path.toString();
        if (list.contains(string)) {
            return;
        }
        list.add(string);
        list2.add(javaHelper$JavaVersion);
    }

    public static void trySearchJava(List<String> list, List<JavaHelper$JavaVersion> list2, Path path2) {
        if (path2 == null || !Files.isDirectory(path2, new LinkOption[0])) {
            return;
        }
        Files.list(path2).filter(path -> Files.exists(path.resolve("bin").resolve(JVMHelper.OS_TYPE == JVMHelper$OS.MUSTDIE ? "java.exe" : "java"), new LinkOption[0])).forEach(path -> {
            JavaHelper.tryAddJava(list, list2, JavaHelper$JavaVersion.getByPath(path));
            if (Files.exists(path.resolve("jre"), new LinkOption[0])) {
                JavaHelper.tryAddJava(list, list2, JavaHelper$JavaVersion.getByPath(path.resolve("jre")));
            }
        });
    }

    public static JavaHelper$JavaVersionAndBuild getJavaVersion(String string) {
        JavaHelper$JavaVersionAndBuild javaHelper$JavaVersionAndBuild = new JavaHelper$JavaVersionAndBuild();
        if (string.startsWith("1.")) {
            javaHelper$JavaVersionAndBuild.version = Integer.parseInt(string.substring(2, 3));
            int n = string.indexOf(95);
            if (n != -1) {
                javaHelper$JavaVersionAndBuild.build = Integer.parseInt(string.substring(n + 1));
            }
        } else {
            int n = string.indexOf(".");
            if (n != -1) {
                javaHelper$JavaVersionAndBuild.version = Integer.parseInt(string.substring(0, n));
                n = string.lastIndexOf(".");
                javaHelper$JavaVersionAndBuild.build = Integer.parseInt(string.substring(n + 1));
            } else {
                try {
                    if (string.endsWith("-ea")) {
                        string = string.substring(0, string.length() - 3);
                    }
                    javaHelper$JavaVersionAndBuild.version = Integer.parseInt(string);
                    javaHelper$JavaVersionAndBuild.build = 0;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return javaHelper$JavaVersionAndBuild;
    }

    static /* synthetic */ JavaHelper$JavaVersion access$000(Path path) {
        return JavaHelper.tryFindJavaByPath(path);
    }
}

