/*
 * Decompiled with CFR 0.152.
 */
package bspkrs.treecapitator.registry;

import bspkrs.treecapitator.config.TCSettings;
import bspkrs.treecapitator.registry.ModConfigRegistry;
import bspkrs.treecapitator.util.TCLog;
import bspkrs.util.ItemID;
import bspkrs.util.ListUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.ForgeHooks;

public class ToolRegistry {
    private static ToolRegistry instance;
    private List<ItemID> axeList;
    private List<ItemID> shearsList;
    private List<ItemID> vanAxeList;
    private List<ItemID> vanShearsList;
    private List<ItemID> blacklist;

    public static ToolRegistry instance() {
        if (instance == null) {
            new ToolRegistry();
        }
        return instance;
    }

    protected ToolRegistry() {
        instance = this;
        this.initLists();
        this.initVanillaItemLists();
    }

    protected void initLists() {
        this.axeList = new ArrayList<ItemID>();
        this.shearsList = new ArrayList<ItemID>();
        this.readBlacklistFromDelimitedString(TCSettings.itemIDBlacklist);
    }

    protected void initVanillaLists() {
        this.vanAxeList = new ArrayList<ItemID>();
        this.vanShearsList = new ArrayList<ItemID>();
    }

    protected void initVanillaItemLists() {
        this.initVanillaLists();
        this.vanAxeList.add(new ItemID(Items.field_151053_p));
        this.vanAxeList.add(new ItemID(Items.field_151049_t));
        this.vanAxeList.add(new ItemID(Items.field_151036_c));
        this.vanAxeList.add(new ItemID(Items.field_151006_E));
        this.vanAxeList.add(new ItemID(Items.field_151056_x));
        this.vanShearsList.add(new ItemID((Item)Items.field_151097_aZ));
    }

    public static synchronized void autoDetectAxe(ItemStack item, Block block, int blockMetadata) {
        if (item != null && item.func_77973_b() != null && ForgeHooks.isToolEffective((ItemStack)item, (Block)block, (int)blockMetadata)) {
            ItemID axe = new ItemID(item);
            if (!instance.isAxe(item)) {
                TCLog.debug("Auto Axe Detection: Attempting to register axe %s", axe);
            }
            if (instance.registerAxe(axe)) {
                int index = axe.id.indexOf(":");
                String modID = index == -1 ? "minecraft" : axe.id.substring(0, index);
                ModConfigRegistry.instance().appendAxeToModConfig(modID, axe);
            }
        }
    }

    public List<ItemID> blacklist() {
        return new ArrayList<ItemID>(this.blacklist);
    }

    public void readBlacklistFromDelimitedString(String dList) {
        this.blacklist = ListUtils.getDelimitedStringAsItemIDList((String)dList, (String)";");
    }

    protected void readFromNBT(NBTTagCompound ntc) {
        this.axeList = ListUtils.getDelimitedStringAsItemIDList((String)ntc.func_74779_i("axeIDList"), (String)";");
        this.shearsList = ListUtils.getDelimitedStringAsItemIDList((String)ntc.func_74779_i("shearsIDList"), (String)";");
        this.blacklist = ListUtils.getDelimitedStringAsItemIDList((String)ntc.func_74779_i("blacklist"), (String)";");
    }

    public void writeToNBT(NBTTagCompound ntc) {
        ntc.func_74778_a("axeIDList", ListUtils.getListAsDelimitedString(this.axeList, (String)";"));
        ntc.func_74778_a("shearsIDList", ListUtils.getListAsDelimitedString(this.shearsList, (String)";"));
        ntc.func_74778_a("blacklist", ListUtils.getListAsDelimitedString(this.blacklist, (String)";"));
    }

    public synchronized boolean registerAxe(ItemID axe) {
        if (axe != null && !this.blacklist.contains(axe) && !this.axeList.contains(axe)) {
            this.axeList.add(axe);
            TCLog.debug("ToolRegistry: Successfully registered axe item %s", axe);
            return true;
        }
        if (this.blacklist.contains(axe)) {
            TCLog.debug("ToolRegistry: Item %s is on the blacklist and will not be registered as an axe", axe);
        }
        return false;
    }

    public synchronized boolean registerShears(ItemID shears) {
        if (shears != null && !this.blacklist.contains(shears) && !this.shearsList.contains(shears)) {
            this.shearsList.add(shears);
            TCLog.debug("ToolRegistry: Successfully registered shears item %s", shears);
            return true;
        }
        if (this.blacklist.contains(shears)) {
            TCLog.debug("ToolRegistry: Item %s is on the blacklist and will not be registered as shears", shears);
        }
        return false;
    }

    public List<ItemID> axeList() {
        return new ArrayList<ItemID>(this.axeList);
    }

    public List<ItemID> shearsList() {
        return new ArrayList<ItemID>(this.shearsList);
    }

    public List<ItemID> vanillaAxeList() {
        return new ArrayList<ItemID>(this.vanAxeList);
    }

    public List<ItemID> vanillaShearsList() {
        return new ArrayList<ItemID>(this.vanShearsList);
    }

    public boolean isAxe(ItemStack itemStack) {
        if (itemStack != null && itemStack.func_77973_b() != null) {
            ItemID itemID = new ItemID(itemStack);
            return !this.blacklist.contains(itemID) && this.axeList.contains(itemID);
        }
        return false;
    }

    public boolean isShears(ItemStack itemStack) {
        if (itemStack != null && itemStack.func_77973_b() != null) {
            ItemID itemID = new ItemID(itemStack);
            return !this.blacklist.contains(itemID) && this.shearsList.contains(itemID);
        }
        return false;
    }
}

