/*
 * Decompiled with CFR 0.152.
 */
package mods.betterfoliage.client.render;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import mods.betterfoliage.client.render.Utils;
import mods.betterfoliage.kotlin.Metadata;
import mods.betterfoliage.kotlin.TuplesKt;
import mods.betterfoliage.kotlin.Unit;
import mods.betterfoliage.kotlin.collections.CollectionsKt;
import mods.betterfoliage.kotlin.collections.IntIterator;
import mods.betterfoliage.kotlin.jvm.JvmName;
import mods.betterfoliage.kotlin.jvm.functions.Function1;
import mods.betterfoliage.kotlin.jvm.functions.Function6;
import mods.betterfoliage.kotlin.jvm.internal.Intrinsics;
import mods.betterfoliage.kotlin.ranges.IntRange;
import mods.octarinecore.client.render.Double3;
import mods.octarinecore.client.render.GeometryKt;
import mods.octarinecore.client.render.Int3;
import mods.octarinecore.client.render.Model;
import mods.octarinecore.client.render.Quad;
import mods.octarinecore.client.render.RenderVertex;
import mods.octarinecore.client.render.Rotation;
import mods.octarinecore.client.render.ShadingContext;
import mods.octarinecore.client.render.Vertex;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraftforge.common.util.ForgeDirection;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 5}, bv={1, 0, 1}, k=2, d1={"\u0000j\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u000e\u0010'\u001a\u00020\u001a2\u0006\u0010(\u001a\u00020\u000e\u001a.\u0010)\u001a\u00020\u0011*\u00020*2\u0006\u0010+\u001a\u00020*2\u0006\u0010,\u001a\u00020*2\u0012\u0010-\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020$0.\u001a\u0018\u0010/\u001a\b\u0012\u0004\u0012\u00020\u000f00*\u00020\u000f2\u0006\u00101\u001a\u000202\u001a,\u0010/\u001a\b\u0012\u0004\u0012\u00020\u000f00*\u00020\u000f2\u0006\u00101\u001a\u0002022\u0012\u00103\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0.\"\u0019\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\n\n\u0002\u0010\u0005\u001a\u0004\b\u0003\u0010\u0004\"\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\"@\u0010\n\u001a1\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000b\u00a2\u0006\u0002\b\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0019\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\n\n\u0002\u0010\u0005\u001a\u0004\b\u0016\u0010\u0004\"\u0019\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\n\n\u0002\u0010\u0005\u001a\u0004\b\u0018\u0010\u0004\"\u0011\u0010\u0019\u001a\u00020\u001a\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0011\u0010\u001d\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\t\"\u0011\u0010\u001f\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\t\"@\u0010!\u001a1\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000b\u00a2\u0006\u0002\b\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u0014\"\u0015\u0010#\u001a\u00020$*\u00020%8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010&\u00a8\u00064"}, d2={"denseLeavesRot", "", "Lmods/octarinecore/client/render/Rotation;", "getDenseLeavesRot", "()[Lmods/octarinecore/client/render/Rotation;", "[Lmods/octarinecore/client/render/Rotation;", "down1", "Lmods/octarinecore/client/render/Int3;", "getDown1", "()Lmods/octarinecore/client/render/Int3;", "greywash", "Lkotlin/Function6;", "Lmods/octarinecore/client/render/RenderVertex;", "Lmods/octarinecore/client/render/ShadingContext;", "", "Lmods/octarinecore/client/render/Quad;", "Lmods/octarinecore/client/render/Vertex;", "", "Lkotlin/ExtensionFunctionType;", "getGreywash", "()Lkotlin/jvm/functions/Function6;", "normalLeavesRot", "getNormalLeavesRot", "rotationFromUp", "getRotationFromUp", "snowOffset", "Lmods/octarinecore/client/render/Double3;", "getSnowOffset", "()Lmods/octarinecore/client/render/Double3;", "up1", "getUp1", "up2", "getUp2", "whitewash", "getWhitewash", "isSnow", "", "Lnet/minecraft/block/Block;", "(Lnet/minecraft/block/Block;)Z", "xzDisk", "modelIdx", "mix", "Lmods/octarinecore/client/render/Model;", "first", "second", "predicate", "Lkotlin/Function1;", "toCross", "", "rotAxis", "Lnet/minecraftforge/common/util/ForgeDirection;", "trans", "BetterFoliage_main"})
@JvmName(name="Utils")
public final class Utils {
    @NotNull
    private static final Int3 up1 = new Int3(TuplesKt.to(1, ForgeDirection.UP));
    @NotNull
    private static final Int3 up2 = new Int3(TuplesKt.to(2, ForgeDirection.UP));
    @NotNull
    private static final Int3 down1 = new Int3(TuplesKt.to(1, ForgeDirection.DOWN));
    @NotNull
    private static final Double3 snowOffset = GeometryKt.times(ForgeDirection.UP, 0.0625);
    @NotNull
    private static final Rotation[] normalLeavesRot;
    @NotNull
    private static final Rotation[] denseLeavesRot;
    @NotNull
    private static final Function6<RenderVertex, ShadingContext, Integer, Quad, Integer, Vertex, Unit> whitewash;
    @NotNull
    private static final Function6<RenderVertex, ShadingContext, Integer, Quad, Integer, Vertex, Unit> greywash;
    @NotNull
    private static final Rotation[] rotationFromUp;

    @NotNull
    public static final Int3 getUp1() {
        return up1;
    }

    @NotNull
    public static final Int3 getUp2() {
        return up2;
    }

    @NotNull
    public static final Int3 getDown1() {
        return down1;
    }

    @NotNull
    public static final Double3 getSnowOffset() {
        return snowOffset;
    }

    @NotNull
    public static final Rotation[] getNormalLeavesRot() {
        return normalLeavesRot;
    }

    @NotNull
    public static final Rotation[] getDenseLeavesRot() {
        return denseLeavesRot;
    }

    @NotNull
    public static final Function6<RenderVertex, ShadingContext, Integer, Quad, Integer, Vertex, Unit> getWhitewash() {
        return whitewash;
    }

    @NotNull
    public static final Function6<RenderVertex, ShadingContext, Integer, Quad, Integer, Vertex, Unit> getGreywash() {
        return greywash;
    }

    public static final boolean isSnow(@NotNull Block $receiver) {
        Material material;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Material it = material = $receiver.func_149688_o();
        return Intrinsics.areEqual(it, Material.field_151597_y) || Intrinsics.areEqual(it, Material.field_151596_z);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<Quad> toCross(@NotNull Quad $receiver, @NotNull ForgeDirection rotAxis, @NotNull Function1<? super Quad, Quad> trans) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(rotAxis, "rotAxis");
        Intrinsics.checkParameterIsNotNull(trans, "trans");
        Iterable iterable = $receiver$iv = (Iterable)new IntRange(0, 3);
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        Iterator iterator2 = $receiver$iv$iv.iterator();
        while (iterator2.hasNext()) {
            void rotIdx;
            int item$iv$iv;
            int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
            Collection collection = destination$iv$iv;
            Quad quad = trans.invoke($receiver.rotate(Rotation.Companion.getRot90()[rotAxis.ordinal()].times((int)rotIdx)).mirrorUV(rotIdx > true, false));
            collection.add(quad);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public static final List<Quad> toCross(@NotNull Quad $receiver, @NotNull ForgeDirection rotAxis) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(rotAxis, "rotAxis");
        return Utils.toCross($receiver, rotAxis, toCross.2.INSTANCE);
    }

    @NotNull
    public static final Double3 xzDisk(int modelIdx) {
        double d;
        double it = d = Math.PI * 2 * (double)modelIdx / 64.0;
        return new Double3(Math.cos(it), 0.0, Math.sin(it));
    }

    @NotNull
    public static final Rotation[] getRotationFromUp() {
        return rotationFromUp;
    }

    /*
     * WARNING - void declaration
     */
    public static final void mix(@NotNull Model $receiver, @NotNull Model first, @NotNull Model second, @NotNull Function1<? super Integer, Boolean> predicate) {
        Intrinsics.checkParameterIsNotNull($receiver, "$receiver");
        Intrinsics.checkParameterIsNotNull(first, "first");
        Intrinsics.checkParameterIsNotNull(second, "second");
        Intrinsics.checkParameterIsNotNull(predicate, "predicate");
        Iterable $receiver$iv = first.getQuads();
        int index$iv = 0;
        for (Object item$iv : $receiver$iv) {
            void quad;
            int n = index$iv++;
            Quad quad2 = (Quad)item$iv;
            int qi = n;
            Quad otherQuad = second.getQuads().get(qi);
            $receiver.add(new Quad(predicate.invoke((Integer)0) != false ? Vertex.copy$default(otherQuad.getV1(), null, null, null, null, 15, null) : Vertex.copy$default(quad.getV1(), null, null, null, null, 15, null), predicate.invoke((Integer)1) != false ? Vertex.copy$default(otherQuad.getV2(), null, null, null, null, 15, null) : Vertex.copy$default(quad.getV2(), null, null, null, null, 15, null), predicate.invoke((Integer)2) != false ? Vertex.copy$default(otherQuad.getV3(), null, null, null, null, 15, null) : Vertex.copy$default(quad.getV3(), null, null, null, null, 15, null), predicate.invoke((Integer)3) != false ? Vertex.copy$default(otherQuad.getV4(), null, null, null, null, 15, null) : Vertex.copy$default(quad.getV4(), null, null, null, null, 15, null)));
        }
    }

    static {
        Rotation[] elements$iv = new Rotation[]{Rotation.Companion.getIdentity()};
        normalLeavesRot = (Rotation[])((Object[])elements$iv);
        elements$iv = new Rotation[]{Rotation.Companion.getIdentity(), Rotation.Companion.getRot90()[ForgeDirection.EAST.ordinal()], Rotation.Companion.getRot90()[ForgeDirection.SOUTH.ordinal()]};
        denseLeavesRot = (Rotation[])((Object[])elements$iv);
        whitewash = whitewash.1.INSTANCE;
        greywash = greywash.1.INSTANCE;
        elements$iv = new Rotation[]{Rotation.Companion.getRot90()[ForgeDirection.EAST.ordinal()].times(2), Rotation.Companion.getIdentity(), Rotation.Companion.getRot90()[ForgeDirection.WEST.ordinal()], Rotation.Companion.getRot90()[ForgeDirection.EAST.ordinal()], Rotation.Companion.getRot90()[ForgeDirection.SOUTH.ordinal()], Rotation.Companion.getRot90()[ForgeDirection.NORTH.ordinal()]};
        rotationFromUp = (Rotation[])((Object[])elements$iv);
    }
}

