/*
 * Decompiled with CFR 0.152.
 */
package lumien.chunkanimator.asm;

import lumien.chunkanimator.asm.MCPNames;
import net.minecraft.launchwrapper.IClassTransformer;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public class ClassTransformer
implements IClassTransformer {
    Logger logger = LogManager.getLogger((String)"ChunkAnimatorCore");
    final String asmHandler = "lumien/chunkanimator/handler/AsmHandler";

    public ClassTransformer() {
        this.logger.log(Level.DEBUG, "Starting Class Transformation");
    }

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (transformedName.equals("net.minecraft.client.renderer.RenderList")) {
            return this.patchRenderList(basicClass);
        }
        if (transformedName.equals("net.minecraft.client.renderer.WorldRenderer")) {
            return this.patchWorldRenderer(basicClass);
        }
        return basicClass;
    }

    private byte[] patchWorldRenderer(byte[] basicClass) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(basicClass);
        classReader.accept((ClassVisitor)classNode, 0);
        this.logger.log(Level.DEBUG, "Found WorldRenderer Class: " + classNode.name);
        MethodNode setPosition = null;
        for (MethodNode mn : classNode.methods) {
            if (!mn.name.equals(MCPNames.method("func_78913_a"))) continue;
            setPosition = mn;
            break;
        }
        if (setPosition != null) {
            this.logger.log(Level.DEBUG, "- Found setPosition");
            for (int i = 0; i < setPosition.instructions.size(); ++i) {
                AbstractInsnNode ain = setPosition.instructions.get(i);
                if (ain instanceof MethodInsnNode) {
                    MethodInsnNode min = (MethodInsnNode)ain;
                    if (!min.name.equals("glEndList")) continue;
                    InsnList toInsert = new InsnList();
                    toInsert.add((AbstractInsnNode)new VarInsnNode(25, 0));
                    toInsert.add((AbstractInsnNode)new MethodInsnNode(184, "lumien/chunkanimator/handler/AsmHandler", "setPosition", "(Lnet/minecraft/client/renderer/WorldRenderer;)V", false));
                    setPosition.instructions.insertBefore(ain, toInsert);
                    this.logger.log(Level.DEBUG, "- Patched Vanilla setPosition");
                    break;
                }
                if (!(ain instanceof FieldInsnNode)) continue;
                FieldInsnNode fin = (FieldInsnNode)ain;
                if (!fin.name.equals("needsBoxUpdate")) continue;
                InsnList toInsert = new InsnList();
                toInsert.add((AbstractInsnNode)new VarInsnNode(25, 0));
                toInsert.add((AbstractInsnNode)new MethodInsnNode(184, "lumien/chunkanimator/handler/AsmHandler", "setPosition", "(Lnet/minecraft/client/renderer/WorldRenderer;)V", false));
                setPosition.instructions.insertBefore(ain, toInsert);
                this.logger.log(Level.DEBUG, "- Patched Optifine setPosition");
                break;
            }
        }
        ClassWriter writer = new ClassWriter(1);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] patchRenderList(byte[] basicClass) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(basicClass);
        classReader.accept((ClassVisitor)classNode, 0);
        this.logger.log(Level.DEBUG, "Found RenderList Class: " + classNode.name);
        MethodNode callLists = null;
        for (MethodNode mn : classNode.methods) {
            if (!mn.name.equals(MCPNames.method("func_78419_a"))) continue;
            callLists = mn;
        }
        if (callLists != null) {
            this.logger.log(Level.DEBUG, "- Found callLists");
            for (int i = 0; i < callLists.instructions.size(); ++i) {
                AbstractInsnNode ain = callLists.instructions.get(i);
                if (!(ain instanceof MethodInsnNode)) continue;
                MethodInsnNode min = (MethodInsnNode)ain;
                if (!min.name.equals("glCallLists")) continue;
                this.logger.log(Level.DEBUG, "- Patched callLists");
                InsnList toInsert = new InsnList();
                toInsert.add((AbstractInsnNode)new MethodInsnNode(184, "lumien/chunkanimator/handler/AsmHandler", "callLists", "(Ljava/nio/IntBuffer;)V", false));
                callLists.instructions.insert((AbstractInsnNode)min, toInsert);
                callLists.instructions.remove((AbstractInsnNode)min);
                break;
            }
        }
        ClassWriter writer = new ClassWriter(1);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    private byte[] patchDummyClass(byte[] basicClass) {
        ClassNode classNode = new ClassNode();
        ClassReader classReader = new ClassReader(basicClass);
        classReader.accept((ClassVisitor)classNode, 0);
        this.logger.log(Level.DEBUG, "Found Dummy Class: " + classNode.name);
        ClassWriter writer = new ClassWriter(1);
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }
}

