/*
 * Decompiled with CFR 0.152.
 */
package lumien.chunkanimator.handler;

import java.lang.reflect.Field;
import java.nio.IntBuffer;
import java.util.HashMap;
import lumien.chunkanimator.ChunkAnimator;
import lumien.chunkanimator.asm.MCPNames;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.WorldRenderer;
import org.lwjgl.opengl.GL11;

public class AnimationHandler {
    static Field glRenderList;
    HashMap<Integer, RendererInfo> timeStamps = new HashMap();

    public void callLists(IntBuffer glLists) {
        while (glLists.hasRemaining()) {
            int renderListID = glLists.get();
            double modY = 0.0;
            if (this.timeStamps.containsKey(renderListID)) {
                int animationDuration;
                long timeDif;
                RendererInfo renderInfo = this.timeStamps.get(renderListID);
                long time = renderInfo.timeStamp;
                if (time == -1L) {
                    time = renderInfo.timeStamp = System.currentTimeMillis();
                }
                if ((timeDif = System.currentTimeMillis() - time) < (long)(animationDuration = ChunkAnimator.INSTANCE.config.getAnimationDuration())) {
                    double chunkY = renderInfo.posY;
                    int mode = ChunkAnimator.INSTANCE.config.getMode();
                    if (mode == 2) {
                        mode = chunkY < Minecraft.func_71410_x().field_71441_e.field_73011_w.getHorizon() ? 0 : 1;
                    }
                    switch (mode) {
                        case 0: {
                            modY = -chunkY + chunkY / (double)animationDuration * (double)timeDif;
                            break;
                        }
                        case 1: {
                            modY = 256.0 - chunkY - (256.0 - chunkY) / (double)animationDuration * (double)timeDif;
                        }
                    }
                } else {
                    this.timeStamps.remove(renderListID);
                }
            }
            if (modY != 0.0) {
                GL11.glTranslated((double)0.0, (double)modY, (double)0.0);
            }
            GL11.glCallList((int)renderListID);
            if (modY == 0.0) continue;
            GL11.glTranslated((double)0.0, (double)(-modY), (double)0.0);
        }
    }

    public void setPosition(WorldRenderer worldRenderer) {
        int renderID = -1;
        try {
            renderID = glRenderList.getInt(worldRenderer);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.timeStamps.put(renderID, new RendererInfo(worldRenderer.field_78920_d, -1L));
        this.timeStamps.put(renderID + 1, new RendererInfo(worldRenderer.field_78920_d, -1L));
    }

    static {
        try {
            glRenderList = WorldRenderer.class.getDeclaredField(MCPNames.field("field_78942_y"));
            glRenderList.setAccessible(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private class RendererInfo {
        public int posY;
        public long timeStamp;

        public RendererInfo(int posY, long timeStamp) {
            this.posY = posY;
            this.timeStamp = timeStamp;
        }
    }
}

