/*
 * Decompiled with CFR 0.152.
 */
package cofh.repack.cofh.lib.util;

import com.google.common.base.Objects;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class LinkedHashList<E>
extends AbstractCollection<E>
implements List<E>,
Cloneable,
Serializable {
    private static final long serialVersionUID = -642033533165934945L;
    protected transient Entry head;
    protected transient Entry tail;
    protected transient int size;
    protected transient int mask;
    protected transient Entry[] hashTable;
    protected transient int modCount;

    protected static int roundUpToPowerOf2(int n) {
        return n >= 0x40000000 ? 0x40000000 : (n > 2 ? Integer.highestOneBit(n - 1 << 1) : 2);
    }

    public LinkedHashList() {
        this.hashTable = new Entry[8];
        this.mask = 7;
    }

    public LinkedHashList(int n) {
        n = LinkedHashList.roundUpToPowerOf2(n);
        this.hashTable = new Entry[n];
        this.mask = n - 1;
    }

    public LinkedHashList(Collection<E> collection) {
        int n = LinkedHashList.roundUpToPowerOf2(collection.size());
        this.hashTable = new Entry[n];
        this.mask = n - 1;
        this.addAll(collection);
    }

    protected int hash(Object object) {
        int n = object == null ? 0 : object.hashCode();
        n ^= n >>> 20 ^ n >>> 12;
        return n ^ n >>> 7 ^ n >>> 4;
    }

    @Override
    public int size() {
        return this.size;
    }

    protected boolean add(E e, int n) {
        if (this.seek(e, n) != null) {
            return false;
        }
        ++this.modCount;
        Entry entry = new Entry(e, n);
        this.insert(entry);
        this.rehashIfNecessary();
        entry.prev = this.tail;
        entry.next = null;
        if (this.tail != null) {
            this.tail.next = entry;
        } else {
            this.head = entry;
        }
        this.tail = entry;
        return true;
    }

    @Override
    public boolean add(E e) {
        int n = this.hash(e);
        return this.add(e, n);
    }

    @Override
    public E set(int n, E e) {
        this.checkElementIndex(n);
        int n2 = this.hash(e);
        if (this.seek(e, n2) != null) {
            throw new IllegalArgumentException("Duplicate entries not allowed");
        }
        ++this.modCount;
        Entry entry = this.index(n);
        this.delete(entry);
        this.insert(new Entry(e, n2));
        return (E)entry.key;
    }

    @Override
    public void add(int n, E e) {
        this.checkPositionIndex(n);
        int n2 = this.hash(e);
        if (this.seek(e, n2) != null) {
            throw new IllegalArgumentException("Duplicate entries not allowed");
        }
        if (n == this.size) {
            this.add(e, n2);
            return;
        }
        ++this.modCount;
        Entry entry = this.index(n);
        Entry entry2 = new Entry(e, n2);
        entry2.next = entry.next;
        entry2.prev = entry;
        entry.next = entry2;
        if (entry2.next != null) {
            entry2.next.prev = entry2;
        }
        this.insert(entry2);
        this.rehashIfNecessary();
    }

    @Override
    public boolean addAll(int n, Collection<? extends E> collection) {
        if (collection.size() == 0) {
            return false;
        }
        for (E e : collection) {
            this.add(n++, e);
        }
        return true;
    }

    @Override
    public E get(int n) {
        this.checkElementIndex(n);
        return (E)this.index((int)n).key;
    }

    @Override
    public int indexOf(Object object) {
        Entry entry = this.seek(object, this.hash(object));
        if (entry == null) {
            return -1;
        }
        Entry entry2 = this.head;
        int n = 0;
        while (entry2 != this.tail) {
            if (entry == entry2) {
                return n;
            }
            entry2 = entry2.next;
            ++n;
        }
        return this.size;
    }

    @Override
    public int lastIndexOf(Object object) {
        return this.indexOf(object);
    }

    public boolean push(E e) {
        int n = this.hash(e);
        return this.add(e, n);
    }

    public E pop() {
        Entry entry = this.tail;
        if (entry != null) {
            this.unlink(entry);
            return (E)entry.key;
        }
        return null;
    }

    public E peek() {
        return (E)(this.tail != null ? this.tail.key : null);
    }

    public E poke() {
        return (E)(this.head != null ? this.head.key : null);
    }

    public boolean unshift(E e) {
        int n = this.hash(e);
        if (this.seek(e, n) != null) {
            return false;
        }
        ++this.modCount;
        Entry entry = new Entry(e, n);
        this.insert(entry);
        this.rehashIfNecessary();
        entry.next = this.head;
        entry.prev = null;
        if (this.head != null) {
            this.head.prev = entry;
        } else {
            this.tail = entry;
        }
        this.head = entry;
        return true;
    }

    public E shift() {
        Entry entry = this.head;
        if (entry != null) {
            this.unlink(entry);
            return (E)entry.key;
        }
        return null;
    }

    @Override
    public boolean contains(Object object) {
        return this.seek(object, this.hash(object)) != null;
    }

    @Override
    public boolean remove(Object object) {
        Entry entry = this.seek(object, this.hash(object));
        if (entry == null) {
            return false;
        }
        this.unlink(entry);
        return true;
    }

    @Override
    public E remove(int n) {
        this.checkElementIndex(n);
        Entry entry = this.index(n);
        this.unlink(entry);
        return (E)entry.key;
    }

    protected Entry index(int n) {
        Entry entry;
        if (n < this.size >> 1) {
            entry = this.head;
            int n2 = n;
            while (n2-- > 0) {
                entry = entry.next;
            }
        } else {
            entry = this.tail;
            int n3 = this.size - 1;
            while (n3-- > n) {
                entry = entry.prev;
            }
        }
        return entry;
    }

    protected Entry seek(Object object, int n) {
        Entry entry = this.hashTable[n & this.mask];
        while (entry != null) {
            if (n == entry.hash && Objects.equal((Object)object, (Object)entry.key)) {
                return entry;
            }
            entry = entry.nextInBucket;
        }
        return null;
    }

    protected void insert(Entry entry) {
        int n = entry.hash & this.mask;
        entry.nextInBucket = this.hashTable[n];
        this.hashTable[n] = entry;
        ++this.size;
    }

    protected boolean linkBefore(E e, Entry entry) {
        int n = this.hash(e);
        if (this.seek(e, n) != null) {
            return false;
        }
        Entry entry2 = entry.prev;
        Entry entry3 = new Entry(e, n);
        ++this.modCount;
        this.insert(entry3);
        this.rehashIfNecessary();
        entry3.next = entry;
        entry3.prev = entry2;
        entry.prev = entry3;
        if (entry2 == null) {
            this.head = entry3;
        } else {
            entry2.next = entry3;
        }
        return true;
    }

    protected void delete(Entry entry) {
        int n = entry.hash & this.mask;
        Entry entry2 = null;
        Entry entry3 = this.hashTable[n];
        if (entry3 == entry) {
            this.hashTable[n] = entry3.nextInBucket;
        } else {
            while (true) {
                if (entry3 == entry) {
                    entry2.nextInBucket = entry.nextInBucket;
                    break;
                }
                entry2 = entry3;
                entry3 = entry3.nextInBucket;
            }
        }
        --this.size;
    }

    protected E unlink(Entry entry) {
        Object object = entry.key;
        Entry entry2 = entry.next;
        Entry entry3 = entry.prev;
        if (entry3 == null) {
            this.head = entry2;
        } else {
            entry3.next = entry2;
            entry.prev = null;
        }
        if (entry2 == null) {
            this.tail = entry3;
        } else {
            entry2.prev = entry3;
            entry.next = null;
        }
        this.delete(entry);
        ++this.modCount;
        return (E)object;
    }

    protected void rehashIfNecessary() {
        Entry[] entryArray = this.hashTable;
        if (this.size > entryArray.length * 2 && entryArray.length < 0x40000000) {
            int n = entryArray.length * 2;
            int n2 = n - 1;
            Entry[] entryArray2 = new Entry[n];
            int n3 = entryArray.length;
            while (n3-- > 0) {
                Entry entry = entryArray[n3];
                while (entry != null) {
                    Entry entry2 = entry.nextInBucket;
                    int n4 = entry.hash & n2;
                    entry.nextInBucket = entryArray2[n4];
                    entryArray2[n4] = entry;
                    entry = entry2;
                }
            }
            this.hashTable = entryArray2;
            this.mask = n2;
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        int n = this.modCount;
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.size);
        Entry entry = this.head;
        for (int i = 0; i < this.size; ++i) {
            objectOutputStream.writeObject(entry.key);
            entry = entry.next;
        }
        if (this.modCount != n) {
            throw new ConcurrentModificationException();
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        this.tail = null;
        this.head = null;
        this.hashTable = new Entry[8];
        this.mask = 7;
        this.size = 0;
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                this.add(objectInputStream.readObject());
            }
        }
    }

    public LinkedHashList<E> clone() {
        return new LinkedHashList<E>(this);
    }

    @Override
    public List<E> subList(int n, int n2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<E> iterator() {
        return this.listIterator();
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<E> listIterator(int n) {
        this.checkPositionIndex(n);
        return new ListItr(n);
    }

    public Iterator<E> descendingIterator() {
        return new DescendingIterator();
    }

    protected boolean isElementIndex(int n) {
        return n >= 0 && n < this.size;
    }

    protected boolean isPositionIndex(int n) {
        return n >= 0 && n <= this.size;
    }

    protected String outOfBoundsMsg(int n) {
        return "Index: " + n + ", Size: " + this.size;
    }

    protected void checkElementIndex(int n) {
        if (!this.isElementIndex(n)) {
            throw new IndexOutOfBoundsException(this.outOfBoundsMsg(n));
        }
    }

    protected void checkPositionIndex(int n) {
        if (!this.isPositionIndex(n)) {
            throw new IndexOutOfBoundsException(this.outOfBoundsMsg(n));
        }
    }

    protected class DescendingIterator
    implements Iterator<E> {
        protected final ListItr itr;

        protected DescendingIterator() {
            this.itr = new ListItr(LinkedHashList.this.size());
        }

        @Override
        public boolean hasNext() {
            return this.itr.hasPrevious();
        }

        @Override
        public E next() {
            return this.itr.previous();
        }

        @Override
        public void remove() {
            this.itr.remove();
        }
    }

    protected class ListItr
    implements ListIterator<E> {
        protected Entry lastReturned = null;
        protected Entry next;
        protected int nextIndex;
        protected int expectedModCount;

        protected ListItr(int n) {
            this.expectedModCount = LinkedHashList.this.modCount;
            this.next = n == LinkedHashList.this.size ? null : LinkedHashList.this.index(n);
            this.nextIndex = n;
        }

        @Override
        public boolean hasNext() {
            return this.nextIndex < LinkedHashList.this.size;
        }

        @Override
        public E next() {
            this.checkForComodification();
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.next;
            this.next = this.next.next;
            ++this.nextIndex;
            return this.lastReturned.key;
        }

        @Override
        public boolean hasPrevious() {
            return this.nextIndex > 0;
        }

        @Override
        public E previous() {
            this.checkForComodification();
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            this.next = this.next == null ? LinkedHashList.this.tail : this.next.prev;
            this.lastReturned = this.next;
            --this.nextIndex;
            return this.lastReturned.key;
        }

        @Override
        public int nextIndex() {
            return this.nextIndex;
        }

        @Override
        public int previousIndex() {
            return this.nextIndex - 1;
        }

        @Override
        public void remove() {
            this.checkForComodification();
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            Entry entry = this.lastReturned.next;
            LinkedHashList.this.unlink(this.lastReturned);
            if (this.next == this.lastReturned) {
                this.next = entry;
            } else {
                --this.nextIndex;
            }
            this.lastReturned = null;
            ++this.expectedModCount;
        }

        @Override
        public void set(E e) {
            this.checkForComodification();
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            LinkedHashList.this.linkBefore(e, this.lastReturned);
            LinkedHashList.this.unlink(this.lastReturned);
            this.lastReturned = this.next == null ? LinkedHashList.this.tail : this.next.prev;
            this.expectedModCount += 2;
        }

        @Override
        public void add(E e) {
            this.checkForComodification();
            this.lastReturned = null;
            if (this.next == null) {
                LinkedHashList.this.push(e);
            } else {
                LinkedHashList.this.linkBefore(e, this.next);
            }
            ++this.nextIndex;
            ++this.expectedModCount;
        }

        protected final void checkForComodification() {
            if (LinkedHashList.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }

    protected static final class Entry {
        protected Entry next;
        protected Entry prev;
        protected final Object key;
        protected final int hash;
        protected Entry nextInBucket;

        protected Entry(Object object, int n) {
            this.key = object;
            this.hash = n;
        }
    }
}

