/*
 * Decompiled with CFR 0.152.
 */
package cofh.repack.net.minecraft.client.renderer.chunk;

import cofh.repack.com.sun.org.apache.xml.internal.utils.IntStack;
import cofh.repack.net.minecraft.client.renderer.chunk.SetVisibility;
import java.util.BitSet;
import java.util.EnumSet;
import java.util.Set;
import net.minecraft.util.EnumFacing;

public class VisGraph {
    private static final int X_OFFSET = (int)Math.pow(16.0, 0.0);
    private static final int Z_OFFSET = (int)Math.pow(16.0, 1.0);
    private static final int Y_OFFSET = (int)Math.pow(16.0, 2.0);
    private static final int[] EDGES = new int[1352];
    private static final SetVisibility ALL_VIS = new SetVisibility();
    private final BitSet opaqueBlocks = new BitSet(4096);
    private final BitSet visibleBlocks = new BitSet(4096);
    private short transparentBlocks = (short)4096;
    private boolean dirty = true;
    private boolean computedVis = true;
    private SetVisibility visibility;

    private static int getIndex(int n, int n2, int n3) {
        return n << 0 | n2 << 8 | n3 << 4;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public boolean isRenderDirty() {
        if (this.isDirty()) {
            return true;
        }
        boolean bl = this.computedVis;
        this.computedVis = false;
        return bl;
    }

    public void setOpaque(int n, int n2, int n3, boolean bl) {
        boolean bl2 = this.opaqueBlocks.get(VisGraph.getIndex(n, n2, n3));
        if (bl2 != bl) {
            this.opaqueBlocks.set(VisGraph.getIndex(n, n2, n3), bl);
            this.transparentBlocks = (short)(this.transparentBlocks + (bl ? -1 : 1));
            this.dirty = true;
        }
    }

    public SetVisibility getVisibility() {
        SetVisibility setVisibility = this.visibility;
        if (setVisibility != null) {
            return setVisibility;
        }
        return ALL_VIS;
    }

    public void computeVisibility() {
        this.dirty = false;
        SetVisibility setVisibility = new SetVisibility();
        if (4096 - this.transparentBlocks < 256) {
            setVisibility.setAllVisible(true);
        } else if (this.transparentBlocks == 0) {
            setVisibility.setAllVisible(false);
        } else {
            int[] nArray = EDGES;
            int n = nArray.length;
            this.visibleBlocks.andNot(this.visibleBlocks);
            this.visibleBlocks.or(this.opaqueBlocks);
            IntStack intStack = new IntStack(1024, 512);
            for (int i = 0; i < n; ++i) {
                int n2 = nArray[i];
                if (!this.opaqueBlocks.get(n2)) {
                    setVisibility.setManyVisible(this.computeVisibleFacingsFrom(n2, intStack));
                }
                intStack.setSize(0);
            }
        }
        this.visibility = setVisibility;
        this.computedVis = true;
    }

    public Set<EnumFacing> getVisibleFacingsFrom(int n, int n2, int n3) {
        this.visibleBlocks.andNot(this.visibleBlocks);
        this.visibleBlocks.or(this.opaqueBlocks);
        return this.computeVisibleFacingsFrom(VisGraph.getIndex(n & 0xF, n2 & 0xF, n3 & 0xF), new IntStack(256, 512));
    }

    private EnumSet<EnumFacing> computeVisibleFacingsFrom(int n, IntStack intStack) {
        EnumSet<EnumFacing> enumSet = EnumSet.noneOf(EnumFacing.class);
        intStack.add(n);
        BitSet bitSet = this.visibleBlocks;
        bitSet.set(n, true);
        EnumFacing[] enumFacingArray = EnumFacing.values();
        int n2 = enumFacingArray.length;
        while (!intStack.isEmpty()) {
            int n3 = intStack.poll();
            this.addSides(n3, enumSet);
            for (int i = 0; i < n2; ++i) {
                EnumFacing enumFacing = enumFacingArray[i];
                int n4 = this.stepTo(n3, enumFacing);
                if (n4 < 0 || bitSet.get(n4)) continue;
                bitSet.set(n4, true);
                intStack.add(n4);
            }
        }
        return enumSet;
    }

    private void addSides(int n, Set<EnumFacing> set) {
        int n2 = n >> 0 & 0xF;
        if (n2 == 0) {
            set.add(EnumFacing.WEST);
        } else if (n2 == 15) {
            set.add(EnumFacing.EAST);
        }
        int n3 = n >> 8 & 0xF;
        if (n3 == 0) {
            set.add(EnumFacing.DOWN);
        } else if (n3 == 15) {
            set.add(EnumFacing.UP);
        }
        int n4 = n >> 4 & 0xF;
        if (n4 == 0) {
            set.add(EnumFacing.NORTH);
        } else if (n4 == 15) {
            set.add(EnumFacing.SOUTH);
        }
    }

    private int stepTo(int n, EnumFacing enumFacing) {
        switch (enumFacing) {
            case DOWN: {
                if ((n >> 8 & 0xF) == 0) {
                    return -1;
                }
                return n - Y_OFFSET;
            }
            case UP: {
                if ((n >> 8 & 0xF) == 15) {
                    return -1;
                }
                return n + Y_OFFSET;
            }
            case NORTH: {
                if ((n >> 4 & 0xF) == 0) {
                    return -1;
                }
                return n - Z_OFFSET;
            }
            case SOUTH: {
                if ((n >> 4 & 0xF) == 15) {
                    return -1;
                }
                return n + Z_OFFSET;
            }
            case WEST: {
                if ((n >> 0 & 0xF) == 0) {
                    return -1;
                }
                return n - X_OFFSET;
            }
            case EAST: {
                if ((n >> 0 & 0xF) == 15) {
                    return -1;
                }
                return n + X_OFFSET;
            }
        }
        return -1;
    }

    static {
        ALL_VIS.setAllVisible(true);
        int n = 0;
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                for (int k = 0; k < 16; ++k) {
                    if (i != 0 && i != 15 && j != 0 && j != 15 && k != 0 && k != 15) continue;
                    VisGraph.EDGES[n++] = VisGraph.getIndex(i, j, k);
                }
            }
        }
    }
}

