/*
 * Decompiled with CFR 0.152.
 */
package cofh.repack.tweak.codechicken.lib.config;

import cofh.repack.tweak.codechicken.lib.config.ConfigTagParent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;

public class ConfigFile
extends ConfigTagParent {
    public static final byte[] crlf = new byte[]{13, 10};
    public File file;
    private boolean loading;

    public ConfigFile(File file) {
        this.newlinemode = 2;
        this.load(file);
    }

    protected ConfigFile() {
    }

    protected void load(File file) {
        try {
            if (!file.getParentFile().exists()) {
                file.getParentFile().mkdirs();
            }
            if (!file.exists()) {
                file.createNewFile();
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        this.file = file;
        this.loadConfig();
    }

    protected void loadConfig() {
        this.loading = true;
        BufferedReader bufferedReader = null;
        try {
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.file), "utf8"));
            while (true) {
                bufferedReader.mark(2000);
                String string = bufferedReader.readLine();
                if (string == null || !string.startsWith("#")) break;
                if (this.comment == null || this.comment.equals("")) {
                    this.comment = string.substring(1);
                    continue;
                }
                this.comment = this.comment + "\n" + string.substring(1);
            }
            bufferedReader.reset();
            this.loadChildren(bufferedReader);
            bufferedReader.close();
        }
        catch (IOException iOException) {
            IOException iOException2;
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException3) {
                    iOException2 = iOException3;
                }
            }
            throw new RuntimeException(iOException2);
        }
        this.loading = false;
    }

    @Override
    public ConfigFile setComment(String string) {
        super.setComment(string);
        return this;
    }

    @Override
    public ConfigFile setSortMode(int n) {
        super.setSortMode(n);
        return this;
    }

    @Override
    public String getNameQualifier() {
        return "";
    }

    public static String readLine(BufferedReader bufferedReader) throws IOException {
        String string = bufferedReader.readLine();
        return string == null ? null : string.replace("\t", "");
    }

    public static void writeLine(PrintWriter printWriter, String string, int n) {
        for (int i = 0; i < n; ++i) {
            printWriter.print('\t');
        }
        printWriter.println(string);
    }

    @Override
    public void saveConfig() {
        PrintWriter printWriter;
        if (this.loading) {
            return;
        }
        try {
            printWriter = new PrintWriter(this.file, "utf8");
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        this.writeComment(printWriter, 0);
        ConfigFile.writeLine(printWriter, "", 0);
        this.saveTagTree(printWriter, 0, "");
        printWriter.flush();
        printWriter.close();
    }

    public boolean isLoading() {
        return this.loading;
    }
}

