/*
 * Decompiled with CFR 0.152.
 */
package cofh.tweak.asm;

import cofh.tweak.asm.LoadingPlugin;
import cofh.tweak.asmhooks.Config;
import cpw.mods.fml.relauncher.FMLLaunchHandler;
import cpw.mods.fml.relauncher.Side;
import gnu.trove.map.hash.TObjectByteHashMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FrameNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.IntInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

class ASMCore {
    static Logger log = LogManager.getLogger((String)"CoFHTweak ASM");
    static TObjectByteHashMap<String> hashes = new TObjectByteHashMap(30, 1.0f, 0);
    private static String HooksCore = "cofh/tweak/asmhooks/HooksCore";
    private static String ConfigCore = "cofh/tweak/asmhooks/Config";

    ASMCore() {
    }

    static void init() {
    }

    static byte[] transform(int n, String string, String string2, byte[] byArray) {
        ClassReader classReader = new ClassReader(byArray);
        switch (n) {
            case 1: {
                return ASMCore.alterLongHashMap(string2, byArray, classReader);
            }
            case 2: {
                return ASMCore.alterChunk(string2, byArray, classReader);
            }
            case 3: {
                return ASMCore.alterMinecraft(string2, byArray, classReader);
            }
            case 4: {
                return ASMCore.alterEntity(string2, byArray, classReader);
            }
            case 5: {
                return ASMCore.alterHooksCore(string2, byArray, classReader);
            }
            case 6: {
                return ASMCore.alterEntityItem(string2, byArray, classReader);
            }
            case 7: {
                return ASMCore.alterWorld(string2, byArray, classReader);
            }
            case 8: {
                return ASMCore.alterEntityLiving(string2, byArray, classReader);
            }
            case 9: {
                return ASMCore.alterWorldClient(string2, byArray, classReader);
            }
            case 10: {
                return ASMCore.alterCPC(string2, byArray, classReader);
            }
            case 11: {
                return ASMCore.alterbranding(string2, byArray, classReader);
            }
            case 12: {
                return ASMCore.alterSquid(string2, byArray, classReader);
            }
            case 13: {
                return ASMCore.alterWaterMob(string2, byArray, classReader);
            }
            case 14: {
                return ASMCore.alterFollowParent(string2, byArray, classReader);
            }
            case 15: {
                return ASMCore.fixNetHandlerPlayServer(string2, byArray, classReader);
            }
        }
        return byArray;
    }

    private static byte[] fixNetHandlerPlayServer(String string, byte[] byArray, ClassReader classReader) {
        String[] stringArray = LoadingPlugin.runtimeDeobfEnabled ? new String[]{"func_147233_a", "func_76319_b", "func_76320_a"} : new String[]{"onNetworkTick", "endSection", "startSection"};
        ClassNode classNode = new ClassNode(327680);
        classReader.accept((ClassVisitor)classNode, 0);
        block0: for (MethodNode methodNode : classNode.methods) {
            if (!stringArray[0].equals(methodNode.name)) continue;
            InsnList insnList = new InsnList();
            int n = methodNode.instructions.size();
            for (int i = 0; i < n; ++i) {
                AbstractInsnNode abstractInsnNode = methodNode.instructions.get(i);
                if (abstractInsnNode.getOpcode() != 182) continue;
                MethodInsnNode methodInsnNode = (MethodInsnNode)abstractInsnNode;
                if (!"net/minecraft/profiler/Profiler".equals(methodInsnNode.owner)) continue;
                if (stringArray[1].equals(methodInsnNode.name)) break block0;
                if (!stringArray[2].equals(methodInsnNode.name) || insnList.size() != 0) continue;
                abstractInsnNode = abstractInsnNode.getPrevious().getPrevious();
                while (abstractInsnNode.getOpcode() != 25) {
                    insnList.insert(abstractInsnNode.clone(null));
                    abstractInsnNode = abstractInsnNode.getPrevious();
                }
                insnList.insert(abstractInsnNode.clone(null));
            }
            if (insnList.size() == 0) break;
            insnList.add((AbstractInsnNode)new MethodInsnNode(182, "net/minecraft/profiler/Profiler", stringArray[1], "()V", false));
            for (AbstractInsnNode abstractInsnNode = methodNode.instructions.getFirst(); abstractInsnNode != null; abstractInsnNode = abstractInsnNode.getNext()) {
                if (abstractInsnNode.getOpcode() != 177) continue;
                for (AbstractInsnNode abstractInsnNode2 = insnList.getFirst(); abstractInsnNode2 != null; abstractInsnNode2 = abstractInsnNode2.getNext()) {
                    methodNode.instructions.insertBefore(abstractInsnNode, abstractInsnNode2.clone(null));
                }
            }
        }
        ClassWriter classWriter = new ClassWriter(1);
        classNode.accept((ClassVisitor)classWriter);
        byArray = classWriter.toByteArray();
        return byArray;
    }

    private static byte[] alterWorld(String string, byte[] byArray, ClassReader classReader) {
        Object object;
        String[] stringArray = LoadingPlugin.runtimeDeobfEnabled ? new String[]{"func_72945_a", "func_72903_x", "func_147451_t", "func_98179_a", "func_147463_c"} : new String[]{"getCollidingBoundingBoxes", "setActivePlayerChunksAndCheckLight", "func_147451_t", "computeLightValue", "updateLightByType"};
        ClassNode classNode = new ClassNode(327680);
        classReader.accept((ClassVisitor)classNode, 0);
        MethodNode methodNode = null;
        MethodNode methodNode2 = null;
        MethodNode methodNode3 = null;
        MethodNode methodNode4 = null;
        int n = 0;
        int n2 = 4;
        for (MethodNode methodNode5 : classNode.methods) {
            if (stringArray[0].equals(methodNode5.name)) {
                methodNode = methodNode5;
                if (++n != n2) continue;
                break;
            }
            if (stringArray[1].equals(methodNode5.name)) {
                methodNode2 = methodNode5;
                if (++n != n2) continue;
                break;
            }
            if (stringArray[3].equals(methodNode5.name)) {
                methodNode3 = methodNode5;
                if (++n != n2) continue;
                break;
            }
            if (!stringArray[4].equals(methodNode5.name)) continue;
            methodNode4 = methodNode5;
            if (++n != n2) continue;
            break;
        }
        if (methodNode4 != null) {
            methodNode4.localVariables = null;
            methodNode4.instructions.clear();
            methodNode4.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            methodNode4.instructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
            methodNode4.instructions.add((AbstractInsnNode)new VarInsnNode(21, 2));
            methodNode4.instructions.add((AbstractInsnNode)new VarInsnNode(21, 3));
            methodNode4.instructions.add((AbstractInsnNode)new VarInsnNode(21, 4));
            object = "(Lnet/minecraft/world/World;Lnet/minecraft/world/EnumSkyBlock;III)Z";
            methodNode4.instructions.add((AbstractInsnNode)new MethodInsnNode(184, HooksCore, "updateLightByType", (String)object, false));
            methodNode4.instructions.add((AbstractInsnNode)new InsnNode(172));
        }
        if (methodNode3 != null) {
            methodNode3.localVariables = null;
            methodNode3.instructions.clear();
            methodNode3.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            methodNode3.instructions.add((AbstractInsnNode)new VarInsnNode(21, 1));
            methodNode3.instructions.add((AbstractInsnNode)new VarInsnNode(21, 2));
            methodNode3.instructions.add((AbstractInsnNode)new VarInsnNode(21, 3));
            methodNode3.instructions.add((AbstractInsnNode)new VarInsnNode(25, 4));
            object = "(Lnet/minecraft/world/World;IIILnet/minecraft/world/EnumSkyBlock;)I";
            methodNode3.instructions.add((AbstractInsnNode)new MethodInsnNode(184, HooksCore, "computeLightValue", (String)object, false));
            methodNode3.instructions.add((AbstractInsnNode)new InsnNode(172));
        }
        if (methodNode != null) {
            methodNode.localVariables = null;
            methodNode.instructions.clear();
            methodNode.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            methodNode.instructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
            methodNode.instructions.add((AbstractInsnNode)new VarInsnNode(25, 2));
            object = "(Lnet/minecraft/world/World;Lnet/minecraft/entity/Entity;Lnet/minecraft/util/AxisAlignedBB;)Ljava/util/List;";
            methodNode.instructions.add((AbstractInsnNode)new MethodInsnNode(184, HooksCore, "getWorldCollisionBoxes", (String)object, false));
            methodNode.instructions.add((AbstractInsnNode)new InsnNode(176));
        }
        if (methodNode2 != null) {
            boolean bl = false;
            for (MethodNode methodNode5 = methodNode2.instructions.getLast(); methodNode5 != null; methodNode5 = methodNode5.getPrevious()) {
                if (bl && methodNode5.getOpcode() == 185 && "isEmpty".equals(((MethodInsnNode)methodNode5).name)) {
                    methodNode2.instructions.insert((AbstractInsnNode)methodNode5, (AbstractInsnNode)new InsnNode(128));
                    methodNode2.instructions.insert((AbstractInsnNode)methodNode5, (AbstractInsnNode)new InsnNode(130));
                    methodNode2.instructions.insert((AbstractInsnNode)methodNode5, (AbstractInsnNode)new InsnNode(4));
                    methodNode2.instructions.insert((AbstractInsnNode)methodNode5, (AbstractInsnNode)new FieldInsnNode(178, ConfigCore, "lightChunks", "Z"));
                    break;
                }
                if (methodNode5.getOpcode() != 182 || !stringArray[2].equals(((MethodInsnNode)methodNode5).name)) continue;
                bl = true;
            }
        }
        ClassWriter classWriter = new ClassWriter(1);
        classNode.accept((ClassVisitor)classWriter);
        byArray = classWriter.toByteArray();
        return byArray;
    }

    private static byte[] alterHooksCore(String string, byte[] byArray, ClassReader classReader) {
        String[] stringArray = LoadingPlugin.runtimeDeobfEnabled ? new String[]{"func_70104_M"} : new String[]{"canBePushed"};
        ClassNode classNode = new ClassNode(327680);
        classReader.accept((ClassVisitor)classNode, 0);
        for (MethodNode methodNode : classNode.methods) {
            int n = methodNode.instructions.size();
            for (int i = 0; i < n; ++i) {
                AbstractInsnNode abstractInsnNode = methodNode.instructions.get(i);
                if (abstractInsnNode.getOpcode() != 182) continue;
                MethodInsnNode methodInsnNode = (MethodInsnNode)abstractInsnNode;
                if (!stringArray[0].equals(methodInsnNode.name)) continue;
                methodInsnNode.name = "cofh_collideCheck";
            }
        }
        ClassWriter classWriter = new ClassWriter(1);
        classNode.accept((ClassVisitor)classWriter);
        byArray = classWriter.toByteArray();
        return byArray;
    }

    private static byte[] alterbranding(String string, byte[] byArray, ClassReader classReader) {
        String string2 = "computeBranding";
        ClassNode classNode = new ClassNode(327680);
        classReader.accept((ClassVisitor)classNode, 0);
        block0: for (MethodNode methodNode : classNode.methods) {
            if (!string2.equals(methodNode.name)) continue;
            int n = methodNode.instructions.size();
            for (int i = 0; i < n; ++i) {
                AbstractInsnNode abstractInsnNode = methodNode.instructions.get(i);
                if (abstractInsnNode.getType() != 5) continue;
                MethodInsnNode methodInsnNode = (MethodInsnNode)abstractInsnNode;
                if (!"callForgeMethod".equals(methodInsnNode.name) || !"cpw/mods/fml/common/FMLCommonHandler".equals(methodInsnNode.owner) || !"(Ljava/lang/String;)Ljava/lang/Object;".equals(methodInsnNode.desc)) continue;
                methodInsnNode = new MethodInsnNode(184, HooksCore, "getBrand", "()Ljava/lang/String;", false);
                methodNode.instructions.insert(abstractInsnNode.getNext().getNext(), (AbstractInsnNode)methodInsnNode);
                abstractInsnNode = methodInsnNode;
                methodNode.instructions.insertBefore(abstractInsnNode, (AbstractInsnNode)new VarInsnNode(25, 1));
                methodInsnNode = new MethodInsnNode(182, null, "add", null, false);
                methodInsnNode.owner = "com/google/common/collect/ImmutableList$Builder";
                methodInsnNode.desc = "(Ljava/lang/Object;)Lcom/google/common/collect/ImmutableList$Builder;";
                methodNode.instructions.insert(abstractInsnNode, (AbstractInsnNode)methodInsnNode);
                methodNode.instructions.insert((AbstractInsnNode)methodInsnNode, (AbstractInsnNode)new InsnNode(87));
                break block0;
            }
        }
        ClassWriter classWriter = new ClassWriter(1);
        classNode.accept((ClassVisitor)classWriter);
        byArray = classWriter.toByteArray();
        return byArray;
    }

    private static byte[] alterCPC(String string, byte[] byArray, ClassReader classReader) {
        String[] stringArray = LoadingPlugin.runtimeDeobfEnabled ? new String[]{"func_73158_c"} : new String[]{"loadChunk"};
        ClassNode classNode = new ClassNode(327680);
        classReader.accept((ClassVisitor)classNode, 0);
        MethodNode methodNode = null;
        for (MethodNode methodNode2 : classNode.methods) {
            if (!stringArray[0].equals(methodNode2.name)) continue;
            methodNode = methodNode2;
            break;
        }
        if (methodNode != null) {
            AbstractInsnNode abstractInsnNode = methodNode.instructions.getFirst();
            while (abstractInsnNode != null) {
                if (abstractInsnNode.getOpcode() == 187 && "net/minecraft/world/chunk/Chunk".equals(((TypeInsnNode)abstractInsnNode).desc)) {
                    ((TypeInsnNode)abstractInsnNode).desc = "cofh/tweak/asmhooks/world/ClientChunk";
                    while (abstractInsnNode != null) {
                        if (abstractInsnNode.getOpcode() == 183) {
                            ((MethodInsnNode)abstractInsnNode).owner = "cofh/tweak/asmhooks/world/ClientChunk";
                            break;
                        }
                        abstractInsnNode = abstractInsnNode.getNext();
                    }
                }
                abstractInsnNode = abstractInsnNode == null ? null : abstractInsnNode.getNext();
            }
            abstractInsnNode = new ClassWriter(0);
            classNode.accept((ClassVisitor)abstractInsnNode);
            byArray = abstractInsnNode.toByteArray();
        }
        return byArray;
    }

    private static byte[] alterWorldClient(String string, byte[] byArray, ClassReader classReader) {
        String[] stringArray = LoadingPlugin.runtimeDeobfEnabled ? new String[]{"func_147492_c"} : new String[]{"func_147492_c"};
        ClassNode classNode = new ClassNode(327680);
        classReader.accept((ClassVisitor)classNode, 0);
        MethodNode methodNode = null;
        for (MethodNode methodNode2 : classNode.methods) {
            if (!stringArray[0].equals(methodNode2.name)) continue;
            methodNode = methodNode2;
            break;
        }
        if (methodNode != null) {
            MethodNode methodNode2;
            methodNode.localVariables = null;
            methodNode.instructions.clear();
            methodNode.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            methodNode.instructions.add((AbstractInsnNode)new VarInsnNode(21, 1));
            methodNode.instructions.add((AbstractInsnNode)new VarInsnNode(21, 2));
            methodNode.instructions.add((AbstractInsnNode)new VarInsnNode(21, 3));
            methodNode.instructions.add((AbstractInsnNode)new VarInsnNode(25, 4));
            methodNode.instructions.add((AbstractInsnNode)new VarInsnNode(21, 5));
            String string2 = "(Lnet/minecraft/client/multiplayer/WorldClient;IIILnet/minecraft/block/Block;I)Z";
            methodNode.instructions.add((AbstractInsnNode)new MethodInsnNode(184, HooksCore, "setClientBlock", string2, false));
            methodNode.instructions.add((AbstractInsnNode)new InsnNode(172));
            methodNode2 = new ClassWriter(0);
            classNode.accept((ClassVisitor)methodNode2);
            byArray = methodNode2.toByteArray();
        }
        return byArray;
    }

    private static byte[] alterFollowParent(String string, byte[] byArray, ClassReader classReader) {
        Object object;
        String[] stringArray = LoadingPlugin.runtimeDeobfEnabled ? new String[]{"func_75250_a", "func_75253_b"} : new String[]{"shouldExecute", "continueExecuting"};
        ClassNode classNode = new ClassNode(327680);
        classReader.accept((ClassVisitor)classNode, 0);
        MethodNode methodNode = null;
        MethodNode methodNode2 = null;
        for (MethodNode methodNode3 : classNode.methods) {
            if (stringArray[0].equals(methodNode3.name)) {
                methodNode = methodNode3;
                continue;
            }
            if (!stringArray[1].equals(methodNode3.name)) continue;
            methodNode2 = methodNode3;
        }
        if (methodNode != null) {
            methodNode.localVariables = null;
            methodNode.instructions.clear();
            methodNode.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            object = "(Lnet/minecraft/entity/ai/EntityAIFollowParent;)Z";
            methodNode.instructions.add((AbstractInsnNode)new MethodInsnNode(184, HooksCore, "shouldChildFollowParent", (String)object, false));
            methodNode.instructions.add((AbstractInsnNode)new InsnNode(172));
        }
        if (methodNode2 != null) {
            methodNode2.localVariables = null;
            methodNode2.instructions.clear();
            methodNode2.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            object = "(Lnet/minecraft/entity/ai/EntityAIFollowParent;)Z";
            methodNode2.instructions.add((AbstractInsnNode)new MethodInsnNode(184, HooksCore, "shouldChildContinueFollowParent", (String)object, false));
            methodNode2.instructions.add((AbstractInsnNode)new InsnNode(172));
        }
        object = new ClassWriter(1);
        classNode.accept((ClassVisitor)object);
        byArray = object.toByteArray();
        return byArray;
    }

    private static byte[] alterEntityItem(String string, byte[] byArray, ClassReader classReader) {
        String[] stringArray = LoadingPlugin.runtimeDeobfEnabled ? new String[]{"func_85054_d"} : new String[]{"searchForOtherItemsNearby"};
        ClassNode classNode = new ClassNode(327680);
        classReader.accept((ClassVisitor)classNode, 0);
        MethodNode methodNode = null;
        for (MethodNode methodNode2 : classNode.methods) {
            if (!stringArray[0].equals(methodNode2.name)) continue;
            methodNode = methodNode2;
            break;
        }
        if (methodNode != null) {
            methodNode.localVariables = null;
            methodNode.instructions.clear();
            methodNode.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
            methodNode.instructions.add((AbstractInsnNode)new MethodInsnNode(184, HooksCore, "stackItems", "(Lnet/minecraft/entity/item/EntityItem;)V", false));
            methodNode.instructions.add((AbstractInsnNode)new InsnNode(177));
            ClassWriter classWriter = new ClassWriter(0);
            classNode.accept((ClassVisitor)classWriter);
            byArray = classWriter.toByteArray();
        }
        return byArray;
    }

    private static byte[] alterSquid(String string, byte[] byArray, ClassReader classReader) {
        ClassWriter classWriter;
        String[] stringArray = LoadingPlugin.runtimeDeobfEnabled ? new String[]{"func_85033_bc"} : new String[]{"collideWithNearbyEntities"};
        string = string.replace('.', '/');
        ClassNode classNode = new ClassNode(327680);
        classReader.accept((ClassVisitor)classNode, 0);
        boolean bl = false;
        boolean bl2 = false;
        for (MethodNode methodNode : classNode.methods) {
            if ("cofh_collideCheck".equals(methodNode.name)) {
                bl = true;
                continue;
            }
            if (!stringArray[0].equals(methodNode.name)) continue;
            bl2 = true;
        }
        if (!bl) {
            classWriter = new MethodNode(1, "cofh_collideCheck", "()Z", null, null);
            classNode.methods.add(classWriter);
            classWriter.instructions.add((AbstractInsnNode)new InsnNode(3));
            classWriter.instructions.add((AbstractInsnNode)new InsnNode(172));
        }
        if (!bl2) {
            classWriter = new MethodNode(1, stringArray[0], "()V", null, null);
            classNode.methods.add(classWriter);
            classWriter.instructions.add((AbstractInsnNode)new InsnNode(177));
        }
        classWriter = new ClassWriter(0);
        classNode.accept((ClassVisitor)classWriter);
        byArray = classWriter.toByteArray();
        return byArray;
    }

    private static byte[] alterWaterMob(String string, byte[] byArray, ClassReader classReader) {
        String[] stringArray = LoadingPlugin.runtimeDeobfEnabled ? new String[]{"func_70692_ba"} : new String[]{"canDespawn"};
        string = string.replace('.', '/');
        ClassNode classNode = new ClassNode(327680);
        classReader.accept((ClassVisitor)classNode, 0);
        ClassWriter classWriter = classNode.methods.iterator();
        while (classWriter.hasNext()) {
            MethodNode methodNode = (MethodNode)classWriter.next();
            if (!stringArray[0].equals(methodNode.name)) continue;
            classWriter.remove();
        }
        classWriter = new ClassWriter(0);
        classNode.accept((ClassVisitor)classWriter);
        byArray = classWriter.toByteArray();
        return byArray;
    }

    private static byte[] alterEntityLiving(String string, byte[] byArray, ClassReader classReader) {
        MethodNode methodNode;
        String[] stringArray = LoadingPlugin.runtimeDeobfEnabled ? new String[]{"<init>", "func_70692_ba", "field_70173_aa", "func_70623_bb", "field_70708_bq"} : new String[]{"<init>", "canDespawn", "ticksExisted", "despawnEntity", "entityAge"};
        ClassNode classNode = new ClassNode(327680);
        classReader.accept((ClassVisitor)classNode, 0);
        MethodNode methodNode2 = null;
        MethodNode methodNode3 = null;
        MethodNode methodNode4 = null;
        AbstractInsnNode abstractInsnNode = classNode.methods.iterator();
        while (abstractInsnNode.hasNext()) {
            methodNode = (MethodNode)abstractInsnNode.next();
            if (stringArray[0].equals(methodNode.name)) {
                methodNode2 = methodNode;
                continue;
            }
            if (stringArray[1].equals(methodNode.name)) {
                methodNode3 = methodNode;
                continue;
            }
            if (!stringArray[3].equals(methodNode.name)) continue;
            methodNode4 = methodNode;
        }
        if (methodNode2 != null) {
            for (abstractInsnNode = methodNode2.instructions.getFirst(); abstractInsnNode != null; abstractInsnNode = abstractInsnNode.getNext()) {
                if (abstractInsnNode.getOpcode() != 187) continue;
                methodNode = (TypeInsnNode)abstractInsnNode;
                if (!"net/minecraft/entity/ai/EntityAITasks".equals(methodNode.desc)) continue;
                methodNode.desc = "cofh/tweak/asmhooks/entity/EntityAITasks";
                while (abstractInsnNode.getOpcode() != 183) {
                    abstractInsnNode = abstractInsnNode.getNext();
                }
                ((MethodInsnNode)abstractInsnNode).owner = methodNode.desc;
            }
        }
        if (methodNode3 != null) {
            abstractInsnNode = new InsnList();
            methodNode = new LabelNode();
            abstractInsnNode.add((AbstractInsnNode)new VarInsnNode(25, 0));
            abstractInsnNode.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/entity/Entity", stringArray[2], "I"));
            abstractInsnNode.add((AbstractInsnNode)new LdcInsnNode((Object)new Integer(700)));
            abstractInsnNode.add((AbstractInsnNode)new JumpInsnNode(162, (LabelNode)methodNode));
            abstractInsnNode.add((AbstractInsnNode)new InsnNode(3));
            abstractInsnNode.add((AbstractInsnNode)new InsnNode(172));
            abstractInsnNode.add((AbstractInsnNode)new FrameNode(3, 0, null, 0, null));
            abstractInsnNode.add((AbstractInsnNode)methodNode);
            abstractInsnNode.add((AbstractInsnNode)new InsnNode(4));
            abstractInsnNode.add((AbstractInsnNode)new InsnNode(172));
            methodNode3.instructions.clear();
            methodNode3.localVariables = null;
            methodNode3.instructions.insert((InsnList)abstractInsnNode);
        }
        if (methodNode4 != null) {
            abstractInsnNode = new InsnList();
            methodNode = new LabelNode();
            abstractInsnNode.add((AbstractInsnNode)new VarInsnNode(25, 0));
            abstractInsnNode.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/entity/EntityLivingBase", stringArray[4], "I"));
            abstractInsnNode.add((AbstractInsnNode)new LdcInsnNode((Object)new Integer(31)));
            abstractInsnNode.add((AbstractInsnNode)new InsnNode(126));
            abstractInsnNode.add((AbstractInsnNode)new LdcInsnNode((Object)new Integer(30)));
            abstractInsnNode.add((AbstractInsnNode)new JumpInsnNode(159, (LabelNode)methodNode));
            abstractInsnNode.add((AbstractInsnNode)new InsnNode(177));
            abstractInsnNode.add((AbstractInsnNode)new FrameNode(3, 0, null, 0, null));
            abstractInsnNode.add((AbstractInsnNode)methodNode);
            methodNode4.localVariables = null;
            for (AbstractInsnNode abstractInsnNode2 = methodNode4.instructions.getFirst(); abstractInsnNode2 != null; abstractInsnNode2 = abstractInsnNode2.getNext()) {
                if (abstractInsnNode2.getOpcode() != 182) continue;
                MethodInsnNode methodInsnNode = (MethodInsnNode)abstractInsnNode2;
                if (!"net/minecraft/world/World".equals(methodInsnNode.owner) || !"(Lnet/minecraft/entity/Entity;D)Lnet/minecraft/entity/player/EntityPlayer;".equals(methodInsnNode.desc)) continue;
                while (abstractInsnNode2 != null && abstractInsnNode2.getType() != 8) {
                    abstractInsnNode2 = abstractInsnNode2.getPrevious();
                }
                while (abstractInsnNode2 != null && abstractInsnNode2.getOpcode() != 25) {
                    abstractInsnNode2 = abstractInsnNode2.getNext();
                }
                if (abstractInsnNode2 == null) break;
                methodNode4.instructions.insertBefore(abstractInsnNode2, (InsnList)abstractInsnNode);
                break;
            }
        }
        abstractInsnNode = new ClassWriter(0);
        classNode.accept((ClassVisitor)abstractInsnNode);
        byArray = abstractInsnNode.toByteArray();
        return byArray;
    }

    private static byte[] alterEntity(String string, byte[] byArray, ClassReader classReader) {
        String[] stringArray = LoadingPlugin.runtimeDeobfEnabled ? new String[]{"func_70091_d", "func_72945_a", "func_70104_M", "shouldRenderInPass"} : new String[]{"moveEntity", "getCollidingBoundingBoxes", "canBePushed", "shouldRenderInPass"};
        string = string.replace('.', '/');
        ClassNode classNode = new ClassNode(327680);
        classReader.accept((ClassVisitor)classNode, 0);
        String string2 = "net/minecraft/world/World";
        MethodNode methodNode = null;
        MethodNode methodNode2 = null;
        boolean bl = false;
        for (MethodNode methodNode3 : classNode.methods) {
            if (stringArray[0].equals(methodNode3.name)) {
                methodNode = methodNode3;
                continue;
            }
            if ("cofh_collideCheck".equals(methodNode3.name)) {
                bl = true;
                continue;
            }
            if (!stringArray[3].equals(methodNode3.name)) continue;
            methodNode2 = methodNode3;
        }
        int n = methodNode.instructions.size();
        for (int i = 0; i < n; ++i) {
            MethodInsnNode methodInsnNode;
            AbstractInsnNode abstractInsnNode = methodNode.instructions.get(i);
            if (abstractInsnNode.getOpcode() == 182) {
                methodInsnNode = (MethodInsnNode)abstractInsnNode;
                if (!string2.equals(methodInsnNode.owner) || !stringArray[1].equals(methodInsnNode.name)) continue;
                methodInsnNode.setOpcode(184);
                methodInsnNode.owner = HooksCore;
                methodInsnNode.desc = "(Lnet/minecraft/world/World;Lnet/minecraft/entity/Entity;Lnet/minecraft/util/AxisAlignedBB;)Ljava/util/List;";
                methodInsnNode.name = "getEntityCollisionBoxes";
                continue;
            }
            if (abstractInsnNode.getOpcode() != 184) continue;
            methodInsnNode = (MethodInsnNode)abstractInsnNode;
            if (!"cofh/asmhooks/HooksCore".equals(methodInsnNode.owner) || !"getEntityCollisionBoxes".equals(methodInsnNode.name)) continue;
            methodInsnNode.owner = HooksCore;
        }
        if (FMLLaunchHandler.side() == Side.CLIENT) {
            InsnList insnList = new InsnList();
            LabelNode labelNode = new LabelNode();
            insnList.add((AbstractInsnNode)new VarInsnNode(25, 0));
            insnList.add((AbstractInsnNode)new MethodInsnNode(184, HooksCore, "renderEntity", "(Lnet/minecraft/entity/Entity;)Z", false));
            insnList.add((AbstractInsnNode)new JumpInsnNode(154, labelNode));
            insnList.add((AbstractInsnNode)new InsnNode(3));
            insnList.add((AbstractInsnNode)new InsnNode(172));
            insnList.add((AbstractInsnNode)new FrameNode(3, 0, null, 0, null));
            insnList.add((AbstractInsnNode)labelNode);
            methodNode2.instructions.insertBefore(methodNode2.instructions.getFirst(), insnList);
        }
        if (!bl) {
            methodNode = new MethodNode(1, "cofh_collideCheck", "()Z", null, null);
            classNode.methods.add(methodNode);
            methodNode.instructions.insert((AbstractInsnNode)new InsnNode(172));
            methodNode.instructions.insert((AbstractInsnNode)new MethodInsnNode(182, string, stringArray[2], "()Z", false));
            methodNode.instructions.insert((AbstractInsnNode)new VarInsnNode(25, 0));
        }
        ClassWriter classWriter = new ClassWriter(0);
        classNode.accept((ClassVisitor)classWriter);
        byArray = classWriter.toByteArray();
        return byArray;
    }

    private static byte[] alterMinecraft(String string, byte[] byArray, ClassReader classReader) {
        String[] stringArray = LoadingPlugin.runtimeDeobfEnabled ? new String[]{"func_71407_l", "func_110550_d"} : new String[]{"runTick", "tick"};
        ClassNode classNode = new ClassNode(327680);
        classReader.accept((ClassVisitor)classNode, 0);
        String string2 = "net/minecraft/client/renderer/texture/TextureManager";
        boolean bl = false;
        block0: for (MethodNode methodNode : classNode.methods) {
            String string3 = methodNode.name;
            if (!stringArray[0].equals(string3) || !"()V".equals(methodNode.desc)) continue;
            bl = true;
            int n = methodNode.instructions.size();
            for (int i = 0; i < n; ++i) {
                MethodInsnNode methodInsnNode;
                AbstractInsnNode abstractInsnNode = methodNode.instructions.get(i);
                if (abstractInsnNode.getOpcode() == 182) {
                    methodInsnNode = (MethodInsnNode)abstractInsnNode;
                    if (!string2.equals(methodInsnNode.owner) || !stringArray[1].equals(methodInsnNode.name) || !"()V".equals(methodInsnNode.desc)) continue;
                    methodNode.instructions.set((AbstractInsnNode)methodInsnNode, (AbstractInsnNode)new MethodInsnNode(184, HooksCore, "tickTextures", "(Lnet/minecraft/client/renderer/texture/ITickable;)V", false));
                    break block0;
                }
                if (abstractInsnNode.getOpcode() != 184) continue;
                methodInsnNode = (MethodInsnNode)abstractInsnNode;
                if (!"cofh/asmhooks/HooksCore".equals(methodInsnNode.owner) || !"tickTextures".equals(methodInsnNode.name) || !"(Lnet/minecraft/client/renderer/texture/ITickable;)V".equals(methodInsnNode.desc)) continue;
                methodNode.instructions.set((AbstractInsnNode)methodInsnNode, (AbstractInsnNode)new MethodInsnNode(184, HooksCore, "tickTextures", "(Lnet/minecraft/client/renderer/texture/ITickable;)V", false));
                break block0;
            }
        }
        if (bl) {
            ClassWriter classWriter = new ClassWriter(1);
            classNode.accept((ClassVisitor)classWriter);
            byArray = classWriter.toByteArray();
        }
        return byArray;
    }

    private static byte[] alterChunk(String string, byte[] byArray, ClassReader classReader) {
        String[] stringArray = LoadingPlugin.runtimeDeobfEnabled ? new String[]{"func_150803_c", "field_76650_s", "func_76618_a", "func_76588_a", "field_76644_m"} : new String[]{"recheckGaps", "isGapLightingUpdated", "getEntitiesOfTypeWithinAAAB", "getEntitiesWithinAABBForEntity", "hasEntities"};
        string = string.replace('.', '/');
        ClassNode classNode = new ClassNode(327680);
        classReader.accept((ClassVisitor)classNode, 0);
        boolean bl = false;
        block0: for (MethodNode methodNode : classNode.methods) {
            String string2 = methodNode.name;
            if (stringArray[0].equals(string2) && "(Z)V".equals(methodNode.desc)) {
                bl = true;
                int n = methodNode.instructions.size();
                for (int i = 0; i < n; ++i) {
                    AbstractInsnNode abstractInsnNode = methodNode.instructions.get(i);
                    if (abstractInsnNode.getOpcode() != 177) continue;
                    methodNode.instructions.insertBefore(abstractInsnNode, (AbstractInsnNode)new VarInsnNode(25, 0));
                    methodNode.instructions.insertBefore(abstractInsnNode, (AbstractInsnNode)new InsnNode(3));
                    methodNode.instructions.insertBefore(abstractInsnNode, (AbstractInsnNode)new FieldInsnNode(181, string, stringArray[1], "Z"));
                    continue block0;
                }
                continue;
            }
            if ("<init>".equals(string2)) {
                AbstractInsnNode abstractInsnNode = methodNode.instructions.getFirst();
                while (abstractInsnNode != null) {
                    if (abstractInsnNode.getOpcode() == 187 && "java/util/ArrayList".equals(((TypeInsnNode)abstractInsnNode).desc)) {
                        bl = true;
                        ((TypeInsnNode)abstractInsnNode).desc = "cofh/tweak/util/ClassInheritenceArrayList";
                        while (abstractInsnNode != null) {
                            if (abstractInsnNode.getOpcode() == 183) {
                                ((MethodInsnNode)abstractInsnNode).owner = "cofh/tweak/util/ClassInheritenceArrayList";
                                break;
                            }
                            abstractInsnNode = abstractInsnNode.getNext();
                        }
                    }
                    abstractInsnNode = abstractInsnNode == null ? null : abstractInsnNode.getNext();
                }
                continue;
            }
            if (stringArray[2].equals(string2)) {
                bl = true;
                methodNode.localVariables = null;
                methodNode.instructions.clear();
                methodNode.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
                methodNode.instructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
                methodNode.instructions.add((AbstractInsnNode)new VarInsnNode(25, 2));
                methodNode.instructions.add((AbstractInsnNode)new VarInsnNode(25, 3));
                methodNode.instructions.add((AbstractInsnNode)new VarInsnNode(25, 4));
                methodNode.instructions.add((AbstractInsnNode)new MethodInsnNode(184, HooksCore, "getEntities", "(Lnet/minecraft/world/chunk/Chunk;Ljava/lang/Class;Lnet/minecraft/util/AxisAlignedBB;Ljava/util/List;Lnet/minecraft/command/IEntitySelector;)V", false));
                methodNode.instructions.add((AbstractInsnNode)new InsnNode(177));
                continue;
            }
            if (!stringArray[3].equals(string2)) continue;
            bl = true;
            methodNode.localVariables = null;
            InsnList insnList = new InsnList();
            LabelNode labelNode = new LabelNode();
            insnList.add((AbstractInsnNode)new VarInsnNode(25, 0));
            insnList.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraft/world/chunk/Chunk", stringArray[4], "Z"));
            insnList.add((AbstractInsnNode)new JumpInsnNode(154, labelNode));
            insnList.add((AbstractInsnNode)new InsnNode(177));
            insnList.add((AbstractInsnNode)new FrameNode(3, 0, null, 0, null));
            insnList.add((AbstractInsnNode)labelNode);
            methodNode.instructions.insert(insnList);
        }
        if (bl) {
            ClassWriter classWriter = new ClassWriter(1);
            classNode.accept((ClassVisitor)classWriter);
            byArray = classWriter.toByteArray();
        }
        return byArray;
    }

    public static int hash6432shift(long l) {
        l = (l ^ 0xFFFFFFFFFFFFFFFFL) + (l << 18);
        l ^= l >>> 31;
        l *= 21L;
        l ^= l >>> 11;
        l += l << 6;
        l ^= l >>> 22;
        return (int)l;
    }

    private static byte[] alterLongHashMap(String string, byte[] byArray, ClassReader classReader) {
        ClassNode classNode;
        Object object;
        String[] stringArray = LoadingPlugin.runtimeDeobfEnabled ? new String[]{"func_76155_g", "func_76160_c", "func_76161_b"} : new String[]{"getHashedKey", "getEntry", "containsItem"};
        ClassNode classNode2 = new ClassNode(327680);
        classReader.accept((ClassVisitor)classNode2, 0);
        boolean bl = false;
        MethodNode methodNode = null;
        Object object2 = null;
        for (Object object3 : classNode2.methods) {
            object = ((MethodNode)object3).name;
            if (stringArray[0].equals(object) && "(J)I".equals(((MethodNode)object3).desc)) {
                bl = true;
                ((MethodNode)object3).localVariables = null;
                ((MethodNode)object3).instructions.clear();
                ((MethodNode)object3).instructions.add((AbstractInsnNode)new IntInsnNode(22, 0));
                ((MethodNode)object3).instructions.add((AbstractInsnNode)new LdcInsnNode((Object)new Long(-1L)));
                ((MethodNode)object3).instructions.add((AbstractInsnNode)new InsnNode(131));
                ((MethodNode)object3).instructions.add((AbstractInsnNode)new IntInsnNode(22, 0));
                ((MethodNode)object3).instructions.add((AbstractInsnNode)new IntInsnNode(16, 18));
                ((MethodNode)object3).instructions.add((AbstractInsnNode)new InsnNode(121));
                ((MethodNode)object3).instructions.add((AbstractInsnNode)new InsnNode(97));
                ((MethodNode)object3).instructions.add((AbstractInsnNode)new InsnNode(92));
                ((MethodNode)object3).instructions.add((AbstractInsnNode)new InsnNode(92));
                ((MethodNode)object3).instructions.add((AbstractInsnNode)new IntInsnNode(16, 31));
                ((MethodNode)object3).instructions.add((AbstractInsnNode)new InsnNode(125));
                ((MethodNode)object3).instructions.add((AbstractInsnNode)new InsnNode(131));
                ((MethodNode)object3).instructions.add((AbstractInsnNode)new InsnNode(92));
                ((MethodNode)object3).instructions.add((AbstractInsnNode)new LdcInsnNode((Object)new Long(21L)));
                ((MethodNode)object3).instructions.add((AbstractInsnNode)new InsnNode(105));
                ((MethodNode)object3).instructions.add((AbstractInsnNode)new InsnNode(92));
                ((MethodNode)object3).instructions.add((AbstractInsnNode)new InsnNode(92));
                ((MethodNode)object3).instructions.add((AbstractInsnNode)new IntInsnNode(16, 11));
                ((MethodNode)object3).instructions.add((AbstractInsnNode)new InsnNode(125));
                ((MethodNode)object3).instructions.add((AbstractInsnNode)new InsnNode(131));
                ((MethodNode)object3).instructions.add((AbstractInsnNode)new InsnNode(92));
                ((MethodNode)object3).instructions.add((AbstractInsnNode)new InsnNode(92));
                ((MethodNode)object3).instructions.add((AbstractInsnNode)new IntInsnNode(16, 6));
                ((MethodNode)object3).instructions.add((AbstractInsnNode)new InsnNode(121));
                ((MethodNode)object3).instructions.add((AbstractInsnNode)new InsnNode(97));
                ((MethodNode)object3).instructions.add((AbstractInsnNode)new InsnNode(92));
                ((MethodNode)object3).instructions.add((AbstractInsnNode)new InsnNode(92));
                ((MethodNode)object3).instructions.add((AbstractInsnNode)new IntInsnNode(16, 22));
                ((MethodNode)object3).instructions.add((AbstractInsnNode)new InsnNode(125));
                ((MethodNode)object3).instructions.add((AbstractInsnNode)new InsnNode(131));
                ((MethodNode)object3).instructions.add((AbstractInsnNode)new InsnNode(136));
                ((MethodNode)object3).instructions.add((AbstractInsnNode)new InsnNode(172));
                if (object2 == null) continue;
                break;
            }
            if (!stringArray[2].equals(object) || !"(J)Z".equals(((MethodNode)object3).desc)) continue;
            object2 = object3;
            if (!bl) continue;
            break;
        }
        if (object2 != null) {
            MethodNode methodNode2;
            Object object3;
            classNode = new ClassNode(327680);
            classReader.accept((ClassVisitor)classNode, 0);
            object3 = "(J)Lnet/minecraft/util/LongHashMap$Entry;";
            object = classNode.methods.iterator();
            while (object.hasNext()) {
                methodNode2 = (MethodNode)object.next();
                String string2 = methodNode2.name;
                if (!stringArray[1].equals(string2) || !((String)object3).equals(methodNode2.desc)) continue;
                methodNode = methodNode2;
                break;
            }
            if (methodNode != null) {
                bl = true;
                ((MethodNode)object2).instructions.clear();
                ((MethodNode)object2).instructions.add(methodNode.instructions);
                for (object = ((MethodNode)object2).instructions.get(0); object != null; object = object.getNext()) {
                    if (object.getOpcode() != 176) continue;
                    methodNode2 = object.getPrevious();
                    if (methodNode2.getOpcode() == 1) {
                        ((MethodNode)object2).instructions.set((AbstractInsnNode)methodNode2, (AbstractInsnNode)new InsnNode(3));
                    } else {
                        ((MethodNode)object2).instructions.set((AbstractInsnNode)methodNode2, (AbstractInsnNode)new InsnNode(4));
                    }
                    Object object4 = object;
                    object = new InsnNode(172);
                    ((MethodNode)object2).instructions.set((AbstractInsnNode)object4, (AbstractInsnNode)object);
                }
            }
        }
        if (bl) {
            classNode = new ClassWriter(1);
            classNode2.accept((ClassVisitor)classNode);
            byArray = classNode.toByteArray();
        }
        return byArray;
    }

    static {
        hashes.put((Object)"net.minecraft.util.LongHashMap", (byte)1);
        if (!Config.lightChunks) {
            hashes.put((Object)"net.minecraft.world.chunk.Chunk", (byte)2);
        }
        hashes.put((Object)"net.minecraft.client.Minecraft", (byte)3);
        hashes.put((Object)"net.minecraft.entity.Entity", (byte)4);
        hashes.put((Object)"cofh.tweak.asmhooks.HooksCore", (byte)5);
        hashes.put((Object)"net.minecraft.entity.item.EntityItem", (byte)6);
        hashes.put((Object)"net.minecraft.world.World", (byte)7);
        hashes.put((Object)"net.minecraft.entity.EntityLiving", (byte)8);
        hashes.put((Object)"net.minecraft.client.multiplayer.WorldClient", (byte)9);
        hashes.put((Object)"net.minecraft.client.multiplayer.ChunkProviderClient", (byte)10);
        hashes.put((Object)"cpw.mods.fml.common.FMLCommonHandler", (byte)11);
        hashes.put((Object)"net.minecraft.entity.passive.EntitySquid", (byte)12);
        hashes.put((Object)"net.minecraft.entity.passive.EntityWaterMob", (byte)13);
        hashes.put((Object)"net.minecraft.entity.ai.EntityAIFollowParent", (byte)14);
        hashes.put((Object)"net.minecraft.network.NetHandlerPlayServer", (byte)15);
    }
}

