/*
 * Decompiled with CFR 0.152.
 */
package cofh.tweak.asmhooks.render;

import cofh.repack.cofh.lib.util.IdentityLinkedHashList;
import cofh.repack.com.sun.org.apache.xml.internal.utils.IntStack;
import cofh.repack.net.minecraft.client.renderer.chunk.SetVisibility;
import cofh.repack.net.minecraft.client.renderer.chunk.VisGraph;
import cofh.tweak.CoFHTweaks;
import cofh.tweak.asmhooks.Config;
import cofh.tweak.asmhooks.render.TweakedRenderer;
import cofh.tweak.asmhooks.world.ClientChunk;
import cofh.tweak.util.Frustrum;
import cpw.mods.fml.common.FMLLog;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.IdentityHashMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderList;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.util.RenderDistanceSorter;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.client.MinecraftForgeClient;
import org.lwjgl.opengl.GL11;

public class RenderGlobal
extends net.minecraft.client.renderer.RenderGlobal {
    private static IntStack deferredAreas = new IntStack(6144);
    private int renderersNeedUpdate;
    private int prevRotationPitch = -9999;
    private int prevRotationYaw = -9999;
    private int prevRenderX;
    private int prevRenderY;
    private int prevRenderZ;
    private short alphaSortProgress = 0;
    private byte timeCheckInterval = (byte)5;
    private byte frameCounter;
    private byte frameTarget;
    private int countTileEntitiesTotal;
    private int countTileEntitiesRendered;
    private IdentityLinkedHashList<WorldRenderer> worldRenderersToUpdateList = new IdentityLinkedHashList();
    private IdentityLinkedHashList<WorldRenderer> workerWorldRenderers;
    private final Thread clientThread;
    public static RenderWorker worker = new RenderWorker();

    public static final synchronized void updateArea(int n, int n2, int n3, int n4, int n5, int n6) {
        deferredAreas.add(n6);
        deferredAreas.add(n5);
        deferredAreas.add(n4);
        deferredAreas.add(n3);
        deferredAreas.add(n2);
        deferredAreas.add(n);
    }

    private static final synchronized void processUpdate(RenderGlobal renderGlobal) {
        if (deferredAreas.isEmpty()) {
            return;
        }
        int n = deferredAreas.pop();
        int n2 = deferredAreas.pop();
        int n3 = deferredAreas.pop();
        int n4 = deferredAreas.pop();
        int n5 = deferredAreas.pop();
        int n6 = deferredAreas.pop();
        renderGlobal.markBlocksForUpdate_internal(n, n2, n3, n4, n5, n6);
    }

    public RenderGlobal(Minecraft minecraft) {
        super(minecraft);
        this.field_72767_j = this.worldRenderersToUpdateList;
        this.workerWorldRenderers = new IdentityLinkedHashList();
        this.field_72774_t = false;
        this.clientThread = Thread.currentThread();
    }

    public void func_72729_a(ICamera iCamera, float f) {
        if (this.field_72777_q.field_71474_y.field_151451_c != this.field_72739_F) {
            this.func_72712_a();
        }
        int n = this.field_72757_g++;
        WorldRenderer[] worldRendererArray = this.field_72768_k;
        int n2 = this.field_72751_K;
        for (int i = 0; i < n2; ++i) {
            WorldRenderer worldRenderer = worldRendererArray[i];
            if (!(!worldRenderer.field_78927_l | (i + n & 0xF) == 0)) continue;
            worldRenderer.func_78908_a(iCamera);
        }
    }

    public boolean func_72716_a(EntityLivingBase entityLivingBase, boolean bl) {
        int n;
        this.field_72769_h.field_72984_F.func_76320_a("deferred_updates");
        if (deferredAreas.size() > 0) {
            long l = System.nanoTime();
            n = 0;
            while (deferredAreas.size() > 0) {
                RenderGlobal.processUpdate(this);
                if (++n <= 5) continue;
                n = 0;
                long l2 = System.nanoTime() - l >>> 1;
                if (l2 <= 100000L) continue;
                break;
            }
        }
        this.field_72769_h.field_72984_F.func_76318_c("rebuild");
        int n2 = this.field_72767_j.size() + this.workerWorldRenderers.size();
        if (n2 > 0) {
            this.frameCounter = (byte)(this.frameCounter + 1);
            this.rebuildChunks(entityLivingBase, n2, System.nanoTime());
        }
        this.field_72769_h.field_72984_F.func_76318_c("scan");
        int n3 = MathHelper.func_76141_d((float)(entityLivingBase.field_70177_z + 45.0f)) >> 4;
        n = MathHelper.func_76141_d((float)(entityLivingBase.field_70125_A + 45.0f)) >> 4;
        if (RenderGlobal.worker.dirty || n3 != this.prevRotationYaw || n != this.prevRotationPitch) {
            worker.run(true);
            this.prevRotationYaw = n3;
            this.prevRotationPitch = n;
        }
        this.field_72769_h.field_72984_F.func_76319_b();
        return true;
    }

    private boolean rebuildChunks(EntityLivingBase entityLivingBase, int n, long l) {
        IdentityLinkedHashList<WorldRenderer> identityLinkedHashList = this.workerWorldRenderers;
        IdentityLinkedHashList<WorldRenderer> identityLinkedHashList2 = this.worldRenderersToUpdateList;
        boolean bl = true;
        byte by = 0;
        for (int i = 0; i < n; ++i) {
            WorldRenderer worldRenderer;
            if (identityLinkedHashList.size() > 0) {
                worldRenderer = (WorldRenderer)identityLinkedHashList.shift();
                identityLinkedHashList2.remove(worldRenderer);
            } else {
                worldRenderer = (WorldRenderer)identityLinkedHashList2.shift();
            }
            if (worldRenderer == null) break;
            if (!(worldRenderer.field_78927_l & worldRenderer.field_78936_t)) continue;
            boolean bl2 = worldRenderer.field_78935_u;
            worldRenderer.func_147892_a(entityLivingBase);
            worldRenderer.field_78936_t = worldRenderer.field_78936_t & !bl2;
            worldRenderer.field_78935_u = worldRenderer.func_78906_e();
            if (++by <= this.timeCheckInterval) continue;
            long l2 = System.nanoTime() - l >>> 1;
            if (l2 > 2250000L) {
                if (by == i | this.frameCounter == this.frameTarget) {
                    this.timeCheckInterval = (byte)(this.timeCheckInterval - 1);
                    this.timeCheckInterval = (byte)(this.timeCheckInterval & ~this.timeCheckInterval);
                    this.frameTarget = (byte)(this.frameCounter + 50);
                }
                bl = false;
                break;
            }
            by = 0;
        }
        if (bl & this.frameCounter == this.frameTarget & this.timeCheckInterval < 5) {
            this.timeCheckInterval = (byte)(this.timeCheckInterval + 1);
            this.frameTarget = (byte)(this.frameCounter + 50);
        }
        return bl;
    }

    public void func_147589_a(EntityLivingBase entityLivingBase, ICamera iCamera, float f) {
        Entity entity;
        int n;
        int n2 = MinecraftForgeClient.getRenderPass();
        if (this.field_72740_G > 0) {
            if (n2 > 0) {
                return;
            }
            --this.field_72740_G;
            return;
        }
        this.field_72769_h.field_72984_F.func_76320_a("prepare");
        double d = entityLivingBase.field_70169_q + (entityLivingBase.field_70165_t - entityLivingBase.field_70169_q) * (double)f;
        double d2 = entityLivingBase.field_70167_r + (entityLivingBase.field_70163_u - entityLivingBase.field_70167_r) * (double)f;
        double d3 = entityLivingBase.field_70166_s + (entityLivingBase.field_70161_v - entityLivingBase.field_70166_s) * (double)f;
        TileEntityRendererDispatcher.field_147556_a.func_147542_a((World)this.field_72769_h, this.field_72777_q.func_110434_K(), this.field_72777_q.field_71466_p, this.field_72777_q.field_71451_h, f);
        RenderManager.field_78727_a.func_147938_a((World)this.field_72769_h, this.field_72777_q.func_110434_K(), this.field_72777_q.field_71466_p, this.field_72777_q.field_71451_h, this.field_72777_q.field_147125_j, this.field_72777_q.field_71474_y, f);
        if (n2 == 0) {
            this.field_72748_H = 0;
            this.field_72749_I = 0;
            this.field_72750_J = 0;
            this.countTileEntitiesTotal = 0;
            this.countTileEntitiesRendered = 0;
        }
        entityLivingBase = this.field_72777_q.field_71451_h;
        double d4 = entityLivingBase.field_70142_S + (entityLivingBase.field_70165_t - entityLivingBase.field_70142_S) * (double)f;
        double d5 = entityLivingBase.field_70137_T + (entityLivingBase.field_70163_u - entityLivingBase.field_70137_T) * (double)f;
        double d6 = entityLivingBase.field_70136_U + (entityLivingBase.field_70161_v - entityLivingBase.field_70136_U) * (double)f;
        TileEntityRendererDispatcher.field_147554_b = d4;
        TileEntityRendererDispatcher.field_147555_c = d5;
        TileEntityRendererDispatcher.field_147552_d = d6;
        this.field_72769_h.field_72984_F.func_76318_c("staticentities");
        if (this.field_147595_R) {
            RenderManager.field_78725_b = 0.0;
            RenderManager.field_78726_c = 0.0;
            RenderManager.field_78723_d = 0.0;
            this.func_147591_f();
        }
        GL11.glMatrixMode((int)5888);
        GL11.glPushMatrix();
        GL11.glTranslated((double)(-d4), (double)(-d5), (double)(-d6));
        GL11.glCallList((int)this.field_147594_S);
        GL11.glPopMatrix();
        RenderManager.field_78725_b = d4;
        RenderManager.field_78726_c = d5;
        RenderManager.field_78723_d = d6;
        this.field_72769_h.field_72984_F.func_76318_c("global");
        this.field_72777_q.field_71460_t.func_78463_b((double)f);
        List list = this.field_72769_h.func_72910_y();
        if (n2 == 0) {
            this.field_72748_H = list.size() + this.field_72769_h.field_73007_j.size();
        }
        for (n = 0; n < this.field_72769_h.field_73007_j.size(); ++n) {
            entity = (Entity)this.field_72769_h.field_73007_j.get(n);
            if (!entity.shouldRenderInPass(n2) || !entity.func_145770_h(d, d2, d3)) continue;
            ++this.field_72749_I;
            RenderManager.field_78727_a.func_147937_a(entity, f);
        }
        this.field_72769_h.field_72984_F.func_76318_c("entities");
        for (n = 0; n < list.size(); ++n) {
            EntityLiving entityLiving;
            boolean bl;
            entity = (Entity)list.get(n);
            if (!entity.shouldRenderInPass(n2)) continue;
            boolean bl2 = bl = entity.field_70153_n == this.field_72777_q.field_71439_g;
            if (!bl) {
                bl = entity.func_145770_h(d, d2, d3);
                bl &= entity.field_70158_ak || iCamera.func_78546_a(entity.field_70121_D);
            }
            if (!bl && entity instanceof EntityLiving && (entityLiving = (EntityLiving)entity).func_110167_bD() && entityLiving.func_110166_bE() != null) {
                Entity entity2 = entityLiving.func_110166_bE();
                bl = iCamera.func_78546_a(entity2.field_70121_D);
            }
            if ((!bl || entity == entityLivingBase) && this.field_72777_q.field_71474_y.field_74320_O == 0 && !entityLivingBase.func_70608_bn()) continue;
            entityLiving = this.getRenderer(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
            if (entityLiving != null && !entityLiving.field_78936_t) {
                ++this.field_72750_J;
                continue;
            }
            ++this.field_72749_I;
            RenderManager.field_78727_a.func_147937_a(entity, f);
        }
        this.field_72769_h.field_72984_F.func_76318_c("blockentities");
        RenderHelper.func_74519_b();
        List list2 = this.field_147598_a;
        if (n2 == 0) {
            this.countTileEntitiesTotal = list2.size();
        }
        for (int i = 0; i < list2.size(); ++i) {
            TileEntity tileEntity = (TileEntity)list2.get(i);
            if (!tileEntity.shouldRenderInPass(n2) || !iCamera.func_78546_a(tileEntity.getRenderBoundingBox())) continue;
            ++this.countTileEntitiesRendered;
            TileEntityRendererDispatcher.field_147556_a.func_147544_a(tileEntity, f);
        }
        this.field_72777_q.field_71460_t.func_78483_a((double)f);
        this.field_72769_h.field_72984_F.func_76319_b();
    }

    public String func_72735_c() {
        StringBuilder stringBuilder = new StringBuilder(80);
        stringBuilder.append("C: ").append(this.field_72746_N).append('/').append(this.field_72751_K).append('/').append(this.field_72765_l.length);
        stringBuilder.append(". F: ").append(this.field_72744_L);
        stringBuilder.append(", O: ").append(this.field_72745_M);
        stringBuilder.append(", E: ").append(this.field_72747_O);
        stringBuilder.append(", I: ").append(this.field_72753_P);
        stringBuilder.append("; U: ").append(this.renderersNeedUpdate);
        stringBuilder.append(", W: ").append(this.workerWorldRenderers.size());
        stringBuilder.append(", N: ").append(this.field_72767_j.size());
        return stringBuilder.toString();
    }

    public String func_72723_d() {
        StringBuilder stringBuilder = new StringBuilder(44);
        stringBuilder.append("E: ").append(this.field_72749_I).append('/').append(this.field_72748_H);
        stringBuilder.append(". B: ").append(this.field_72750_J);
        stringBuilder.append(", I: ").append(this.field_72748_H - this.field_72750_J - this.field_72749_I);
        stringBuilder.append("; TE: ").append(this.countTileEntitiesRendered).append('/').append(this.countTileEntitiesTotal);
        return stringBuilder.toString();
    }

    public int func_72719_a(EntityLivingBase entityLivingBase, int n, double d) {
        int n2;
        int n3;
        this.field_72769_h.field_72984_F.func_76320_a("sortchunks");
        List list = this.field_72767_j;
        WorldRenderer[] worldRendererArray = this.field_72768_k;
        if (this.field_72751_K > 0) {
            n3 = this.field_72751_K - 10;
            n3 &= n3 >> 31;
            n3 += 10;
            for (n2 = 0; n2 < n3; ++n2) {
                this.field_72752_Q = (this.field_72752_Q + 1) % this.field_72751_K;
                WorldRenderer worldRenderer = worldRendererArray[this.field_72752_Q];
                if (!(worldRenderer.field_78927_l & worldRenderer.field_78936_t & worldRenderer.field_78939_q)) continue;
                list.add(worldRenderer);
            }
        }
        this.field_72769_h.field_72984_F.func_76320_a("reposition_chunks");
        if (this.field_147603_i != entityLivingBase.field_70176_ah || this.field_147600_j != entityLivingBase.field_70162_ai || this.field_147601_k != entityLivingBase.field_70164_aj) {
            this.field_147603_i = entityLivingBase.field_70176_ah;
            this.field_147600_j = entityLivingBase.field_70162_ai;
            this.field_147601_k = entityLivingBase.field_70164_aj;
            this.func_72722_c(MathHelper.func_76128_c((double)entityLivingBase.field_70165_t), MathHelper.func_76128_c((double)entityLivingBase.field_70163_u), MathHelper.func_76128_c((double)entityLivingBase.field_70161_v));
        }
        this.field_72769_h.field_72984_F.func_76319_b();
        if (n == 1) {
            this.field_72769_h.field_72984_F.func_76320_a("alpha_sort");
            if (this.field_147596_f != entityLivingBase.field_70165_t || this.field_147597_g != entityLivingBase.field_70163_u || this.field_147602_h != entityLivingBase.field_70161_v) {
                this.field_147596_f = entityLivingBase.field_70165_t;
                this.field_147597_g = entityLivingBase.field_70163_u;
                this.field_147602_h = entityLivingBase.field_70161_v;
                n3 = (int)((this.field_147596_f - (double)(entityLivingBase.field_70176_ah * 16)) * 2.0);
                n2 = (int)((this.field_147597_g - (double)(entityLivingBase.field_70162_ai * 16)) * 2.0);
                int n4 = (int)((this.field_147602_h - (double)(entityLivingBase.field_70164_aj * 16)) * 2.0);
                if (this.prevRenderX != n3 || this.prevRenderY != n2 || this.prevRenderZ != n4) {
                    this.prevRenderX = n3;
                    this.prevRenderY = n2;
                    this.prevRenderZ = n4;
                    this.alphaSortProgress = 0;
                }
            }
            int n5 = n3 = this.field_72751_K < 27 ? this.field_72751_K : Math.max(this.field_72751_K >> 1, 27);
            if (this.alphaSortProgress < n3) {
                for (n2 = 0; n2 < 10 && this.alphaSortProgress < n3; ++n2) {
                    short s = this.alphaSortProgress;
                    this.alphaSortProgress = (short)(s + 1);
                    WorldRenderer worldRenderer = worldRendererArray[s];
                    worldRenderer.func_147889_b(entityLivingBase);
                }
            }
            this.field_72769_h.field_72984_F.func_76319_b();
        }
        this.field_72769_h.field_72984_F.func_76318_c("render");
        RenderHelper.func_74518_a();
        n3 = this.func_72724_a(0, this.field_72751_K, n, d);
        this.field_72769_h.field_72984_F.func_76319_b();
        return n3;
    }

    protected int func_72724_a(int n, int n2, int n3, double d) {
        int n4;
        int n5;
        int n6;
        int n7;
        int n8;
        int n9;
        EntityLivingBase entityLivingBase = this.field_72777_q.field_71451_h;
        double d2 = entityLivingBase.field_70142_S + (entityLivingBase.field_70165_t - entityLivingBase.field_70142_S) * d;
        double d3 = entityLivingBase.field_70137_T + (entityLivingBase.field_70163_u - entityLivingBase.field_70137_T) * d;
        double d4 = entityLivingBase.field_70136_U + (entityLivingBase.field_70161_v - entityLivingBase.field_70136_U) * d;
        RenderList[] renderListArray = this.field_72754_S;
        for (n9 = 0; n9 < renderListArray.length; ++n9) {
            renderListArray[n9].func_78421_b();
        }
        n9 = n;
        int n10 = n2;
        int n11 = 1;
        if (n3 == 1) {
            n9 = n2 - 1;
            n10 = n - 1;
            n11 = -1;
        }
        if (n3 == 0 && this.field_72777_q.field_71474_y.field_74330_P) {
            this.field_72777_q.field_71441_e.field_72984_F.func_76320_a("debug_info");
            n8 = 0;
            n7 = 0;
            int n12 = 0;
            n6 = 0;
            n5 = 0;
            n4 = 0;
            for (WorldRenderer worldRenderer : this.field_72765_l) {
                if (!worldRenderer.field_78915_A) {
                    ++n8;
                } else if (!worldRenderer.field_78927_l) {
                    ++n7;
                } else if (!worldRenderer.field_78936_t) {
                    ++n12;
                } else if (worldRenderer.field_78935_u) {
                    ++n5;
                } else {
                    ++n6;
                }
                if (!worldRenderer.field_78939_q) continue;
                ++n4;
            }
            this.field_72753_P = n8;
            this.field_72744_L = n7;
            this.field_72745_M = n12;
            this.field_72746_N = n6;
            this.field_72747_O = n5;
            this.renderersNeedUpdate = n4;
            this.field_72777_q.field_71441_e.field_72984_F.func_76319_b();
        }
        this.field_72777_q.field_71441_e.field_72984_F.func_76320_a("setup_lists");
        n8 = 0;
        n7 = 0;
        WorldRenderer[] worldRendererArray = this.field_72768_k;
        for (n6 = n9; n6 != n10; n6 += n11) {
            WorldRenderer worldRenderer;
            block15: {
                worldRenderer = worldRendererArray[n6];
                if (!(worldRenderer.field_78927_l & !worldRenderer.field_78928_m[n3])) continue;
                for (int i = 0; i < n7; ++i) {
                    if (!renderListArray[i].func_78418_a(worldRenderer.field_78918_f, worldRenderer.field_78919_g, worldRenderer.field_78931_h)) continue;
                    n4 = i;
                    break block15;
                }
                n4 = n7++;
                renderListArray[n4].func_78422_a(worldRenderer.field_78918_f, worldRenderer.field_78919_g, worldRenderer.field_78931_h, d2, d3, d4);
            }
            renderListArray[n4].func_78420_a(worldRenderer.field_78942_y + n3);
            ++n8;
        }
        this.field_72777_q.field_71441_e.field_72984_F.func_76318_c("call_lists");
        this.field_72777_q.field_71460_t.func_78463_b(d);
        n6 = MathHelper.func_76128_c((double)d2);
        n5 = MathHelper.func_76128_c((double)d4);
        n6 -= n6 & 0x3FF;
        n5 -= n5 & 0x3FF;
        Arrays.sort(renderListArray, new RenderDistanceSorter(n6, n5));
        for (n4 = 0; n4 < 4; ++n4) {
            renderListArray[n4].func_78419_a();
        }
        this.field_72777_q.field_71460_t.func_78483_a(d);
        this.field_72777_q.field_71441_e.field_72984_F.func_76319_b();
        return n8;
    }

    public void func_72725_b(int n, int n2, int n3, int n4, int n5, int n6) {
        if (Thread.currentThread() != this.clientThread) {
            RenderGlobal.updateArea(n, n2, n3, n4, n5, n6);
        } else {
            this.markBlocksForUpdate_internal(n, n2, n3, n4, n5, n6);
        }
    }

    public void markBlocksForUpdate_internal(int n, int n2, int n3, int n4, int n5, int n6) {
        int n7 = MathHelper.func_76137_a((int)n, (int)16);
        int n8 = MathHelper.func_76137_a((int)n2, (int)16);
        int n9 = MathHelper.func_76137_a((int)n3, (int)16);
        int n10 = MathHelper.func_76137_a((int)n4, (int)16);
        int n11 = MathHelper.func_76137_a((int)n5, (int)16);
        int n12 = MathHelper.func_76137_a((int)n6, (int)16);
        int n13 = this.field_72766_m;
        int n14 = this.field_72763_n;
        int n15 = this.field_72764_o;
        WorldRenderer[] worldRendererArray = this.field_72765_l;
        boolean bl = false;
        for (int i = n7; i <= n10; ++i) {
            int n16 = i % n13;
            n16 += n13 & n16 >> 31;
            for (int j = n8; j <= n11; ++j) {
                int n17 = j % n14;
                n17 += n14 & n17 >> 31;
                for (int k = n9; k <= n12; ++k) {
                    int n18 = k % n15;
                    n18 += n15 & n18 >> 31;
                    int n19 = (n18 * n14 + n17) * n13 + n16;
                    WorldRenderer worldRenderer = worldRendererArray[n19];
                    if (worldRenderer.field_78939_q && (!worldRenderer.field_78936_t || this.field_72767_j.contains(worldRenderer))) continue;
                    worldRenderer.func_78914_f();
                    if (worldRenderer.func_78912_a((Entity)this.field_72777_q.field_71451_h) > 2883.0f) {
                        this.field_72767_j.add(worldRenderer);
                        continue;
                    }
                    Chunk chunk = this.field_72769_h.func_72938_d(worldRenderer.field_78923_c, worldRenderer.field_78921_e);
                    if (chunk instanceof ClientChunk && ((ClientChunk)chunk).visibility[worldRenderer.field_78920_d >> 4].isRenderDirty()) {
                        bl = true;
                    }
                    this.workerWorldRenderers.remove(worldRenderer);
                    this.workerWorldRenderers.unshift(worldRenderer);
                }
            }
        }
        if (bl) {
            RenderGlobal.worker.dirty = true;
        }
    }

    public void func_72732_a(WorldClient worldClient) {
        if (worldClient != null && !CoFHTweaks.canHaveWorld()) {
            FMLLog.bigWarning((String)"World exists prior to starting the server!", (Object[])new Object[0]);
        }
        worker.setWorld(this, worldClient);
        super.func_72732_a(worldClient);
    }

    public void func_72712_a() {
        if (this.field_72769_h != null) {
            int n = Config.overrideFancyLeaves;
            int n2 = (n == -1 ? this.field_72777_q.field_71474_y.field_74347_j : (n == 1 ? 1 : 0)) ? 1 : 0;
            Blocks.field_150362_t.func_150122_b(n2 != 0);
            Blocks.field_150361_u.func_150122_b(n2 != 0);
            this.field_72739_F = this.field_72777_q.field_71474_y.field_151451_c;
            if (this.field_72765_l != null) {
                for (n = 0; n < this.field_72765_l.length; ++n) {
                    this.field_72765_l[n].func_78911_c();
                }
            }
            this.field_72766_m = n = this.field_72739_F * 2 + 1;
            this.field_72763_n = 16;
            this.field_72764_o = n;
            this.field_72751_K = 0;
            this.field_72765_l = new WorldRenderer[this.field_72766_m * this.field_72763_n * this.field_72764_o];
            this.field_72768_k = new WorldRenderer[this.field_72766_m * this.field_72763_n * this.field_72764_o];
            this.field_72780_y = 0;
            this.field_72779_z = 0;
            this.field_72741_A = 0;
            this.field_72742_B = this.field_72766_m * 16;
            this.field_72743_C = this.field_72763_n * 16;
            this.field_72737_D = this.field_72764_o * 16;
            this.field_72767_j.clear();
            this.field_147598_a.clear();
            this.func_147584_b();
            n2 = 0;
            int n3 = 0;
            for (int i = 0; i < this.field_72766_m; ++i) {
                for (int j = 0; j < this.field_72763_n; ++j) {
                    for (int k = 0; k < this.field_72764_o; ++k) {
                        int n4 = (k * this.field_72763_n + j) * this.field_72766_m + i;
                        TweakedRenderer tweakedRenderer = new TweakedRenderer((World)this.field_72769_h, this.field_147598_a, i * 16, j * 16, k * 16, this.field_72778_p + n3);
                        n3 += 2;
                        this.field_72765_l[n4] = tweakedRenderer;
                        this.field_72768_k[n4] = tweakedRenderer;
                        tweakedRenderer.field_78935_u = false;
                        tweakedRenderer.field_78936_t = false;
                        tweakedRenderer.field_78927_l = false;
                        tweakedRenderer.field_78937_s = n2++;
                        tweakedRenderer.func_78914_f();
                        this.field_72767_j.add(tweakedRenderer);
                    }
                }
            }
            EntityLivingBase entityLivingBase = this.field_72777_q.field_71451_h;
            this.field_72740_G = 2;
            if (entityLivingBase != null) {
                this.func_72722_c(MathHelper.func_76128_c((double)entityLivingBase.field_70165_t), MathHelper.func_76128_c((double)entityLivingBase.field_70163_u), MathHelper.func_76128_c((double)entityLivingBase.field_70161_v));
            }
        }
        RenderGlobal.worker.dirty = true;
    }

    protected void func_72722_c(int n, int n2, int n3) {
        n -= 8;
        n2 -= 8;
        n3 -= 8;
        this.field_72780_y = Integer.MAX_VALUE;
        this.field_72779_z = Integer.MAX_VALUE;
        this.field_72741_A = Integer.MAX_VALUE;
        this.field_72742_B = Integer.MIN_VALUE;
        this.field_72743_C = Integer.MIN_VALUE;
        this.field_72737_D = Integer.MIN_VALUE;
        int n4 = this.field_72766_m * 16;
        int n5 = n4 / 2;
        for (int i = 0; i < this.field_72766_m; ++i) {
            int n6 = i * 16;
            int n7 = n6 + n5 - n;
            if (n7 < 0) {
                n7 -= n4 - 1;
            }
            if ((n6 -= (n7 /= n4) * n4) < this.field_72780_y) {
                this.field_72780_y = n6;
            }
            if (n6 > this.field_72742_B) {
                this.field_72742_B = n6;
            }
            for (int j = 0; j < this.field_72764_o; ++j) {
                int n8 = j * 16;
                int n9 = n8 + n5 - n3;
                if (n9 < 0) {
                    n9 -= n4 - 1;
                }
                if ((n8 -= (n9 /= n4) * n4) < this.field_72741_A) {
                    this.field_72741_A = n8;
                }
                if (n8 > this.field_72737_D) {
                    this.field_72737_D = n8;
                }
                for (int k = 0; k < this.field_72763_n; ++k) {
                    int n10 = k * 16;
                    if (n10 < this.field_72779_z) {
                        this.field_72779_z = n10;
                    }
                    if (n10 > this.field_72743_C) {
                        this.field_72743_C = n10;
                    }
                    WorldRenderer worldRenderer = this.field_72765_l[(j * this.field_72763_n + k) * this.field_72766_m + i];
                    boolean bl = worldRenderer.field_78939_q;
                    worldRenderer.func_78913_a(n6, n10, n8);
                    if (!worldRenderer.field_78915_A) {
                        worldRenderer.field_78935_u = false;
                        worldRenderer.field_78936_t = false;
                    }
                    if (bl || !worldRenderer.field_78939_q) continue;
                    this.field_72767_j.add(worldRenderer);
                }
            }
        }
        worker.run(true);
    }

    private static int fixPos(int n, int n2) {
        int n3 = MathHelper.func_76137_a((int)n, (int)16) % n2;
        return n3 + (n2 & n3 >> 31);
    }

    private WorldRenderer getRenderer(int n, int n2, int n3) {
        if (n2 - 15 > this.field_72743_C | n2 < this.field_72779_z) {
            return null;
        }
        if (n - 15 > this.field_72742_B | n < this.field_72780_y) {
            return null;
        }
        if (n3 - 15 > this.field_72737_D | n3 < this.field_72741_A) {
            return null;
        }
        n = RenderGlobal.fixPos(n, this.field_72766_m);
        n2 = RenderGlobal.fixPos(n2, this.field_72763_n);
        n3 = RenderGlobal.fixPos(n3, this.field_72764_o);
        return this.field_72765_l[(n3 * this.field_72763_n + n2) * this.field_72766_m + n];
    }

    private WorldRenderer getRenderer(double d, double d2, double d3) {
        int n = MathHelper.func_76128_c((double)d);
        int n2 = MathHelper.func_76128_c((double)d2);
        int n3 = MathHelper.func_76128_c((double)d3);
        return this.getRenderer(n, n2, n3);
    }

    private static enum RenderPosition {
        DOWN(EnumFacing.DOWN, 0, -1, 0),
        UP(EnumFacing.UP, 0, 16, 0),
        WEST(EnumFacing.WEST, -1, 0, 0),
        EAST(EnumFacing.EAST, 16, 0, 0),
        NORTH(EnumFacing.NORTH, 0, 0, -1),
        SOUTH(EnumFacing.SOUTH, 0, 0, 16),
        NONE(null, 0, 0, 0),
        NONE_opp(null, 0, 0, 0);

        public static final RenderPosition[] POSITIONS;
        public static final RenderPosition[][] POSITIONS_BIAS;
        public static final RenderPosition[] FROM_FACING;
        public static final List<RenderPosition> SIDES;
        public final int x;
        public final int y;
        public final int z;
        public final EnumFacing facing;
        private final int _x;
        private final int _y;
        private final int _z;

        private RenderPosition(EnumFacing enumFacing, int n2, int n3, int n4) {
            this.facing = enumFacing;
            this.x = n2;
            this.y = n3;
            this.z = n4;
            this._x = n2 > 0 ? 1 : n2;
            this._y = n3 > 0 ? 1 : n3;
            this._z = n4 > 0 ? 1 : n4;
        }

        public RenderPosition getOpposite() {
            return POSITIONS[this.ordinal() ^ 1];
        }

        public static RenderPosition getBackFacingFromVector(EntityLivingBase entityLivingBase) {
            float f = entityLivingBase.field_70125_A;
            float f2 = entityLivingBase.field_70177_z;
            if (Minecraft.func_71410_x().field_71474_y.field_74320_O == 2) {
                f += 180.0f;
            }
            float f3 = MathHelper.func_76134_b((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
            float f4 = MathHelper.func_76126_a((float)(-f2 * ((float)Math.PI / 180) - (float)Math.PI));
            float f5 = -MathHelper.func_76134_b((float)(-f * ((float)Math.PI / 180)));
            float f6 = MathHelper.func_76126_a((float)(-f * ((float)Math.PI / 180)));
            float f7 = f4 * f5;
            float f8 = f6;
            float f9 = f3 * f5;
            RenderPosition renderPosition = NORTH;
            f2 = Float.MIN_VALUE;
            for (RenderPosition renderPosition2 : RenderPosition.values()) {
                float f10 = f7 * (float)(-renderPosition2._x) + f8 * (float)(-renderPosition2._y) + f9 * (float)(-renderPosition2._z);
                if (!(f10 > f2)) continue;
                f2 = f10;
                renderPosition = renderPosition2;
            }
            return renderPosition;
        }

        static {
            POSITIONS = RenderPosition.values();
            POSITIONS_BIAS = new RenderPosition[6][6];
            FROM_FACING = new RenderPosition[6];
            SIDES = Arrays.asList(POSITIONS).subList(1, 6);
            block5: for (int i = 0; i < 6; ++i) {
                RenderPosition renderPosition;
                RenderPosition.FROM_FACING[renderPosition.facing.ordinal()] = renderPosition = POSITIONS[i];
                RenderPosition[] renderPositionArray = POSITIONS_BIAS[i];
                int n = 0;
                int n2 = renderPosition.ordinal() & 1;
                switch (renderPosition) {
                    case DOWN: 
                    case UP: {
                        renderPositionArray[n++] = renderPosition;
                        renderPositionArray[n++] = POSITIONS[NORTH.ordinal() ^ n2];
                        renderPositionArray[n++] = POSITIONS[SOUTH.ordinal() ^ n2];
                        renderPositionArray[n++] = POSITIONS[EAST.ordinal() ^ n2];
                        renderPositionArray[n++] = POSITIONS[WEST.ordinal() ^ n2];
                        renderPositionArray[n++] = renderPosition.getOpposite();
                        continue block5;
                    }
                    case WEST: 
                    case EAST: {
                        renderPositionArray[n++] = renderPosition;
                        renderPositionArray[n++] = POSITIONS[NORTH.ordinal() ^ n2];
                        renderPositionArray[n++] = POSITIONS[SOUTH.ordinal() ^ n2];
                        renderPositionArray[n++] = POSITIONS[UP.ordinal() ^ n2];
                        renderPositionArray[n++] = POSITIONS[DOWN.ordinal() ^ n2];
                        renderPositionArray[n++] = renderPosition.getOpposite();
                        continue block5;
                    }
                    case NORTH: 
                    case SOUTH: {
                        renderPositionArray[n++] = renderPosition;
                        renderPositionArray[n++] = POSITIONS[EAST.ordinal() ^ n2];
                        renderPositionArray[n++] = POSITIONS[WEST.ordinal() ^ n2];
                        renderPositionArray[n++] = POSITIONS[UP.ordinal() ^ n2];
                        renderPositionArray[n++] = POSITIONS[DOWN.ordinal() ^ n2];
                        renderPositionArray[n++] = renderPosition.getOpposite();
                        continue block5;
                    }
                }
            }
        }
    }

    public static class RenderWorker {
        private static VisGraph DUMMY = new VisGraph();
        public volatile boolean dirty = false;
        private ArrayDeque<CullInfo> queue = new ArrayDeque();
        private Frustrum fStack = new Frustrum();
        private IdentityHashMap<WorldRenderer, CullInfo> log = new IdentityHashMap();
        private WorldClient theWorld;
        private ClientChunk[] chunkArray = null;
        private RenderGlobal render;

        public void setWorld(RenderGlobal renderGlobal, WorldClient worldClient) {
            this.render = renderGlobal;
            this.theWorld = worldClient;
        }

        public void run(boolean bl) {
            block20: {
                Object object;
                int n;
                Object object2;
                int n2;
                int n3;
                ClientChunk[] clientChunkArray;
                int n4;
                int n5;
                ArrayDeque<CullInfo> arrayDeque;
                int n6;
                int n7;
                WorldClient worldClient;
                RenderPosition renderPosition;
                EntityLivingBase entityLivingBase;
                block21: {
                    WorldRenderer worldRenderer;
                    int n8;
                    block18: {
                        int n9;
                        block19: {
                            ClientChunk[] clientChunkArray2;
                            if (this.render == null || this.render.field_72777_q == null) {
                                return;
                            }
                            entityLivingBase = ((RenderGlobal)this.render).field_72777_q.field_71451_h;
                            if (this.theWorld == null || entityLivingBase == null) {
                                return;
                            }
                            if (!CoFHTweaks.canHaveWorld()) {
                                FMLLog.bigWarning((String)"World exists prior to starting the server!", (Object[])new Object[0]);
                                return;
                            }
                            this.theWorld.field_72984_F.func_76320_a("prep");
                            WorldRenderer[] worldRendererArray = this.render.field_72768_k;
                            int n10 = this.render.field_72751_K;
                            for (int i = 0; i < n10; ++i) {
                                worldRendererArray[i].field_78936_t = false;
                            }
                            this.render.field_72751_K = 0;
                            renderPosition = RenderPosition.getBackFacingFromVector(entityLivingBase);
                            worldClient = this.theWorld;
                            n7 = this.render.field_72739_F;
                            n6 = n7 * 2 + 1;
                            arrayDeque = this.queue;
                            n5 = MathHelper.func_76128_c((double)entityLivingBase.field_70165_t);
                            n4 = MathHelper.func_76128_c((double)(entityLivingBase.field_70163_u + (double)entityLivingBase.func_70047_e()));
                            n8 = MathHelper.func_76128_c((double)entityLivingBase.field_70161_v);
                            worldClient.field_72984_F.func_76318_c("gather_chunks");
                            n9 = ++n6 * n6--;
                            if (this.chunkArray == null || this.chunkArray.length != n9) {
                                this.chunkArray = new ClientChunk[n9];
                                clientChunkArray2 = this.chunkArray;
                            } else {
                                clientChunkArray2 = this.chunkArray;
                            }
                            clientChunkArray = clientChunkArray2;
                            n3 = (n5 >> 4) - n7 - 1;
                            n2 = (n8 >> 4) - n7 - 1;
                            for (int i = 0; i <= n6; ++i) {
                                int n11 = i * n6;
                                for (int j = 0; j <= n6; ++j) {
                                    Chunk chunk = worldClient.func_72964_e(i + n3, j + n2);
                                    clientChunkArray[n11 + j] = chunk instanceof ClientChunk ? (ClientChunk)chunk : null;
                                }
                            }
                            worldClient.field_72984_F.func_76318_c("seed_queue");
                            worldRenderer = this.render.getRenderer(n5, n4, n8);
                            if (worldRenderer != null) break block18;
                            n9 = n4 > 5 ? 250 : 5;
                            worldRenderer = this.render.getRenderer(n5, n9, n8);
                            if (worldRenderer != null) break block19;
                            this.dirty = false;
                            break block20;
                        }
                        object2 = n4 < 5 ? RenderPosition.UP : RenderPosition.DOWN;
                        ClientChunk clientChunk = RenderWorker.getChunk(clientChunkArray, worldRenderer, n3, n2, n6);
                        CullInfo cullInfo = new CullInfo(worldRenderer, clientChunk == null ? DUMMY : clientChunk.visibility[worldRenderer.field_78920_d >> 4], (RenderPosition)((Object)object2), -2);
                        cullInfo.facings.addAll(RenderPosition.SIDES);
                        cullInfo.facings.remove(object2);
                        this.log.put(worldRenderer, cullInfo);
                        arrayDeque.add(cullInfo);
                        boolean bl2 = false;
                        worldClient.field_72984_F.func_76320_a("gather_world");
                        int n12 = 1;
                        while (!bl2) {
                            bl2 = true;
                            int n13 = 0;
                            int n14 = n12;
                            while (n13 < n12) {
                                for (int i = 0; i < 4; ++i) {
                                    int n15 = (i & 1) == 0 ? -1 : 1;
                                    worldRenderer = this.render.getRenderer(n5 + n13 * 16 * n15, n9, n8 + n14 * 16 * (n = (i & 2) == 0 ? -1 : 1));
                                    if (worldRenderer == null) continue;
                                    bl2 = false;
                                    ClientChunk clientChunk2 = RenderWorker.getChunk(clientChunkArray, worldRenderer, n3, n2, n6);
                                    object = new CullInfo(worldRenderer, clientChunk2 == null ? DUMMY : clientChunk2.visibility[worldRenderer.field_78920_d >> 4], (RenderPosition)((Object)object2), -2);
                                    ((CullInfo)object).facings.addAll(RenderPosition.SIDES);
                                    ((CullInfo)object).facings.remove(object2);
                                    this.log.put(worldRenderer, (CullInfo)object);
                                    arrayDeque.add((CullInfo)object);
                                }
                                ++n13;
                                --n14;
                            }
                            ++n12;
                        }
                        worldClient.field_72984_F.func_76319_b();
                        break block21;
                    }
                    ClientChunk clientChunk = RenderWorker.getChunk(clientChunkArray, worldRenderer, n3, n2, n6);
                    object2 = clientChunk != null ? clientChunk.visibility[worldRenderer.field_78920_d >> 4] : DUMMY;
                    this.markRenderer(worldRenderer, entityLivingBase, (VisGraph)object2);
                    Object object3 = new CullInfo(worldRenderer, (VisGraph)object2, renderPosition, (n7 >> 1) * -1 - 3);
                    ((CullInfo)object3).facings.remove((Object)renderPosition);
                    this.log.put(worldRenderer, (CullInfo)object3);
                    object3 = ((VisGraph)object2).getVisibleFacingsFrom(n5, n4, n8);
                    RenderPosition[] renderPositionArray = RenderPosition.POSITIONS_BIAS[renderPosition.ordinal()];
                    for (int i = 0; i < 6; ++i) {
                        WorldRenderer worldRenderer2;
                        RenderPosition renderPosition2 = renderPositionArray[i];
                        if (!object3.contains(renderPosition2.facing) || (worldRenderer2 = this.render.getRenderer(worldRenderer.field_78923_c + renderPosition2.x, worldRenderer.field_78920_d + renderPosition2.y, worldRenderer.field_78921_e + renderPosition2.z)) == null) continue;
                        clientChunk = RenderWorker.getChunk(clientChunkArray, worldRenderer2, n3, n2, n6);
                        CullInfo cullInfo = new CullInfo(worldRenderer2, clientChunk == null ? DUMMY : clientChunk.visibility[worldRenderer2.field_78920_d >> 4], renderPosition2, (n7 >> 1) * -1 - 2);
                        cullInfo.facings.remove((Object)renderPosition2);
                        this.log.put(worldRenderer2, cullInfo);
                        arrayDeque.add(cullInfo);
                    }
                }
                worldClient.field_72984_F.func_76318_c("process_queue");
                if (!arrayDeque.isEmpty()) {
                    CullInfo cullInfo;
                    n4 = n5 = arrayDeque.size();
                    IdentityHashMap<WorldRenderer, CullInfo> identityHashMap = this.log;
                    RenderGlobal renderGlobal = this.render;
                    object2 = RenderPosition.POSITIONS_BIAS[renderPosition.ordinal() ^ 1];
                    while (!arrayDeque.isEmpty() && (cullInfo = arrayDeque.pollFirst()) != null) {
                        cullInfo.visited = true;
                        if (cullInfo.count > n7) continue;
                        WorldRenderer worldRenderer = cullInfo.rend;
                        ClientChunk clientChunk = RenderWorker.getChunk(clientChunkArray, worldRenderer, n3, n2, n6);
                        VisGraph visGraph = clientChunk != null ? clientChunk.visibility[worldRenderer.field_78920_d >> 4] : DUMMY;
                        RenderPosition renderPosition3 = cullInfo.last;
                        this.markRenderer(worldRenderer, entityLivingBase, visGraph);
                        SetVisibility setVisibility = visGraph.getVisibility();
                        n = setVisibility.isAllVisible(true) ? 1 : 0;
                        for (int i = 0; i < 6; ++i) {
                            ClientChunk clientChunk3;
                            CullInfo cullInfo2;
                            object = object2[i];
                            if (object == renderPosition3 || cullInfo.facings.contains(object) || n == 0 && !setVisibility.isVisible(renderPosition3.facing, ((RenderPosition)((Object)object)).facing)) continue;
                            cullInfo.facings.add((RenderPosition)((Object)object));
                            WorldRenderer worldRenderer3 = renderGlobal.getRenderer(worldRenderer.field_78923_c + ((RenderPosition)((Object)object)).x, worldRenderer.field_78920_d + ((RenderPosition)((Object)object)).y, worldRenderer.field_78921_e + ((RenderPosition)((Object)object)).z);
                            if (worldRenderer3 == null) continue;
                            ++n4;
                            int n16 = 1;
                            if (object == renderPosition) {
                                n16 += n7;
                            }
                            if ((cullInfo2 = identityHashMap.get(worldRenderer3)) != null && (cullInfo2.facings.contains(object) || !cullInfo2.visited && cullInfo2.vis.getVisibility().isVisible(((RenderPosition)((Object)object)).facing, cullInfo2.last.facing))) continue;
                            if ((worldRenderer3.field_78935_u | n) != 0) {
                                n16 -= n7 >> 1;
                                n16 &= ~n16 >> 31;
                            }
                            ++n5;
                            VisGraph visGraph2 = cullInfo2 == null ? ((clientChunk3 = worldRenderer3.field_78923_c != worldRenderer.field_78923_c | worldRenderer3.field_78921_e != worldRenderer.field_78921_e ? RenderWorker.getChunk(clientChunkArray, worldRenderer3, n3, n2, n6) : clientChunk) == null ? DUMMY : clientChunk3.visibility[worldRenderer3.field_78920_d >> 4]) : cullInfo2.vis;
                            CullInfo cullInfo3 = new CullInfo(worldRenderer3, visGraph2, (RenderPosition)((Object)object), cullInfo.count + n16);
                            if (cullInfo2 != null) {
                                cullInfo3.facings.addAll(cullInfo2.facings);
                            }
                            identityHashMap.put(worldRenderer3, cullInfo3);
                            arrayDeque.add(cullInfo3);
                        }
                    }
                }
                worldClient.field_72984_F.func_76318_c("cleanup");
                arrayDeque.clear();
                this.log.clear();
            }
            this.dirty = false;
            this.theWorld.field_72984_F.func_76319_b();
        }

        private void markRenderer(WorldRenderer worldRenderer, EntityLivingBase entityLivingBase, VisGraph visGraph) {
            if (!worldRenderer.field_78936_t) {
                worldRenderer.field_78936_t = true;
                if (!worldRenderer.field_78935_u) {
                    ((RenderGlobal)this.render).field_72768_k[((RenderGlobal)this.render).field_72751_K++] = worldRenderer;
                }
            }
            if (!worldRenderer.field_78915_A | worldRenderer.field_78939_q || visGraph.isRenderDirty()) {
                worldRenderer.field_78939_q = true;
                if (!worldRenderer.field_78915_A || worldRenderer.field_78939_q && worldRenderer.func_78912_a((Entity)entityLivingBase) <= 1128.0f) {
                    this.render.workerWorldRenderers.push(worldRenderer);
                }
            }
        }

        private static ClientChunk getChunk(ClientChunk[] clientChunkArray, WorldRenderer worldRenderer, int n, int n2, int n3) {
            int n4;
            int n5 = (worldRenderer.field_78923_c >> 4) - n;
            if (n5 < 0 | (n4 = (worldRenderer.field_78921_e >> 4) - n2) < 0 | n5 > n3 | n4 > n3) {
                return null;
            }
            return clientChunkArray[n5 * n3 + n4];
        }

        static {
            DUMMY.computeVisibility();
        }

        private static class CullInfo {
            boolean visited = false;
            final int count;
            final WorldRenderer rend;
            final VisGraph vis;
            final RenderPosition last;
            final EnumSet<RenderPosition> facings;

            public CullInfo(WorldRenderer worldRenderer, VisGraph visGraph, RenderPosition renderPosition, int n) {
                this.count = n;
                this.rend = worldRenderer;
                this.vis = visGraph;
                this.last = renderPosition.getOpposite();
                this.facings = EnumSet.of(this.last);
            }
        }
    }
}

