/*
 * Decompiled with CFR 0.152.
 */
package cofh.tweak.asmhooks.world;

import cofh.repack.cofh.lib.util.LinkedHashList;
import cofh.repack.cofh.lib.util.SynchronizedIdentityLinkedHashList;
import cofh.repack.net.minecraft.client.renderer.chunk.SetVisibility;
import cofh.repack.net.minecraft.client.renderer.chunk.VisGraph;
import cofh.tweak.CoFHTweaks;
import cofh.tweak.asmhooks.render.RenderGlobal;
import cpw.mods.fml.common.FMLLog;
import net.minecraft.block.Block;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class ClientChunk
extends Chunk {
    private static ChunkThread worker = new ChunkThread();
    public VisGraph[] visibility = new VisGraph[16];

    private static void init(VisGraph[] visGraphArray) {
        for (int i = 0; i < 16; ++i) {
            visGraphArray[i] = new VisGraph();
        }
        if (!CoFHTweaks.canHaveWorld()) {
            FMLLog.bigWarning((String)"World exists prior to starting the server!", (Object[])new Object[0]);
        }
    }

    public ClientChunk(World world, int n, int n2) {
        super(world, n, n2);
        ClientChunk.init(this.visibility);
    }

    public ClientChunk(World world, Block[] blockArray, int n, int n2) {
        super(world, blockArray, n, n2);
        ClientChunk.init(this.visibility);
    }

    public ClientChunk(World world, Block[] blockArray, byte[] byArray, int n, int n2) {
        super(world, blockArray, byArray, n, n2);
        ClientChunk.init(this.visibility);
    }

    boolean checkPosSolid(int n, int n2, int n3, Block block) {
        if (n2 > 255 || n2 < 0) {
            return false;
        }
        if (block == null) {
            block = this.func_150810_a(n, n2, n3);
        }
        VisGraph visGraph = this.visibility[n2 >> 4];
        visGraph.setOpaque(n, n2 &= 0xF, n3, block.func_149662_c());
        return visGraph.isDirty();
    }

    public boolean func_150807_a(int n, int n2, int n3, Block block, int n4) {
        boolean bl = super.func_150807_a(n, n2, n3, block, n4);
        if (bl && this.checkPosSolid(n & 0xF, n2, n3 & 0xF, block)) {
            ClientChunk.worker.modified.add(this);
        }
        return bl;
    }

    public void func_76607_a(byte[] byArray, int n, int n2, boolean bl) {
        super.func_76607_a(byArray, n, n2, bl);
        ClientChunk.worker.loaded.add(this);
    }

    ClientChunk buildSides() {
        if (!this.field_76637_e.func_72916_c(this.field_76635_g, this.field_76647_h)) {
            return null;
        }
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                for (int k = 0; k < 256; ++k) {
                    this.checkPosSolid(i, k, j, null);
                }
            }
        }
        RenderGlobal.updateArea(this.field_76635_g * 16 - 1, 0, this.field_76647_h * 16 - 1, this.field_76635_g * 16 + 16, 255, this.field_76647_h * 16 + 16);
        return this;
    }

    static {
        worker.start();
    }

    private static class ChunkThread
    extends Thread {
        public LinkedHashList<ClientChunk> loaded = new SynchronizedIdentityLinkedHashList<ClientChunk>();
        public LinkedHashList<ClientChunk> modified = new SynchronizedIdentityLinkedHashList<ClientChunk>();

        public ChunkThread() {
            super("Chunk Worker");
        }

        @Override
        public void run() {
            while (true) {
                ClientChunk clientChunk;
                int n = 0;
                boolean bl = false;
                while (this.loaded.size() > 0) {
                    clientChunk = this.loaded.shift().buildSides();
                    if (clientChunk != null) {
                        this.modified.add(clientChunk);
                        bl = true;
                    }
                    if ((n & 3) == 0) {
                        ChunkThread.yield();
                    }
                    ++n;
                }
                n = 0;
                while (this.modified.size() > 0) {
                    clientChunk = this.modified.shift();
                    if (!this.loaded.contains((Object)clientChunk)) {
                        for (VisGraph visGraph : clientChunk.visibility) {
                            if (!visGraph.isDirty()) continue;
                            SetVisibility setVisibility = visGraph.getVisibility();
                            visGraph.computeVisibility();
                            bl |= !setVisibility.equals(visGraph.getVisibility());
                        }
                        if ((n & 7) == 0) {
                            ChunkThread.yield();
                        }
                    }
                    ++n;
                }
                RenderGlobal.worker.dirty = bl;
                try {
                    Thread.sleep(30L);
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    }
}

