/*
 * Decompiled with CFR 0.152.
 */
package cofh.tweak.util;

import cofh.repack.java.util.ShiftingBitSet;
import cofh.tweak.util.maps.ObjectIntHashBiMap;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.apache.commons.lang3.ClassUtils;

public class ClassInheritenceArrayList<E>
extends ArrayList<E> {
    private static final long serialVersionUID = 693698853710457585L;
    private static final IdentityHashMap<Class<?>, BitSet> classMapping = new IdentityHashMap();
    private static final ObjectIntHashBiMap<Class<?>> classIds = new ObjectIntHashBiMap<Class<?>>(32){

        @Override
        protected final boolean equal(Object object, Object object2) {
            return object == object2;
        }
    };
    private int size;
    private BitSet containedClasses = new BitSet();
    private TIntObjectHashMap<ShiftingBitSet> classIndexes = new TIntObjectHashMap();
    private static final Field superElementData;
    private transient Object[] elementData;

    private static synchronized void compileClass(Class<?> clazz) {
        BitSet bitSet = new BitSet();
        bitSet.set(classIds.putIfAbsent(clazz, classIds.size()));
        int n = classIds.size();
        for (Class clazz2 : ClassUtils.hierarchy(clazz, (ClassUtils.Interfaces)ClassUtils.Interfaces.INCLUDE)) {
            int n2 = classIds.putIfAbsent(clazz2, n);
            if (n2 == n) {
                ClassInheritenceArrayList.compileClass(clazz2);
                n = classIds.size();
            }
            if (clazz2 == clazz) continue;
            bitSet.or(classMapping.get(clazz2));
            if (clazz2.isInterface()) continue;
            break;
        }
        classMapping.put(clazz, bitSet);
    }

    public ClassInheritenceArrayList() {
        this(8);
    }

    public ClassInheritenceArrayList(int n) {
        this.elementData = new Object[n];
        this.setSuperElementData();
    }

    public ClassInheritenceArrayList(Collection<? extends E> collection) {
        this(collection.size());
        this.addAll(collection);
    }

    private void addClasses(int n, Class<?> clazz) {
        if (!classIds.containsKey(clazz)) {
            ClassInheritenceArrayList.compileClass(clazz);
        }
        BitSet bitSet = classMapping.get(clazz);
        this.containedClasses.or(bitSet);
        int n2 = -1;
        while (true) {
            ++n2;
            if ((n2 = bitSet.nextSetBit(n2)) < 0) break;
            ShiftingBitSet shiftingBitSet = (ShiftingBitSet)this.classIndexes.get(n2);
            if (shiftingBitSet == null) {
                shiftingBitSet = new ShiftingBitSet();
                this.classIndexes.put(n2, (Object)shiftingBitSet);
            }
            shiftingBitSet.set(n);
        }
    }

    private void removeClasses(int n, Class<?> clazz) {
        BitSet bitSet = classMapping.get(clazz);
        int n2 = -1;
        while (true) {
            ++n2;
            if ((n2 = bitSet.nextSetBit(n2)) < 0) break;
            ShiftingBitSet shiftingBitSet = (ShiftingBitSet)this.classIndexes.get(n2);
            shiftingBitSet.clear(n);
            if (shiftingBitSet.cardinality() != 0) continue;
            this.classIndexes.remove(n2);
            this.containedClasses.clear(n2);
        }
    }

    @Override
    public boolean add(E e) {
        this.addClasses(this.size(), Preconditions.checkNotNull(e, (Object)"element cannot be null").getClass());
        this.ensureCapacity(this.size + 1);
        this.elementData[this.size++] = e;
        return true;
    }

    @Override
    public void add(int n, E e) {
        this.RangeCheck(n, false);
        if (n != this.size()) {
            int n2 = -1;
            while (true) {
                ++n2;
                if ((n2 = this.containedClasses.nextSetBit(n2)) < 0) break;
                ShiftingBitSet shiftingBitSet = (ShiftingBitSet)this.classIndexes.get(n2);
                if (shiftingBitSet.nextSetBit(n) < n) continue;
                shiftingBitSet.shiftRight(n);
            }
        }
        this.addClasses(n, Preconditions.checkNotNull(e, (Object)"element cannot be null").getClass());
        this.ensureCapacity(this.size + 1);
        if (n < this.size) {
            System.arraycopy(this.elementData, n, this.elementData, n + 1, this.size - n);
        }
        this.elementData[n] = e;
        ++this.size;
    }

    @Override
    public E set(int n, E e) {
        this.RangeCheck(n, true);
        Preconditions.checkNotNull(e, (Object)"element cannot be null");
        Object object = this.elementData[n];
        this.removeClasses(n, object.getClass());
        this.elementData[n] = e;
        this.addClasses(n, e.getClass());
        return (E)object;
    }

    @Override
    public E remove(int n) {
        this.RangeCheck(n, true);
        return this.internalRemove(n);
    }

    @Override
    public boolean remove(Object object) {
        int n;
        int n2 = n = object == null ? 0 : classIds.get(object.getClass());
        if (!this.containedClasses.get(n)) {
            return false;
        }
        int n3 = this.size();
        if (object == null) {
            for (int i = 0; i < n3; ++i) {
                if (this.elementData[i] != null) continue;
                this.internalRemove(i);
                return true;
            }
        } else {
            for (int i = 0; i < n3; ++i) {
                if (!object.equals(this.elementData[i])) continue;
                this.internalRemove(i);
                return true;
            }
        }
        return false;
    }

    private E internalRemove(int n) {
        ++this.modCount;
        Object object = this.elementData[n];
        int n2 = this.size - n - 1;
        if (n2 > 0) {
            System.arraycopy(this.elementData, n + 1, this.elementData, n, n2);
        }
        this.elementData[--this.size] = null;
        this.removeClasses(n, object.getClass());
        if (n != this.size()) {
            int n3 = -1;
            while (true) {
                ++n3;
                if ((n3 = this.containedClasses.nextSetBit(n3)) < 0) break;
                ShiftingBitSet shiftingBitSet = (ShiftingBitSet)this.classIndexes.get(n3);
                if (shiftingBitSet.nextSetBit(n) < n) continue;
                shiftingBitSet.shiftLeft(n);
            }
        }
        return (E)object;
    }

    public <T> Iterator<T> getIteratorFor(Class<?> clazz) {
        int n = classIds.get(clazz);
        if (this.containedClasses.get(n)) {
            return new Itr((ShiftingBitSet)this.classIndexes.get(n));
        }
        return null;
    }

    @Override
    public int indexOf(Object object) {
        int n;
        int n2 = n = object == null ? 0 : classIds.get(object.getClass());
        if (!this.containedClasses.get(n)) {
            return -1;
        }
        int n3 = this.size();
        if (object == null) {
            for (int i = 0; i < n3; ++i) {
                if (this.elementData[i] != null) continue;
                return i;
            }
        } else {
            for (int i = 0; i < n3; ++i) {
                if (!object.equals(this.elementData[i])) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object object) {
        int n;
        int n2 = n = object == null ? 0 : classIds.get(object.getClass());
        if (!this.containedClasses.get(n)) {
            return -1;
        }
        int n3 = this.size();
        if (object == null) {
            for (int i = n3 - 1; i >= 0; --i) {
                if (this.elementData[i] != null) continue;
                return i;
            }
        } else {
            for (int i = n3 - 1; i >= 0; --i) {
                if (!object.equals(this.elementData[i])) continue;
                return i;
            }
        }
        return -1;
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        if (collection.size() == 0) {
            return false;
        }
        boolean bl = false;
        for (E e : collection) {
            bl |= this.add(e);
        }
        return bl;
    }

    @Override
    public boolean addAll(int n, Collection<? extends E> collection) {
        if (collection.size() == 0) {
            return false;
        }
        for (E e : collection) {
            this.add(n++, e);
        }
        return true;
    }

    private void RangeCheck(int n, boolean bl) {
        int n2;
        if (n < 0 | n > (n2 = this.size()) | bl & n == n2) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + n2);
        }
    }

    private final void setSuperElementData() {
        try {
            superElementData.set(this, this.elementData);
        }
        catch (Exception exception) {
            Throwables.propagate((Throwable)exception);
        }
    }

    @Override
    public Object[] toArray() {
        return Arrays.copyOf(this.elementData, this.size);
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        if (TArray.length < this.size) {
            return Arrays.copyOf(this.elementData, this.size, TArray.getClass());
        }
        System.arraycopy(this.elementData, 0, TArray, 0, this.size);
        if (TArray.length > this.size) {
            TArray[this.size] = null;
        }
        return TArray;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public void clear() {
        ++this.modCount;
        for (int i = 0; i < this.size; ++i) {
            this.elementData[i] = null;
        }
        this.size = 0;
    }

    @Override
    public void trimToSize() {
        ++this.modCount;
        int n = this.elementData.length;
        if (this.size < n) {
            this.elementData = Arrays.copyOf(this.elementData, this.size);
            this.setSuperElementData();
        }
    }

    @Override
    public E get(int n) {
        this.RangeCheck(n, true);
        return (E)this.elementData[n];
    }

    @Override
    public void ensureCapacity(int n) {
        ++this.modCount;
        int n2 = this.elementData.length;
        if (n > n2) {
            int n3 = n2 * 3 / 2 + 1;
            if (n3 < n) {
                n3 = n;
            }
            this.elementData = Arrays.copyOf(this.elementData, n3);
            this.setSuperElementData();
        }
    }

    @Override
    protected void removeRange(int n, int n2) {
        ++this.modCount;
        int n3 = this.size - n2;
        System.arraycopy(this.elementData, n2, this.elementData, n, n3);
        int n4 = this.size - (n2 - n);
        while (this.size != n4) {
            this.elementData[--this.size] = null;
        }
    }

    @Override
    public Iterator<E> iterator() {
        return new Itr1();
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<E> listIterator(int n) {
        this.RangeCheck(n, false);
        return new ListItr(n);
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        return this.batchRemove((Collection)Preconditions.checkNotNull(collection), false);
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        return this.batchRemove((Collection)Preconditions.checkNotNull(collection), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean batchRemove(Collection<?> collection, boolean bl) {
        boolean bl2;
        int n;
        block8: {
            int n2;
            Object[] objectArray = this.elementData;
            n = 0;
            bl2 = false;
            try {
                for (n2 = 0; n2 < this.size; ++n2) {
                    if (collection.contains(objectArray[n2]) != bl) continue;
                    objectArray[n++] = objectArray[n2];
                }
                if (n2 == this.size) break block8;
            }
            catch (Throwable throwable) {
                if (n2 != this.size) {
                    System.arraycopy(objectArray, n2, objectArray, n, this.size - n2);
                    n += this.size - n2;
                }
                if (n != this.size) {
                    for (int i = n; i < this.size; ++i) {
                        objectArray[i] = null;
                    }
                    this.modCount += this.size - n;
                    this.size = n;
                    bl2 = true;
                }
                throw throwable;
            }
            System.arraycopy(objectArray, n2, objectArray, n, this.size - n2);
            n += this.size - n2;
        }
        if (n != this.size) {
            for (int i = n; i < this.size; ++i) {
                objectArray[i] = null;
            }
            this.modCount += this.size - n;
            this.size = n;
            bl2 = true;
        }
        return bl2;
    }

    @Override
    public Object clone() {
        ClassInheritenceArrayList classInheritenceArrayList = (ClassInheritenceArrayList)super.clone();
        for (Object object : this.elementData) {
            classInheritenceArrayList.add(object);
        }
        classInheritenceArrayList.modCount = 0;
        return classInheritenceArrayList;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        int n = this.modCount;
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.size());
        int n2 = this.size();
        for (int i = 0; i < n2; ++i) {
            objectOutputStream.writeObject(this.elementData[i]);
        }
        if (this.modCount != n) {
            throw new ConcurrentModificationException();
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        this.clear();
        this.trimToSize();
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        if (n > 0) {
            this.ensureCapacity(n);
            for (int i = 0; i < n; ++i) {
                this.add(objectInputStream.readObject());
            }
        }
    }

    static /* synthetic */ int access$000(ClassInheritenceArrayList classInheritenceArrayList) {
        return classInheritenceArrayList.modCount;
    }

    static /* synthetic */ int access$400(ClassInheritenceArrayList classInheritenceArrayList) {
        return classInheritenceArrayList.modCount;
    }

    static {
        classIds.put(null, 0);
        Object object = new BitSet();
        ((BitSet)object).set(0);
        classMapping.put(null, (BitSet)object);
        object = null;
        try {
            object = ArrayList.class.getDeclaredField("elementData");
            ((Field)object).setAccessible(true);
        }
        catch (Exception exception) {
            Throwables.propagate((Throwable)exception);
        }
        superElementData = object;
    }

    private class ListItr
    extends Itr1
    implements ListIterator<E> {
        ListItr(int n) {
            this.cursor = n;
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor != 0;
        }

        @Override
        public E previous() {
            this.checkForComodification();
            try {
                int n = this.cursor - 1;
                Object e = ClassInheritenceArrayList.this.get(n);
                this.lastRet = this.cursor = n;
                return e;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.checkForComodification();
                throw new NoSuchElementException();
            }
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        @Override
        public void set(E e) {
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            try {
                ClassInheritenceArrayList.this.set(this.lastRet, e);
                this.expectedModCount = ClassInheritenceArrayList.this.modCount;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public void add(E e) {
            this.checkForComodification();
            try {
                int n = this.cursor;
                ClassInheritenceArrayList.this.add(n, e);
                this.lastRet = -1;
                this.cursor = n + 1;
                this.expectedModCount = ClassInheritenceArrayList.this.modCount;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }
    }

    private class Itr1
    implements Iterator<E> {
        int cursor = 0;
        int lastRet = -1;
        int expectedModCount = ClassInheritenceArrayList.access$400(ClassInheritenceArrayList.this);

        private Itr1() {
        }

        @Override
        public boolean hasNext() {
            return this.cursor != ClassInheritenceArrayList.this.size();
        }

        @Override
        public E next() {
            this.checkForComodification();
            try {
                int n = this.cursor;
                Object e = ClassInheritenceArrayList.this.get(n);
                this.lastRet = n;
                this.cursor = n + 1;
                return e;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.checkForComodification();
                throw new NoSuchElementException();
            }
        }

        @Override
        public void remove() {
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            try {
                ClassInheritenceArrayList.this.remove(this.lastRet);
                if (this.lastRet < this.cursor) {
                    --this.cursor;
                }
                this.lastRet = -1;
                this.expectedModCount = ClassInheritenceArrayList.this.modCount;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }

        final void checkForComodification() {
            if (ClassInheritenceArrayList.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }

    private class Itr<T>
    implements Iterator<T> {
        final ShiftingBitSet cursor;
        int nextRet = -1;
        int lastRet = -1;
        int expectedModCount = ClassInheritenceArrayList.access$000(ClassInheritenceArrayList.this);
        boolean movedNext = false;

        public Itr(ShiftingBitSet shiftingBitSet) {
            this.cursor = shiftingBitSet;
        }

        @Override
        public boolean hasNext() {
            return this.nextRet > this.lastRet || (this.nextRet = this.cursor.nextSetBit(++this.nextRet)) > this.lastRet;
        }

        @Override
        public T next() {
            this.checkForComodification();
            try {
                this.lastRet = this.nextRet;
                Object e = ClassInheritenceArrayList.this.get(this.lastRet);
                this.movedNext = true;
                return (T)e;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                this.checkForComodification();
                throw new NoSuchElementException();
            }
        }

        @Override
        public void remove() {
            if (!this.movedNext) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            try {
                ClassInheritenceArrayList.this.remove(this.lastRet);
                this.movedNext = false;
                this.expectedModCount = ClassInheritenceArrayList.this.modCount;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }

        final void checkForComodification() {
            if (ClassInheritenceArrayList.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

