/*
 * Decompiled with CFR 0.152.
 */
package cofh.tweak.util;

import cofh.tweak.util.Vector3;
import java.math.RoundingMode;
import java.text.DecimalFormat;

public class Matrix4 {
    public float m00;
    public float m01;
    public float m02;
    public float m03;
    public float m10;
    public float m11;
    public float m12;
    public float m13;
    public float m20;
    public float m21;
    public float m22;
    public float m23;
    public float m30;
    public float m31;
    public float m32;
    public float m33;

    public Matrix4() {
        this.m33 = 1.0f;
        this.m22 = 1.0f;
        this.m11 = 1.0f;
        this.m00 = 1.0f;
    }

    public Matrix4(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, float f16) {
        this.m00 = f;
        this.m01 = f2;
        this.m02 = f3;
        this.m03 = f4;
        this.m10 = f5;
        this.m11 = f6;
        this.m12 = f7;
        this.m13 = f8;
        this.m20 = f9;
        this.m21 = f10;
        this.m22 = f11;
        this.m23 = f12;
        this.m30 = f13;
        this.m31 = f14;
        this.m32 = f15;
        this.m33 = f16;
    }

    public Matrix4(float[] fArray) {
        this.set(fArray);
    }

    public Matrix4(Matrix4 matrix4) {
        this.set(matrix4);
    }

    public Matrix4 setIdentity() {
        this.m33 = 1.0f;
        this.m22 = 1.0f;
        this.m11 = 1.0f;
        this.m00 = 1.0f;
        this.m32 = 0.0f;
        this.m31 = 0.0f;
        this.m30 = 0.0f;
        this.m23 = 0.0f;
        this.m21 = 0.0f;
        this.m20 = 0.0f;
        this.m13 = 0.0f;
        this.m12 = 0.0f;
        this.m10 = 0.0f;
        this.m03 = 0.0f;
        this.m02 = 0.0f;
        this.m01 = 0.0f;
        return this;
    }

    public Matrix4 orthogonal(float f, float f2, float f3, float f4, float f5, float f6) {
        this.setIdentity();
        this.transpose();
        this.m00 = 2.0f / (f2 - f);
        this.m11 = 2.0f / (f4 - f3);
        this.m22 = -2.0f / (f6 - f5);
        this.m32 = (f6 + f5) / (f6 - f5);
        this.m30 = (f2 + f) / (f2 - f);
        this.m31 = (f4 + f3) / (f4 - f3);
        this.transpose();
        return this;
    }

    public Matrix4 orthogonal(float f, float f2, float f3, float f4) {
        return this.orthogonal(-f, f, -f2, f2, f3, f4);
    }

    public Matrix4 orthogonal(float f, float f2, float f3) {
        return this.orthogonal(-f, f, -f, f, f2, f3);
    }

    public Matrix4 perspective(float f, float f2, float f3, float f4, float f5, float f6) {
        this.setIdentity();
        this.transpose();
        this.m00 = 2.0f * f5 / (f2 - f);
        this.m11 = 2.0f * f5 / (f4 - f3);
        this.m22 = -(f6 + f5) / (f6 - f5);
        this.m23 = -1.0f;
        this.m32 = -2.0f * f6 * f5 / (f6 - f5);
        this.m20 = (f2 + f) / (f2 - f);
        this.m21 = (f4 + f3) / (f4 - f3);
        this.m33 = 0.0f;
        this.transpose();
        return this;
    }

    public Matrix4 perspective(float f, float f2, float f3, float f4) {
        return this.perspective(-f, f, -f2, f2, f3, f4);
    }

    public Matrix4 perspective(float f, float f2, float f3) {
        return this.perspective(-f, f, -f, f, f2, f3);
    }

    public Matrix4 camera(Vector3 vector3) {
        Vector3 vector32 = vector3.clone().normalize();
        Vector3 vector33 = new Vector3(0.0f, 1.0f, 0.0f).crossProduct(vector32);
        Vector3 vector34 = vector32.clone().crossProduct(vector33).normalize();
        vector33.normalize();
        this.m00 = vector33.x;
        this.m01 = vector33.y;
        this.m02 = vector33.z;
        this.m03 = -vector33.dotProduct(vector3);
        this.m10 = vector34.x;
        this.m11 = vector34.y;
        this.m12 = vector34.z;
        this.m13 = -vector34.dotProduct(vector3);
        this.m20 = vector32.x;
        this.m21 = vector32.y;
        this.m22 = vector32.z;
        this.m23 = -vector32.dotProduct(vector3);
        this.m30 = 0.0f;
        this.m31 = 0.0f;
        this.m32 = 0.0f;
        this.m33 = 1.0f;
        return this;
    }

    public Matrix4 translate(Vector3 vector3) {
        this.m03 += this.m00 * vector3.x + this.m01 * vector3.y + this.m02 * vector3.z;
        this.m13 += this.m10 * vector3.x + this.m11 * vector3.y + this.m12 * vector3.z;
        this.m23 += this.m20 * vector3.x + this.m21 * vector3.y + this.m22 * vector3.z;
        this.m33 += this.m30 * vector3.x + this.m31 * vector3.y + this.m32 * vector3.z;
        return this;
    }

    public Matrix4 translate(float f, float f2, float f3) {
        this.m03 += this.m00 * f + this.m01 * f2 + this.m02 * f3;
        this.m13 += this.m10 * f + this.m11 * f2 + this.m12 * f3;
        this.m23 += this.m20 * f + this.m21 * f2 + this.m22 * f3;
        this.m33 += this.m30 * f + this.m31 * f2 + this.m32 * f3;
        return this;
    }

    public Matrix4 scale(Vector3 vector3) {
        this.m00 *= vector3.x;
        this.m10 *= vector3.x;
        this.m20 *= vector3.x;
        this.m30 *= vector3.x;
        this.m01 *= vector3.y;
        this.m11 *= vector3.y;
        this.m21 *= vector3.y;
        this.m31 *= vector3.y;
        this.m02 *= vector3.z;
        this.m12 *= vector3.z;
        this.m22 *= vector3.z;
        this.m32 *= vector3.z;
        return this;
    }

    public Matrix4 rotate(float f, Vector3 vector3) {
        float f2 = (float)Math.cos(f);
        float f3 = (float)Math.sin(f);
        float f4 = 1.0f - f2;
        float f5 = vector3.x * vector3.y;
        float f6 = vector3.y * vector3.z;
        float f7 = vector3.x * vector3.z;
        float f8 = vector3.x * f3;
        float f9 = vector3.y * f3;
        float f10 = vector3.z * f3;
        float f11 = vector3.x * vector3.x * f4 + f2;
        float f12 = f5 * f4 + f10;
        float f13 = f7 * f4 - f9;
        float f14 = f5 * f4 - f10;
        float f15 = vector3.y * vector3.y * f4 + f2;
        float f16 = f6 * f4 + f8;
        float f17 = f7 * f4 + f9;
        float f18 = f6 * f4 - f8;
        float f19 = vector3.z * vector3.z * f4 + f2;
        float f20 = this.m00 * f11 + this.m01 * f12 + this.m02 * f13;
        float f21 = this.m10 * f11 + this.m11 * f12 + this.m12 * f13;
        float f22 = this.m20 * f11 + this.m21 * f12 + this.m22 * f13;
        float f23 = this.m30 * f11 + this.m31 * f12 + this.m32 * f13;
        float f24 = this.m00 * f14 + this.m01 * f15 + this.m02 * f16;
        float f25 = this.m10 * f14 + this.m11 * f15 + this.m12 * f16;
        float f26 = this.m20 * f14 + this.m21 * f15 + this.m22 * f16;
        float f27 = this.m30 * f14 + this.m31 * f15 + this.m32 * f16;
        this.m02 = this.m00 * f17 + this.m01 * f18 + this.m02 * f19;
        this.m12 = this.m10 * f17 + this.m11 * f18 + this.m12 * f19;
        this.m22 = this.m20 * f17 + this.m21 * f18 + this.m22 * f19;
        this.m32 = this.m30 * f17 + this.m31 * f18 + this.m32 * f19;
        this.m00 = f20;
        this.m10 = f21;
        this.m20 = f22;
        this.m30 = f23;
        this.m01 = f24;
        this.m11 = f25;
        this.m21 = f26;
        this.m31 = f27;
        return this;
    }

    public Matrix4 leftMultiply(Matrix4 matrix4) {
        float f = this.m00 * matrix4.m00 + this.m10 * matrix4.m01 + this.m20 * matrix4.m02 + this.m30 * matrix4.m03;
        float f2 = this.m01 * matrix4.m00 + this.m11 * matrix4.m01 + this.m21 * matrix4.m02 + this.m31 * matrix4.m03;
        float f3 = this.m02 * matrix4.m00 + this.m12 * matrix4.m01 + this.m22 * matrix4.m02 + this.m32 * matrix4.m03;
        float f4 = this.m03 * matrix4.m00 + this.m13 * matrix4.m01 + this.m23 * matrix4.m02 + this.m33 * matrix4.m03;
        float f5 = this.m00 * matrix4.m10 + this.m10 * matrix4.m11 + this.m20 * matrix4.m12 + this.m30 * matrix4.m13;
        float f6 = this.m01 * matrix4.m10 + this.m11 * matrix4.m11 + this.m21 * matrix4.m12 + this.m31 * matrix4.m13;
        float f7 = this.m02 * matrix4.m10 + this.m12 * matrix4.m11 + this.m22 * matrix4.m12 + this.m32 * matrix4.m13;
        float f8 = this.m03 * matrix4.m10 + this.m13 * matrix4.m11 + this.m23 * matrix4.m12 + this.m33 * matrix4.m13;
        float f9 = this.m00 * matrix4.m20 + this.m10 * matrix4.m21 + this.m20 * matrix4.m22 + this.m30 * matrix4.m23;
        float f10 = this.m01 * matrix4.m20 + this.m11 * matrix4.m21 + this.m21 * matrix4.m22 + this.m31 * matrix4.m23;
        float f11 = this.m02 * matrix4.m20 + this.m12 * matrix4.m21 + this.m22 * matrix4.m22 + this.m32 * matrix4.m23;
        float f12 = this.m03 * matrix4.m20 + this.m13 * matrix4.m21 + this.m23 * matrix4.m22 + this.m33 * matrix4.m23;
        float f13 = this.m00 * matrix4.m30 + this.m10 * matrix4.m31 + this.m20 * matrix4.m32 + this.m30 * matrix4.m33;
        float f14 = this.m01 * matrix4.m30 + this.m11 * matrix4.m31 + this.m21 * matrix4.m32 + this.m31 * matrix4.m33;
        float f15 = this.m02 * matrix4.m30 + this.m12 * matrix4.m31 + this.m22 * matrix4.m32 + this.m32 * matrix4.m33;
        float f16 = this.m03 * matrix4.m30 + this.m13 * matrix4.m31 + this.m23 * matrix4.m32 + this.m33 * matrix4.m33;
        this.m00 = f;
        this.m01 = f2;
        this.m02 = f3;
        this.m03 = f4;
        this.m10 = f5;
        this.m11 = f6;
        this.m12 = f7;
        this.m13 = f8;
        this.m20 = f9;
        this.m21 = f10;
        this.m22 = f11;
        this.m23 = f12;
        this.m30 = f13;
        this.m31 = f14;
        this.m32 = f15;
        this.m33 = f16;
        return this;
    }

    public Matrix4 multiply(Matrix4 matrix4) {
        float f = this.m00 * matrix4.m00 + this.m01 * matrix4.m10 + this.m02 * matrix4.m20 + this.m03 * matrix4.m30;
        float f2 = this.m00 * matrix4.m01 + this.m01 * matrix4.m11 + this.m02 * matrix4.m21 + this.m03 * matrix4.m31;
        float f3 = this.m00 * matrix4.m02 + this.m01 * matrix4.m12 + this.m02 * matrix4.m22 + this.m03 * matrix4.m32;
        float f4 = this.m00 * matrix4.m03 + this.m01 * matrix4.m13 + this.m02 * matrix4.m23 + this.m03 * matrix4.m33;
        float f5 = this.m10 * matrix4.m00 + this.m11 * matrix4.m10 + this.m12 * matrix4.m20 + this.m13 * matrix4.m30;
        float f6 = this.m10 * matrix4.m01 + this.m11 * matrix4.m11 + this.m12 * matrix4.m21 + this.m13 * matrix4.m31;
        float f7 = this.m10 * matrix4.m02 + this.m11 * matrix4.m12 + this.m12 * matrix4.m22 + this.m13 * matrix4.m32;
        float f8 = this.m10 * matrix4.m03 + this.m11 * matrix4.m13 + this.m12 * matrix4.m23 + this.m13 * matrix4.m33;
        float f9 = this.m20 * matrix4.m00 + this.m21 * matrix4.m10 + this.m22 * matrix4.m20 + this.m23 * matrix4.m30;
        float f10 = this.m20 * matrix4.m01 + this.m21 * matrix4.m11 + this.m22 * matrix4.m21 + this.m23 * matrix4.m31;
        float f11 = this.m20 * matrix4.m02 + this.m21 * matrix4.m12 + this.m22 * matrix4.m22 + this.m23 * matrix4.m32;
        float f12 = this.m20 * matrix4.m03 + this.m21 * matrix4.m13 + this.m22 * matrix4.m23 + this.m23 * matrix4.m33;
        float f13 = this.m30 * matrix4.m00 + this.m31 * matrix4.m10 + this.m32 * matrix4.m20 + this.m33 * matrix4.m30;
        float f14 = this.m30 * matrix4.m01 + this.m31 * matrix4.m11 + this.m32 * matrix4.m21 + this.m33 * matrix4.m31;
        float f15 = this.m30 * matrix4.m02 + this.m31 * matrix4.m12 + this.m32 * matrix4.m22 + this.m33 * matrix4.m32;
        float f16 = this.m30 * matrix4.m03 + this.m31 * matrix4.m13 + this.m32 * matrix4.m23 + this.m33 * matrix4.m33;
        this.m00 = f;
        this.m01 = f2;
        this.m02 = f3;
        this.m03 = f4;
        this.m10 = f5;
        this.m11 = f6;
        this.m12 = f7;
        this.m13 = f8;
        this.m20 = f9;
        this.m21 = f10;
        this.m22 = f11;
        this.m23 = f12;
        this.m30 = f13;
        this.m31 = f14;
        this.m32 = f15;
        this.m33 = f16;
        return this;
    }

    public Matrix4 transpose() {
        float f = this.m00;
        float f2 = this.m01;
        float f3 = this.m02;
        float f4 = this.m03;
        float f5 = this.m10;
        float f6 = this.m11;
        float f7 = this.m12;
        float f8 = this.m13;
        float f9 = this.m20;
        float f10 = this.m21;
        float f11 = this.m22;
        float f12 = this.m23;
        float f13 = this.m30;
        float f14 = this.m31;
        float f15 = this.m32;
        float f16 = this.m33;
        this.m00 = f;
        this.m01 = f5;
        this.m02 = f9;
        this.m03 = f13;
        this.m10 = f2;
        this.m11 = f6;
        this.m12 = f10;
        this.m13 = f14;
        this.m20 = f3;
        this.m21 = f7;
        this.m22 = f11;
        this.m23 = f15;
        this.m30 = f4;
        this.m31 = f8;
        this.m32 = f12;
        this.m33 = f16;
        return this;
    }

    public Matrix4 clone() {
        return new Matrix4(this);
    }

    public Matrix4 set(Matrix4 matrix4) {
        this.m00 = matrix4.m00;
        this.m01 = matrix4.m01;
        this.m02 = matrix4.m02;
        this.m03 = matrix4.m03;
        this.m10 = matrix4.m10;
        this.m11 = matrix4.m11;
        this.m12 = matrix4.m12;
        this.m13 = matrix4.m13;
        this.m20 = matrix4.m20;
        this.m21 = matrix4.m21;
        this.m22 = matrix4.m22;
        this.m23 = matrix4.m23;
        this.m30 = matrix4.m30;
        this.m31 = matrix4.m31;
        this.m32 = matrix4.m32;
        this.m33 = matrix4.m33;
        return this;
    }

    public Matrix4 set(float[] fArray) {
        this.m00 = fArray[0];
        this.m01 = fArray[1];
        this.m02 = fArray[2];
        this.m03 = fArray[3];
        this.m10 = fArray[4];
        this.m11 = fArray[5];
        this.m12 = fArray[6];
        this.m13 = fArray[7];
        this.m20 = fArray[8];
        this.m21 = fArray[9];
        this.m22 = fArray[10];
        this.m23 = fArray[11];
        this.m30 = fArray[12];
        this.m31 = fArray[13];
        this.m32 = fArray[14];
        this.m33 = fArray[15];
        this.transpose();
        return this;
    }

    private void mult3x3(Vector3 vector3) {
        float f = this.m00 * vector3.x + this.m01 * vector3.y + this.m02 * vector3.z;
        float f2 = this.m10 * vector3.x + this.m11 * vector3.y + this.m12 * vector3.z;
        float f3 = this.m20 * vector3.x + this.m21 * vector3.y + this.m22 * vector3.z;
        vector3.x = f;
        vector3.y = f2;
        vector3.z = f3;
    }

    public void apply(Vector3 vector3) {
        this.mult3x3(vector3);
        vector3.add(this.m03, this.m13, this.m23);
    }

    public void applyN(Vector3 vector3) {
        this.mult3x3(vector3);
        vector3.normalize();
    }

    public String toString() {
        DecimalFormat decimalFormat = new DecimalFormat("+0.00000;-0.00000");
        decimalFormat.setRoundingMode(RoundingMode.HALF_UP);
        StringBuffer stringBuffer = new StringBuffer(177);
        stringBuffer.append('[').append(decimalFormat.format(this.m00)).append(',').append(decimalFormat.format(this.m01)).append(',').append(decimalFormat.format(this.m02)).append(',').append(decimalFormat.format(this.m03)).append(']').append('\n');
        stringBuffer.append('[').append(decimalFormat.format(this.m10)).append(',').append(decimalFormat.format(this.m11)).append(',').append(decimalFormat.format(this.m12)).append(',').append(decimalFormat.format(this.m13)).append(']').append('\n');
        stringBuffer.append('[').append(decimalFormat.format(this.m20)).append(',').append(decimalFormat.format(this.m21)).append(',').append(decimalFormat.format(this.m22)).append(',').append(decimalFormat.format(this.m23)).append(']').append('\n');
        stringBuffer.append('[').append(decimalFormat.format(this.m30)).append(',').append(decimalFormat.format(this.m31)).append(',').append(decimalFormat.format(this.m32)).append(',').append(decimalFormat.format(this.m33)).append(']');
        return stringBuffer.toString();
    }
}

