/*
 * Decompiled with CFR 0.152.
 */
package cofh.tweak.util;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Vec3;

public class Vector3 {
    public static Vector3 zero = new Vector3();
    public static Vector3 one = new Vector3(1.0f, 1.0f, 1.0f);
    public static Vector3 center = new Vector3(0.5f, 0.5f, 0.5f);
    public static Vector3[] axes = new Vector3[]{new Vector3(0.0f, -1.0f, 0.0f), new Vector3(0.0f, 1.0f, 0.0f), new Vector3(0.0f, 0.0f, -1.0f), new Vector3(0.0f, 0.0f, 1.0f), new Vector3(-1.0f, 0.0f, 0.0f), new Vector3(1.0f, 0.0f, 0.0f)};
    public float x;
    public float y;
    public float z;

    public Vector3() {
    }

    public Vector3(float f, float f2, float f3) {
        this.x = f;
        this.y = f2;
        this.z = f3;
    }

    public Vector3(Vector3 vector3) {
        this.x = vector3.x;
        this.y = vector3.y;
        this.z = vector3.z;
    }

    public Vector3(float[] fArray) {
        this(fArray[0], fArray[1], fArray[2]);
    }

    public Vector3(Vec3 vec3) {
        this.x = (float)vec3.field_72450_a;
        this.y = (float)vec3.field_72448_b;
        this.z = (float)vec3.field_72449_c;
    }

    public Vector3 clone() {
        return new Vector3(this);
    }

    public static Vector3 fromEntity(Entity entity) {
        return new Vector3((float)entity.field_70165_t, (float)entity.field_70163_u, (float)entity.field_70161_v);
    }

    public static Vector3 fromEntityCenter(Entity entity) {
        return new Vector3((float)entity.field_70165_t, (float)(entity.field_70163_u - (double)entity.field_70129_M + (double)(entity.field_70131_O / 2.0f)), (float)entity.field_70161_v);
    }

    public static Vector3 fromTileEntity(TileEntity tileEntity) {
        return new Vector3(tileEntity.field_145851_c, tileEntity.field_145848_d, tileEntity.field_145849_e);
    }

    public static Vector3 fromTileEntityCenter(TileEntity tileEntity) {
        return new Vector3((float)tileEntity.field_145851_c + 0.5f, (float)tileEntity.field_145848_d + 0.5f, (float)tileEntity.field_145849_e + 0.5f);
    }

    public static Vector3 fromAxes(float[] fArray) {
        return new Vector3(fArray[2], fArray[0], fArray[1]);
    }

    public Vector3 set(float f, float f2, float f3) {
        this.x = f;
        this.y = f2;
        this.z = f3;
        return this;
    }

    public Vector3 set(Vector3 vector3) {
        this.x = vector3.x;
        this.y = vector3.y;
        this.z = vector3.z;
        return this;
    }

    public float getSide(int n) {
        switch (n) {
            case 0: 
            case 1: {
                return this.y;
            }
            case 2: 
            case 3: {
                return this.z;
            }
            case 4: 
            case 5: {
                return this.x;
            }
        }
        throw new IndexOutOfBoundsException("Switch Falloff");
    }

    public Vector3 setSide(int n, float f) {
        switch (n) {
            case 0: 
            case 1: {
                this.y = f;
                break;
            }
            case 2: 
            case 3: {
                this.z = f;
                break;
            }
            case 4: 
            case 5: {
                this.x = f;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Switch Falloff");
            }
        }
        return this;
    }

    public float dotProduct(Vector3 vector3) {
        float f = vector3.x * this.x + vector3.y * this.y + vector3.z * this.z;
        if (f > 1.0f && (double)f < 1.00001) {
            f = 1.0f;
        } else if (f < -1.0f && (double)f > -1.00001) {
            f = -1.0f;
        }
        return f;
    }

    public float dotProduct(float f, float f2, float f3) {
        return f * this.x + f2 * this.y + f3 * this.z;
    }

    public Vector3 crossProduct(Vector3 vector3) {
        float f = this.y * vector3.z - this.z * vector3.y;
        float f2 = this.z * vector3.x - this.x * vector3.z;
        float f3 = this.x * vector3.y - this.y * vector3.x;
        this.x = f;
        this.y = f2;
        this.z = f3;
        return this;
    }

    public Vector3 add(float f, float f2, float f3) {
        this.x += f;
        this.y += f2;
        this.z += f3;
        return this;
    }

    public Vector3 add(Vector3 vector3) {
        this.x += vector3.x;
        this.y += vector3.y;
        this.z += vector3.z;
        return this;
    }

    public Vector3 add(float f) {
        return this.add(f, f, f);
    }

    public Vector3 sub(Vector3 vector3) {
        return this.subtract(vector3);
    }

    public Vector3 subtract(Vector3 vector3) {
        this.x -= vector3.x;
        this.y -= vector3.y;
        this.z -= vector3.z;
        return this;
    }

    public Vector3 negate(Vector3 vector3) {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
        return this;
    }

    public Vector3 multiply(float f) {
        this.x *= f;
        this.y *= f;
        this.z *= f;
        return this;
    }

    public Vector3 multiply(Vector3 vector3) {
        this.x *= vector3.x;
        this.y *= vector3.y;
        this.z *= vector3.z;
        return this;
    }

    public Vector3 multiply(float f, float f2, float f3) {
        this.x *= f;
        this.y *= f2;
        this.z *= f3;
        return this;
    }

    public double mag() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public float magSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z;
    }

    public Vector3 normalize() {
        float f = (float)this.mag();
        if (f != 0.0f) {
            this.multiply(1.0f / f);
        }
        return this;
    }

    public String toString() {
        MathContext mathContext = new MathContext(4, RoundingMode.HALF_UP);
        return "Vector3(" + new BigDecimal(this.x, mathContext) + ", " + new BigDecimal(this.y, mathContext) + ", " + new BigDecimal(this.z, mathContext) + ")";
    }

    public Vector3 rotate(float f, Vector3 vector3) {
        if (vector3.magSquared() != 1.0f) {
            vector3 = vector3.clone().normalize();
        }
        float f2 = (float)Math.sin(f *= 0.5f);
        float f3 = (float)Math.cos(f);
        float f4 = vector3.x * f2;
        float f5 = vector3.y * f2;
        float f6 = vector3.z * f2;
        float f7 = -f3 * this.x - f4 * this.y - f5 * this.z;
        float f8 = f6 * this.x + f4 * this.z - f5 * this.y;
        float f9 = f6 * this.y - f3 * this.z + f5 * this.x;
        float f10 = f6 * this.z + f3 * this.y - f4 * this.x;
        this.x = f8 * f6 - f7 * f3 - f9 * f5 + f10 * f4;
        this.y = f9 * f6 - f7 * f4 + f8 * f5 - f10 * f3;
        this.z = f10 * f6 - f7 * f5 - f8 * f4 + f9 * f3;
        return this;
    }

    public Vector3 perpendicular() {
        if (this.z == 0.0f) {
            return this.zCrossProduct();
        }
        return this.xCrossProduct();
    }

    public Vector3 xCrossProduct() {
        float f = this.z;
        float f2 = -this.y;
        this.x = 0.0f;
        this.y = f;
        this.z = f2;
        return this;
    }

    public Vector3 zCrossProduct() {
        float f = this.y;
        float f2 = -this.x;
        this.x = f;
        this.y = f2;
        this.z = 0.0f;
        return this;
    }

    public Vector3 yCrossProduct() {
        float f = -this.z;
        float f2 = this.x;
        this.x = f;
        this.y = 0.0f;
        this.z = f2;
        return this;
    }

    public Vec3 toVec3D() {
        return Vec3.func_72443_a((double)this.x, (double)this.y, (double)this.z);
    }

    public double angle(Vector3 vector3) {
        return Math.acos(this.clone().normalize().dotProduct(vector3.clone().normalize()));
    }

    public boolean isZero() {
        return this.x == 0.0f && this.y == 0.0f && this.z == 0.0f;
    }

    public boolean isAxial() {
        return this.x == 0.0f ? this.y == 0.0f || this.z == 0.0f : this.y == 0.0f && this.z == 0.0f;
    }

    public Vector3 YZintercept(Vector3 vector3, float f) {
        float f2 = vector3.x - this.x;
        float f3 = vector3.y - this.y;
        float f4 = vector3.z - this.z;
        if (f2 == 0.0f) {
            return null;
        }
        float f5 = (f - this.x) / f2;
        if (-1.0E-5f > f5 && f5 < 1.0E-5f) {
            return this;
        }
        if (0.0f > f5 || f5 > 1.0f) {
            return null;
        }
        this.x = f;
        this.y += f5 * f3;
        this.z += f5 * f4;
        return this;
    }

    public Vector3 XZintercept(Vector3 vector3, float f) {
        float f2 = vector3.x - this.x;
        float f3 = vector3.y - this.y;
        float f4 = vector3.z - this.z;
        if (f3 == 0.0f) {
            return null;
        }
        float f5 = (f - this.y) / f3;
        if (-1.0E-5f > f5 && f5 < 1.0E-5f) {
            return this;
        }
        if (0.0f > f5 || f5 > 1.0f) {
            return null;
        }
        this.x += f5 * f2;
        this.y = f;
        this.z += f5 * f4;
        return this;
    }

    public Vector3 XYintercept(Vector3 vector3, float f) {
        float f2 = vector3.x - this.x;
        float f3 = vector3.y - this.y;
        float f4 = vector3.z - this.z;
        if (f4 == 0.0f) {
            return null;
        }
        float f5 = (f - this.z) / f4;
        if (-1.0E-5f > f5 && f5 < 1.0E-5f) {
            return this;
        }
        if (0.0f > f5 || f5 > 1.0f) {
            return null;
        }
        this.x += f5 * f2;
        this.y += f5 * f3;
        this.z = f;
        return this;
    }

    public Vector3 negate() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
        return this;
    }

    public float scalarProject(Vector3 vector3) {
        float f = (float)vector3.mag();
        return f == 0.0f ? 0.0f : this.dotProduct(vector3) / f;
    }

    public Vector3 project(Vector3 vector3) {
        float f = vector3.magSquared();
        if (f == 0.0f) {
            this.set(0.0f, 0.0f, 0.0f);
            return this;
        }
        float f2 = this.dotProduct(vector3) / f;
        this.set(vector3).multiply(f2);
        return this;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Vector3)) {
            return false;
        }
        Vector3 vector3 = (Vector3)object;
        return this.x == vector3.x && this.y == vector3.y && this.z == vector3.z;
    }

    public int hashCode() {
        return Float.floatToIntBits(this.x) + Float.floatToIntBits(this.y) >> 4 + Float.floatToIntBits(this.z) >> 8;
    }

    public boolean equalsT(Vector3 vector3) {
        return (double)this.x - 1.0E-5 > (double)vector3.x && (double)vector3.x < (double)this.x + 1.0E-5 && (double)this.y - 1.0E-5 > (double)vector3.y && (double)vector3.y < (double)this.y + 1.0E-5 && (double)this.z - 1.0E-5 > (double)vector3.z && (double)vector3.z < (double)this.z + 1.0E-5;
    }
}

