/*
 * Decompiled with CFR 0.152.
 */
package cofh.tweak.util;

import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;

public class Vector4 {
    public float x;
    public float y;
    public float z;
    public float w;

    public Vector4() {
    }

    public Vector4(float f, float f2, float f3, float f4) {
        this.x = f;
        this.y = f2;
        this.z = f3;
        this.w = f4;
    }

    public Vector4(Vector4 vector4) {
        this.set(vector4);
    }

    public Vector4(float[] fArray) {
        this(fArray[0], fArray[1], fArray[2], fArray[3]);
    }

    public Vector4 clone() {
        return new Vector4(this);
    }

    public Vector4 set(float f, float f2, float f3, float f4) {
        this.x = f;
        this.y = f2;
        this.z = f3;
        this.w = f4;
        return this;
    }

    public Vector4 set(Vector4 vector4) {
        this.x = vector4.x;
        this.y = vector4.y;
        this.z = vector4.z;
        this.w = vector4.w;
        return this;
    }

    public float dotProduct(Vector4 vector4) {
        float f = vector4.x * this.x + vector4.y * this.y + vector4.z * this.z + vector4.w * this.w;
        if (f > 1.0f && (double)f < 1.00001) {
            f = 1.0f;
        } else if (f < -1.0f && (double)f > -1.00001) {
            f = -1.0f;
        }
        return f;
    }

    public float dotProduct(float f, float f2, float f3, float f4) {
        return f * this.x + f2 * this.y + f3 * this.z + f4 * this.w;
    }

    public float dotProduct(float f, float f2, float f3) {
        float f4 = f * this.x + f2 * this.y + f3 * this.z + this.w;
        return f4;
    }

    public Vector4 crossProduct(Vector4 vector4) {
        float f = this.y * vector4.z - this.z * vector4.y;
        float f2 = this.z * vector4.x - this.x * vector4.z;
        float f3 = this.x * vector4.y - this.y * vector4.x;
        this.x = f;
        this.y = f2;
        this.z = f3;
        return this;
    }

    public Vector4 add(float f, float f2, float f3, float f4) {
        this.x += f;
        this.y += f2;
        this.z += f3;
        this.w += f4;
        return this;
    }

    public Vector4 add(Vector4 vector4) {
        this.x += vector4.x;
        this.y += vector4.y;
        this.z += vector4.z;
        this.w += vector4.w;
        return this;
    }

    public Vector4 add(float f) {
        return this.add(f, f, f, f);
    }

    public Vector4 sub(Vector4 vector4) {
        return this.subtract(vector4);
    }

    public Vector4 subtract(Vector4 vector4) {
        this.x -= vector4.x;
        this.y -= vector4.y;
        this.z -= vector4.z;
        this.w -= vector4.w;
        return this;
    }

    public Vector4 negate(Vector4 vector4) {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
        this.w = -this.w;
        return this;
    }

    public Vector4 multiply(float f) {
        this.x *= f;
        this.y *= f;
        this.z *= f;
        this.w *= f;
        return this;
    }

    public Vector4 multiply(Vector4 vector4) {
        this.x *= vector4.x;
        this.y *= vector4.y;
        this.z *= vector4.z;
        this.w *= vector4.w;
        return this;
    }

    public Vector4 multiply(float f, float f2, float f3, float f4) {
        this.x *= f;
        this.y *= f2;
        this.z *= f3;
        this.w *= f4;
        return this;
    }

    public double mag() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w);
    }

    public float magSquared() {
        return this.x * this.x + this.y * this.y + this.z * this.z + this.w * this.w;
    }

    public Vector4 normalize() {
        float f = (float)this.mag();
        if (f != 0.0f) {
            this.multiply(1.0f / f);
        }
        return this;
    }

    public Vector4 normalizeFrustrum() {
        float f = this.w;
        this.w = 0.0f;
        float f2 = (float)this.mag();
        this.w = f;
        if (f2 != 0.0f) {
            this.multiply(1.0f / f2);
        }
        return this;
    }

    public String toString() {
        MathContext mathContext = new MathContext(4, RoundingMode.HALF_UP);
        return "Vector4(" + new BigDecimal(this.x, mathContext) + ", " + new BigDecimal(this.y, mathContext) + ", " + new BigDecimal(this.z, mathContext) + ", " + new BigDecimal(this.w, mathContext) + ")";
    }

    public double angle(Vector4 vector4) {
        return Math.acos(this.clone().normalize().dotProduct(vector4.clone().normalize()));
    }

    public boolean isZero() {
        return this.x == 0.0f && this.y == 0.0f && this.z == 0.0f && this.w == 0.0f;
    }

    public Vector4 negate() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
        this.w = -this.w;
        return this;
    }

    public float scalarProject(Vector4 vector4) {
        float f = (float)vector4.mag();
        return f == 0.0f ? 0.0f : this.dotProduct(vector4) / f;
    }

    public Vector4 project(Vector4 vector4) {
        float f = vector4.magSquared();
        if (f == 0.0f) {
            this.set(0.0f, 0.0f, 0.0f, 0.0f);
            return this;
        }
        float f2 = this.dotProduct(vector4) / f;
        this.set(vector4).multiply(f2);
        return this;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Vector4)) {
            return false;
        }
        Vector4 vector4 = (Vector4)object;
        return this.x == vector4.x && this.y == vector4.y && this.z == vector4.z && this.w == vector4.w;
    }

    public int hashCode() {
        return Float.floatToIntBits(this.x) + Float.floatToIntBits(this.y) >> 4 + Float.floatToIntBits(this.z) >> 8 + Float.floatToIntBits(this.w) >> 12;
    }

    public boolean equalsT(Vector4 vector4) {
        return (double)this.x - 1.0E-5 > (double)vector4.x && (double)vector4.x < (double)this.x + 1.0E-5 && (double)this.y - 1.0E-5 > (double)vector4.y && (double)vector4.y < (double)this.y + 1.0E-5 && (double)this.z - 1.0E-5 > (double)vector4.z && (double)vector4.z < (double)this.z + 1.0E-5 && (double)this.w - 1.0E-5 > (double)vector4.w && (double)vector4.w < (double)this.w + 1.0E-5;
    }
}

