/*
 * Decompiled with CFR 0.152.
 */
package cofh.tweak.util.maps;

import cofh.tweak.util.maps.ObjectIntHashBiMap;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class IntObjectHashBiMap<V> {
    private transient BiEntry<V>[] hashTableKToV;
    private transient BiEntry<V>[] hashTableVToK;
    private transient int size;
    private transient int mask;
    private transient int modCount;
    private transient ObjectIntHashBiMap<V> inverse;

    protected IntObjectHashBiMap() {
    }

    public IntObjectHashBiMap(int n) {
        this.init(n);
    }

    private void init(int n) {
        ObjectIntHashBiMap.checkNonnegative(n, "expectedSize");
        int n2 = ObjectIntHashBiMap.closedTableSize(n, 1.0);
        this.hashTableKToV = this.createTable(n2);
        this.hashTableVToK = this.createTable(n2);
        this.mask = n2 - 1;
        this.modCount = 0;
        this.size = 0;
    }

    private void delete(BiEntry<V> biEntry) {
        int n = biEntry.keyHash & this.mask;
        BiEntry<V> biEntry2 = null;
        BiEntry<V> biEntry3 = this.hashTableKToV[n];
        while (true) {
            if (biEntry3 == biEntry) {
                if (biEntry2 == null) {
                    this.hashTableKToV[n] = biEntry.nextInKToVBucket;
                    break;
                }
                biEntry2.nextInKToVBucket = biEntry.nextInKToVBucket;
                break;
            }
            biEntry2 = biEntry3;
            biEntry3 = biEntry3.nextInKToVBucket;
        }
        int n2 = biEntry.valueHash & this.mask;
        biEntry2 = null;
        BiEntry<V> biEntry4 = this.hashTableVToK[n2];
        while (true) {
            if (biEntry4 == biEntry) {
                if (biEntry2 == null) {
                    this.hashTableVToK[n2] = biEntry.nextInVToKBucket;
                    break;
                }
                biEntry2.nextInVToKBucket = biEntry.nextInVToKBucket;
                break;
            }
            biEntry2 = biEntry4;
            biEntry4 = biEntry4.nextInVToKBucket;
        }
        --this.size;
        ++this.modCount;
    }

    private void insert(BiEntry<V> biEntry) {
        int n = biEntry.keyHash & this.mask;
        biEntry.nextInKToVBucket = this.hashTableKToV[n];
        this.hashTableKToV[n] = biEntry;
        int n2 = biEntry.valueHash & this.mask;
        biEntry.nextInVToKBucket = this.hashTableVToK[n2];
        this.hashTableVToK[n2] = biEntry;
        ++this.size;
        ++this.modCount;
    }

    protected int hash(Object object) {
        return ObjectIntHashBiMap.smear(object == null ? 0 : object.hashCode());
    }

    protected int hash(int n) {
        return ObjectIntHashBiMap.smear(n);
    }

    protected boolean equal(Object object, Object object2) {
        return object == object2 || object != null && object.equals(object2);
    }

    private BiEntry<V> seekByKey(int n, int n2) {
        BiEntry<V> biEntry = this.hashTableKToV[n2 & this.mask];
        while (biEntry != null) {
            if (n2 == biEntry.keyHash & n == biEntry.key) {
                return biEntry;
            }
            biEntry = biEntry.nextInKToVBucket;
        }
        return null;
    }

    private BiEntry<V> seekByValue(Object object, int n) {
        BiEntry<V> biEntry = this.hashTableVToK[n & this.mask];
        while (biEntry != null) {
            if (n == biEntry.valueHash && this.equal(object, biEntry.value)) {
                return biEntry;
            }
            biEntry = biEntry.nextInVToKBucket;
        }
        return null;
    }

    public boolean containsKey(int n) {
        return this.seekByKey(n, this.hash(n)) != null;
    }

    public boolean containsValue(Object object) {
        return this.seekByValue(object, this.hash(object)) != null;
    }

    public V get(int n) {
        BiEntry<V> biEntry = this.seekByKey(n, this.hash(n));
        return biEntry == null ? null : (V)biEntry.value;
    }

    public V put(int n, V v) {
        return this.put(n, v, false, true);
    }

    public V forcePut(int n, V v) {
        return this.put(n, v, true, true);
    }

    public V putIfAbsent(int n, V v) {
        return this.put(n, v, false, false);
    }

    private V put(int n, V v, boolean bl, boolean bl2) {
        BiEntry<V> biEntry;
        int n2 = this.hash(n);
        int n3 = this.hash(v);
        BiEntry<V> biEntry2 = this.seekByKey(n, n2);
        if (biEntry2 != null) {
            if (!bl2) {
                return biEntry2.value;
            }
            if (n3 == biEntry2.valueHash && this.equal(v, biEntry2.value)) {
                return v;
            }
        }
        if ((biEntry = this.seekByValue(v, n3)) != null) {
            if (bl) {
                this.delete(biEntry);
            } else {
                if (bl2) {
                    throw new IllegalArgumentException("value already present: " + v);
                }
                return biEntry2 == null ? null : (V)biEntry2.value;
            }
        }
        if (biEntry2 != null) {
            this.delete(biEntry2);
        }
        BiEntry<V> biEntry3 = new BiEntry<V>(n, n2, v, n3);
        this.insert(biEntry3);
        this.rehashIfNecessary();
        return biEntry2 == null ? v : biEntry2.value;
    }

    private int putInverse(V v, int n, boolean bl, boolean bl2) {
        BiEntry<V> biEntry;
        int n2 = this.hash(v);
        int n3 = this.hash(n);
        BiEntry<V> biEntry2 = this.seekByValue(v, n2);
        if (biEntry2 != null) {
            if (!bl2) {
                return biEntry2.key;
            }
            if (n3 == biEntry2.keyHash && n == biEntry2.key) {
                return n;
            }
        }
        if ((biEntry = this.seekByKey(n, n3)) != null) {
            if (bl) {
                this.delete(biEntry);
            } else {
                if (bl2) {
                    throw new IllegalArgumentException("value already present: " + n);
                }
                return biEntry2 == null ? 0 : biEntry2.key;
            }
        }
        if (biEntry2 != null) {
            this.delete(biEntry2);
        }
        BiEntry<V> biEntry3 = new BiEntry<V>(n, n3, v, n2);
        this.insert(biEntry3);
        this.rehashIfNecessary();
        return biEntry2 == null ? n : biEntry2.key;
    }

    private void rehashIfNecessary() {
        BiEntry<V>[] biEntryArray = this.hashTableKToV;
        if (ObjectIntHashBiMap.needsResizing(this.size, biEntryArray.length, 1.0)) {
            int n = biEntryArray.length * 2;
            this.hashTableKToV = this.createTable(n);
            this.hashTableVToK = this.createTable(n);
            this.mask = n - 1;
            this.size = 0;
            for (int i = 0; i < biEntryArray.length; ++i) {
                BiEntry<V> biEntry = biEntryArray[i];
                while (biEntry != null) {
                    BiEntry biEntry2 = biEntry.nextInKToVBucket;
                    this.insert(biEntry);
                    biEntry = biEntry2;
                }
            }
            ++this.modCount;
        }
    }

    private BiEntry<V>[] createTable(int n) {
        return new BiEntry[n];
    }

    public V remove(int n) {
        BiEntry<V> biEntry = this.seekByKey(n, this.hash(n));
        if (biEntry == null) {
            return null;
        }
        this.delete(biEntry);
        return biEntry.value;
    }

    public void clear() {
        this.size = 0;
        Arrays.fill(this.hashTableKToV, null);
        Arrays.fill(this.hashTableVToK, null);
        ++this.modCount;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Set<Integer> keySet() {
        return new KeySet();
    }

    public Set<V> values() {
        return this.inverse().keySet();
    }

    public Set<Map.Entry<Integer, V>> entrySet() {
        return new EntrySet();
    }

    public ObjectIntHashBiMap<V> inverse() {
        return this.inverse == null ? (this.inverse = new Inverse()) : this.inverse;
    }

    private final class Inverse
    extends ObjectIntHashBiMap<V> {
        private Inverse() {
        }

        IntObjectHashBiMap<V> forward() {
            return IntObjectHashBiMap.this;
        }

        @Override
        public int size() {
            return IntObjectHashBiMap.this.size;
        }

        @Override
        public void clear() {
            this.forward().clear();
        }

        @Override
        protected boolean equal(Object object, Object object2) {
            return IntObjectHashBiMap.this.equal(object, object2);
        }

        @Override
        public boolean containsKey(Object object) {
            return this.forward().containsValue(object);
        }

        @Override
        public int get(Object object) {
            BiEntry biEntry = IntObjectHashBiMap.this.seekByValue(object, this.hash(object));
            return biEntry == null ? 0 : biEntry.key;
        }

        @Override
        public int put(V v, int n) {
            return IntObjectHashBiMap.this.putInverse(v, n, false, true);
        }

        @Override
        public int forcePut(V v, int n) {
            return IntObjectHashBiMap.this.putInverse(v, n, true, true);
        }

        @Override
        public int putIfAbsent(V v, int n) {
            return IntObjectHashBiMap.this.putInverse(v, n, false, false);
        }

        @Override
        public int remove(Object object) {
            BiEntry biEntry = IntObjectHashBiMap.this.seekByValue(object, this.hash(object));
            if (biEntry == null) {
                return 0;
            }
            IntObjectHashBiMap.this.delete(biEntry);
            return biEntry.key;
        }

        @Override
        public IntObjectHashBiMap<V> inverse() {
            return this.forward();
        }

        @Override
        public Set<V> keySet() {
            return new InverseKeySet();
        }

        @Override
        public Set<Integer> values() {
            return this.forward().keySet();
        }

        @Override
        public Set<Map.Entry<V, Integer>> entrySet() {
            return new ObjectIntHashBiMap.EntrySet(this){

                ObjectIntHashBiMap<V> map() {
                    return Inverse.this;
                }

                @Override
                public Iterator<Map.Entry<V, Integer>> iterator() {
                    return new Itr<Map.Entry<V, Integer>>(IntObjectHashBiMap.this){

                        @Override
                        Map.Entry<V, Integer> output(BiEntry<V> biEntry) {
                            return new InverseEntry(biEntry);
                        }

                        class InverseEntry
                        implements Map.Entry<V, Integer> {
                            BiEntry<V> delegate;

                            InverseEntry(BiEntry<V> biEntry) {
                                this.delegate = biEntry;
                            }

                            @Override
                            public V getKey() {
                                return this.delegate.value;
                            }

                            @Override
                            public Integer getValue() {
                                return this.delegate.key;
                            }

                            @Override
                            public Integer setValue(Integer n) {
                                Preconditions.checkNotNull((Object)n, (Object)"value cannot be null");
                                int n2 = this.delegate.key;
                                int n3 = Inverse.this.hash(n);
                                int n4 = n;
                                if (n3 == this.delegate.keyHash && n4 == n2) {
                                    return n;
                                }
                                Preconditions.checkArgument((IntObjectHashBiMap.this.seekByKey(n4, n3) == null ? 1 : 0) != 0, (String)"value already present: %s", (Object[])new Object[]{n});
                                IntObjectHashBiMap.this.delete(this.delegate);
                                BiEntry biEntry = new BiEntry(n4, n3, this.delegate.value, this.delegate.valueHash);
                                IntObjectHashBiMap.this.insert(biEntry);
                                expectedModCount = IntObjectHashBiMap.this.modCount;
                                return n2;
                            }
                        }
                    };
                }
            };
        }

        private final class InverseKeySet
        extends AbstractSet<V> {
            InverseKeySet() {
            }

            @Override
            public boolean remove(Object object) {
                BiEntry biEntry = IntObjectHashBiMap.this.seekByValue(object, Inverse.this.hash(object));
                if (biEntry == null) {
                    return false;
                }
                IntObjectHashBiMap.this.delete(biEntry);
                return true;
            }

            @Override
            public Iterator<V> iterator() {
                return new Itr<V>(Inverse.this.forward()){

                    @Override
                    V output(BiEntry<V> biEntry) {
                        return biEntry.value;
                    }
                };
            }

            @Override
            public int size() {
                return Inverse.this.forward().size();
            }
        }
    }

    class EntrySet
    extends AbstractSet<Map.Entry<Integer, V>> {
        EntrySet() {
        }

        IntObjectHashBiMap<V> map() {
            return IntObjectHashBiMap.this;
        }

        @Override
        public int size() {
            return this.map().size();
        }

        @Override
        public void clear() {
            this.map().clear();
        }

        @Override
        public boolean contains(Object object) {
            Map.Entry entry;
            Object k;
            if (object instanceof Map.Entry && (k = (entry = (Map.Entry)object).getKey()) instanceof Number) {
                Number number = (Number)k;
                BiEntry biEntry = this.map().seekByKey(number.intValue(), IntObjectHashBiMap.this.hash(number));
                return biEntry != null && IntObjectHashBiMap.this.equal(biEntry.value, entry.getValue());
            }
            return false;
        }

        @Override
        public boolean isEmpty() {
            return this.map().isEmpty();
        }

        @Override
        public boolean remove(Object object) {
            if (this.contains(object)) {
                Map.Entry entry = (Map.Entry)object;
                return this.map().keySet().remove(entry.getKey());
            }
            return false;
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            try {
                return super.removeAll((Collection)Preconditions.checkNotNull(collection));
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                boolean bl = false;
                Iterator<?> iterator = collection.iterator();
                while (iterator.hasNext()) {
                    bl |= this.remove(iterator.next());
                }
                return bl;
            }
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            try {
                return super.retainAll((Collection)Preconditions.checkNotNull(collection));
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                HashSet hashSet = Sets.newHashSetWithExpectedSize((int)collection.size());
                for (Object obj : collection) {
                    if (!this.contains(obj)) continue;
                    Map.Entry entry = (Map.Entry)obj;
                    hashSet.add(entry.getKey());
                }
                return this.map().keySet().retainAll(hashSet);
            }
        }

        @Override
        public Iterator<Map.Entry<Integer, V>> iterator() {
            return new Itr<Map.Entry<Integer, V>>(){

                @Override
                Map.Entry<Integer, V> output(BiEntry<V> biEntry) {
                    return new MapEntry(biEntry);
                }

                class MapEntry
                implements Map.Entry<Integer, V> {
                    BiEntry<V> delegate;

                    MapEntry(BiEntry<V> biEntry) {
                        this.delegate = biEntry;
                    }

                    @Override
                    public Integer getKey() {
                        return this.delegate.key;
                    }

                    @Override
                    public V getValue() {
                        return this.delegate.value;
                    }

                    @Override
                    public V setValue(V v) {
                        Object v2 = this.delegate.value;
                        int n = IntObjectHashBiMap.this.hash(v);
                        if (n == this.delegate.valueHash && IntObjectHashBiMap.this.equal(v, v2)) {
                            return v;
                        }
                        Preconditions.checkArgument((IntObjectHashBiMap.this.seekByValue(v, n) == null ? 1 : 0) != 0, (String)"value already present: %s", (Object[])new Object[]{v});
                        IntObjectHashBiMap.this.delete(this.delegate);
                        BiEntry biEntry = new BiEntry(this.delegate.key, this.delegate.keyHash, v, n);
                        IntObjectHashBiMap.this.insert(biEntry);
                        expectedModCount = IntObjectHashBiMap.this.modCount;
                        if (toRemove == this.delegate) {
                            toRemove = biEntry;
                        }
                        this.delegate = biEntry;
                        return v2;
                    }
                }
            };
        }
    }

    private final class KeySet
    extends AbstractSet<Integer> {
        KeySet() {
        }

        @Override
        public Iterator<Integer> iterator() {
            return new Itr<Integer>(){

                @Override
                Integer output(BiEntry<V> biEntry) {
                    return biEntry.key;
                }
            };
        }

        @Override
        public boolean remove(Object object) {
            if (!(object instanceof Number)) {
                return false;
            }
            int n = ((Number)object).intValue();
            BiEntry biEntry = IntObjectHashBiMap.this.seekByKey(n, IntObjectHashBiMap.this.hash(n));
            if (biEntry == null) {
                return false;
            }
            IntObjectHashBiMap.this.delete(biEntry);
            return true;
        }

        @Override
        public int size() {
            return IntObjectHashBiMap.this.size();
        }
    }

    abstract class Itr<T>
    implements Iterator<T> {
        int nextBucket = 0;
        BiEntry<V> next = null;
        BiEntry<V> toRemove = null;
        int expectedModCount = IntObjectHashBiMap.access$000(IntObjectHashBiMap.this);

        Itr() {
        }

        private void checkForConcurrentModification() {
            if (IntObjectHashBiMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public boolean hasNext() {
            this.checkForConcurrentModification();
            if (this.next != null) {
                return true;
            }
            while (this.nextBucket < IntObjectHashBiMap.this.hashTableKToV.length) {
                if (IntObjectHashBiMap.this.hashTableKToV[this.nextBucket] != null) {
                    this.next = IntObjectHashBiMap.this.hashTableKToV[this.nextBucket++];
                    return true;
                }
                ++this.nextBucket;
            }
            return false;
        }

        @Override
        public T next() {
            this.checkForConcurrentModification();
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            BiEntry biEntry = this.next;
            this.next = biEntry.nextInKToVBucket;
            this.toRemove = biEntry;
            return this.output(biEntry);
        }

        @Override
        public void remove() {
            this.checkForConcurrentModification();
            ObjectIntHashBiMap.checkRemove(this.toRemove != null);
            IntObjectHashBiMap.this.delete(this.toRemove);
            this.expectedModCount = IntObjectHashBiMap.this.modCount;
            this.toRemove = null;
        }

        abstract T output(BiEntry<V> var1);
    }

    private static final class BiEntry<V> {
        final V value;
        final int key;
        final int keyHash;
        final int valueHash;
        BiEntry<V> nextInKToVBucket;
        BiEntry<V> nextInVToKBucket;

        BiEntry(int n, int n2, V v, int n3) {
            this.key = n;
            this.value = v;
            this.keyHash = n2;
            this.valueHash = n3;
        }
    }
}

