/*
 * Decompiled with CFR 0.152.
 */
package cofh.tweak.util.maps;

import cofh.tweak.util.maps.IntObjectHashBiMap;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class ObjectIntHashBiMap<K> {
    static final double LOAD_FACTOR = 1.0;
    private transient BiEntry<K>[] hashTableKToV;
    private transient BiEntry<K>[] hashTableVToK;
    private transient int size;
    private transient int mask;
    private transient int modCount;
    private transient IntObjectHashBiMap<K> inverse;
    private static final int C1 = -862048943;
    private static final int C2 = 461845907;
    private static int MAX_TABLE_SIZE = 0x40000000;

    protected ObjectIntHashBiMap() {
    }

    public ObjectIntHashBiMap(int n) {
        this.init(n);
    }

    private void init(int n) {
        ObjectIntHashBiMap.checkNonnegative(n, "expectedSize");
        int n2 = ObjectIntHashBiMap.closedTableSize(n, 1.0);
        this.hashTableKToV = this.createTable(n2);
        this.hashTableVToK = this.createTable(n2);
        this.mask = n2 - 1;
        this.modCount = 0;
        this.size = 0;
    }

    private void delete(BiEntry<K> biEntry) {
        int n = biEntry.keyHash & this.mask;
        BiEntry<K> biEntry2 = null;
        BiEntry<K> biEntry3 = this.hashTableKToV[n];
        while (true) {
            if (biEntry3 == biEntry) {
                if (biEntry2 == null) {
                    this.hashTableKToV[n] = biEntry.nextInKToVBucket;
                    break;
                }
                biEntry2.nextInKToVBucket = biEntry.nextInKToVBucket;
                break;
            }
            biEntry2 = biEntry3;
            biEntry3 = biEntry3.nextInKToVBucket;
        }
        int n2 = biEntry.valueHash & this.mask;
        biEntry2 = null;
        BiEntry<K> biEntry4 = this.hashTableVToK[n2];
        while (true) {
            if (biEntry4 == biEntry) {
                if (biEntry2 == null) {
                    this.hashTableVToK[n2] = biEntry.nextInVToKBucket;
                    break;
                }
                biEntry2.nextInVToKBucket = biEntry.nextInVToKBucket;
                break;
            }
            biEntry2 = biEntry4;
            biEntry4 = biEntry4.nextInVToKBucket;
        }
        --this.size;
        ++this.modCount;
    }

    private void insert(BiEntry<K> biEntry) {
        int n = biEntry.keyHash & this.mask;
        biEntry.nextInKToVBucket = this.hashTableKToV[n];
        this.hashTableKToV[n] = biEntry;
        int n2 = biEntry.valueHash & this.mask;
        biEntry.nextInVToKBucket = this.hashTableVToK[n2];
        this.hashTableVToK[n2] = biEntry;
        ++this.size;
        ++this.modCount;
    }

    protected int hash(Object object) {
        return ObjectIntHashBiMap.smear(object == null ? 0 : object.hashCode());
    }

    protected int hash(int n) {
        return ObjectIntHashBiMap.smear(n);
    }

    protected boolean equal(Object object, Object object2) {
        return object == object2 || object != null && object.equals(object2);
    }

    private BiEntry<K> seekByKey(Object object, int n) {
        BiEntry<K> biEntry = this.hashTableKToV[n & this.mask];
        while (biEntry != null) {
            if (n == biEntry.keyHash && this.equal(object, biEntry.key)) {
                return biEntry;
            }
            biEntry = biEntry.nextInKToVBucket;
        }
        return null;
    }

    private BiEntry<K> seekByValue(int n, int n2) {
        BiEntry<K> biEntry = this.hashTableVToK[n2 & this.mask];
        while (biEntry != null) {
            if (n2 == biEntry.valueHash & n == biEntry.value) {
                return biEntry;
            }
            biEntry = biEntry.nextInVToKBucket;
        }
        return null;
    }

    public boolean containsKey(Object object) {
        return this.seekByKey(object, this.hash(object)) != null;
    }

    public boolean containsValue(int n) {
        return this.seekByValue(n, this.hash(n)) != null;
    }

    public int get(Object object) {
        BiEntry<K> biEntry = this.seekByKey(object, this.hash(object));
        return biEntry == null ? 0 : biEntry.value;
    }

    public int put(K k, int n) {
        return this.put(k, n, false, true);
    }

    public int forcePut(K k, int n) {
        return this.put(k, n, true, true);
    }

    public int putIfAbsent(K k, int n) {
        return this.put(k, n, false, false);
    }

    private int put(K k, int n, boolean bl, boolean bl2) {
        BiEntry<K> biEntry;
        int n2 = this.hash(k);
        int n3 = this.hash(n);
        BiEntry<K> biEntry2 = this.seekByKey(k, n2);
        if (biEntry2 != null) {
            if (!bl2) {
                return biEntry2.value;
            }
            if (n3 == biEntry2.valueHash && n == biEntry2.value) {
                return n;
            }
        }
        if ((biEntry = this.seekByValue(n, n3)) != null) {
            if (bl) {
                this.delete(biEntry);
            } else {
                if (bl2) {
                    throw new IllegalArgumentException("value already present: " + n);
                }
                return biEntry2 == null ? 0 : biEntry2.value;
            }
        }
        if (biEntry2 != null) {
            this.delete(biEntry2);
        }
        BiEntry<K> biEntry3 = new BiEntry<K>(k, n2, n, n3);
        this.insert(biEntry3);
        this.rehashIfNecessary();
        return biEntry2 == null ? n : biEntry2.value;
    }

    private K putInverse(int n, K k, boolean bl, boolean bl2) {
        BiEntry<K> biEntry;
        int n2 = this.hash(n);
        int n3 = this.hash(k);
        BiEntry<K> biEntry2 = this.seekByValue(n, n2);
        if (biEntry2 != null) {
            if (!bl2) {
                return biEntry2.key;
            }
            if (n3 == biEntry2.keyHash && this.equal(k, biEntry2.key)) {
                return k;
            }
        }
        if ((biEntry = this.seekByKey(k, n3)) != null) {
            if (bl) {
                this.delete(biEntry);
            } else {
                if (bl2) {
                    throw new IllegalArgumentException("value already present: " + k);
                }
                return biEntry2 == null ? null : (K)biEntry2.key;
            }
        }
        if (biEntry2 != null) {
            this.delete(biEntry2);
        }
        BiEntry<K> biEntry3 = new BiEntry<K>(k, n3, n, n2);
        this.insert(biEntry3);
        this.rehashIfNecessary();
        return biEntry2 == null ? k : biEntry2.key;
    }

    private void rehashIfNecessary() {
        BiEntry<K>[] biEntryArray = this.hashTableKToV;
        if (ObjectIntHashBiMap.needsResizing(this.size, biEntryArray.length, 1.0)) {
            int n = biEntryArray.length * 2;
            this.hashTableKToV = this.createTable(n);
            this.hashTableVToK = this.createTable(n);
            this.mask = n - 1;
            this.size = 0;
            for (int i = 0; i < biEntryArray.length; ++i) {
                BiEntry<K> biEntry = biEntryArray[i];
                while (biEntry != null) {
                    BiEntry biEntry2 = biEntry.nextInKToVBucket;
                    this.insert(biEntry);
                    biEntry = biEntry2;
                }
            }
            ++this.modCount;
        }
    }

    private BiEntry<K>[] createTable(int n) {
        return new BiEntry[n];
    }

    public int remove(Object object) {
        BiEntry<K> biEntry = this.seekByKey(object, this.hash(object));
        if (biEntry == null) {
            return 0;
        }
        this.delete(biEntry);
        return biEntry.value;
    }

    public void clear() {
        this.size = 0;
        Arrays.fill(this.hashTableKToV, null);
        Arrays.fill(this.hashTableVToK, null);
        ++this.modCount;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Set<K> keySet() {
        return new KeySet();
    }

    public Set<Integer> values() {
        return this.inverse().keySet();
    }

    public Set<Map.Entry<K, Integer>> entrySet() {
        return new EntrySet();
    }

    public IntObjectHashBiMap<K> inverse() {
        return this.inverse == null ? (this.inverse = new Inverse()) : this.inverse;
    }

    static void checkEntryNotNull(Object object, Object object2) {
        if (object == null) {
            throw new NullPointerException("null key in entry: null=" + object2);
        }
        if (object2 == null) {
            throw new NullPointerException("null value in entry: " + object + "=null");
        }
    }

    static int checkNonnegative(int n, String string) {
        if (n < 0) {
            throw new IllegalArgumentException(string + " cannot be negative but was: " + n);
        }
        return n;
    }

    static void checkRemove(boolean bl) {
        Preconditions.checkState((boolean)bl, (Object)"no calls to next() since the last call to remove()");
    }

    static int smear(int n) {
        return 461845907 * Integer.rotateLeft(n * -862048943, 15);
    }

    static int smearedHash(Object object) {
        return ObjectIntHashBiMap.smear(object == null ? 0 : object.hashCode());
    }

    static int closedTableSize(int n, double d) {
        int n2;
        if ((n = Math.max(n, 2)) > (int)(d * (double)(n2 = Integer.highestOneBit(n)))) {
            return (n2 <<= 1) > 0 ? n2 : MAX_TABLE_SIZE;
        }
        return n2;
    }

    static boolean needsResizing(int n, int n2, double d) {
        return (double)n > d * (double)n2 && n2 < MAX_TABLE_SIZE;
    }

    private final class Inverse
    extends IntObjectHashBiMap<K> {
        private Inverse() {
        }

        ObjectIntHashBiMap<K> forward() {
            return ObjectIntHashBiMap.this;
        }

        @Override
        public int size() {
            return ObjectIntHashBiMap.this.size;
        }

        @Override
        public void clear() {
            this.forward().clear();
        }

        @Override
        protected boolean equal(Object object, Object object2) {
            return ObjectIntHashBiMap.this.equal(object, object2);
        }

        @Override
        public boolean containsKey(int n) {
            return this.forward().containsValue(n);
        }

        @Override
        public K get(int n) {
            BiEntry biEntry = ObjectIntHashBiMap.this.seekByValue(n, this.hash(n));
            return biEntry == null ? null : (Object)biEntry.key;
        }

        @Override
        public K put(int n, K k) {
            return ObjectIntHashBiMap.this.putInverse(n, k, false, true);
        }

        @Override
        public K forcePut(int n, K k) {
            return ObjectIntHashBiMap.this.putInverse(n, k, true, true);
        }

        @Override
        public K putIfAbsent(int n, K k) {
            return ObjectIntHashBiMap.this.putInverse(n, k, false, false);
        }

        @Override
        public K remove(int n) {
            BiEntry biEntry = ObjectIntHashBiMap.this.seekByValue(n, this.hash(n));
            if (biEntry == null) {
                return null;
            }
            ObjectIntHashBiMap.this.delete(biEntry);
            return biEntry.key;
        }

        @Override
        public ObjectIntHashBiMap<K> inverse() {
            return this.forward();
        }

        @Override
        public Set<Integer> keySet() {
            return new InverseKeySet();
        }

        @Override
        public Set<K> values() {
            return this.forward().keySet();
        }

        @Override
        public Set<Map.Entry<Integer, K>> entrySet() {
            return new IntObjectHashBiMap.EntrySet(this){

                IntObjectHashBiMap<K> map() {
                    return Inverse.this;
                }

                @Override
                public Iterator<Map.Entry<Integer, K>> iterator() {
                    return new Itr<Map.Entry<Integer, K>>(ObjectIntHashBiMap.this){

                        @Override
                        Map.Entry<Integer, K> output(BiEntry<K> biEntry) {
                            return new InverseEntry(biEntry);
                        }

                        class InverseEntry
                        implements Map.Entry<Integer, K> {
                            BiEntry<K> delegate;

                            InverseEntry(BiEntry<K> biEntry) {
                                this.delegate = biEntry;
                            }

                            @Override
                            public Integer getKey() {
                                return this.delegate.value;
                            }

                            @Override
                            public K getValue() {
                                return this.delegate.key;
                            }

                            @Override
                            public K setValue(K k) {
                                Object k2 = this.delegate.key;
                                int n = Inverse.this.hash(k);
                                if (n == this.delegate.keyHash && Inverse.this.equal(k, k2)) {
                                    return k;
                                }
                                Preconditions.checkArgument((ObjectIntHashBiMap.this.seekByKey(k, n) == null ? 1 : 0) != 0, (String)"value already present: %s", (Object[])new Object[]{k});
                                ObjectIntHashBiMap.this.delete(this.delegate);
                                BiEntry biEntry = new BiEntry(k, n, this.delegate.value, this.delegate.valueHash);
                                ObjectIntHashBiMap.this.insert(biEntry);
                                expectedModCount = ObjectIntHashBiMap.this.modCount;
                                return k2;
                            }
                        }
                    };
                }
            };
        }

        private final class InverseKeySet
        extends AbstractSet<Integer> {
            InverseKeySet() {
            }

            @Override
            public boolean remove(Object object) {
                if (!(object instanceof Number)) {
                    return false;
                }
                int n = ((Number)object).intValue();
                BiEntry biEntry = ObjectIntHashBiMap.this.seekByValue(n, Inverse.this.hash(n));
                if (biEntry == null) {
                    return false;
                }
                ObjectIntHashBiMap.this.delete(biEntry);
                return true;
            }

            @Override
            public Iterator<Integer> iterator() {
                return new Itr<Integer>(Inverse.this.forward()){

                    @Override
                    Integer output(BiEntry<K> biEntry) {
                        return biEntry.value;
                    }
                };
            }

            @Override
            public int size() {
                return Inverse.this.forward().size();
            }
        }
    }

    class EntrySet
    extends AbstractSet<Map.Entry<K, Integer>> {
        EntrySet() {
        }

        ObjectIntHashBiMap<K> map() {
            return ObjectIntHashBiMap.this;
        }

        @Override
        public int size() {
            return this.map().size();
        }

        @Override
        public void clear() {
            this.map().clear();
        }

        @Override
        public boolean contains(Object object) {
            Map.Entry entry;
            Object v;
            if (object instanceof Map.Entry && (v = (entry = (Map.Entry)object).getValue()) instanceof Number) {
                int n = ((Number)v).intValue();
                Object k = entry.getKey();
                BiEntry biEntry = this.map().seekByKey(k, ObjectIntHashBiMap.this.hash(k));
                return biEntry != null && biEntry.value == n;
            }
            return false;
        }

        @Override
        public boolean isEmpty() {
            return this.map().isEmpty();
        }

        @Override
        public boolean remove(Object object) {
            if (this.contains(object)) {
                Map.Entry entry = (Map.Entry)object;
                return this.map().keySet().remove(entry.getKey());
            }
            return false;
        }

        @Override
        public boolean removeAll(Collection<?> collection) {
            try {
                return super.removeAll((Collection)Preconditions.checkNotNull(collection));
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                boolean bl = false;
                Iterator<?> iterator = collection.iterator();
                while (iterator.hasNext()) {
                    bl |= this.remove(iterator.next());
                }
                return bl;
            }
        }

        @Override
        public boolean retainAll(Collection<?> collection) {
            try {
                return super.retainAll((Collection)Preconditions.checkNotNull(collection));
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                HashSet hashSet = Sets.newHashSetWithExpectedSize((int)collection.size());
                for (Object obj : collection) {
                    if (!this.contains(obj)) continue;
                    Map.Entry entry = (Map.Entry)obj;
                    hashSet.add(entry.getKey());
                }
                return this.map().keySet().retainAll(hashSet);
            }
        }

        @Override
        public Iterator<Map.Entry<K, Integer>> iterator() {
            return new Itr<Map.Entry<K, Integer>>(){

                @Override
                Map.Entry<K, Integer> output(BiEntry<K> biEntry) {
                    return new MapEntry(biEntry);
                }

                class MapEntry
                implements Map.Entry<K, Integer> {
                    BiEntry<K> delegate;

                    MapEntry(BiEntry<K> biEntry) {
                        this.delegate = biEntry;
                    }

                    @Override
                    public K getKey() {
                        return this.delegate.key;
                    }

                    @Override
                    public Integer getValue() {
                        return this.delegate.value;
                    }

                    @Override
                    public Integer setValue(Integer n) {
                        Preconditions.checkNotNull((Object)n, (Object)"value cannot be null");
                        int n2 = this.delegate.value;
                        int n3 = ObjectIntHashBiMap.this.hash(n);
                        int n4 = n;
                        if (n3 == this.delegate.valueHash & n4 == n2) {
                            return n;
                        }
                        Preconditions.checkArgument((ObjectIntHashBiMap.this.seekByValue(n4, n3) == null ? 1 : 0) != 0, (String)"value already present: %s", (Object[])new Object[]{n});
                        ObjectIntHashBiMap.this.delete(this.delegate);
                        BiEntry biEntry = new BiEntry(this.delegate.key, this.delegate.keyHash, n4, n3);
                        ObjectIntHashBiMap.this.insert(biEntry);
                        expectedModCount = ObjectIntHashBiMap.this.modCount;
                        if (toRemove == this.delegate) {
                            toRemove = biEntry;
                        }
                        this.delegate = biEntry;
                        return n2;
                    }
                }
            };
        }
    }

    private final class KeySet
    extends AbstractSet<K> {
        KeySet() {
        }

        @Override
        public Iterator<K> iterator() {
            return new Itr<K>(){

                @Override
                K output(BiEntry<K> biEntry) {
                    return biEntry.key;
                }
            };
        }

        @Override
        public boolean remove(Object object) {
            BiEntry biEntry = ObjectIntHashBiMap.this.seekByKey(object, ObjectIntHashBiMap.this.hash(object));
            if (biEntry == null) {
                return false;
            }
            ObjectIntHashBiMap.this.delete(biEntry);
            return true;
        }

        @Override
        public int size() {
            return ObjectIntHashBiMap.this.size();
        }
    }

    abstract class Itr<T>
    implements Iterator<T> {
        int nextBucket = 0;
        BiEntry<K> next = null;
        BiEntry<K> toRemove = null;
        int expectedModCount = ObjectIntHashBiMap.access$000(ObjectIntHashBiMap.this);

        Itr() {
        }

        private void checkForConcurrentModification() {
            if (ObjectIntHashBiMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public boolean hasNext() {
            this.checkForConcurrentModification();
            if (this.next != null) {
                return true;
            }
            while (this.nextBucket < ObjectIntHashBiMap.this.hashTableKToV.length) {
                if (ObjectIntHashBiMap.this.hashTableKToV[this.nextBucket] != null) {
                    this.next = ObjectIntHashBiMap.this.hashTableKToV[this.nextBucket++];
                    return true;
                }
                ++this.nextBucket;
            }
            return false;
        }

        @Override
        public T next() {
            this.checkForConcurrentModification();
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            BiEntry biEntry = this.next;
            this.next = biEntry.nextInKToVBucket;
            this.toRemove = biEntry;
            return this.output(biEntry);
        }

        @Override
        public void remove() {
            this.checkForConcurrentModification();
            ObjectIntHashBiMap.checkRemove(this.toRemove != null);
            ObjectIntHashBiMap.this.delete(this.toRemove);
            this.expectedModCount = ObjectIntHashBiMap.this.modCount;
            this.toRemove = null;
        }

        abstract T output(BiEntry<K> var1);
    }

    private static final class BiEntry<K> {
        final K key;
        final int value;
        final int keyHash;
        final int valueHash;
        BiEntry<K> nextInKToVBucket;
        BiEntry<K> nextInVToKBucket;

        BiEntry(K k, int n, int n2, int n3) {
            this.key = k;
            this.value = n2;
            this.keyHash = n;
            this.valueHash = n3;
        }
    }
}

