/*
 * Decompiled with CFR 0.152.
 */
package makamys.coretweaks;

import cpw.mods.fml.common.versioning.ComparableVersion;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import makamys.coretweaks.Config;
import net.minecraft.launchwrapper.Launch;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import org.apache.commons.io.IOUtils;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;

public class Compat {
    public static boolean isBetterCrashesPresent() {
        return Config.class.getResource("/vfyjxf/bettercrashes/BetterCrashes.class") != null;
    }

    public static boolean isCrashGuardPresent() {
        return Config.class.getResource("/com/falsepattern/crashguard/CrashGuard.class") != null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isHodgepodgeChatLinkCrashFixEnabled() {
        try (InputStream is = Compat.class.getResourceAsStream("/com/mitchej123/hodgepodge/Hodgepodge.class");){
            if (is == null) return false;
            byte[] data = IOUtils.toByteArray((InputStream)is);
            VersionRetrievingModClassVisitor visitor = new VersionRetrievingModClassVisitor();
            ClassReader classReader = new ClassReader(data);
            classReader.accept((ClassVisitor)visitor, 0);
            if (visitor.modVersion == null) return false;
            String version = visitor.modVersion;
            if (new ComparableVersion(version).compareTo(new ComparableVersion("1.6.14")) < 0) return false;
            Configuration config = new Configuration(new File(Launch.minecraftHome, "config/hodgepodge.cfg"));
            config.load();
            ConfigCategory cat = config.getCategory("fixes");
            if (cat.containsKey("fixUrlDetection")) {
                boolean bl = cat.get("fixUrlDetection").getBoolean();
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public static boolean isBackport5160Present() {
        return Config.class.getResource("/ru/itaros/backport5160/Forge5160Plugin.class") != null;
    }

    public static boolean isOptifinePresent() {
        return Config.class.getResource("/optifine/OptiFineTweaker.class") != null;
    }

    private static class VersionRetrievingModClassVisitor
    extends ClassVisitor {
        public String modVersion;

        public VersionRetrievingModClassVisitor() {
            super(327680);
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            if (desc.equals("Lcpw/mods/fml/common/Mod;")) {
                return new ModAnnotationVisitor();
            }
            return super.visitAnnotation(desc, visible);
        }

        private class ModAnnotationVisitor
        extends AnnotationVisitor {
            public ModAnnotationVisitor() {
                super(327680);
            }

            public void visit(String name, Object value) {
                if (name.equals("version")) {
                    VersionRetrievingModClassVisitor.this.modVersion = (String)value;
                }
            }
        }
    }
}

