/*
 * Decompiled with CFR 0.152.
 */
package makamys.coretweaks;

import cpw.mods.fml.common.versioning.ComparableVersion;
import java.io.File;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.List;
import makamys.coretweaks.Compat;
import makamys.coretweaks.ConfigMigrator;
import makamys.coretweaks.CoreTweaks;
import makamys.coretweaks.util.AnnotationBasedConfigHelper;
import makamys.coretweaks.util.ConfigDumper;
import net.minecraft.launchwrapper.Launch;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;

public class Config {
    private static final String TRUE = "true";
    private static final String FALSE = "false";
    @AnnotationBasedConfigHelper.ConfigWrappedEnum(cat="Tweaks", def="true", com="Lets you survive crashes without the game exiting, usually.\nCompatibility note: Not compatible BetterCrashes and CrashGuard, which do the same thing (this feature will be disabled).")
    public static FeatureSetting crashHandler;
    @AnnotationBasedConfigHelper.ConfigWrappedEnum(cat="Tweaks", def="true", com="Causes lighting updates around the block the player is looking at. A workaround for lighting errors that lets you fix them by staring at them. Useful in the Nether.")
    public static FeatureSetting lightFixStare;
    @AnnotationBasedConfigHelper.ConfigWrappedEnum(cat="Tweaks", def="false", com="EXPERIMENTAL: Uncaps framerate even when framelimiter is enabled. The framerate limit will only be used to decide how much time to spend updating chunks each frame. Vanilla Beta 1.7.3 behavior. It seems to make things worse though, at least with OptiFine.")
    public static FeatureSetting forceUncapFramerate;
    @AnnotationBasedConfigHelper.ConfigWrappedEnum(cat="Tweaks.Mods", def="false", com="Fixes OptiFine's implementation of updateRenderers returning the opposite value of what it should (probably a bug). Only effective when framerate limiter is enabled. Speeds up chunk updates significantly, and increases framerate when there aren't many chunk updates. However, during heavy chunk updating (e.g. when loading a world) it decreases the framerate as a side effect of not being as lazy.")
    public static FeatureSetting ofFixUpdateRenderersReturnValue;
    @AnnotationBasedConfigHelper.ConfigWrappedEnum(cat="Tweaks.Mods", def="true", com="Allows custom sky rendering in OptiFine D6 when using a render distance lower than 8.")
    public static FeatureSetting ofUnlockCustomSkyMinRenderDistance;
    @AnnotationBasedConfigHelper.ConfigWrappedEnum(cat="Tweaks", def="true", com="If enabled, the distance of the view fustrum's far plane will be clamped above `minFarPlaneDistance`. Setting it to 180 or higher fixes clipping in OptiFine's custom skybox that happens when using lower render distances.")
    public static FeatureSetting clampFarPlaneDistance;
    @AnnotationBasedConfigHelper.ConfigFloat(cat="Tweaks.clampFarPlaneDistance", def=180.0f, min=0.0f, max=3.4028235E38f, com="See `clampFarPlaneDistance`.")
    public static float minFarPlaneDistance;
    @AnnotationBasedConfigHelper.ConfigWrappedEnum(cat="Tweaks", def="false", com="Disables fog. Simple as.")
    public static FeatureSetting disableFog;
    @AnnotationBasedConfigHelper.ConfigWrappedEnum(cat="Tweaks", def="false", com="Uncap max length for world name and world seed in the world creation GUI. (By default, it's capped at 32.)")
    public static FeatureSetting uncapCreateWorldGuiTextFieldLength;
    @AnnotationBasedConfigHelper.ConfigWrappedEnum(cat="Tweaks", def="false", com="Add a button to the main menu that loads the last played world.")
    public static FeatureSetting mainMenuContinueButton;
    @AnnotationBasedConfigHelper.ConfigWrappedEnum(cat="Tweaks", def="false", com="In vanilla, the player can't sprint for longer than 30 seconds. This tweak lets you modify this time limit.")
    public static FeatureSetting extendSprintTimeLimit;
    @AnnotationBasedConfigHelper.ConfigInt(cat="Tweaks.extendSprintTimeLimit", def=0x7FFFFFFF, min=0, max=0x7FFFFFFF, com="The maximum amount of ticks the player can sprint for. The default value corresponds to 3.4 years. The vanilla value is 600 ticks (= 30 seconds).")
    public static int sprintTimeLimit;
    @AnnotationBasedConfigHelper.ConfigWrappedEnum(cat="Bugfixes", def="true", com="Restore interdimensional travel sound (travel.ogg). Fixes MC-233, fixed in 1.9")
    public static FeatureSetting restoreTravelSound;
    @AnnotationBasedConfigHelper.ConfigWrappedEnum(cat="Bugfixes", def="true", com="Fixes bug in entity swimming code resulting in small entities (ones with hitboxes less than 0.8 units tall, such as DMod's foxes) being prone to drowning.")
    public static FeatureSetting fixSmallEntitySwim;
    @AnnotationBasedConfigHelper.ConfigWrappedEnum(cat="Tweaks", def="true", com="If enabled, the condition used to decide whether to render opaque or transparent clouds will be set based on the value of `cloudHeightCheckMode`.")
    public static FeatureSetting tweakCloudHeightCheck;
    @AnnotationBasedConfigHelper.ConfigEnum(cat="Tweaks.tweakCloudHeightCheck", def="ALWAYS_TRANSPARENT", com="Lets you tweak the condition used to decide whether to render opaque or transparent clouds.\n* VARIABLE_CORRECTED: Keep vanilla behavior of rendering clouds as opaque when the player is below them and transparent otherwise, but with the turning point corrected to match the cloud height even when the world provider has a different cloud height than 128. Also provides a fix for OptiFine's bug where clouds disappear when the player is between Y=128 and the cloud height level when they are raised.\n* ALWAYS_TRANSPARENT: Always render clouds as transparent (how it is in b1.7.3 and 1.15+)\n* ALWAYS_OPAQUE: Always render clouds as opaque")
    public static CloudHeightCheck cloudHeightCheckMode;
    @AnnotationBasedConfigHelper.ConfigWrappedEnum(cat="Bugfixes", def="true", com="Fixes graphical glitches that happen after recovering from a game crash, caused by world renderer display lists getting deleted but never reallocated. From 1.12.")
    public static FeatureSetting fixDisplayListDelete;
    @AnnotationBasedConfigHelper.ConfigWrappedEnum(cat="Bugfixes", def="true", com="Fixes heightmap calculation not including the top layer of 16x16x16 regions, causing lighting errors (MC-7508)")
    public static FeatureSetting fixHeightmapRange;
    @AnnotationBasedConfigHelper.ConfigWrappedEnum(cat="Bugfixes", def="true", com="Fixes an extra food item sometimes getting silently consumed (MC-849)")
    public static FeatureSetting fixDoubleEat;
    @AnnotationBasedConfigHelper.ConfigWrappedEnum(cat="Bugfixes", def="true", com="Fixes crash when certain invalid URLs appear in chat.\nCompatibility note: Not compatible with `fixUrlDetection` in Hodgepodge 1.6.14 and higher, which does the same (this feature will be disabled).")
    public static FeatureSetting fixForgeChatLinkCrash;
    @AnnotationBasedConfigHelper.ConfigWrappedEnum(cat="Bugfixes", def="true", com="Backports most of https://github.com/MinecraftForge/MinecraftForge/pull/5160, a patch that fixes minecarts duplicating and vanishing.")
    public static FeatureSetting fixEntityTracking;
    @AnnotationBasedConfigHelper.ConfigWrappedEnum(cat="Optimizations", def="true", com="Optimizes WorldServer#getPendingBlockUpdates. Speeds up chunk unloading.\nCompatibility note: Not compatible with OptiFine, which does the same thing (this feature will be disabled).")
    public static FeatureSetting optimizeGetPendingBlockUpdates;
    public static FeatureSetting clientChunkMap;
    @AnnotationBasedConfigHelper.ConfigWrappedEnum(cat="Optimizations", def="true", com="Skip over known libraries during Forge mod discovery. From Forge 1.12 (added in 1.9)")
    public static FeatureSetting forgeModDiscovererSkipKnownLibraries;
    @AnnotationBasedConfigHelper.ConfigWrappedEnum(cat="Optimizations", def="true", com="Cache jar discoverer results (and fix a memory leak as a nice bonus).\nCompatibility note: Not compatible with `jarDiscovererMemoryLeakFix` in FoamFix, which is a subset of this fix (we will attempt to disable their feature - if this fails, this feature will be disabled).")
    public static FeatureSetting jarDiscovererCache;
    @AnnotationBasedConfigHelper.ConfigInt(cat="Optimizations.jarDiscovererCache", def=8, min=-1, max=0x7FFFFFFF, com="Maximum age (in runs) of elements in cache. If an element hasn't been used for more than this many runs, it will be discarded. Set to -1 for no limit.")
    public static int jarDiscovererCacheMaxAge;
    @AnnotationBasedConfigHelper.ConfigWrappedEnum(cat="Optimizations", def="true", com="Don't update progress bar on steps. Only active if splash is disabled.")
    public static FeatureSetting forgeFastProgressBar;
    @AnnotationBasedConfigHelper.ConfigWrappedEnum(cat="Optimizations", def="true", com="Don't strip unusual characters from bar step messages. Only active if splash is disabled.")
    public static FeatureSetting forgeFastStepMessageStrip;
    @AnnotationBasedConfigHelper.ConfigWrappedEnum(cat="Optimizations", def="true", com="Reduces the unnecessary work FMLDeobfuscationRemapper does when we are in a deobfuscated (i.e. development) environment.")
    public static FeatureSetting forgeFastDeobfuscationRemapper;
    @AnnotationBasedConfigHelper.ConfigWrappedEnum(cat="Optimizations.Mods", def="true", com="Replaces the reflection OptiFine uses to access Forge methods in WorldRenderer#updateRenderer with direct calls to those methods. Small speedup during chunk updates.")
    public static FeatureSetting ofOptimizeWorldRenderer;
    @AnnotationBasedConfigHelper.ConfigWrappedEnum(cat="Optimizations.Mods", def="true", com="Removes the call to GL11#getInteger in FastCraft's texture upload handler during texture stitching and uses a cached value instead. Fixes the slowness of texture stitching that happens when OptiFine and FastCraft are both present, and mipmapping is enabled.")
    public static FeatureSetting fcOptimizeTextureUpload;
    @AnnotationBasedConfigHelper.ConfigWrappedEnum(cat="Optimizations", def="true", com="Sets TCP_NODELAY to true, reducing network latency in multiplayer. Works on server as well as client. From Minecraft 1.12 (added in 1.8.1).")
    public static FeatureSetting tcpNoDelay;
    public static FeatureSetting coreTweaksCommand;
    public static FeatureSetting threadedTextureLoader;
    @AnnotationBasedConfigHelper.ConfigWrappedEnum(cat="Optimizations", def="true", com="Enable class transformer cache.")
    public static FeatureSetting transformerCache;
    @AnnotationBasedConfigHelper.ConfigEnum(cat="Optimizations.transformerCache", def="LITE", com="The type of transformer caching to use.\n* LITE: Cache individual transformations of select transformers. Reduces startup time. Safe.\n* FULL: Cache the entire transformer chain. Reduces startup time further, but breaks with many mods.")
    public static TransformerCache transformerCacheMode;
    @AnnotationBasedConfigHelper.ConfigWrappedEnum(cat="Optimizations", def="true", com="Cache the file paths contained in folder resource packs. Eliminates the immense slowdown they add to the loading of large modpacks.")
    public static FeatureSetting fastFolderTexturePack;
    @AnnotationBasedConfigHelper.ConfigWrappedEnum(cat="Optimizations", def="false", com="EXPERIMENTAL: Speed up resource stream construction in DefaultResourcePack. Mostly makes a difference in dev environment.")
    public static FeatureSetting fastDefaultTexturePack;
    public static int threadedTextureLoaderThreadCount;
    @AnnotationBasedConfigHelper.ConfigString(cat="Optimizations.transformerCache.full", def="org.spongepowered.asm.mixin.transformer.Proxy,appeng.transformer.asm.ApiRepairer,com.mumfrey.liteloader.transformers.ClassOverlayTransformer+", com="Comma-separated list of transformers for which the view of the transformer chain should be restored.\n\nThe caching class transformer replaces the transformer chain with just itself. This creates conflicts with certain other transformers which also access the transformer chain, which can result in the game crashing.\nTo solve this, our transformer will restore the view of the transformer chain while these transformers are running.\n\nHow to find bad transformers? If you see another transformer's name in your crash log, or see its name in one of the iterator stack traces printed in debug mode, adding it to this list may solve the problem.\n")
    public static String badTransformers;
    @AnnotationBasedConfigHelper.ConfigString(cat="Optimizations.transformerCache.full", def="net.eq2online.macros.permissions.MacroModPermissions", com="Sometimes caching classes can cause problems. Classes in this list will not be cached.\n")
    public static String badClasses;
    @AnnotationBasedConfigHelper.ConfigString(cat="Optimizations.transformerCache.full", def="CMD files.jar", com="Comma-separated list of mod files to ignore modifications of when deciding if a cache rebuild should be triggered.\nIf your cache keeps getting rebuilt even though you haven't changed any mods, look for deranged mod files and add them to this list.")
    public static String modFilesToIgnore;
    @AnnotationBasedConfigHelper.ConfigInt(cat="Optimizations.transformerCache.full", def=512, min=-1, max=0x7FFFFFFF, com="Cached class bytecode is removed from memory after being used, but the most recent N are kept around because the same class is often transformed more than once. This option sets the value of that N.\n(Set to -1 to keep class bytecode in RAM forever)")
    public static int recentCacheSize;
    @AnnotationBasedConfigHelper.ConfigInt(cat="Optimizations.transformerCache.full", def=1, min=0, max=2, com="* 0: Only print the essential messages.\n* 1: Print when the cache gets saved.\n* 2: Debug mode. Turn this on to log a bunch of stuff that can help find the cause of a crash.")
    public static int verbosity;
    @AnnotationBasedConfigHelper.ConfigStringList(cat="Optimizations.transformerCache.lite", def={"cpw.mods.fml.common.asm.transformers.DeobfuscationTransformer", "codechicken.core.asm.MCPDeobfuscationTransformer", "net.minecraftforge.classloading.FluidIdTransformer", "cpw.mods.fml.common.asm.transformers.SideTransformer", "cpw.mods.fml.common.asm.transformers.TerminalTransformer"}, com="Canonical class names of the transformers that should be cached.")
    public static String[] transformersToCache;
    @AnnotationBasedConfigHelper.ConfigInt(cat="Optimizations.transformerCache.lite", def=128, min=-1, max=0x7FFFFFFF, com="Maximum size (in MB) of cache. If the cache grows larger than this, the least recently used entries will be discarded. Set to -1 for no limit.")
    public static int liteTransformerCacheMaxSizeMB;
    private static AnnotationBasedConfigHelper configHelper;

    public static void reload() {
        Configuration config = new Configuration(new File(Launch.minecraftHome, "config/coretweaks.cfg"), "0.3.0.1");
        config.load();
        configHelper.loadFields(config);
        config.setCategoryComment("_categories", "In this config file, every feature toggle has the name of '_enabled'.\nA feature toggle can be set to the following values. If a different value is provided, the setting will be reverted to the default setting on next start.\n* false: Disable the feature\n* true: Enable the feature if it doesn't cause an incompatibility\n* force: Enable feature unconditionally (for special use cases)\n\nFor convenience, the '_categories' category contains toggles that can be used to disable all features in a category.");
        config.setCategoryComment("Optimizations.transformer_cache.full", "Options for the full caching class transformer. (only appliable if it's enabled)");
        config.setCategoryComment("Optimizations.transformer_cache.lite", "Options for the lite caching class transformer. (only appliable if it's enabled)");
        String loadedVersion = config.getLoadedConfigVersion();
        if (loadedVersion == null || !loadedVersion.startsWith("@") && new ComparableVersion(config.getLoadedConfigVersion()).compareTo(new ComparableVersion("0.3")) < 0) {
            new ConfigMigrator(config).migrate();
            configHelper.saveFields(config);
        }
        Config.sortCategories(config);
        if (ConfigDumper.ENABLED) {
            ConfigDumper.dumpConfig(config);
        }
        if (config.hasChanged()) {
            config.save();
        }
    }

    private static void sortCategories(Configuration config) {
        Field childrenF = null;
        try {
            childrenF = ConfigCategory.class.getDeclaredField("children");
            childrenF.setAccessible(true);
            for (String category : config.getCategoryNames()) {
                ConfigCategory cat = config.getCategory(category);
                List children = (List)childrenF.get(cat);
                Collections.sort(children, (catA, catB) -> {
                    String nameA = catA.getName();
                    String nameB = catB.getName();
                    if (nameA.equals("mods") && !nameB.equals("mods")) {
                        return 1;
                    }
                    if (!nameA.equals("mods") && nameB.equals("mods")) {
                        return -1;
                    }
                    if (nameA.equals("mods") && nameB.equals("mods")) {
                        return 0;
                    }
                    return nameA.compareTo(nameB);
                });
            }
        }
        catch (Exception e) {
            CoreTweaks.LOGGER.info("Failed to sort config categories");
        }
    }

    private static boolean shouldDisable(FeatureSetting feature) {
        if (feature == crashHandler) {
            if (Compat.isBetterCrashesPresent()) {
                CoreTweaks.LOGGER.info("Disabling crash handler because BetterCrashes is present.");
                return true;
            }
            if (Compat.isCrashGuardPresent()) {
                CoreTweaks.LOGGER.info("Disabling crash handler because CrashGuard is present.");
                return true;
            }
        } else if (feature == fixForgeChatLinkCrash) {
            if (Compat.isHodgepodgeChatLinkCrashFixEnabled()) {
                CoreTweaks.LOGGER.info("Disabling forge chat link crash fix because Hodgepodge has the same fix enabled.");
                return true;
            }
        } else if (feature == fixEntityTracking) {
            if (Compat.isBackport5160Present()) {
                CoreTweaks.LOGGER.info("Disabling backport of Forge PR #5160 because backport5160 is present.");
                return true;
            }
        } else if (feature == optimizeGetPendingBlockUpdates && Compat.isOptifinePresent()) {
            CoreTweaks.LOGGER.info("Disabling getPendingBlockUpdates optimization because OptiFine is present.");
            return true;
        }
        return false;
    }

    private static String capitalize(String s) {
        return s.substring(0, 1).toUpperCase() + s.substring(1);
    }

    static {
        clientChunkMap = FeatureSetting.FALSE;
        coreTweaksCommand = FeatureSetting.FALSE;
        threadedTextureLoader = FeatureSetting.FALSE;
        configHelper = new AnnotationBasedConfigHelper(Config.class, CoreTweaks.LOGGER);
    }

    @AnnotationBasedConfigHelper.WrappedEnum(enumClass=Setting.class, categoryProperty="_enabled")
    public static class FeatureSetting
    implements AnnotationBasedConfigHelper.IWrappedEnum {
        private static FeatureSetting FALSE = new FeatureSetting(Setting.FALSE);
        private Setting setting;
        private boolean disabled;

        public FeatureSetting(Setting setting) {
            this.setting = setting;
        }

        public FeatureSetting() {
        }

        public void disable() {
            this.disabled = true;
        }

        public boolean isActive() {
            return this.setting != Setting.FALSE && (this.setting == Setting.FORCE || this.setting == Setting.TRUE && !this.disabled);
        }

        @Override
        public void setValue(Object newValue, Field field, Configuration config) {
            this.setting = (Setting)((Object)newValue);
            if (!this.disabled) {
                AnnotationBasedConfigHelper.ConfigWrappedEnum ann = field.getAnnotation(AnnotationBasedConfigHelper.ConfigWrappedEnum.class);
                if (!config.getBoolean("enable" + Config.capitalize(ann.cat().toLowerCase().split("\\.")[0]), "_categories", true, "Set this to false to disable all features in the '" + ann.cat().toLowerCase() + "' category.") || this.setting == Setting.TRUE && Config.shouldDisable(this)) {
                    this.disable();
                }
            }
        }

        @Override
        public Object getValue() {
            return this.setting;
        }

        public void setValue(Setting newValue) {
            this.setting = newValue;
        }

        public boolean equals(Object obj) {
            if (obj instanceof FeatureSetting) {
                FeatureSetting o = (FeatureSetting)obj;
                return this.setting == o.setting;
            }
            return super.equals(obj);
        }

        public static enum Setting {
            FALSE,
            TRUE,
            FORCE;

        }
    }

    public static enum TransformerCache {
        LITE,
        FULL;

    }

    public static enum CloudHeightCheck {
        VARIABLE_CORRECTED,
        ALWAYS_TRANSPARENT,
        ALWAYS_OPAQUE;

    }
}

