/*
 * Decompiled with CFR 0.152.
 */
package makamys.coretweaks;

import java.util.function.Consumer;
import makamys.coretweaks.Config;
import makamys.coretweaks.CoreTweaks;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import org.apache.commons.lang3.EnumUtils;

public class ConfigMigrator {
    private Configuration config;

    public ConfigMigrator(Configuration config) {
        this.config = config;
    }

    public void migrate() {
        CoreTweaks.LOGGER.info("Migrating config from 0.2 to 0.3");
        this.migrateFeatureSetting("bugfixes", "fixDisplayListDelete", Config.fixDisplayListDelete);
        this.migrateFeatureSetting("bugfixes", "fixDoubleEat", Config.fixDoubleEat);
        this.migrateFeatureSetting("bugfixes", "fixForgeChatLinkCrash", Config.fixForgeChatLinkCrash);
        this.migrateFeatureSetting("bugfixes", "fixHeightmapRange", Config.fixHeightmapRange);
        this.migrateFeatureSetting("bugfixes", "fixSmallEntitySwim", Config.fixSmallEntitySwim);
        this.migrateFeatureSetting("bugfixes", "restoreTravelSound", Config.restoreTravelSound);
        this.migrateFeatureSetting("optimizations", "clientChunkMap", Config.clientChunkMap);
        this.migrateFeatureSetting("optimizations", "fastFolderTexturePack", Config.fastFolderTexturePack);
        this.migrateFeatureSetting("optimizations", "fcOptimizeTextureUpload", Config.fcOptimizeTextureUpload);
        this.migrateFeatureSetting("optimizations", "forgeFastDeobfuscationRemapper", Config.forgeFastDeobfuscationRemapper);
        this.migrateFeatureSetting("optimizations", "forgeFastProgressBar", Config.forgeFastProgressBar);
        this.migrateFeatureSetting("optimizations", "forgeFastStepMessageStrip", Config.forgeFastStepMessageStrip);
        this.migrateFeatureSetting("optimizations", "forgeModDiscovererSkipKnownLibraries", Config.forgeModDiscovererSkipKnownLibraries);
        this.migrateFeatureSetting("optimizations", "getPendingBlockUpdates", Config.optimizeGetPendingBlockUpdates);
        this.migrateFeatureSetting("optimizations", "jarDiscovererCache", Config.jarDiscovererCache);
        this.migrateFeatureSetting("optimizations", "ofOptimizeWorldRenderer", Config.ofOptimizeWorldRenderer);
        this.migrateFeatureSetting("optimizations", "tcpNoDelay", Config.tcpNoDelay);
        this.migrateInt("optimizations", "threadedTextureLoaderThreadCount", x -> {
            Config.threadedTextureLoaderThreadCount = x;
        });
        this.migrateEnum("optimizations", "transformerCache", x -> {
            if (x != null) {
                Config.transformerCacheMode = (Config.TransformerCache)((Object)x);
                Config.transformerCache.setValue(Config.FeatureSetting.Setting.TRUE);
            } else {
                Config.transformerCache.setValue(Config.FeatureSetting.Setting.FALSE);
            }
        }, ((Object)((Object)Config.transformerCacheMode)).getClass());
        this.migrateString("transformer_cache_full", "badClasses", x -> {
            Config.badClasses = x;
        });
        this.migrateString("transformer_cache_full", "badTransformers", x -> {
            Config.badTransformers = x;
        });
        this.migrateString("transformer_cache_full", "modFilesToIgnore", x -> {
            Config.modFilesToIgnore = x;
        });
        this.migrateInt("transformer_cache_full", "recentCacheSize", x -> {
            Config.recentCacheSize = x;
        });
        this.migrateInt("transformer_cache_full", "verbosity", x -> {
            Config.verbosity = x;
        });
        this.migrateStringList("transformer_cache_lite", "transformersToCache", x -> {
            Config.transformersToCache = x;
        });
        this.migrateEnum("tweaks", "cloudHeightCheck", x -> {
            if (x != null) {
                Config.cloudHeightCheckMode = (Config.CloudHeightCheck)((Object)x);
                Config.tweakCloudHeightCheck.setValue(Config.FeatureSetting.Setting.TRUE);
            } else {
                Config.tweakCloudHeightCheck.setValue(Config.FeatureSetting.Setting.FALSE);
            }
        }, ((Object)((Object)Config.cloudHeightCheckMode)).getClass());
        this.migrateFeatureSetting("tweaks", "crashHandler", Config.crashHandler);
        this.migrateFeatureSetting("tweaks", "disableFog", Config.disableFog);
        this.migrateFeatureSetting("tweaks", "forceUncapFramerate", Config.forceUncapFramerate);
        this.migrateFeatureSetting("tweaks", "lightFixStare", Config.lightFixStare);
        this.migrateFeatureSetting("tweaks", "mainMenuContinueButton", Config.mainMenuContinueButton);
        this.migrateFloat("tweaks", "minFarPlaneDistance", x -> {
            Config.minFarPlaneDistance = Math.max(0.0f, x.floatValue());
            Config.clampFarPlaneDistance.setValue(x.floatValue() >= 0.0f ? Config.FeatureSetting.Setting.TRUE : Config.FeatureSetting.Setting.FALSE);
        });
        this.migrateFeatureSetting("tweaks", "ofFixUpdateRenderersReturnValue", Config.ofFixUpdateRenderersReturnValue);
        this.migrateFeatureSetting("tweaks", "ofUnlockCustomSkyMinRenderDistance", Config.ofUnlockCustomSkyMinRenderDistance);
        this.migrateFeatureSetting("tweaks", "uncapCreateWorldGuiTextFieldLength", Config.uncapCreateWorldGuiTextFieldLength);
        this.deleteBooleanIfDefault("diagnostics", "coreTweaksCommand", true);
        this.deleteBooleanIfDefault("diagnostics", "crasher", false);
        this.deleteBooleanIfDefault("diagnostics", "forgeBarProfiler", false);
        this.deleteBooleanIfDefault("diagnostics", "frameProfilerHooks", false);
        this.deleteBooleanIfDefault("diagnostics", "frameProfilerPrint", false);
        this.deleteBooleanIfDefault("diagnostics", "frameProfilerStartEnabled", false);
        this.deleteStringIfDefault("diagnostics", "profilerMethods", "");
        this.deleteBooleanIfDefault("diagnostics", "serverRunTimePrinter", false);
        this.deleteBooleanIfDefault("diagnostics", "wireframe", false);
        this.deleteBooleanIfDefault("tweaks", "autoLoadDingOnWorldEntry", true);
        this.deleteBooleanIfDefault("tweaks", "autoLoadPauseOnWorldEntry", true);
        this.deleteIntIfDefault("tweaks", "autoLoadPauseWaitLength", 20);
        for (String catName : this.config.getCategoryNames()) {
            ConfigCategory cat = this.config.getCategory(catName);
            if (!cat.isEmpty()) continue;
            this.config.removeCategory(cat);
        }
    }

    private void deleteIntIfDefault(String cat, String name, int def) {
        Property prop;
        ConfigCategory category;
        if (this.config.hasCategory(cat) && (category = this.config.getCategory(cat)).containsKey(name) && (prop = category.get(name)).getType() == Property.Type.INTEGER && prop.getInt() == def) {
            category.remove((Object)name);
        }
    }

    private void deleteStringIfDefault(String cat, String name, String def) {
        Property prop;
        ConfigCategory category;
        if (this.config.hasCategory(cat) && (category = this.config.getCategory(cat)).containsKey(name) && (prop = category.get(name)).getType() == Property.Type.STRING && prop.getString().equals(def)) {
            category.remove((Object)name);
        }
    }

    private void deleteBooleanIfDefault(String cat, String name, boolean def) {
        Property prop;
        ConfigCategory category;
        if (this.config.hasCategory(cat) && (category = this.config.getCategory(cat)).containsKey(name) && (prop = category.get(name)).getType() == Property.Type.BOOLEAN && prop.getBoolean() == def) {
            category.remove((Object)name);
        }
    }

    private void migrateFeatureSetting(String cat, String name, Config.FeatureSetting setting) {
        Property prop;
        ConfigCategory category;
        if (this.config.hasCategory(cat) && (category = this.config.getCategory(cat)).containsKey(name) && (prop = category.get(name)).getType() == Property.Type.BOOLEAN) {
            setting.setValue(prop.getBoolean() ? Config.FeatureSetting.Setting.TRUE : Config.FeatureSetting.Setting.FALSE);
            category.remove((Object)name);
        }
    }

    private void migrateInt(String cat, String name, Consumer<Integer> consumer) {
        Property prop;
        ConfigCategory category;
        if (this.config.hasCategory(cat) && (category = this.config.getCategory(cat)).containsKey(name) && (prop = category.get(name)).getType() == Property.Type.INTEGER) {
            consumer.accept(prop.getInt());
            category.remove((Object)name);
        }
    }

    private void migrateString(String cat, String name, Consumer<String> consumer) {
        Property prop;
        ConfigCategory category;
        if (this.config.hasCategory(cat) && (category = this.config.getCategory(cat)).containsKey(name) && (prop = category.get(name)).getType() == Property.Type.STRING) {
            consumer.accept(prop.getString());
            category.remove((Object)name);
        }
    }

    private void migrateFloat(String cat, String name, Consumer<Float> consumer) {
        Property prop;
        ConfigCategory category;
        if (this.config.hasCategory(cat) && (category = this.config.getCategory(cat)).containsKey(name) && (prop = category.get(name)).getType() == Property.Type.STRING) {
            consumer.accept(Float.valueOf((float)prop.getDouble()));
            category.remove((Object)name);
        }
    }

    private void migrateStringList(String cat, String name, Consumer<String[]> consumer) {
        Property prop;
        ConfigCategory category;
        if (this.config.hasCategory(cat) && (category = this.config.getCategory(cat)).containsKey(name) && (prop = category.get(name)).getType() == Property.Type.STRING) {
            consumer.accept(prop.getStringList());
            category.remove((Object)name);
        }
    }

    private void migrateEnum(String cat, String name, Consumer<Enum<?>> consumer, Class<? extends Enum> enumClass) {
        Property prop;
        ConfigCategory category;
        if (this.config.hasCategory(cat) && (category = this.config.getCategory(cat)).containsKey(name) && (prop = category.get(name)).getType() == Property.Type.STRING) {
            consumer.accept((Enum)EnumUtils.getEnumMap(enumClass).get(prop.getString().toUpperCase()));
            category.remove((Object)name);
        }
    }
}

