/*
 * Decompiled with CFR 0.152.
 */
package makamys.coretweaks.optimization;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.unsafe.UnsafeInput;
import com.esotericsoftware.kryo.unsafe.UnsafeOutput;
import cpw.mods.fml.common.discovery.asm.ASMModParser;
import cpw.mods.fml.common.discovery.asm.ModAnnotation;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import makamys.coretweaks.Config;
import makamys.coretweaks.CoreTweaks;
import makamys.coretweaks.util.Util;
import org.objectweb.asm.Type;

public class JarDiscovererCache {
    private static Map<String, CachedModInfo> cache = new HashMap<String, CachedModInfo>();
    private static int epoch;
    private static byte MAGIC_0;
    private static byte VERSION;
    private static final File DAT_OLD;
    private static final File DAT;
    private static final File DAT_ERRORED;
    private static final Kryo kryo;

    public static void load() {
        CoreTweaks.LOGGER.info("Loading JarDiscovererCache");
        kryo.register(Type.class, new TypeSerializer());
        kryo.register(ModAnnotation.class, new ModAnnotationSerializer());
        kryo.register(ModAnnotation.EnumHolder.class, new EnumHolderSerializer());
        kryo.setRegistrationRequired(false);
        if (DAT_OLD.exists() && !DAT.exists()) {
            CoreTweaks.LOGGER.info("Migrating jar discoverer cache: " + DAT_OLD + " -> " + DAT);
            DAT_OLD.renameTo(DAT);
        }
        if (DAT.exists()) {
            try (UnsafeInput is = new UnsafeInput(new BufferedInputStream(new FileInputStream(DAT)));){
                byte magic0 = kryo.readObject(is, Byte.TYPE);
                byte version = kryo.readObject(is, Byte.TYPE);
                epoch = kryo.readObject(is, Integer.TYPE);
                ++epoch;
                if (magic0 != MAGIC_0 || version != VERSION) {
                    CoreTweaks.LOGGER.warn("Jar discoverer cache is either a different version or corrupted, discarding.");
                } else {
                    cache = JarDiscovererCache.returnVerifiedMap(kryo.readObject(is, HashMap.class));
                }
            }
            catch (Exception e) {
                CoreTweaks.LOGGER.error("There was an error reading the jar discoverer cache. A new one will be created. The previous one has been saved as " + DAT_ERRORED.getName() + " for inspection.");
                DAT.renameTo(DAT_ERRORED);
                e.printStackTrace();
                cache.clear();
                epoch = 0;
            }
        }
    }

    private static Map<String, CachedModInfo> returnVerifiedMap(Map<String, CachedModInfo> map) {
        if (map.containsKey(null)) {
            throw new RuntimeException("Map contains null key");
        }
        if (map.containsValue(null)) {
            throw new RuntimeException("Map contains null value");
        }
        return map;
    }

    public static void finish() {
        if (!cache.isEmpty()) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        if (!DAT.exists()) {
                            DAT.getParentFile().mkdirs();
                            DAT.createNewFile();
                        }
                        cache.entrySet().removeIf(e -> epoch - ((CachedModInfo)e.getValue()).lastAccessed > Config.jarDiscovererCacheMaxAge);
                        try (UnsafeOutput output = new UnsafeOutput(new BufferedOutputStream(new FileOutputStream(DAT)));){
                            kryo.writeObject(output, MAGIC_0);
                            kryo.writeObject(output, VERSION);
                            kryo.writeObject(output, epoch);
                            kryo.writeObject(output, cache);
                        }
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                    cache = null;
                }
            }, "CoreTweaks JarDiscovererCache save thread").start();
        }
    }

    public static CachedModInfo getCachedModInfo(String hash) {
        CachedModInfo cmi = cache.get(hash);
        if (cmi == null) {
            cmi = new CachedModInfo(true);
            cache.put(hash, cmi);
        }
        cmi.lastAccessed = epoch;
        return cmi;
    }

    public static boolean isActive() {
        return Config.jarDiscovererCache.isActive();
    }

    static {
        MAGIC_0 = 0;
        VERSION = 1;
        DAT_OLD = Util.childFile(CoreTweaks.CACHE_DIR, "jarDiscovererCache.dat");
        DAT = Util.childFile(CoreTweaks.CACHE_DIR, "jarDiscoverer.cache");
        DAT_ERRORED = Util.childFile(CoreTweaks.CACHE_DIR, "jarDiscoverer.cache.errored");
        kryo = new Kryo();
    }

    public static class EnumHolderSerializer
    extends Serializer<ModAnnotation.EnumHolder> {
        @Override
        public void write(Kryo kryo, Output output, ModAnnotation.EnumHolder eh) {
            try {
                Field descF = eh.getClass().getDeclaredField("desc");
                descF.setAccessible(true);
                Field valueF = eh.getClass().getDeclaredField("value");
                valueF.setAccessible(true);
                String desc = (String)descF.get(eh);
                String value = (String)valueF.get(eh);
                output.writeString(desc);
                output.writeString(value);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                e.printStackTrace();
            }
        }

        @Override
        public ModAnnotation.EnumHolder read(Kryo kryo, Input input, Class<? extends ModAnnotation.EnumHolder> type) {
            ModAnnotation modAnnotation = ModAnnotationSerializer.lastMa;
            modAnnotation.getClass();
            return new ModAnnotation.EnumHolder(modAnnotation, input.readString(), input.readString());
        }
    }

    public static class ModAnnotationSerializer
    extends Serializer<ModAnnotation> {
        private static ModAnnotation lastMa;

        @Override
        public void write(Kryo kryo, Output output, ModAnnotation ma) {
            kryo.writeObject(output, ma.getType());
            kryo.writeObject(output, ma.getASMType());
            output.writeString(ma.getMember());
            HashMap serializableValues = new HashMap();
            kryo.writeObject(output, ma.getValues());
        }

        @Override
        public ModAnnotation read(Kryo kryo, Input input, Class<? extends ModAnnotation> ma) {
            try {
                Field type = ma.getDeclaredField("type");
                Object at = kryo.readObject(input, type.getType());
                ModAnnotation maa = new ModAnnotation(null, kryo.readObject(input, Type.class), input.readString());
                type.setAccessible(true);
                type.set(maa, at);
                lastMa = maa;
                try {
                    Map values = kryo.readObject(input, HashMap.class);
                    values.forEach((k, v) -> maa.addProperty(k, v));
                }
                catch (Exception e) {
                    return null;
                }
                return maa;
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                e.printStackTrace();
                return null;
            }
        }
    }

    public static class TypeSerializer
    extends Serializer<Type> {
        @Override
        public void write(Kryo kryo, Output output, Type type) {
            output.writeByte(type.getSort());
            if (type.getSort() >= 9) {
                output.writeString(type.getInternalName());
            }
        }

        @Override
        public Type read(Kryo kryo, Input input, Class<? extends Type> type) {
            byte sort = input.readByte();
            String buf = sort >= 9 ? input.readString() : null;
            switch (sort) {
                case 0: {
                    return Type.VOID_TYPE;
                }
                case 1: {
                    return Type.BOOLEAN_TYPE;
                }
                case 2: {
                    return Type.CHAR_TYPE;
                }
                case 3: {
                    return Type.BYTE_TYPE;
                }
                case 4: {
                    return Type.SHORT_TYPE;
                }
                case 5: {
                    return Type.INT_TYPE;
                }
                case 6: {
                    return Type.FLOAT_TYPE;
                }
                case 7: {
                    return Type.LONG_TYPE;
                }
                case 8: {
                    return Type.DOUBLE_TYPE;
                }
                case 9: 
                case 10: {
                    return Type.getObjectType((String)buf);
                }
                case 11: {
                    return Type.getMethodType((String)buf);
                }
            }
            return null;
        }
    }

    public static class CachedModInfo {
        Map<String, ASMModParser> parserMap = new HashMap<String, ASMModParser>();
        Set<String> modClasses = new HashSet<String>();
        int lastAccessed;
        transient boolean dirty;

        public CachedModInfo(boolean dirty) {
            this.dirty = dirty;
        }

        public CachedModInfo() {
            this(false);
        }

        public ASMModParser getCachedParser(ZipEntry ze) {
            return this.parserMap.get(ze.getName());
        }

        public void putParser(ZipEntry ze, ASMModParser parser) {
            this.parserMap.put(ze.getName(), parser);
        }

        public int getCachedIsModClass(ZipEntry ze) {
            return this.dirty ? -1 : (this.modClasses.contains(ze.getName()) ? 1 : 0);
        }

        public void putIsModClass(ZipEntry ze, boolean value) {
            if (!this.dirty) {
                throw new IllegalStateException();
            }
            if (value) {
                this.modClasses.add(ze.getName());
            }
        }
    }
}

