/*
 * Decompiled with CFR 0.152.
 */
package makamys.coretweaks.optimization.transformercache.lite;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.unsafe.UnsafeInput;
import com.esotericsoftware.kryo.unsafe.UnsafeOutput;
import com.google.common.hash.Hashing;
import cpw.mods.fml.relauncher.ReflectionHelper;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.SourceVersion;
import makamys.coretweaks.Config;
import makamys.coretweaks.CoreTweaks;
import makamys.coretweaks.IModEventListener;
import makamys.coretweaks.optimization.transformercache.lite.CachedNameTransformerProxy;
import makamys.coretweaks.optimization.transformercache.lite.CachedTransformerProxy;
import makamys.coretweaks.util.Util;
import net.minecraft.launchwrapper.IClassNameTransformer;
import net.minecraft.launchwrapper.IClassTransformer;
import net.minecraft.launchwrapper.Launch;
import net.minecraft.launchwrapper.LaunchClassLoader;

public class TransformerCache
implements IModEventListener {
    public static TransformerCache instance = new TransformerCache();
    private List<IClassTransformer> myTransformers = new ArrayList<IClassTransformer>();
    private Map<String, TransformerData> transformerMap = new HashMap<String, TransformerData>();
    private static final byte MAGIC_0 = 0;
    private static final byte VERSION = 1;
    private static final File DAT_OLD = Util.childFile(CoreTweaks.CACHE_DIR, "transformerCache.dat");
    private static final File DAT = Util.childFile(CoreTweaks.CACHE_DIR, "classTransformerLite.cache");
    private static final File DAT_ERRORED = Util.childFile(CoreTweaks.CACHE_DIR, "classTransformerLite.cache.errored");
    private static final File TRANSFORMERCACHE_PROFILER_CSV = Util.childFile(CoreTweaks.OUT_DIR, "transformercache_profiler.csv");
    private final Kryo kryo = new Kryo();
    private Set<String> transformersToCache = new HashSet<String>();
    private boolean inited = false;
    private static byte[] memoizedHashData;
    private static int memoizedHashValue;

    public void init() {
        if (this.inited) {
            return;
        }
        this.transformersToCache = Arrays.stream(Config.transformersToCache).collect(Collectors.toSet());
        Launch.classLoader.addTransformerExclusion("makamys.coretweaks.optimization.transformercache.lite");
        this.loadData();
        this.hookClassLoader();
    }

    private void hookClassLoader() {
        LaunchClassLoader lcl = Launch.classLoader;
        List transformers = (List)ReflectionHelper.getPrivateValue(LaunchClassLoader.class, (Object)lcl, (String[])new String[]{"transformers"});
        for (int i = 0; i < transformers.size(); ++i) {
            IClassTransformer transformer = (IClassTransformer)transformers.get(i);
            if (!this.transformersToCache.contains(transformer.getClass().getCanonicalName())) continue;
            CoreTweaks.LOGGER.info("Replacing " + transformer.getClass().getCanonicalName() + " with cached proxy");
            CachedTransformerProxy newTransformer = transformer instanceof IClassNameTransformer ? new CachedNameTransformerProxy(transformer) : new CachedTransformerProxy(transformer);
            this.myTransformers.add(newTransformer);
            transformers.set(i, newTransformer);
        }
    }

    private void loadData() {
        this.kryo.setRegistrationRequired(false);
        if (DAT_OLD.exists() && !DAT.exists()) {
            CoreTweaks.LOGGER.info("Migrating class cache: " + DAT_OLD + " -> " + DAT);
            DAT_OLD.renameTo(DAT);
        }
        if (DAT.exists()) {
            try (UnsafeInput is = new UnsafeInput(new BufferedInputStream(new FileInputStream(DAT)));){
                byte magic0 = this.kryo.readObject(is, Byte.TYPE);
                byte version = this.kryo.readObject(is, Byte.TYPE);
                if (magic0 != 0 || version != 1) {
                    CoreTweaks.LOGGER.warn("Transformer cache is either a different version or corrupted, discarding.");
                } else {
                    this.transformerMap = TransformerCache.returnVerifiedTransformerMap(this.kryo.readObject(is, HashMap.class));
                }
                for (TransformerData data : this.transformerMap.values()) {
                    if (Arrays.asList(Config.transformersToCache).contains(data.transformerClassName)) continue;
                    CoreTweaks.LOGGER.info("Dropping " + data.transformerClassName + " from cache because we don't care about it anymore.");
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                CoreTweaks.LOGGER.error("There was an error reading the transformer cache. A new one will be created. The previous one has been saved as " + DAT_ERRORED.getName() + " for inspection.");
                DAT.renameTo(DAT_ERRORED);
                e.printStackTrace();
            }
        }
    }

    private static Map<String, TransformerData> returnVerifiedTransformerMap(Map<String, TransformerData> map) {
        if (map.containsKey(null)) {
            throw new RuntimeException("Map contains null key");
        }
        if (map.containsValue(null)) {
            throw new RuntimeException("Map contains null value");
        }
        for (String key : map.keySet()) {
            if (SourceVersion.isName(key)) continue;
            throw new RuntimeException("Map contains invalid key: " + key);
        }
        return map;
    }

    @Override
    public void onShutdown() {
        try {
            this.saveTransformerCache();
            this.saveProfilingResults();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void saveTransformerCache() throws IOException {
        if (!DAT.exists()) {
            DAT.getParentFile().mkdirs();
            DAT.createNewFile();
        }
        CoreTweaks.LOGGER.info("Saving transformer cache");
        this.trimCache((long)Config.liteTransformerCacheMaxSizeMB * 1024L * 1024L);
        try (UnsafeOutput output = new UnsafeOutput(new BufferedOutputStream(new FileOutputStream(DAT)));){
            this.kryo.writeObject(output, (byte)0);
            this.kryo.writeObject(output, (byte)1);
            this.kryo.writeObject(output, this.transformerMap);
        }
    }

    private void trimCache(long maxSize) {
        if (maxSize == -1L) {
            return;
        }
        ArrayList<TransformerData.CachedTransformation> data = new ArrayList<TransformerData.CachedTransformation>();
        for (TransformerData transData : this.transformerMap.values()) {
            data.addAll(transData.transformationMap.values());
        }
        data.sort(this::sortByAge);
        long usedSpace = 0L;
        int cutoff = -1;
        for (int i = data.size() - 1; i >= 0; --i) {
            if ((usedSpace += (long)((TransformerData.CachedTransformation)data.get(i)).getEstimatedSize()) <= maxSize) continue;
            cutoff = ((TransformerData.CachedTransformation)data.get((int)i)).lastAccessed;
            break;
        }
        if (cutoff != -1) {
            int cutoffCopy = cutoff;
            for (TransformerData transData : this.transformerMap.values()) {
                transData.transformationMap.entrySet().removeIf(e -> ((TransformerData.CachedTransformation)e.getValue()).lastAccessed <= cutoffCopy);
            }
            this.transformerMap.entrySet().removeIf(e -> ((TransformerData)e.getValue()).transformationMap.isEmpty());
        }
    }

    private int sortByAge(TransformerData.CachedTransformation a, TransformerData.CachedTransformation b) {
        return a.lastAccessed < b.lastAccessed ? -1 : (a.lastAccessed > b.lastAccessed ? 1 : 0);
    }

    private void saveProfilingResults() throws IOException {
        try (FileWriter fw = new FileWriter(TRANSFORMERCACHE_PROFILER_CSV);){
            fw.write("class,name,runs,misses\n");
            for (IClassTransformer transformer : this.myTransformers) {
                String className = transformer.getClass().getCanonicalName();
                String name = transformer.toString();
                int runs = 0;
                int misses = 0;
                if (transformer instanceof CachedTransformerProxy) {
                    CachedTransformerProxy proxy = (CachedTransformerProxy)transformer;
                    runs = proxy.runs;
                    misses = proxy.misses;
                }
                fw.write(className + "," + name + "," + runs + "," + misses + "\n");
            }
        }
    }

    public byte[] getCached(String transName, String name, String transformedName, byte[] basicClass) {
        TransformerData.CachedTransformation trans;
        TransformerData transData = this.transformerMap.get(transName);
        if (transData != null && (trans = transData.transformationMap.get(transformedName)) != null && TransformerCache.nullSafeLength(basicClass) == trans.preLength && TransformerCache.calculateHash(basicClass) == trans.preHash) {
            trans.lastAccessed = TransformerCache.now();
            return trans.postHash == trans.preHash ? basicClass : trans.newClass;
        }
        return null;
    }

    private static int nullSafeLength(byte[] array) {
        return array == null ? -1 : array.length;
    }

    public void prePutCached(String transName, String name, String transformedName, byte[] basicClass) {
        TransformerData data = this.transformerMap.get(transName);
        if (data == null) {
            data = new TransformerData(transName);
            this.transformerMap.put(transName, data);
        }
        data.transformationMap.put(transformedName, new TransformerData.CachedTransformation(transformedName, TransformerCache.calculateHash(basicClass), TransformerCache.nullSafeLength(basicClass)));
    }

    public void putCached(String transName, String name, String transformedName, byte[] result) {
        this.transformerMap.get((Object)transName).transformationMap.get(transformedName).putClass(result);
    }

    public static int calculateHash(byte[] data) {
        if (data == memoizedHashData) {
            return memoizedHashValue;
        }
        memoizedHashData = data;
        memoizedHashValue = data == null ? -1 : Hashing.adler32().hashBytes(data).asInt();
        return memoizedHashValue;
    }

    private static int now() {
        return (int)(System.currentTimeMillis() / 1000L / 60L);
    }

    public static class TransformerData {
        String transformerClassName;
        Map<String, CachedTransformation> transformationMap = new HashMap<String, CachedTransformation>();

        public TransformerData(String transformerClassName) {
            this.transformerClassName = transformerClassName;
        }

        public TransformerData() {
        }

        public static class CachedTransformation {
            String targetClassName;
            int preLength;
            int preHash;
            int postHash;
            byte[] newClass;
            int lastAccessed;

            public CachedTransformation() {
            }

            public CachedTransformation(String targetClassName, int preHash, int preLength) {
                this.targetClassName = targetClassName;
                this.preHash = preHash;
                this.preLength = preLength;
                this.lastAccessed = TransformerCache.now();
            }

            public void putClass(byte[] result) {
                this.postHash = TransformerCache.calculateHash(result);
                if (this.preHash != this.postHash) {
                    this.newClass = result;
                }
            }

            public int getEstimatedSize() {
                return this.targetClassName.length() + 4 + 4 + 4 + (this.newClass != null ? this.newClass.length : 0) + 4;
            }
        }
    }
}

