/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.mod.DynSurround.client.fog;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import org.blockartistry.mod.DynSurround.client.EnvironStateHandler;
import org.blockartistry.mod.DynSurround.client.fog.FogResult;
import org.blockartistry.mod.DynSurround.client.fog.VanillaFogRangeCalculator;
import org.blockartistry.mod.DynSurround.client.weather.Weather;
import org.blockartistry.mod.DynSurround.data.BiomeRegistry;
import org.blockartistry.mod.DynSurround.util.MathStuff;

@SideOnly(value=Side.CLIENT)
public class BiomeFogRangeCalculator
extends VanillaFogRangeCalculator {
    protected static final int DISTANCE = 20;
    protected static final float DUST_FOG_IMPACT = 0.9f;
    protected final Context[] context = new Context[]{new Context(), new Context(), new Context()};

    private int getIdx(@Nonnull EntityViewRenderEvent.RenderFogEvent event) {
        return event.fogMode < 0 ? 2 : event.fogMode;
    }

    @Override
    @Nonnull
    public FogResult calculate(@Nonnull EntityViewRenderEvent.RenderFogEvent event) {
        EntityPlayer player = EnvironStateHandler.EnvironState.getPlayer();
        World world = EnvironStateHandler.EnvironState.getWorld();
        int playerX = MathStuff.floor(player.field_70165_t);
        int playerY = MathStuff.floor(player.field_70163_u);
        int playerZ = MathStuff.floor(player.field_70161_v);
        float rainStr = Weather.getIntensityLevel();
        Context ctx = this.context[this.getIdx(event)];
        if (ctx.returnCached(playerX, playerZ, rainStr, event)) {
            return ctx.cached;
        }
        float fpDistanceBiomeFog = 0.0f;
        float weightBiomeFog = 0.0f;
        boolean isRaining = Weather.isRaining();
        ctx.rain = rainStr;
        ctx.doScan = false;
        for (int x = -20; x <= 20; ++x) {
            for (int z = -20; z <= 20; ++z) {
                int theX = playerX + x;
                int theZ = playerZ + z;
                BiomeGenBase biome = world.func_72807_a(theX, theZ);
                float distancePart = 1.0f;
                float weightPart = 1.0f;
                ctx.doScan = ctx.doScan | !world.func_72899_e(theX, playerY, theZ);
                if (isRaining && BiomeRegistry.hasDust(biome)) {
                    distancePart = 1.0f - 0.9f * rainStr;
                } else if (BiomeRegistry.hasFog(biome)) {
                    distancePart = BiomeRegistry.getFogDensity(biome);
                }
                fpDistanceBiomeFog += distancePart;
                weightBiomeFog += 1.0f;
            }
        }
        float weightMixed = 1681.0f;
        float weightDefault = 1681.0f - weightBiomeFog;
        float fpDistanceBiomeFogAvg = weightBiomeFog == 0.0f ? 0.0f : fpDistanceBiomeFog / weightBiomeFog;
        float farPlaneDistance = (fpDistanceBiomeFog * 240.0f + event.farPlaneDistance * weightDefault) / 1681.0f;
        float farPlaneDistanceScaleBiome = 0.1f * (1.0f - fpDistanceBiomeFogAvg) + 0.75f * fpDistanceBiomeFogAvg;
        float farPlaneDistanceScale = (farPlaneDistanceScaleBiome * weightBiomeFog + 0.75f * weightDefault) / 1681.0f;
        ctx.posX = playerX;
        ctx.posZ = playerZ;
        ctx.lastFarPlane = event.farPlaneDistance;
        farPlaneDistance = Math.min(farPlaneDistance, event.farPlaneDistance);
        ctx.cached.set(event.fogMode, farPlaneDistance, farPlaneDistanceScale);
        return ctx.cached;
    }

    private static class Context {
        public int posX;
        public int posZ;
        public float rain;
        public float lastFarPlane;
        public boolean doScan = true;
        public final FogResult cached = new FogResult();

        private Context() {
        }

        public boolean returnCached(int pX, int pZ, float r, @Nonnull EntityViewRenderEvent.RenderFogEvent event) {
            return !this.doScan && pX == this.posX && pZ == this.posZ && r == this.rain && this.lastFarPlane == event.farPlaneDistance && this.cached.isValid(event);
        }
    }
}

