/*
 * Decompiled with CFR 0.152.
 */
package org.blockartistry.mod.DynSurround.client.weather;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gnu.trove.map.hash.TIntObjectHashMap;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.gen.NoiseGeneratorSimplex;
import org.apache.commons.lang3.StringUtils;
import org.blockartistry.mod.DynSurround.ModOptions;
import org.blockartistry.mod.DynSurround.client.EnvironStateHandler;
import org.blockartistry.mod.DynSurround.client.WeatherUtils;
import org.blockartistry.mod.DynSurround.client.fx.particle.ParticleFactory;
import org.blockartistry.mod.DynSurround.client.weather.NetherSplashRenderer;
import org.blockartistry.mod.DynSurround.client.weather.NullSplashRenderer;
import org.blockartistry.mod.DynSurround.client.weather.Weather;
import org.blockartistry.mod.DynSurround.compat.IParticleFactory;
import org.blockartistry.mod.DynSurround.data.BiomeRegistry;
import org.blockartistry.mod.DynSurround.data.DimensionRegistry;
import org.blockartistry.mod.DynSurround.util.DiurnalUtils;
import org.blockartistry.mod.DynSurround.util.random.XorShiftRandom;

@SideOnly(value=Side.CLIENT)
public class StormSplashRenderer {
    private static final TIntObjectHashMap<StormSplashRenderer> splashRenderers = new TIntObjectHashMap();
    private static final StormSplashRenderer DEFAULT = new StormSplashRenderer();
    protected static final int PARTICLE_SOUND_CHANCE = 20;
    protected static final int RANGE = 10;
    protected static final XorShiftRandom RANDOM;
    protected static final NoiseGeneratorSimplex GENERATOR;

    public static void renderStormSplashes(int dimensionId, EntityRenderer renderer) {
        StormSplashRenderer splash = (StormSplashRenderer)splashRenderers.get(dimensionId);
        if (splash == null) {
            splash = DEFAULT;
        }
        splash.addRainParticles(renderer);
    }

    protected StormSplashRenderer() {
    }

    protected static float calculateRainSoundVolume(World world) {
        return MathHelper.func_76131_a((float)((float)((double)Weather.getCurrentVolume() + GENERATOR.func_151605_a((double)(DiurnalUtils.getClockTime(world) / 100L), 1.0) / 5.0)), (float)0.0f, (float)1.0f);
    }

    protected EntityFX getBlockParticleFX(Block block, boolean dust, World world, double x, double y, double z) {
        IParticleFactory factory = null;
        if (dust) {
            factory = null;
        } else if (block == Blocks.field_150425_aM) {
            factory = null;
        } else if (block == Blocks.field_150424_aL && RANDOM.nextInt(20) == 0) {
            factory = ParticleFactory.lavaSpark;
        } else if (block.func_149688_o() == Material.field_151587_i) {
            factory = ParticleFactory.smoke;
        } else if (block.func_149688_o() != Material.field_151579_a) {
            factory = ParticleFactory.rain;
        }
        return factory != null ? factory.getEntityFX(0, world, x, y, z, 0.0, 0.0, 0.0, new int[0]) : null;
    }

    protected String getBlockSoundFX(Block block, boolean hasDust, World world) {
        if (hasDust) {
            return Weather.getIntensity().getDustSound();
        }
        if (block == Blocks.field_150424_aL) {
            return "minecraft:liquid.lavapop";
        }
        return Weather.getIntensity().getStormSound();
    }

    protected int getPrecipitationHeight(World world, int range, int x, int z) {
        return world.func_72874_g(x, z);
    }

    protected void playSplashSound(EntityRenderer renderer, WorldClient world, EntityLivingBase player, double x, double y, double z) {
        int theX = MathHelper.func_76128_c((double)x);
        int theY = MathHelper.func_76128_c((double)y);
        int theZ = MathHelper.func_76128_c((double)z);
        boolean hasDust = WeatherUtils.biomeHasDust(world.func_72807_a(theX, theZ));
        Block block = world.func_147439_a(theX, theY - 1, theZ);
        String sound = this.getBlockSoundFX(block, hasDust, (World)world);
        if (!StringUtils.isEmpty((CharSequence)sound)) {
            float volume = StormSplashRenderer.calculateRainSoundVolume((World)world);
            float pitch = 1.0f;
            int playerX = MathHelper.func_76128_c((double)player.field_70165_t);
            int playerY = MathHelper.func_76128_c((double)player.field_70163_u);
            int playerZ = MathHelper.func_76128_c((double)player.field_70161_v);
            if (y > player.field_70163_u + 1.0 && world.func_72874_g(playerX, playerZ) > playerY) {
                pitch = 0.5f;
            }
            renderer.field_78531_r.field_71441_e.func_72980_b(x, y, z, sound, volume, pitch, false);
        }
    }

    public void addRainParticles(EntityRenderer theThis) {
        if (theThis.field_78531_r.field_71474_y.field_74362_aa == 2) {
            return;
        }
        if (!DimensionRegistry.hasWeather(EnvironStateHandler.EnvironState.getWorld())) {
            return;
        }
        float rainStrengthFactor = theThis.field_78531_r.field_71441_e.func_72867_j(1.0f);
        if (!theThis.field_78531_r.field_71474_y.field_74347_j) {
            rainStrengthFactor /= 2.0f;
        }
        if (rainStrengthFactor <= 0.0f) {
            return;
        }
        RANDOM.setSeed((long)theThis.field_78529_t * 312987231L);
        EntityLivingBase entity = theThis.field_78531_r.field_71451_h;
        WorldClient worldclient = theThis.field_78531_r.field_71441_e;
        int playerX = MathHelper.func_76128_c((double)entity.field_70165_t);
        int playerY = MathHelper.func_76128_c((double)entity.field_70163_u);
        int playerZ = MathHelper.func_76128_c((double)entity.field_70161_v);
        double spawnX = 0.0;
        double spawnY = 0.0;
        double spawnZ = 0.0;
        int particlesSpawned = 0;
        int particleCount = (int)((float)ModOptions.particleCountBase * rainStrengthFactor * rainStrengthFactor);
        if (theThis.field_78531_r.field_71474_y.field_74362_aa == 1) {
            particleCount >>= 1;
        }
        for (int j1 = 0; j1 < particleCount; ++j1) {
            double posZ;
            double posY;
            double posX;
            int locX = playerX + RANDOM.nextInt(10) - RANDOM.nextInt(10);
            int locZ = playerZ + RANDOM.nextInt(10) - RANDOM.nextInt(10);
            int locY = this.getPrecipitationHeight((World)worldclient, 5, locX, locZ);
            BiomeGenBase biome = worldclient.func_72807_a(locX, locZ);
            boolean hasDust = WeatherUtils.biomeHasDust(biome);
            if (locY > playerY + 10 || locY < playerY - 10 || !hasDust && (!BiomeRegistry.hasPrecipitation(biome) || !(biome.func_150564_a(locX, locY, locZ) >= 0.15f))) continue;
            Block block = worldclient.func_147439_a(locX, locY - 1, locZ);
            EntityFX particle = this.getBlockParticleFX(block, hasDust, (World)worldclient, posX = (double)((float)locX + RANDOM.nextFloat()), posY = (double)((float)locY + 0.1f) - block.func_149665_z(), posZ = (double)((float)locZ + RANDOM.nextFloat()));
            if (particle != null) {
                theThis.field_78531_r.field_71452_i.func_78873_a(particle);
            }
            if (RANDOM.nextInt(++particlesSpawned) != 0) continue;
            spawnX = posX;
            spawnY = posY;
            spawnZ = posZ;
        }
        if (particlesSpawned > 0 && RANDOM.nextInt(20) < theThis.field_78534_ac++) {
            theThis.field_78534_ac = 0;
            this.playSplashSound(theThis, worldclient, entity, spawnX, spawnY, spawnZ);
        }
    }

    static {
        splashRenderers.put(0, (Object)DEFAULT);
        splashRenderers.put(-1, (Object)new NetherSplashRenderer());
        splashRenderers.put(1, (Object)new NullSplashRenderer());
        RANDOM = new XorShiftRandom();
        GENERATOR = new NoiseGeneratorSimplex((Random)RANDOM);
    }
}

