/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.foamfix.coremod.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import net.minecraft.launchwrapper.LaunchClassLoader;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.commons.Remapper;
import org.objectweb.asm.commons.RemappingClassAdapter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import pl.asie.foamfix.bugfixmod.coremod.BugfixModClassTransformer;

public final class ClassSplicingUtil {
    private ClassSplicingUtil() {
    }

    private static byte[] getClassBytes(String className) throws IOException {
        ClassLoader loader = ClassSplicingUtil.class.getClassLoader();
        if (loader instanceof LaunchClassLoader) {
            return ((LaunchClassLoader)loader).getClassBytes(className);
        }
        throw new RuntimeException("Incompatible class loader for FoamFixTransformer.getClassBytes: " + loader.getClass().getName());
    }

    public static boolean spliceClasses(ClassNode data, String className, boolean addMethods, String ... methods) {
        try {
            byte[] dataSplice = ClassSplicingUtil.getClassBytes(className);
            return ClassSplicingUtil.spliceClasses(data, dataSplice, className, addMethods, methods);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static boolean spliceClasses(ClassNode nodeData, byte[] dataSplice, String className, boolean addMethods, String ... methods) {
        int j;
        boolean added;
        MethodNode mn;
        int i;
        if (dataSplice == null) {
            throw new RuntimeException("Class " + className + " not found! This is a FoamFix bug!");
        }
        boolean addedGlobal = false;
        HashSet methodSet = Sets.newHashSet((Object[])methods);
        ArrayList methodList = Lists.newArrayList((Object[])methods);
        ClassReader readerSplice = new ClassReader(dataSplice);
        final String className2 = className.replace('.', '/');
        final String targetClassName2 = nodeData.name;
        String targetClassName = targetClassName2.replace('/', '.');
        Remapper remapper = new Remapper(){

            public String map(String name) {
                return className2.equals(name) ? targetClassName2 : name;
            }
        };
        ClassNode nodeSplice = new ClassNode();
        readerSplice.accept((ClassVisitor)new RemappingClassAdapter((ClassVisitor)nodeSplice, remapper), 8);
        for (String s : nodeSplice.interfaces) {
            if (!s.contains("IFoamFix")) continue;
            nodeData.interfaces.add(s);
            BugfixModClassTransformer.instance.logger.info("Added INTERFACE: " + s);
        }
        for (i = 0; i < nodeSplice.methods.size(); ++i) {
            if (!methodSet.contains(((MethodNode)nodeSplice.methods.get((int)i)).name)) continue;
            mn = (MethodNode)nodeSplice.methods.get(i);
            added = false;
            for (j = 0; j < nodeData.methods.size(); ++j) {
                if (!((MethodNode)nodeData.methods.get((int)j)).name.equals(mn.name) || !((MethodNode)nodeData.methods.get((int)j)).desc.equals(mn.desc)) continue;
                MethodNode oldMn = (MethodNode)nodeData.methods.get(j);
                BugfixModClassTransformer.instance.logger.info("Spliced in METHOD: " + targetClassName + "." + mn.name);
                nodeData.methods.set(j, mn);
                if (nodeData.superName != null && nodeData.name.equals(nodeSplice.superName)) {
                    for (AbstractInsnNode node : mn.instructions) {
                        if (!(node instanceof MethodInsnNode) || node.getOpcode() != 183) continue;
                        MethodInsnNode methodNode = (MethodInsnNode)node;
                        if (!targetClassName2.equals(methodNode.owner)) continue;
                        methodNode.owner = nodeData.superName;
                    }
                }
                oldMn.name = (String)methodList.get(methodList.indexOf(oldMn.name) & 0xFFFFFFFE) + "_foamfix_old";
                nodeData.methods.add(oldMn);
                added = true;
                break;
            }
            if (!added && addMethods) {
                BugfixModClassTransformer.instance.logger.info("Added METHOD: " + targetClassName + "." + mn.name);
                nodeData.methods.add(mn);
                added = true;
            }
            addedGlobal |= added;
        }
        for (i = 0; i < nodeSplice.fields.size(); ++i) {
            if (!methodSet.contains(((FieldNode)nodeSplice.fields.get((int)i)).name)) continue;
            mn = (FieldNode)nodeSplice.fields.get(i);
            added = false;
            for (j = 0; j < nodeData.fields.size(); ++j) {
                if (!((FieldNode)nodeData.fields.get((int)j)).name.equals(mn.name) || !((FieldNode)nodeData.fields.get((int)j)).desc.equals(mn.desc)) continue;
                BugfixModClassTransformer.instance.logger.info("Spliced in FIELD: " + targetClassName + "." + mn.name);
                nodeData.fields.set(j, mn);
                added = true;
                break;
            }
            if (!added) {
                BugfixModClassTransformer.instance.logger.info("Added FIELD: " + targetClassName + "." + mn.name);
                nodeData.fields.add(mn);
                added = true;
            }
            addedGlobal |= added;
        }
        return addedGlobal;
    }

    public static ClassNode replaceClasses(ClassNode data, String className) {
        try {
            byte[] dataSplice = ClassSplicingUtil.getClassBytes(className);
            return ClassSplicingUtil.replaceClasses(data, dataSplice, className);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static ClassNode replaceClasses(ClassNode nodeData, byte[] dataSplice, String className) {
        BugfixModClassTransformer.instance.logger.info("Replacing " + nodeData.name + " with " + className);
        if (dataSplice == null) {
            throw new RuntimeException("Class " + className + " not found! This is a FoamFix bug!");
        }
        ClassReader readerSplice = new ClassReader(dataSplice);
        final String className2 = className.replace('.', '/');
        final String targetClassName2 = nodeData.name;
        String targetClassName = targetClassName2.replace('/', '.');
        Remapper remapper = new Remapper(){

            public String map(String name) {
                return className2.equals(name) ? targetClassName2 : name;
            }
        };
        ClassNode nodeSplice = new ClassNode();
        readerSplice.accept((ClassVisitor)new RemappingClassAdapter((ClassVisitor)nodeSplice, remapper), 8);
        return nodeSplice;
    }
}

